/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css3.CssColor;
import org.w3c.css.properties.css3.CssTextDecorationColor;
import org.w3c.css.properties.css3.CssTextDecorationLine;
import org.w3c.css.properties.css3.CssTextDecorationStyle;
import org.w3c.css.properties.css3.CssTextDecorationThickness;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssTextDecoration
extends org.w3c.css.properties.css.CssTextDecoration {
    CssTextDecorationLine lineValue = null;
    CssTextDecorationColor colorValue = null;
    CssTextDecorationStyle styleValue = null;
    CssTextDecorationThickness thicknessValue = null;

    public CssTextDecoration() {
        this.value = initial;
    }

    public CssTextDecoration(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > CssTextDecorationLine.multiple_allowed_values.length + 3) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssIdent styValue = null;
        CssValue colValue = null;
        CssValue thiValue = null;
        CssExpression linExp = null;
        CssExpression thiExp = null;
        boolean gotCssWide = false;
        int state = 0;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            if (val instanceof CssFunction) {
                if (!this.validateFunction((CssFunction)val, ac)) {
                    throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
                }
                expression.next();
            } else if (val.getType() != 0) {
                switch (val.getType()) {
                    case 4: 
                    case 5: 
                    case 6: {
                        if (thiValue != null) {
                            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                        }
                        try {
                            thiExp = new CssExpression();
                            thiExp.addValue(val);
                            this.thicknessValue = new CssTextDecorationThickness(ac, thiExp, check2);
                        }
                        catch (Exception ex) {
                            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                        }
                        thiValue = val;
                        expression.next();
                        break;
                    }
                    default: {
                        if (colValue != null) {
                            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                        }
                        CssColor c = new CssColor(ac, expression, false);
                        colValue = c.getColor();
                    }
                }
                state *= 2;
            } else {
                CssIdent ident = val.getIdent();
                if (CssIdent.isCssWide(ident)) {
                    this.value = val;
                    gotCssWide = true;
                    if (check2 && expression.getCount() != 1) {
                        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                    }
                    expression.next();
                } else {
                    CssIdent id;
                    boolean match = false;
                    if (styValue == null && (id = CssTextDecorationStyle.getMatchingIdent(ident)) != null) {
                        styValue = id;
                        match = true;
                        state *= 2;
                        expression.next();
                    }
                    if (!match && thiValue == null && (id = CssTextDecorationThickness.getMatchingIdent(ident)) != null) {
                        thiValue = id;
                        match = true;
                        state *= 2;
                        expression.next();
                    }
                    if (!match && state <= 1 && (id = CssTextDecorationLine.getAllowedValue(ident)) != null) {
                        state = 1;
                        match = true;
                        if (linExp == null) {
                            linExp = new CssExpression();
                        }
                        linExp.addValue(val);
                        expression.next();
                    }
                    if (!match && colValue == null) {
                        try {
                            CssColor c = new CssColor(ac, expression, false);
                            colValue = c.getColor();
                            if (colValue == null) {
                                colValue = c.value;
                            }
                            state *= 2;
                        }
                        catch (InvalidParamException iex) {
                            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                        }
                    } else if (!match) {
                        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                    }
                }
            }
            if (op == ' ') continue;
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        int got = 0;
        if (linExp != null) {
            this.lineValue = new CssTextDecorationLine(ac, linExp, check2);
            ++got;
            this.value = this.lineValue.value;
        }
        if (colValue != null) {
            this.colorValue = new CssTextDecorationColor();
            this.colorValue.value = colValue;
            this.value = colValue;
            ++got;
        }
        if (styValue != null) {
            this.styleValue = new CssTextDecorationStyle();
            this.styleValue.value = styValue;
            this.value = styValue;
            ++got;
        }
        if (thiValue != null) {
            this.thicknessValue = new CssTextDecorationThickness();
            this.thicknessValue.value = thiValue;
            this.value = thiValue;
            ++got;
        }
        if (!gotCssWide && got > 1) {
            ArrayList<CssValue> v = new ArrayList<CssValue>(4);
            if (this.lineValue != null) {
                v.add(this.lineValue.value);
            }
            if (styValue != null) {
                v.add(styValue);
            }
            if (colValue != null) {
                v.add(colValue);
            }
            if (thiValue != null) {
                v.add(thiValue);
            }
            this.value = new CssValueList(v);
        }
    }

    public CssTextDecoration(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    @Override
    public void addToStyle(ApplContext ac, CssStyle style) {
        super.addToStyle(ac, style);
        if (this.colorValue != null) {
            this.colorValue.addToStyle(ac, style);
        }
        if (this.styleValue != null) {
            this.styleValue.addToStyle(ac, style);
        }
        if (this.lineValue != null) {
            this.lineValue.addToStyle(ac, style);
        }
        if (this.thicknessValue != null) {
            this.thicknessValue.addToStyle(ac, style);
        }
    }
}

