/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tokenmarker.xml;

import com.oxygenxml.tokenmarker.AbstractLexer;
import com.oxygenxml.tokenmarker.LexerException;
import com.oxygenxml.tokenmarker.LexicalState;
import com.oxygenxml.tokenmarker.LexicalStateOverLong;
import com.oxygenxml.tokenmarker.LexicalStateUnlimittedStack;
import com.oxygenxml.tokenmarker.Symbol;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public class XMLLexer
extends AbstractLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int COMMENT = 2;
    public static final int CDATA = 4;
    public static final int TAG = 6;
    public static final int AFTER_ATTRIBUTE = 8;
    public static final int AFTER_EQUAL = 10;
    public static final int END_TAG = 12;
    public static final int END_TAG_AFTER_NEW_LINE = 14;
    public static final int ATTRIBUTE_DQ_STRING = 16;
    public static final int ATTRIBUTE_SQ_STRING = 18;
    public static final int INSTR = 20;
    public static final int JSP = 22;
    public static final int XML_INSTR = 24;
    public static final int DOCTYPE = 26;
    public static final int DOCTYPE_DQ_STRING = 28;
    public static final int DOCTYPE_SQ_STRING = 30;
    public static final int DOCTYPE_INTERNAL_SUBSET = 32;
    public static final int DOCTYPE_INTERNAL_SUBSET_COMMENT = 34;
    public static final int DOCTYPE_INTERNAL_SUBSET_SQ_STRING = 36;
    public static final int DOCTYPE_INTERNAL_SUBSET_DQ_STRING = 38;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19};
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001\u0002\u0001\u0002\u0002\u0000\u0001\u0002\u0012\u0000\u0001\u0001\u0001\n\u0001\u0019\u0001\u0017\u0001\u0003\u0001!\u0001\u0016\u0001\u001a\u0005\u0003\u0001\u0007\u0001\u0004\u0001\u0014\u0001\u0004\t\u0004\u0001\b\u0001\u0018\u0001\t\u0001\"\u0001\u0015\u0001\u001b\u0001\u0003\u0001 \u0001\u0004\u0001\r\u0001\u0005\u0001\u0013\u0001\u0004\b\u0004\u0001\f\u0001\u0012\u0003\u0004\u0001\u000f\u0004\u0004\u0001\u0011\u0001\u0004\u0001\u001f\u0001\u0003\u0001#\u0001\u0003\u0001\u0004\u0001\u0003\u0002\u0004\u0001\u000e\u0001\u000b\u0001\u0013\u0006\u0004\u0001\u001e\u0001\u001d\u0001\u0004\u0001\f\u0001\u0012\u0003\u0004\u0001\u0010\u0003\u0004\u0001\u001c\u0001\u0011\u0001\u0004<\u0003\u0001\u0004\b\u0003\u0017\u0004\u0001\u0003\n\u0004\u0001\u0004\u0014\u0004\u0001\u0003\u0208\u0004p\u0004\u000e\u0004\u0001\u0003\u0c81\u0004\u0001\u0004\u00fe\u0004\u0001\u0004\u0f00\u0004\u0001\u0003\u000b\u0003\u0002\u0004\u000e\u0003\u0001\u0003\"\u0003\u0002\u0004/\u0003<\u0004\u0001\u0004\u00e3\u0004\u0a70\u0003\u03f0\u0004\u000f\u0003\u0001\u0003\u0001\u0002\u0ffe\u0004\u0001\u0004\u0001\u0004\u0ffe\u0004\u0001\u0004\u0001\u0004\u0ffe\u0004\u0001\u0004\u0001\u0004\u0ffe\u0004\u0001\u0004\u0001\u0004\u0ffe\u0004\u0001\u0004\u0001\u0004\u0ffe\u0004\u0001\u0004\u0001\u0004\u0ffe\u0004\u0001\u0004\u0001\u0004\u0ffe\u0004\u0001\u0004\u0001\u0004\u0ffe\u0004\u0001\u0004\u0001\u0004\u0ffe\u0004\u0001\u0004\u0001\u0004\u07ff\u0004\u0400\u0006\u03ff\u0006\u0001\u0004\u0001\u0003\u0ffe\u0003\u0001\u0003\u0001\u0003\u08ff\u0003\u04d0\u0004 \u0003\u020e\u0004\u0001\u0000\u0001\u0003";
    private static final char[] ZZ_CMAP = XMLLexer.zzUnpackCMap("\t\u0000\u0001\u0002\u0001\u0002\u0002\u0000\u0001\u0002\u0012\u0000\u0001\u0001\u0001\n\u0001\u0019\u0001\u0017\u0001\u0003\u0001!\u0001\u0016\u0001\u001a\u0005\u0003\u0001\u0007\u0001\u0004\u0001\u0014\u0001\u0004\t\u0004\u0001\b\u0001\u0018\u0001\t\u0001\"\u0001\u0015\u0001\u001b\u0001\u0003\u0001 \u0001\u0004\u0001\r\u0001\u0005\u0001\u0013\u0001\u0004\b\u0004\u0001\f\u0001\u0012\u0003\u0004\u0001\u000f\u0004\u0004\u0001\u0011\u0001\u0004\u0001\u001f\u0001\u0003\u0001#\u0001\u0003\u0001\u0004\u0001\u0003\u0002\u0004\u0001\u000e\u0001\u000b\u0001\u0013\u0006\u0004\u0001\u001e\u0001\u001d\u0001\u0004\u0001\f\u0001\u0012\u0003\u0004\u0001\u0010\u0003\u0004\u0001\u001c\u0001\u0011\u0001\u0004<\u0003\u0001\u0004\b\u0003\u0017\u0004\u0001\u0003\n\u0004\u0001\u0004\u0014\u0004\u0001\u0003\u0208\u0004p\u0004\u000e\u0004\u0001\u0003\u0c81\u0004\u0001\u0004\u00fe\u0004\u0001\u0004\u0f00\u0004\u0001\u0003\u000b\u0003\u0002\u0004\u000e\u0003\u0001\u0003\"\u0003\u0002\u0004/\u0003<\u0004\u0001\u0004\u00e3\u0004\u0a70\u0003\u03f0\u0004\u000f\u0003\u0001\u0003\u0001\u0002\u0ffe\u0004\u0001\u0004\u0001\u0004\u0ffe\u0004\u0001\u0004\u0001\u0004\u0ffe\u0004\u0001\u0004\u0001\u0004\u0ffe\u0004\u0001\u0004\u0001\u0004\u0ffe\u0004\u0001\u0004\u0001\u0004\u0ffe\u0004\u0001\u0004\u0001\u0004\u0ffe\u0004\u0001\u0004\u0001\u0004\u0ffe\u0004\u0001\u0004\u0001\u0004\u0ffe\u0004\u0001\u0004\u0001\u0004\u0ffe\u0004\u0001\u0004\u0001\u0004\u07ff\u0004\u0400\u0006\u03ff\u0006\u0001\u0004\u0001\u0003\u0ffe\u0003\u0001\u0003\u0001\u0003\u08ff\u0003\u04d0\u0004 \u0003\u020e\u0004\u0001\u0000\u0001\u0003");
    private static final int[] ZZ_ACTION = XMLLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0014\u0000\u0001\u0001\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\u0000\u0001\b\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\r\u0002\u000e\u0001\u000f\u0001\u000e\u0001\u0010\u0001\u0011\u0001\u0006\u0001\u000e\u0001\u0000\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0005\u0001\u0016\u0001\u0017\u0001\u0018\u0001\u0019\u0001\u0004\u0001\u0005\u0001\u0004\u0001\u0005\u0001\u0004\u0001\u0005\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u001d\u0001\u001e\u0001\u001f\u0001 \u0001\u0005\u0001!\u0001\"\u0001\u0005\u0001\u0000\u0001\u0005\u0001#\u0001\u0000\u0001\u0005\u0002$\u0001%\u0001&\u0001'\u0001(\u0001)\u0002\u0003\u0001*\u0006\u0000\u0001\u0007\u0001+\u0001,\u0001-\u0001.\u0001\u000f\u0001/\u00010\u0003\u000e\u0002\u0000\u00011\u0002\u0000\u00012\u0002\u0000\u00013\u0002\u0000\u00014\u0004\u0000\u00025\u0001&\u0002\u0000\u00016\u00017\u0001\u0007\u0001\u000f\u0001\u000e\u00018\u0001\u0000\u00019\u0001:\u0001\u0000\u0001;\u0002\u0000\u0001<\u0001=\u0005\u0000\u0001>\u0004\u0000\u0001?\u0001@";
    private static final int[] ZZ_ROWMAP = XMLLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000$\u0000H\u0000l\u0000\u0090\u0000\u00b4\u0000\u00d8\u0000\u00fc\u0000\u0120\u0000\u0144\u0000\u0168\u0000\u018c\u0000\u01b0\u0000\u01d4\u0000\u01f8\u0000\u021c\u0000\u0240\u0000\u0264\u0000\u0288\u0000\u02ac\u0000\u02d0\u0000\u02f4\u0000\u0318\u0000\u033c\u0000\u0360\u0000\u0384\u0000\u03a8\u0000\u03cc\u0000\u03f0\u0000\u0414\u0000\u0438\u0000\u045c\u0000\u0438\u0000\u0438\u0000\u0438\u0000\u0438\u0000\u0480\u0000\u04a4\u0000\u04c8\u0000\u04ec\u0000\u0438\u0000\u0510\u0000\u0534\u0000\u0558\u0000\u057c\u0000\u05a0\u0000\u0438\u0000\u0438\u0000\u0438\u0000\u0438\u0000\u0438\u0000\u0438\u0000\u0438\u0000\u0438\u0000\u05c4\u0000\u05e8\u0000\u060c\u0000\u0630\u0000\u0654\u0000\u0678\u0000\u0438\u0000\u0438\u0000\u0438\u0000\u0438\u0000\u0438\u0000\u0438\u0000\u0438\u0000\u069c\u0000\u0438\u0000\u0438\u0000\u06c0\u0000\u06e4\u0000\u06e4\u0000\u0438\u0000\u0708\u0000\u0708\u0000\u072c\u0000\u0750\u0000\u0774\u0000\u0798\u0000\u0438\u0000\u07bc\u0000\u0438\u0000\u07e0\u0000\u0438\u0000\u0438\u0000\u0804\u0000\u0828\u0000\u084c\u0000\u03a8\u0000\u0870\u0000\u0894\u0000\u08b8\u0000\u08dc\u0000\u0414\u0000\u0438\u0000\u0438\u0000\u0900\u0000\u0924\u0000\u04ec\u0000\u0948\u0000\u096c\u0000\u057c\u0000\u0990\u0000\u09b4\u0000\u0438\u0000\u0630\u0000\u09d8\u0000\u0438\u0000\u0678\u0000\u09fc\u0000\u0438\u0000\u0a20\u0000\u0a44\u0000\u0438\u0000\u0a68\u0000\u0a8c\u0000\u0ab0\u0000\u0ad4\u0000\u0798\u0000\u0af8\u0000\u0438\u0000\u0b1c\u0000\u0b40\u0000\u0438\u0000\u0438\u0000\u0b64\u0000\u0b88\u0000\u0bac\u0000\u0438\u0000\u0bd0\u0000\u0438\u0000\u0438\u0000\u0bf4\u0000\u0438\u0000\u0c18\u0000\u0c3c\u0000\u0438\u0000\u0438\u0000\u0c60\u0000\u0c84\u0000\u0ca8\u0000\u0ccc\u0000\u0cf0\u0000\u0438\u0000\u0d14\u0000\u0d38\u0000\u0d5c\u0000\u0d80\u0000\u0438\u0000\u0438";
    private static final int[] ZZ_TRANS = XMLLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\t\u0015\u0001\u0016\f\u0015\u0001\u0017\r\u0015\u0007\u0018\u0001\u0019\u001c\u0018#\u001a\u0001\u001b\u0001\u0000\u0002\u001c\u0001\u0000\u0004\u001d\u0001\u001e\u0001\u001f\u0001\u0000\t\u001d\u0001 \u0001!\u0001\u0017\u0002\u0000\u0001\"\u0001#\u0001\u0000\u0003\u001d\u0001\u0000\u0001\u001d\u0001\u0000\u0001$\u0001\u0000\u0001%\u0002&\u0001%\u0004'\u0001(\u0001)\u0001%\t'\u0001 \u0001!\u0001\u0017\u0005%\u0003'\u0001%\u0001'\u0001%\u0001*\u0001%\u0001\u0000\u0002+\u0001\u0000\u0004,\u0001-\u0001)\u0001\u0000\t,\u0001 \u0001!\u0001\u0017\u0002\u0000\u0001\"\u0001#\u0001\u0000\u0003,\u0001\u0000\u0001,\u0004\u0000\u0002.\u0006\u0000\u0001/\u000b\u0000\u00010\u000f\u0000\u0002.\u0006\u0000\u00011\u000b\u0000\u00010\u000e\u0000\t2\u00013\u000f2\u00014\u00132\u00015\u00102\u00016\t2\u001b7\u00018\b7!9\u0001:\u00029\u001b;\u0001<\b;\u0001\u0000\u00052\u0001\u0000\u00022\u0001=\u000b2\u0001>\u00032\u0001?\u0001@\u00042\u0001A\u00042\u0001\u0000\u00052\u0001\u0000\u00122\u0001B\n2\u0001\u0000\u00052\u0001\u0000\u00132\u0001C\t2\u0001\u0000\u00052\u0001\u0000\u00022\u0001D\u000f2\u0002E\b2\u0001F\u0001\u0000\u00052\u0001\u0000\u0001G\u001c2\u0001H\u0005I\u0001H\u0013I\u0001J\tI\u0001K\u0005L\u0001K\u0012L\u0001J\nL\t\u0015\u0001\u0000\f\u0015\u0001\u0000\r\u0015\u0004\u0000\u0004M\u0001N\u0001\u0000\u0001O\tM\u0001P\u0001Q\u0005\u0000\u0001R\u0003M\u0001\u0000\u0001M\u0001S\u0006\u0000\u0004T\u0001\u0000\u0001U\u0001\u0000\tT\u0001\u0000\u0001U\u0001\u0000\u0001T\u0001V\u0003\u0000\u0003T\u0001\u0000\u0001T\u0003\u0000\u0007\u0018\u0001W\u001c\u0018\u0007X\u0001Y\u001cX#\u001a\u0001Z#[\u0001\\\u0001\u0000\u0002\u001c\u0001\u0000\u0004\u001d\u0001\u001e\u0002\u0000\t\u001d\b\u0000\u0003\u001d\u0001\u0000\u0001\u001d\u0004\u0000\u0002]\u0001\u0000\u0004\u001d\u0001^\u0002\u0000\t\u001d\b\u0000\u0003\u001d\u0001\u0000\u0001\u001d\u0007\u0000\u0004_\u0003\u0000\t_\b\u0000\u0003_\u0001\u0000\u0001_<\u0000\u0001`\u000e\u0000\t%\u0001\u0000\n%\u0003\u0000\u000b%\u0001\u0000\u0002%\u0002&\u0001%\u0004'\u0001(\u0001\u0000\u0001%\t'\u0003\u0000\u0005%\u0003'\u0001%\u0001'\u0001%\u0001a\u0002%\u0002b\u0001%\u0004'\u0001c\u0001\u0000\u0001%\t'\u0003\u0000\u0005%\u0003'\u0001%\u0001'\u0001%\u0001\u0000\u0005%\u0004d\u0001%\u0001\u0000\u0001%\td\u0003\u0000\u0005%\u0003d\u0001%\u0001d\u0001%\u0001\u0000\u0001%\u0001\u0000\u0002*\"\u0000\u0002+\u0001\u0000\u0004,\u0001-\u0002\u0000\t,\b\u0000\u0003,\u0001\u0000\u0001,\u0004\u0000\u0002e\u0001\u0000\u0004,\u0001f\u0002\u0000\t,\b\u0000\u0003,\u0001\u0000\u0001,\u0007\u0000\u0004g\u0003\u0000\tg\b\u0000\u0003g\u0001\u0000\u0001g\u0004\u0000\u0002.!\u0000\u001b7\u0001h\b7\u0015i\u0001j\u0005i\u0001h\bi!9\u0001k\u00029\u0015l\u0001m\u000bl\u0001k\u0002l\u001b;\u0001n\b;\u0015o\u0001p\u0005o\u0001n\bo\n\u0000\u0001q \u0000\u0001r\u001c\u0000\u001aH\u0001s\tH\u0019K\u0001s\nK\u0004\u0000\u0004M\u0001N\u0002\u0000\tM\u0001t\u0001Q\u0006\u0000\u0003M\u0001\u0000\u0001M\u0007\u0000\u0004N\u0003\u0000\tN\u0001t\u0001Q\u0006\u0000\u0003N\u0001\u0000\u0001N\b\u0000\u0001u\u0001\u0000\u0001v\u0003\u0000\u0001u\u0013\u0000\u0001w\b\u0000\u0004x\u0001y\u0002\u0000\tx\u0001\u0000\u0001z\u0006\u0000\u0003x\u0001\u0000\u0001x\u001f\u0000\u0001{\u000b\u0000\u0004T\u0001\u0000\u0001U\u0001\u0000\tT\u0001\u0000\u0001U\u0002\u0000\u0001V\u0003\u0000\u0003T\u0001\u0000\u0001T\u0003\u0000\u0007X\u0001|#X\u0001W#X\u0001|\rX\u0001}\u000eX#[\u0001Z\u0015[\u0001~\r[\u0001\\\u0001\u0000\u0002]%\u0000\u0004\u007f\u0003\u0000\t\u007f\b\u0000\u0003\u007f\u0001\u0000\u0001\u007f\u0003\u0000\u0001%\u0002b\u0006%\u0001\u0000\n%\u0003\u0000\u000b%\u0001\u0000\u0005%\u0004\u0080\u0001%\u0001\u0000\u0001%\t\u0080\u0003\u0000\u0005%\u0003\u0080\u0001%\u0001\u0080\u0001%\u0001\u0000\u0001%\u0001\u0000\u0002e%\u0000\u0004\u0081\u0003\u0000\t\u0081\b\u0000\u0003\u0081\u0001\u0000\u0001\u0081\u0003\u0000\u0015i\u0001\u0082\u0005i\u0001h#i\u0001h\bi!l\u0001k\u0002l\u001bo\u0001n\bo\u0007\u0000\u0001\u00831\u0000\u0001\u0084#\u0000\u0001\u0085\u001a\u0000\u0001\u0086\u001e\u0000\u0001\u0087)\u0000\u0001\u0088\u001a\u0000\u0004y\u0003\u0000\ty\u0001\u0000\u0001z\u0006\u0000\u0003y\u0001\u0000\u0001y \u0000\u0001\u0089\u0006\u0000\u0007X\u0001|\rX\u0001\u008a\u000eX\u0001\u0000\u0002]\u0001\u0000\u0004\u007f\u0003\u0000\t\u007f\b\u0000\u0003\u007f\u0001\u0000\u0001\u007f\u0003\u0000\u0001%\u0002b\u0001%\u0004\u0080\u0001%\u0001\u0000\u0001%\t\u0080\u0003\u0000\u0005%\u0003\u0080\u0001%\u0001\u0080\u0001%\u0001\u0000\u0001%\u0001\u0000\u0002e\u0001\u0000\u0004\u0081\u0003\u0000\t\u0081\b\u0000\u0003\u0081\u0001\u0000\u0001\u0081\n\u0000\u0001\u008b)\u0000\u0002\u008c\u001a\u0000\u0001\u008d<\u0000\u0001\u008e\u0014\u0000\u0002\u008f3\u0000\u0001\u0090\u0004\u0000\u0001\u00913\u0000\u0001\u0092!\u0000\u0001\u0093&\u0000\u0001\u00941\u0000\u0001\u0095\u0016\u0000\u0001\u0096/\u0000\u0001\u0097\u0004\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = XMLLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0014\u0000\t\u0001\u0001\u0000\u0001\t\u0001\u0001\u0004\t\u0004\u0001\u0001\t\u0003\u0001\u0001\u0000\u0001\u0001\b\t\u0006\u0001\u0007\t\u0001\u0001\u0002\t\u0001\u0001\u0001\u0000\u0001\u0001\u0001\t\u0001\u0000\u0005\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0002\t\u0006\u0000\u0003\u0001\u0002\t\u0006\u0001\u0002\u0000\u0001\t\u0002\u0000\u0001\t\u0002\u0000\u0001\t\u0002\u0000\u0001\t\u0004\u0000\u0002\u0001\u0001\t\u0002\u0000\u0002\t\u0003\u0001\u0001\t\u0001\u0000\u0002\t\u0001\u0000\u0001\t\u0002\u0000\u0002\t\u0005\u0000\u0001\t\u0004\u0000\u0002\t";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    public static final byte SYM_TEXT = 0;
    public static final byte SYM_INVALID = 10;
    public static final byte SYM_ENTITY = 5;
    public static final byte SYM_AUTO_CLOSING_TAG = 6;
    public static final byte SYM_TAG_START = 6;
    public static final byte SYM_OPEN_TAG_CLOSE = 6;
    public static final byte SYM_OPEN_TAG_END = 6;
    public static final byte SYM_OPEN_START_TAG = 6;
    public static final byte SYM_CLOSE_TAG = 6;
    public static final byte SYM_LT = 6;
    public static final byte SYM_SLASH = 6;
    public static final byte SYM_INSTR_START = 8;
    public static final byte SYM_INSTR = 8;
    public static final byte SYM_INSTR_END = 8;
    public static final byte SYM_XML_HEADER = 16;
    public static final byte SYM_COMMENT_START = 1;
    public static final byte SYM_COMMENT = 1;
    public static final byte SYM_COMMENT_END = 1;
    public static final byte SYM_CDATA = 11;
    public static final byte SYM_JSP = 8;
    public static final byte SYM_ATTRIBUTE_NAME = 7;
    public static final byte SYM_EQ = 9;
    public static final byte SYM_ATTRIBUTE_VALUE_DQ = 3;
    public static final byte SYM_ATTRIBUTE_VALUE_SQ = 4;
    public static final byte SYM_DOCTYPE_INNER = 12;
    public static final byte SYM_DOCTYPE_INNER_COMMENT = 12;
    public static final byte SYM_DOCTYPE_STRING_DQ = 12;
    public static final byte SYM_DOCTYPE_STRING_SQ = 12;
    public static final byte SYM_DOCTYPE = 2;
    private boolean unlimitedStack = false;
    private static final LexicalState INITIAL_STATE_OL = new LexicalStateOverLong();
    private static final LexicalState INITIAL_STATE_US = new LexicalStateUnlimittedStack();

    private static int[] zzUnpackAction() {
        int[] result = new int[151];
        int offset = 0;
        offset = XMLLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[151];
        int offset = 0;
        offset = XMLLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[3492];
        int offset = 0;
        offset = XMLLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[151];
        int offset = 0;
        offset = XMLLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public XMLLexer(boolean unlimitedStack) {
        this.unlimitedStack = unlimitedStack;
    }

    @Override
    public String getName() {
        return "XML";
    }

    @Override
    protected LexicalState createLexicalState() {
        return this.unlimitedStack ? new LexicalStateUnlimittedStack() : new LexicalStateOverLong();
    }

    @Override
    protected LexicalState getInitialLexicalState() {
        return this.unlimitedStack ? INITIAL_STATE_US : INITIAL_STATE_OL;
    }

    public XMLLexer(Reader in) {
        this.zzReader = in;
    }

    public XMLLexer(InputStream in) {
        this(new InputStreamReader(in, Charset.forName("UTF-8")));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 282) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) > 0) {
            this.zzEndRead += numRead;
            return false;
        }
        if (numRead == 0) {
            int c = this.zzReader.read();
            if (c == -1) {
                return true;
            }
            this.zzBuffer[this.zzEndRead++] = (char)c;
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    @Override
    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
        if (this.zzBuffer.length > 16384) {
            this.zzBuffer = new char[16384];
        }
    }

    @Override
    public final int yystate() {
        return this.zzLexicalState;
    }

    @Override
    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    @Override
    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    @Override
    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) throws LexerException {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new LexerException(message);
    }

    public void yypushback(int number) throws LexerException {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    @Override
    public Symbol yylex() throws IOException, LexerException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block162: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += zzMarkedPosL - this.zzStartRead;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    return this.symbol((byte)0);
                }
                case 65: {
                    continue block162;
                }
                case 2: {
                    this.yybegin(6);
                    return this.symbol((byte)6);
                }
                case 66: {
                    continue block162;
                }
                case 3: {
                    String tokenText = this.yytext();
                    char ch = tokenText.charAt(tokenText.length() - 1);
                    if (ch == '<' || ch == '>') {
                        this.yypushback(1);
                    }
                    return this.symbol((byte)10);
                }
                case 67: {
                    continue block162;
                }
                case 4: {
                    this.cLen += this.yylength();
                }
                case 68: {
                    continue block162;
                }
                case 5: {
                    ++this.cLen;
                }
                case 69: {
                    continue block162;
                }
                case 6: {
                    return this.symbol((byte)7);
                }
                case 70: {
                    continue block162;
                }
                case 7: {
                    this.yybegin(8);
                    return this.symbol((byte)7);
                }
                case 71: {
                    continue block162;
                }
                case 8: {
                    this.yypushback(1);
                    this.yybegin(0);
                }
                case 72: {
                    continue block162;
                }
                case 9: {
                    return this.symbol((byte)6);
                }
                case 73: {
                    continue block162;
                }
                case 10: {
                    this.yybegin(0);
                    return this.symbol((byte)6);
                }
                case 74: {
                    continue block162;
                }
                case 11: {
                    this.yybegin(16);
                    this.cLen = 1;
                }
                case 75: {
                    continue block162;
                }
                case 12: {
                    this.yybegin(18);
                    this.cLen = 1;
                }
                case 76: {
                    continue block162;
                }
                case 13: {
                    this.yypushback(1);
                    this.yybegin(8);
                }
                case 77: {
                    continue block162;
                }
                case 14: {
                    return this.symbol((byte)0);
                }
                case 78: {
                    continue block162;
                }
                case 15: {
                    return this.symbol((byte)7);
                }
                case 79: {
                    continue block162;
                }
                case 16: {
                    this.yypushback(1);
                    this.yybegin(0);
                }
                case 80: {
                    continue block162;
                }
                case 17: {
                    this.yybegin(10);
                    return this.symbol((byte)9);
                }
                case 81: {
                    continue block162;
                }
                case 18: {
                    return this.symbol((byte)7);
                }
                case 82: {
                    continue block162;
                }
                case 19: {
                    this.yypushback(1);
                    this.yybegin(0);
                }
                case 83: {
                    continue block162;
                }
                case 20: {
                    this.yybegin(0);
                    return this.symbol((byte)6);
                }
                case 84: {
                    continue block162;
                }
                case 21: {
                    this.yypushback(1);
                    this.yybegin(0);
                }
                case 85: {
                    continue block162;
                }
                case 22: {
                    this.yypushback(1);
                    this.yybegin(0);
                    return this.flush((byte)3);
                }
                case 86: {
                    continue block162;
                }
                case 23: {
                    ++this.cLen;
                    this.yybegin(6);
                    return this.flush((byte)3);
                }
                case 87: {
                    continue block162;
                }
                case 24: {
                    this.yypushback(1);
                    this.yybegin(0);
                    return this.flush((byte)4);
                }
                case 88: {
                    continue block162;
                }
                case 25: {
                    ++this.cLen;
                    this.yybegin(6);
                    return this.flush((byte)4);
                }
                case 89: {
                    continue block162;
                }
                case 26: {
                    this.yypushback(1);
                    this.yybegin(0);
                    return this.flush((byte)2);
                }
                case 90: {
                    continue block162;
                }
                case 27: {
                    this.yybegin(0);
                    ++this.cLen;
                    return this.flush((byte)2);
                }
                case 91: {
                    continue block162;
                }
                case 28: {
                    this.yybegin(28);
                    ++this.cLen;
                }
                case 92: {
                    continue block162;
                }
                case 29: {
                    this.yybegin(30);
                    ++this.cLen;
                }
                case 93: {
                    continue block162;
                }
                case 30: {
                    ++this.cLen;
                    this.yybegin(32);
                    return this.flush((byte)2);
                }
                case 94: {
                    continue block162;
                }
                case 31: {
                    ++this.cLen;
                    this.yybegin(26);
                }
                case 95: {
                    continue block162;
                }
                case 32: {
                    ++this.cLen;
                    this.yybegin(26);
                }
                case 96: {
                    continue block162;
                }
                case 33: {
                    if (this.cLen > 0) {
                        this.yypushback(1);
                        return this.flush((byte)12);
                    }
                    if (this.yycharat(0) == '\"') {
                        this.yybegin(38);
                    } else {
                        this.yybegin(36);
                    }
                    return this.symbol((byte)12);
                }
                case 97: {
                    continue block162;
                }
                case 34: {
                    if (this.cLen > 0) {
                        this.yypushback(1);
                        return this.flush((byte)12);
                    }
                    this.yybegin(26);
                    return this.symbol((byte)2);
                }
                case 98: {
                    continue block162;
                }
                case 35: {
                    this.yybegin(32);
                    return this.symbol((byte)12);
                }
                case 99: {
                    continue block162;
                }
                case 36: {
                    this.yybegin(6);
                    return this.symbol((byte)6);
                }
                case 100: {
                    continue block162;
                }
                case 37: {
                    return this.symbol((byte)10);
                }
                case 101: {
                    continue block162;
                }
                case 38: {
                    return this.symbol((byte)6);
                }
                case 102: {
                    continue block162;
                }
                case 39: {
                    return this.symbol((byte)6);
                }
                case 103: {
                    continue block162;
                }
                case 40: {
                    this.yybegin(20);
                    return this.symbol((byte)8);
                }
                case 104: {
                    continue block162;
                }
                case 41: {
                    this.yybegin(22);
                    this.yypushback(2);
                    this.cLen = 0;
                }
                case 105: {
                    continue block162;
                }
                case 42: {
                    return this.symbol((byte)5);
                }
                case 106: {
                    continue block162;
                }
                case 43: {
                    this.yybegin(8);
                    return this.symbol((byte)7);
                }
                case 107: {
                    continue block162;
                }
                case 44: {
                    this.yybegin(8);
                    return this.symbol((byte)7);
                }
                case 108: {
                    continue block162;
                }
                case 45: {
                    this.yybegin(0);
                    return this.symbol((byte)6);
                }
                case 109: {
                    continue block162;
                }
                case 46: {
                    this.yypushback(1);
                    return this.symbol((byte)7);
                }
                case 110: {
                    continue block162;
                }
                case 47: {
                    return this.symbol((byte)7);
                }
                case 111: {
                    continue block162;
                }
                case 48: {
                    return this.symbol((byte)7);
                }
                case 112: {
                    continue block162;
                }
                case 49: {
                    this.yybegin(0);
                    return this.symbol((byte)8);
                }
                case 113: {
                    continue block162;
                }
                case 50: {
                    this.yybegin(0);
                    return this.symbol((byte)8);
                }
                case 114: {
                    continue block162;
                }
                case 51: {
                    this.yybegin(0);
                    return this.symbol((byte)16);
                }
                case 115: {
                    continue block162;
                }
                case 52: {
                    this.yypushback(1);
                    return this.symbol((byte)12);
                }
                case 116: {
                    continue block162;
                }
                case 53: {
                    this.yybegin(12);
                    return this.symbol((byte)6);
                }
                case 117: {
                    continue block162;
                }
                case 54: {
                    this.yybegin(0);
                    return this.symbol((byte)1);
                }
                case 118: {
                    continue block162;
                }
                case 55: {
                    this.yybegin(0);
                    return this.symbol((byte)11);
                }
                case 119: {
                    continue block162;
                }
                case 56: {
                    this.yypushback(2);
                    return this.symbol((byte)8);
                }
                case 120: {
                    continue block162;
                }
                case 57: {
                    this.yybegin(32);
                    this.cLen += 3;
                }
                case 121: {
                    continue block162;
                }
                case 58: {
                    return this.symbol((byte)6);
                }
                case 122: {
                    continue block162;
                }
                case 59: {
                    this.yybegin(2);
                    this.cLen = 0;
                    return this.symbol((byte)1);
                }
                case 123: {
                    continue block162;
                }
                case 60: {
                    this.yypushback(3);
                    return this.symbol((byte)1);
                }
                case 124: {
                    continue block162;
                }
                case 61: {
                    this.cLen += 4;
                    this.yybegin(34);
                }
                case 125: {
                    continue block162;
                }
                case 62: {
                    this.yybegin(24);
                    this.cLen = 0;
                    this.yypushback(6);
                }
                case 126: {
                    continue block162;
                }
                case 63: {
                    this.yybegin(26);
                    this.cLen = 9;
                }
                case 127: {
                    continue block162;
                }
                case 64: {
                    this.yybegin(4);
                    this.cLen = 0;
                    this.yypushback(9);
                }
                case 128: {
                    continue block162;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                switch (this.zzLexicalState) {
                    case 2: {
                        return this.flush((byte)1);
                    }
                    case 152: {
                        continue block162;
                    }
                    case 4: {
                        return this.flush((byte)11);
                    }
                    case 153: {
                        continue block162;
                    }
                    case 12: {
                        this.yybegin(14);
                    }
                    case 154: {
                        continue block162;
                    }
                    case 16: {
                        return this.flush((byte)3);
                    }
                    case 155: {
                        continue block162;
                    }
                    case 18: {
                        return this.flush((byte)4);
                    }
                    case 156: {
                        continue block162;
                    }
                    case 20: {
                        return this.flush((byte)8);
                    }
                    case 157: {
                        continue block162;
                    }
                    case 22: {
                        return this.flush((byte)8);
                    }
                    case 158: {
                        continue block162;
                    }
                    case 24: {
                        return this.flush((byte)16);
                    }
                    case 159: {
                        continue block162;
                    }
                    case 26: {
                        return this.flush((byte)2);
                    }
                    case 160: {
                        continue block162;
                    }
                    case 28: {
                        return this.flush((byte)2);
                    }
                    case 161: {
                        continue block162;
                    }
                    case 30: {
                        return this.flush((byte)2);
                    }
                    case 162: {
                        continue block162;
                    }
                    case 32: {
                        return this.flush((byte)12);
                    }
                    case 163: {
                        continue block162;
                    }
                    case 34: {
                        return this.flush((byte)12);
                    }
                    case 164: {
                        continue block162;
                    }
                    case 36: {
                        return this.flush((byte)12);
                    }
                    case 165: {
                        continue block162;
                    }
                    case 38: {
                        return this.flush((byte)12);
                    }
                    case 166: {
                        continue block162;
                    }
                }
                return null;
            }
            this.zzScanError(1);
        }
    }
}

