/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tokenmarker.xhtml;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSAttributesRecognizer {
    private static JSAttributesRecognizer instance = null;
    private Map<String, List<String>> jsAttrsMap = new HashMap<String, List<String>>();

    public static JSAttributesRecognizer getInstance() {
        if (instance == null) {
            instance = new JSAttributesRecognizer();
        }
        return instance;
    }

    private JSAttributesRecognizer() {
        this.jsAttrsMap.put("onabort", Arrays.asList("*"));
        this.jsAttrsMap.put("onafterprint", Arrays.asList("body"));
        this.jsAttrsMap.put("onbeforeprint", Arrays.asList("body"));
        this.jsAttrsMap.put("onbeforeunload", Arrays.asList("body"));
        this.jsAttrsMap.put("onblur", Arrays.asList("*"));
        this.jsAttrsMap.put("oncancel", Arrays.asList("*"));
        this.jsAttrsMap.put("oncanplay", Arrays.asList("*"));
        this.jsAttrsMap.put("oncanplaythrough", Arrays.asList("*"));
        this.jsAttrsMap.put("onchange", Arrays.asList("*"));
        this.jsAttrsMap.put("onclick", Arrays.asList("*"));
        this.jsAttrsMap.put("onclose", Arrays.asList("*"));
        this.jsAttrsMap.put("oncontextmenu", Arrays.asList("*"));
        this.jsAttrsMap.put("oncopy", Arrays.asList("*"));
        this.jsAttrsMap.put("oncuechange", Arrays.asList("*"));
        this.jsAttrsMap.put("oncut", Arrays.asList("*"));
        this.jsAttrsMap.put("ondblclick", Arrays.asList("*"));
        this.jsAttrsMap.put("ondrag", Arrays.asList("*"));
        this.jsAttrsMap.put("ondragend", Arrays.asList("*"));
        this.jsAttrsMap.put("ondragenter", Arrays.asList("*"));
        this.jsAttrsMap.put("ondragexit", Arrays.asList("*"));
        this.jsAttrsMap.put("ondragleave", Arrays.asList("*"));
        this.jsAttrsMap.put("ondragover", Arrays.asList("*"));
        this.jsAttrsMap.put("ondragstart", Arrays.asList("*"));
        this.jsAttrsMap.put("ondrop", Arrays.asList("*"));
        this.jsAttrsMap.put("ondurationchange", Arrays.asList("*"));
        this.jsAttrsMap.put("onemptied", Arrays.asList("*"));
        this.jsAttrsMap.put("onended", Arrays.asList("*"));
        this.jsAttrsMap.put("onerror", Arrays.asList("*"));
        this.jsAttrsMap.put("onfocus", Arrays.asList("*"));
        this.jsAttrsMap.put("onhashchange", Arrays.asList("body"));
        this.jsAttrsMap.put("oninput", Arrays.asList("*"));
        this.jsAttrsMap.put("oninvalid", Arrays.asList("*"));
        this.jsAttrsMap.put("onkeydown", Arrays.asList("*"));
        this.jsAttrsMap.put("onkeypres", Arrays.asList("*"));
        this.jsAttrsMap.put("onkeyup", Arrays.asList("*"));
        this.jsAttrsMap.put("onlanguagechange", Arrays.asList("body"));
        this.jsAttrsMap.put("onload", Arrays.asList("*"));
        this.jsAttrsMap.put("onloadeddata", Arrays.asList("*"));
        this.jsAttrsMap.put("onloadedmetadata", Arrays.asList("*"));
        this.jsAttrsMap.put("onloadstart", Arrays.asList("*"));
        this.jsAttrsMap.put("onmessage", Arrays.asList("body"));
        this.jsAttrsMap.put("onmousedown", Arrays.asList("*"));
        this.jsAttrsMap.put("onmouseenter", Arrays.asList("*"));
        this.jsAttrsMap.put("onmouseleave", Arrays.asList("*"));
        this.jsAttrsMap.put("onmousemove", Arrays.asList("*"));
        this.jsAttrsMap.put("onmouseout", Arrays.asList("*"));
        this.jsAttrsMap.put("onmouseover", Arrays.asList("*"));
        this.jsAttrsMap.put("onmouseup", Arrays.asList("*"));
        this.jsAttrsMap.put("onmousewheel", Arrays.asList("*"));
        this.jsAttrsMap.put("onwheel", Arrays.asList("*"));
        this.jsAttrsMap.put("onoffline", Arrays.asList("body"));
        this.jsAttrsMap.put("ononline", Arrays.asList("body"));
        this.jsAttrsMap.put("onpagehide", Arrays.asList("body"));
        this.jsAttrsMap.put("onpageshow", Arrays.asList("body"));
        this.jsAttrsMap.put("onpaste", Arrays.asList("*"));
        this.jsAttrsMap.put("onpause", Arrays.asList("*"));
        this.jsAttrsMap.put("onplay", Arrays.asList("*"));
        this.jsAttrsMap.put("onplaying", Arrays.asList("*"));
        this.jsAttrsMap.put("onpopstate", Arrays.asList("body"));
        this.jsAttrsMap.put("onprogress", Arrays.asList("*"));
        this.jsAttrsMap.put("onratechange", Arrays.asList("*"));
        this.jsAttrsMap.put("onreset", Arrays.asList("*"));
        this.jsAttrsMap.put("onresize", Arrays.asList("*"));
        this.jsAttrsMap.put("onscroll", Arrays.asList("*"));
        this.jsAttrsMap.put("onseeked", Arrays.asList("*"));
        this.jsAttrsMap.put("onseeking", Arrays.asList("*"));
        this.jsAttrsMap.put("onselect", Arrays.asList("*"));
        this.jsAttrsMap.put("onstalled", Arrays.asList("*"));
        this.jsAttrsMap.put("onstorage", Arrays.asList("body"));
        this.jsAttrsMap.put("onsubmit", Arrays.asList("*"));
        this.jsAttrsMap.put("onsuspend", Arrays.asList("*"));
        this.jsAttrsMap.put("ontimeupdate", Arrays.asList("*"));
        this.jsAttrsMap.put("ontoggle", Arrays.asList("*"));
        this.jsAttrsMap.put("onunload", Arrays.asList("body"));
        this.jsAttrsMap.put("onvolumechange", Arrays.asList("*"));
        this.jsAttrsMap.put("onwaiting", Arrays.asList("*"));
    }

    public boolean isJSAttribute(String elementName, String attributeName) {
        List<String> elements = this.jsAttrsMap.get(attributeName);
        if (elements != null) {
            return elements.contains(elementName) || elements.contains("*");
        }
        return false;
    }
}

