/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tokenmarker.xhtml;

import com.oxygenxml.tokenmarker.activation.AbstractXMLActivationRule;
import com.oxygenxml.tokenmarker.activation.ActivationRange;
import com.oxygenxml.tokenmarker.xhtml.JSAttributesRecognizer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSAttrActivationRule
extends AbstractXMLActivationRule {
    protected static final byte S_XE_RECOGNIZED_OPEN_TAG = 1;
    protected static final byte S_XE_RECOGNIZED_ATTRIBUTE_NAME = 2;
    protected static final byte S_XE_RECOGNIZED_EQUALS_OPERATOR = 3;
    protected static final byte S_XE_ACTIVE_SQ = 4;
    protected static final byte S_XE_ACTIVE_DQ = 5;
    protected static final Logger logger = LoggerFactory.getLogger((String)JSAttrActivationRule.class.getName());
    private String lastUpdatedOriginalTokenText;
    private byte lastUpdatedTokenId;
    private String lastOpenedTagName;

    @Override
    public boolean isStartTag(byte tokenID) {
        return super.isStartTag(tokenID) || tokenID == 17;
    }

    @Override
    public void update(byte tokenId, String originalTokenText, String trimmedTokenText) {
        this.lastUpdatedTokenId = tokenId;
        this.lastUpdatedOriginalTokenText = originalTokenText;
        String tokenText = trimmedTokenText;
        boolean isEmpty = tokenText.length() == 0;
        boolean pushback = false;
        do {
            if (logger.isDebugEnabled()) {
                logger.debug("Updating {} - '{}'\t in state {}{}", new Object[]{tokenId, trimmedTokenText, this.state, pushback ? " (pushed back)" : ""});
            }
            pushback = false;
            switch (this.state) {
                case 0: {
                    this.lastOpenedTagName = null;
                    if (!this.isStartTag(tokenId) || tokenText.startsWith("</") || tokenText.endsWith(">")) break;
                    this.state = 1;
                    this.lastOpenedTagName = tokenText.substring(1);
                    break;
                }
                case 1: {
                    if (tokenId == 7 && JSAttributesRecognizer.getInstance().isJSAttribute(this.lastOpenedTagName, tokenText)) {
                        this.state = (byte)2;
                        break;
                    }
                    if (tokenId == 7 || tokenId == 9 || tokenId == 4 || tokenId == 3) break;
                    if (tokenId == 6) {
                        this.state = 0;
                        pushback = true;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                case 2: {
                    if (tokenId == 9 && "=".equals(tokenText)) {
                        this.state = (byte)3;
                        break;
                    }
                    if (tokenId == 7 && trimmedTokenText.length() == 0) break;
                    if (tokenId == 6) {
                        this.state = 0;
                        pushback = true;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                case 3: {
                    if (tokenId == 4) {
                        this.state = (byte)4;
                        break;
                    }
                    if (tokenId == 3) {
                        this.state = (byte)5;
                        break;
                    }
                    if (tokenId == 7 && trimmedTokenText.length() == 0) break;
                    pushback = true;
                    this.state = 0;
                    break;
                }
                case 4: 
                case 5: {
                    char quote;
                    char c = quote = this.state == 4 ? (char)'\'' : '\"';
                    if (tokenId == 4 && this.state == 4 || tokenId == 3 && this.state == 5) {
                        if (isEmpty || tokenText.charAt(0) != quote) break;
                        pushback = true;
                        this.state = 1;
                        break;
                    }
                    pushback = true;
                    this.state = 1;
                    break;
                }
                default: {
                    logger.error("Illegal state.");
                }
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("\t\t\t\t\t==> {}", (Object)this.state);
        } while (pushback);
    }

    @Override
    public int getActivationState() {
        boolean isActive = this.state == 4 || this.state == 5;
        return isActive ? -1 : -2;
    }

    @Override
    public ActivationRange[] getRanges() {
        ActivationRange[] ranges = null;
        if (this.lastUpdatedTokenId == 3 || this.lastUpdatedTokenId == 4) {
            int len = this.lastUpdatedOriginalTokenText.length();
            if (this.state == 4 || this.state == 5) {
                char ch = this.state == 4 ? (char)'\'' : '\"';
                int beginIndex = ch == this.lastUpdatedOriginalTokenText.charAt(0) ? 1 : 0;
                int endIndex = len > 1 ? (ch == this.lastUpdatedOriginalTokenText.charAt(len - 1) ? len - 1 : len) : beginIndex;
                if (endIndex >= beginIndex) {
                    ranges = new ActivationRange[]{new ActivationRange(beginIndex, endIndex)};
                }
            }
        }
        if (ranges != null && ranges.length == 0) {
            ranges = null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Created ranges {}", (Object)Arrays.toString(ranges));
        }
        return ranges;
    }
}

