/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tokenmarker.xhtml;

import com.oxygenxml.tokenmarker.activation.AbstractXMLActivationRule;
import com.oxygenxml.tokenmarker.activation.ActivationRange;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSSInAttributeActivationRule
extends AbstractXMLActivationRule {
    protected static final byte S_XE_RECOGNIZED_OPEN_TAG = 1;
    protected static final byte S_XE_RECOGNIZED_ATTRIBUTE_NAME = 2;
    protected static final byte S_XE_RECOGNIZED_EQUALS_OPERATOR = 3;
    protected static final byte S_XE_ACTIVE_SQ = 10;
    protected static final byte S_XE_ACTIVE_DQ = 11;
    protected static final Logger logger = LoggerFactory.getLogger((String)CSSInAttributeActivationRule.class.getName());
    private String lastUpdatedOriginalTokenText;
    private byte lastUpdatedTokenId;

    @Override
    public void update(byte tokenId, String originalTokenText, String trimmedTokenText) {
        this.lastUpdatedTokenId = tokenId;
        this.lastUpdatedOriginalTokenText = originalTokenText;
        String tokenText = trimmedTokenText;
        boolean isEmpty = tokenText.length() == 0;
        boolean pushback = false;
        do {
            if (logger.isDebugEnabled()) {
                logger.debug("Updating {} - '{}'\t in state {}{}", new Object[]{tokenId, trimmedTokenText, this.state, pushback ? " (pushed back)" : ""});
            }
            pushback = false;
            switch (this.state) {
                case 0: {
                    if (!this.isStartTag(tokenId) || tokenText.startsWith("</")) break;
                    this.state = 1;
                    break;
                }
                case 1: {
                    if (tokenId == 7 && tokenText.equals("style")) {
                        this.state = (byte)2;
                        break;
                    }
                    if (tokenId == 7 || tokenId == 9 || tokenId == 3 || tokenId == 4) break;
                    if (this.isStartTag(tokenId)) {
                        this.state = 0;
                        pushback = true;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                case 2: {
                    if (tokenId == 9 && "=".equals(tokenText)) {
                        this.state = (byte)3;
                        break;
                    }
                    if (tokenId == 7 && trimmedTokenText.length() == 0) break;
                    if (this.isStartTag(tokenId)) {
                        this.state = 0;
                        pushback = true;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                case 3: {
                    if (tokenId == 4) {
                        this.state = (byte)10;
                        break;
                    }
                    if (tokenId == 3) {
                        this.state = (byte)11;
                        break;
                    }
                    if (tokenId == 7 && trimmedTokenText.length() == 0) break;
                    pushback = true;
                    this.state = 0;
                    break;
                }
                case 10: {
                    if (tokenId == 4) {
                        if (isEmpty || tokenText.charAt(0) == '\'') break;
                        break;
                    }
                    pushback = true;
                    this.state = 1;
                    break;
                }
                case 11: {
                    if (tokenId == 3) {
                        if (isEmpty || tokenText.charAt(0) == '\"') break;
                        break;
                    }
                    pushback = true;
                    this.state = 1;
                    break;
                }
                default: {
                    logger.error("Illegal state.");
                }
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("\t\t\t\t\t==> {}", (Object)this.state);
        } while (pushback);
    }

    @Override
    public ActivationRange[] getRanges() {
        ActivationRange[] ranges = null;
        if (this.lastUpdatedTokenId == 3 || this.lastUpdatedTokenId == 4) {
            int len = this.lastUpdatedOriginalTokenText.length();
            if (this.state == 10 || this.state == 11) {
                char ch = this.state == 10 ? (char)'\'' : '\"';
                int beginIndex = ch == this.lastUpdatedOriginalTokenText.charAt(0) ? 1 : 0;
                int endIndex = ch == this.lastUpdatedOriginalTokenText.charAt(len - 1) ? len - 1 : len;
                if (endIndex >= beginIndex) {
                    ranges = new ActivationRange[]{new ActivationRange(beginIndex, endIndex)};
                }
            }
        }
        if (ranges != null && ranges.length == 0) {
            ranges = null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Created ranges {}", (Object)Arrays.toString(ranges));
        }
        return ranges;
    }

    @Override
    public int getActivationState() {
        boolean isActive = this.state == 10 || this.state == 11;
        return isActive ? 6 : -2;
    }

    @Override
    public boolean isStartTag(byte tokenID) {
        return super.isStartTag(tokenID) || tokenID == 17;
    }
}

