/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tokenmarker.activation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XPathAttributesUtil {
    private static final Map<String, List<String>> XSD_XPATH_ATTRS = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> XSLT_XPATH_ATTRS = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> XSPEC_XPATH_ATTRS = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> SCH_XPATH_ATTRS = new HashMap<String, List<String>>();
    private static final String USE_WHEN = "use-when";
    private static final String MATCH = "match";
    private static final String SELECT = "select";
    private static final String TEST = "test";
    private static final String XPATH = "xpath";
    private static final String PARAM = "param";
    private static final String ASSERT = "assert";

    private XPathAttributesUtil() {
    }

    private static void initXSLTMap() {
        XSLT_XPATH_ATTRS.put("accumulator", Arrays.asList("applies-to", "initial-value", USE_WHEN));
        XSLT_XPATH_ATTRS.put("accumulator-rule", Arrays.asList(MATCH, SELECT, USE_WHEN));
        XSLT_XPATH_ATTRS.put("analyze-string", Arrays.asList(SELECT, USE_WHEN));
        XSLT_XPATH_ATTRS.put("apply-templates", Arrays.asList(SELECT, USE_WHEN));
        XSLT_XPATH_ATTRS.put(ASSERT, Arrays.asList(SELECT, TEST, USE_WHEN));
        XSLT_XPATH_ATTRS.put("attribute", Arrays.asList(SELECT, USE_WHEN));
        XSLT_XPATH_ATTRS.put("break", Arrays.asList(SELECT, USE_WHEN));
        XSLT_XPATH_ATTRS.put("catch", Arrays.asList(SELECT, USE_WHEN));
        XSLT_XPATH_ATTRS.put("comment", Arrays.asList(SELECT, USE_WHEN));
        XSLT_XPATH_ATTRS.put("copy", Arrays.asList(SELECT, "on-empty", USE_WHEN));
        XSLT_XPATH_ATTRS.put("copy-of", Arrays.asList(SELECT, USE_WHEN));
        XSLT_XPATH_ATTRS.put("element", Arrays.asList("on-empty", USE_WHEN));
        XSLT_XPATH_ATTRS.put("evaluate", Arrays.asList(XPATH, "with-params", "context-item", "namespace-context", USE_WHEN));
        XSLT_XPATH_ATTRS.put("for-each", Arrays.asList(SELECT, USE_WHEN));
        XSLT_XPATH_ATTRS.put("for-each-group", Arrays.asList(SELECT, "group-by", "group-adjacent", "group-starting-with", "group-ending-with", USE_WHEN));
        XSLT_XPATH_ATTRS.put("if", Arrays.asList(TEST, USE_WHEN));
        XSLT_XPATH_ATTRS.put("iterate", Arrays.asList(SELECT, USE_WHEN));
        XSLT_XPATH_ATTRS.put("key", Arrays.asList(MATCH, "use", USE_WHEN));
        XSLT_XPATH_ATTRS.put("map-entry", Arrays.asList("key", SELECT, USE_WHEN));
        XSLT_XPATH_ATTRS.put("merge-key", Arrays.asList(SELECT, USE_WHEN));
        XSLT_XPATH_ATTRS.put("merge-source", Arrays.asList(SELECT, "for-each-item", "for-each-stream", USE_WHEN));
        XSLT_XPATH_ATTRS.put("message", Arrays.asList(SELECT, USE_WHEN));
        XSLT_XPATH_ATTRS.put("namespace", Arrays.asList(SELECT, USE_WHEN));
        XSLT_XPATH_ATTRS.put("number", Arrays.asList(SELECT, "value", "count", "from", USE_WHEN));
        XSLT_XPATH_ATTRS.put("on-completion", Arrays.asList(SELECT, USE_WHEN));
        XSLT_XPATH_ATTRS.put("on-empty", Arrays.asList(SELECT, USE_WHEN));
        XSLT_XPATH_ATTRS.put("on-non-empty", Arrays.asList(SELECT, USE_WHEN));
        XSLT_XPATH_ATTRS.put("package", Arrays.asList(USE_WHEN));
        XSLT_XPATH_ATTRS.put(PARAM, Arrays.asList(SELECT, USE_WHEN));
        XSLT_XPATH_ATTRS.put("perform-sort", Arrays.asList(SELECT, USE_WHEN));
        XSLT_XPATH_ATTRS.put("processing-instruction", Arrays.asList(SELECT, USE_WHEN));
        XSLT_XPATH_ATTRS.put("sequence", Arrays.asList(SELECT, USE_WHEN));
        XSLT_XPATH_ATTRS.put("sort", Arrays.asList(SELECT, USE_WHEN));
        XSLT_XPATH_ATTRS.put("stylesheet", Arrays.asList(USE_WHEN));
        XSLT_XPATH_ATTRS.put("value-of", Arrays.asList(SELECT, USE_WHEN));
        XSLT_XPATH_ATTRS.put("variable", Arrays.asList(SELECT, USE_WHEN));
        XSLT_XPATH_ATTRS.put("when", Arrays.asList(TEST, USE_WHEN));
        XSLT_XPATH_ATTRS.put("with-param", Arrays.asList(SELECT, USE_WHEN));
        XSLT_XPATH_ATTRS.put("template", Arrays.asList(MATCH, USE_WHEN));
        XSLT_XPATH_ATTRS.put("transform", Arrays.asList(USE_WHEN));
        XSLT_XPATH_ATTRS.put("try", Arrays.asList(SELECT, USE_WHEN));
        XSLT_XPATH_ATTRS.put("set-attribute", Arrays.asList(SELECT));
        XSLT_XPATH_ATTRS.put("set-property", Arrays.asList("object", SELECT));
        XSLT_XPATH_ATTRS.put("assign", Arrays.asList(SELECT));
        XSLT_XPATH_ATTRS.put("return", Arrays.asList(SELECT));
        XSLT_XPATH_ATTRS.put("while", Arrays.asList(TEST));
    }

    private static void initXSDMap() {
        XSD_XPATH_ATTRS.put("alternative", Arrays.asList(TEST));
        XSD_XPATH_ATTRS.put(ASSERT, Arrays.asList(TEST));
        XSD_XPATH_ATTRS.put("field", Arrays.asList(XPATH));
        XSD_XPATH_ATTRS.put("selector", Arrays.asList(XPATH));
    }

    private static void initSchematronMap() {
        SCH_XPATH_ATTRS.put("rule", Arrays.asList("context"));
        SCH_XPATH_ATTRS.put("let", Arrays.asList("value"));
        SCH_XPATH_ATTRS.put("name", Arrays.asList("path"));
        SCH_XPATH_ATTRS.put("value-of", Arrays.asList(SELECT));
        SCH_XPATH_ATTRS.put(ASSERT, Arrays.asList(TEST, "subject"));
        SCH_XPATH_ATTRS.put("report", Arrays.asList(TEST, "subject"));
        SCH_XPATH_ATTRS.put("pattern", Arrays.asList("documents"));
        SCH_XPATH_ATTRS.put("add", Arrays.asList(MATCH, SELECT, USE_WHEN));
        SCH_XPATH_ATTRS.put("delete", Arrays.asList(MATCH, USE_WHEN));
        SCH_XPATH_ATTRS.put("replace", Arrays.asList(MATCH, SELECT, USE_WHEN));
        SCH_XPATH_ATTRS.put("stringReplace", Arrays.asList(MATCH, SELECT, USE_WHEN));
        SCH_XPATH_ATTRS.put("keep", Arrays.asList(SELECT));
        SCH_XPATH_ATTRS.put("fix", Arrays.asList(USE_WHEN, "use-for-each"));
        SCH_XPATH_ATTRS.put("group", Arrays.asList(USE_WHEN));
        SCH_XPATH_ATTRS.put(PARAM, Arrays.asList("default"));
        SCH_XPATH_ATTRS.put("with-param", Arrays.asList(SELECT));
        SCH_XPATH_ATTRS.put("user-entry", Arrays.asList("default"));
    }

    public static Map<String, List<String>> getSchematronElementsToXPathAttributesMap() {
        if (SCH_XPATH_ATTRS.isEmpty()) {
            XPathAttributesUtil.initSchematronMap();
        }
        return SCH_XPATH_ATTRS;
    }

    public static Map<String, List<String>> getSchemaElementsToXPathAttributesMap() {
        if (XSD_XPATH_ATTRS.isEmpty()) {
            XPathAttributesUtil.initXSDMap();
        }
        return XSD_XPATH_ATTRS;
    }

    public static Map<String, List<String>> getStylesheetElementsToXPathAttributesMap() {
        if (XSLT_XPATH_ATTRS.isEmpty()) {
            XPathAttributesUtil.initXSLTMap();
        }
        return XSLT_XPATH_ATTRS;
    }

    public static Map<String, List<String>> getXSPECElementsToXPathAttributesMap() {
        if (XSPEC_XPATH_ATTRS.isEmpty()) {
            XPathAttributesUtil.initXSPECMap();
        }
        return XSPEC_XPATH_ATTRS;
    }

    private static void initXSPECMap() {
        XSPEC_XPATH_ATTRS.put("context", Arrays.asList(SELECT));
        XSPEC_XPATH_ATTRS.put("expect", Arrays.asList(SELECT, TEST));
        XSPEC_XPATH_ATTRS.put(PARAM, Arrays.asList(SELECT));
    }
}

