/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tokenmarker.activation;

import com.oxygenxml.tokenmarker.activation.AbstractXMLActivationRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceActivationRule
extends AbstractXMLActivationRule {
    private static final Logger logger = LoggerFactory.getLogger((String)SequenceActivationRule.class.getName());
    private SequencePart[] activationSequence;
    private byte[] activationPreservatingTokens;
    private SequencePart inactivationSequence;

    public SequenceActivationRule(SequencePart[] activationSequence, byte[] activationPreservatingTokens) {
        this.activationSequence = activationSequence;
        this.activationPreservatingTokens = activationPreservatingTokens;
        this.inactivationSequence = null;
    }

    public SequenceActivationRule(SequencePart[] activationSequence, byte[] activationPreservatingTokens, SequencePart inactivationSequence) {
        this.activationSequence = activationSequence;
        this.activationPreservatingTokens = activationPreservatingTokens;
        this.inactivationSequence = inactivationSequence;
    }

    @Override
    public void update(byte tokenId, String originalTokenText, String trimmedTokenText) {
        String tokenText = trimmedTokenText;
        if (logger.isDebugEnabled()) {
            logger.debug("Update '{}' is active {}", (Object)tokenText, (Object)this.getActivationState());
        }
        if (this.isInactivateSequencePart(tokenId, tokenText)) {
            this.reset();
        } else {
            if (this.state == this.activationSequence.length) {
                boolean keepActive = false;
                for (int i = 0; i < this.activationPreservatingTokens.length; ++i) {
                    if (tokenId != this.activationPreservatingTokens[i]) continue;
                    keepActive = true;
                }
                if (!keepActive) {
                    this.reset();
                }
            }
            if (this.state < this.activationSequence.length) {
                SequencePart sp = this.activationSequence[this.state];
                if (sp.matchType != SequencePart.Match.MATCH_ANY) {
                    if (sp.matches(tokenId, tokenText)) {
                        this.state = (byte)(this.state + 1);
                    } else {
                        this.reset();
                    }
                } else {
                    sp = this.activationSequence[this.state + 1];
                    if (sp.matches(tokenId, tokenText)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Moving to part after ANY.");
                        }
                        this.state = (byte)(this.state + 2);
                    }
                }
            }
        }
    }

    private boolean isInactivateSequencePart(byte tokenId, String tokenText) {
        return this.inactivationSequence != null && this.inactivationSequence.matches(tokenId, tokenText);
    }

    private void reset() {
        if (logger.isDebugEnabled()) {
            logger.debug("Resetting.");
        }
        this.state = 0;
    }

    @Override
    public int getActivationState() {
        boolean isActive;
        boolean bl = isActive = this.state == this.activationSequence.length;
        if (logger.isDebugEnabled()) {
            logger.debug("Rule active: {}", (Object)isActive);
        }
        return isActive ? -1 : -2;
    }

    public static class SequencePart {
        private byte tokenId;
        private String tokenText;
        private Match matchType;
        private byte alternativeTokenId = (byte)-1;

        public SequencePart(byte tokenId, String tokenText, Match matchType) {
            this.tokenId = tokenId;
            this.tokenText = tokenText;
            if (matchType != Match.MATCH_ANY && matchType != Match.MATCH_ANY_WITH_ID && tokenText == null) {
                logger.error("Cannot hava a rule matching a string with null text.");
            }
            this.matchType = matchType;
        }

        public SequencePart(byte tokenId, String tokenText) {
            this(tokenId, tokenText, Match.MATCH_EQUALS);
        }

        public SequencePart() {
            this(0, null, Match.MATCH_ANY);
        }

        public SequencePart(byte tokenId) {
            this(tokenId, null, Match.MATCH_ANY_WITH_ID);
        }

        public SequencePart(byte tokenId1, byte tokenId2) {
            this(tokenId1, null, Match.MATCH_ANY_WITH_ID);
            this.alternativeTokenId = tokenId2;
        }

        public String toString() {
            return "SequencePart{ " + this.tokenId + " - " + this.tokenText + " - " + this.matchType + " }";
        }

        public boolean matches(byte tokenId, String tokenText) {
            boolean match = false;
            if (this.matchType == Match.MATCH_STARTS_WITH) {
                match = this.tokenId == tokenId && tokenText.startsWith(this.tokenText);
            } else if (this.matchType == Match.MATCH_EQUALS) {
                match = this.tokenId == tokenId && this.tokenText.equalsIgnoreCase(tokenText);
            } else if (this.matchType == Match.MATCH_ANY) {
                match = true;
            } else if (this.matchType == Match.MATCH_ANY_WITH_ID) {
                match = this.tokenId == tokenId || this.alternativeTokenId == tokenId;
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("MC {}", (Object)this);
                }
                boolean bl = match = this.tokenId == tokenId && tokenText.toLowerCase().contains(this.tokenText.toLowerCase());
            }
            if (match && logger.isDebugEnabled()) {
                logger.debug(" -  match on {}", (Object)this);
            }
            return match;
        }

        public static enum Match {
            MATCH_STARTS_WITH,
            MATCH_EQUALS,
            MATCH_CONTAINS,
            MATCH_ANY,
            MATCH_ANY_WITH_ID;

        }
    }
}

