/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.json.instance.generator.engine;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.json.instance.generator.JsonGeneratorUtil;
import ro.sync.json.instance.generator.engine.JsonGeneratorEngine;

public class StringGenerator {
    private JsonGeneratorEngine generator;
    private static final int SIZE = 256;
    static final int MIN_STRING_LENGTH = 1;
    static final int MAX_STRING_LENGTH = 20;
    private static final int GENERATION_ATTEMPTS = 50;
    private static final int MAX_MONTHS_VALUE = 12;
    private static final int MAX_DAYS_VALUE = 30;
    private static final int MAX_HOURS_VALUE = 24;
    private static final int MAX_MINUTES_VALUE = 60;
    private static final int MAX_SECONDS_VALUE = 60;
    private static final int DEFAULT_YEAR_VALUE = 2000;
    private static final int MILLENNIUM = 1000;
    private static final String EMAIL_DOMAIN = "@domain.com";
    private final boolean isRandom;
    private final boolean isDefault;
    private static final Logger logger = LoggerFactory.getLogger((String)StringGenerator.class.getName());

    public StringGenerator(JsonGeneratorEngine generatorEngine) {
        this.generator = generatorEngine;
        this.isRandom = this.generator.getOptions().getPropValuesGeneration().equals("Random");
        this.isDefault = this.generator.getOptions().getPropValuesGeneration().equals("Default");
    }

    private String getFormattedString(String format) {
        Random r = JsonGeneratorUtil.NUMBER_GENERATOR;
        Object formatString = "";
        if (format.equals("email")) {
            formatString = (this.isRandom ? JsonGeneratorUtil.generateRandomString(20).toLowerCase() : "example") + EMAIL_DOMAIN;
        } else if (format.equals("date-time")) {
            LocalDateTime dateTime = LocalDateTime.of(2000, 1, 1, 1, 1, 1);
            if (this.isRandom) {
                int year = r.nextInt(1000) + 1000;
                int month = r.nextInt(12) + 1;
                int dayOfMonth = month == 2 ? r.nextInt(28) + 1 : r.nextInt(30) + 1;
                int hour = r.nextInt(24);
                int minute = r.nextInt(60);
                int second = r.nextInt(59) + 1;
                try {
                    dateTime = LocalDateTime.of(year, month, dayOfMonth, hour, minute, second);
                }
                catch (DateTimeException dateTimeException) {
                    // empty catch block
                }
            }
            formatString = dateTime.toString() + "Z";
        } else if (format.equals("date")) {
            LocalDate date = LocalDate.of(2000, 1, 1);
            if (this.isRandom) {
                int year = r.nextInt(1000) + 1000;
                int month = r.nextInt(12) + 1;
                int dayOfMonth = month == 2 ? r.nextInt(28) + 1 : r.nextInt(30) + 1;
                try {
                    date = LocalDate.of(year, month, dayOfMonth);
                }
                catch (DateTimeException dateTimeException) {
                    // empty catch block
                }
            }
            formatString = date.toString();
        } else if (format.equals("time")) {
            LocalTime time = LocalTime.of(1, 1, 1);
            if (this.isRandom) {
                time = LocalTime.of(r.nextInt(24), r.nextInt(60), r.nextInt(59) + 1);
            }
            formatString = time.toString() + "Z";
        } else if (format.equals("hostname")) {
            formatString = "www";
        } else if (format.equals("uri") || format.equals("uri-reference")) {
            formatString = "http://example.com/resource?foo=bar#fragment";
        } else if (format.equals("ipv4")) {
            formatString = this.isRandom ? r.nextInt(256) + "." + r.nextInt(256) + "." + r.nextInt(256) + "." + r.nextInt(256) : "0.0.0.0";
        } else if (format.equals("ipv6")) {
            if (this.isRandom) {
                StringBuilder ipv6Format = new StringBuilder();
                for (int i = 0; i < 8; ++i) {
                    ipv6Format.append(r.nextInt(256));
                    if (i > 6) continue;
                    ipv6Format.append(":");
                }
                formatString = ipv6Format.toString();
            } else {
                formatString = "0:0:0:0:0:0:0:1";
            }
        } else if ("duration".equals(format)) {
            formatString = "P3D";
        }
        return formatString;
    }

    public String getPatternMatchingString(Pattern pattern, int minLength, int maxLength) {
        String stringToMatch = "";
        String patternStr = pattern.toString();
        if (patternStr.startsWith("^")) {
            ++minLength;
            ++maxLength;
        }
        if (patternStr.endsWith("$")) {
            ++minLength;
            ++maxLength;
        }
        for (int i = 0; i < 50; ++i) {
            stringToMatch = JsonGeneratorUtil.randomPatternRegExp(pattern.toString(), this.isRandom);
            if (stringToMatch == null) {
                stringToMatch = "";
                continue;
            }
            int length = stringToMatch.length();
            if (length >= minLength && length <= maxLength) break;
        }
        if (stringToMatch.equals("")) {
            logger.warn("The pattern may not be valid.");
        }
        stringToMatch = stringToMatch.replaceAll("\"", "");
        if ((stringToMatch = stringToMatch.replaceAll("\\\\", "")).startsWith("^")) {
            stringToMatch = stringToMatch.substring(1);
        }
        if (stringToMatch.endsWith("$")) {
            stringToMatch = stringToMatch.substring(0, stringToMatch.length() - 1);
        }
        return stringToMatch;
    }

    public String generateFromStringSchema(StringSchema stringSchema) {
        ArrayList<Schema> schemaAsArray = new ArrayList<Schema>();
        schemaAsArray.add((Schema)stringSchema);
        return this.generateFromStringSchemas(schemaAsArray);
    }

    String generateFromStringSchemas(List<Schema> stringSchemas) {
        StringSchema firstSchema = (StringSchema)stringSchemas.get(0);
        Integer minLength = firstSchema.getMinLength();
        Integer maxLength = firstSchema.getMaxLength();
        if (minLength == null && maxLength == null) {
            minLength = 1;
            maxLength = 20;
        }
        String format = firstSchema.getFormatValidator().formatName();
        Pattern pattern = firstSchema.getPattern();
        if (stringSchemas.size() > 1) {
            for (int i = 1; i < stringSchemas.size(); ++i) {
                StringSchema stringSchema = (StringSchema)stringSchemas.get(i);
                if (stringSchema.getMinLength() != null && stringSchema.getMinLength() > minLength) {
                    minLength = stringSchema.getMinLength();
                }
                if (stringSchema.getMaxLength() != null && stringSchema.getMaxLength() < maxLength) {
                    maxLength = stringSchema.getMaxLength();
                }
                format = stringSchema.getFormatValidator().formatName();
                if (stringSchema.getPattern() == null) continue;
                pattern = stringSchema.getPattern();
            }
        }
        return "\"" + this.generateString(minLength, maxLength, format, pattern, firstSchema.getUnprocessedProperties()) + "\"";
    }

    private String generateString(Integer minLength, Integer maxLength, String format, Pattern pattern, Map<String, Object> unprocessedProps) {
        String stringToGenerate = "";
        Object defaultValue = unprocessedProps.getOrDefault("default", null);
        ArrayList examples = unprocessedProps.getOrDefault("examples", null);
        if (this.isDefault && (defaultValue != null || examples != null)) {
            if (defaultValue != null) {
                stringToGenerate = defaultValue.toString();
            } else if (!examples.isEmpty()) {
                stringToGenerate = examples.get(0).toString();
            }
        } else if (this.isDefault || this.isRandom) {
            if (!format.equals("unnamed-format")) {
                stringToGenerate = this.getFormattedString(format);
            } else if (pattern != null) {
                stringToGenerate = this.getPatternMatchingString(pattern, minLength, maxLength);
            } else if (this.isRandom) {
                if (minLength != null && maxLength != null) {
                    int stringLength = JsonGeneratorUtil.NUMBER_GENERATOR.nextInt(maxLength - minLength + 1) + minLength;
                    stringToGenerate = JsonGeneratorUtil.generateRandomString(stringLength);
                } else if (minLength != null) {
                    int stringLength = JsonGeneratorUtil.NUMBER_GENERATOR.nextInt(20) + minLength;
                    stringToGenerate = JsonGeneratorUtil.generateRandomString(stringLength);
                } else {
                    int stringLength = JsonGeneratorUtil.NUMBER_GENERATOR.nextInt(maxLength);
                    stringToGenerate = JsonGeneratorUtil.generateRandomString(stringLength);
                }
            } else {
                stringToGenerate = this.generator.getLastProperty();
            }
        }
        return stringToGenerate;
    }
}

