/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.json.instance.generator.engine;

import java.util.Collections;
import java.util.List;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.ConstSchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.NotSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import ro.sync.json.instance.generator.JsonGeneratorUtil;
import ro.sync.json.instance.generator.engine.JsonGeneratorEngine;

public class OtherSchemaGenerator {
    private JsonGeneratorEngine generator;
    private final boolean isRandom;
    private final boolean isDefault;
    private final boolean isNone;

    public OtherSchemaGenerator(JsonGeneratorEngine generatorEngine) {
        this.generator = generatorEngine;
        this.isRandom = this.generator.getOptions().getPropValuesGeneration().equals("Random");
        this.isDefault = this.generator.getOptions().getPropValuesGeneration().equals("Default");
        this.isNone = this.generator.getOptions().getPropValuesGeneration().equals("None");
    }

    String generateFromEnumSchema(EnumSchema enumSchema) {
        Object enumString = null;
        if (this.isNone) {
            enumString = "\"\"";
        } else {
            Object defaultValue = enumSchema.getUnprocessedProperties().getOrDefault("default", null);
            if (this.isDefault && defaultValue != null) {
                enumString = defaultValue instanceof String ? "\"" + defaultValue + "\"" : enumSchema.getDefaultValue().toString();
            } else {
                List enumValues = enumSchema.getPossibleValuesAsList();
                int randomIndex = JsonGeneratorUtil.NUMBER_GENERATOR.nextInt(enumSchema.getPossibleValues().size());
                enumString = enumValues.get(0) instanceof String ? "\"" + (this.isRandom ? enumValues.get(randomIndex) : enumValues.get(0)) + "\"" : (this.isRandom ? enumValues.get(randomIndex).toString() : enumValues.get(0).toString());
            }
        }
        return enumString;
    }

    String generateFromReferenceSchema(ReferenceSchema referenceSchema) {
        String stringFromRefSchema = "";
        this.generator.addReferredSchema(referenceSchema.getReferredSchema());
        if (Collections.frequency(this.generator.getReferredSchemas(), referenceSchema.getReferredSchema()) <= this.generator.getOptions().getRecursionLevel()) {
            stringFromRefSchema = this.generator.generateInstance(referenceSchema.getReferredSchema());
        } else if (referenceSchema.getReferredSchema() instanceof ObjectSchema) {
            stringFromRefSchema = "{}";
        } else if (referenceSchema.getReferredSchema() instanceof ArraySchema) {
            stringFromRefSchema = "[]";
        }
        this.generator.popSchema();
        return stringFromRefSchema;
    }

    String generateFromConstSchema(ConstSchema constSchema) {
        Object permittedValue = constSchema.getPermittedValue();
        Object constValue = null;
        if (permittedValue instanceof String) {
            constValue = "\"" + permittedValue.toString() + "\"";
        } else if (permittedValue != null) {
            constValue = permittedValue.toString();
        }
        return constValue;
    }

    String generateFromNotSchema(NotSchema notSchema) {
        Schema mustNotMatch = notSchema.getMustNotMatch();
        if (mustNotMatch instanceof NumberSchema) {
            return "\"not_number\"";
        }
        if (mustNotMatch instanceof ObjectSchema) {
            return "{}";
        }
        if (mustNotMatch instanceof ArraySchema) {
            return "[]";
        }
        return "" + (this.isRandom ? JsonGeneratorUtil.NUMBER_GENERATOR.nextInt(100) : 0);
    }

    String generateFromBooleanSchema(BooleanSchema booleanSchema) {
        boolean randomBool;
        String booleanValue = "false";
        if (this.isDefault) {
            booleanValue = ((Object)booleanSchema.getUnprocessedProperties().getOrDefault("default", false)).toString();
        } else if (this.isRandom && (randomBool = JsonGeneratorUtil.NUMBER_GENERATOR.nextBoolean())) {
            booleanValue = "true";
        }
        return booleanValue;
    }

    String generateFromNullSchema() {
        return "null";
    }

    String generateFromEmptySchema() {
        return "\"\"";
    }
}

