/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.json.instance.generator.engine;

import java.util.List;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.Schema;
import ro.sync.json.instance.generator.JsonGeneratorUtil;
import ro.sync.json.instance.generator.engine.JsonGeneratorEngine;

public class ArrayGenerator {
    private JsonGeneratorEngine generator;
    private static final int DEFAULT_MIN_ITEMS = 1;
    private static final int DEFAULT_MAX_ITEMS = 5;

    public ArrayGenerator(JsonGeneratorEngine generatorEngine) {
        this.generator = generatorEngine;
    }

    String generateFromArraySchema(ArraySchema arraySchema) {
        StringBuilder arrayBuilder = new StringBuilder();
        int minItems = arraySchema.getMinItems() != null ? arraySchema.getMinItems() : 1;
        int maxItems = arraySchema.getMaxItems() != null ? arraySchema.getMaxItems() : minItems + 5;
        String lastPropertyName = this.generator.getLastProperty();
        int numberOfItems = this.generator.getOptions().getPropValuesGeneration().equals("Random") ? JsonGeneratorUtil.NUMBER_GENERATOR.nextInt(maxItems - minItems) + minItems : minItems;
        arrayBuilder.append('[');
        if (arraySchema.getAllItemSchema() != null) {
            for (int i = 0; i < numberOfItems; ++i) {
                this.generator.setLastProperty(lastPropertyName + i);
                arrayBuilder.append(this.generator.generateInstance(arraySchema.getAllItemSchema()));
                if (i >= numberOfItems - 1) continue;
                arrayBuilder.append(',');
            }
        } else if (arraySchema.getItemSchemas() != null) {
            List itemSchemas = arraySchema.getItemSchemas();
            for (Schema itemSchema : itemSchemas) {
                arrayBuilder.append(this.generator.generateInstance(itemSchema)).append(',');
            }
        } else if (arraySchema.getContainedItemSchema() != null) {
            int minContains = arraySchema.getMinContains() != null ? arraySchema.getMinContains() : 0;
            int maxContains = arraySchema.getMaxContains() != null ? arraySchema.getMaxContains() : minContains + 5;
            int containedItems = this.generator.getOptions().getPropValuesGeneration().equals("Random") ? JsonGeneratorUtil.NUMBER_GENERATOR.nextInt(maxContains - minContains) + minContains : minContains;
            for (int i = 0; i < containedItems; ++i) {
                this.generator.setLastProperty(lastPropertyName + i);
                arrayBuilder.append(this.generator.generateInstance(arraySchema.getContainedItemSchema()));
                if (i >= containedItems - 1) continue;
                arrayBuilder.append(',');
            }
        }
        if (this.generator.getOptions().isGenerateAdditionalProps() && arraySchema.getSchemaOfAdditionalItems() != null) {
            arrayBuilder.append(this.generator.generateInstance(arraySchema.getSchemaOfAdditionalItems()));
        }
        if (this.generator.getOptions().isGenerateAdditionalProps() && arraySchema.getSchemaOfUnevaluatedItems() != null) {
            arrayBuilder.append(this.generator.generateInstance(arraySchema.getSchemaOfUnevaluatedItems()));
        }
        if (arrayBuilder.charAt(arrayBuilder.length() - 1) == ',') {
            arrayBuilder.setLength(arrayBuilder.length() - 1);
        }
        arrayBuilder.append(']');
        return arrayBuilder.toString();
    }
}

