/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.json.instance.generator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Random;
import org.apache.xerces.impl.xpath.regex.RegexpInputGeneratorInternal;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import ro.sync.basic.xml.encoding.EncodingDetectorImpl;
import ro.sync.json.instance.generator.JSONGenerationException;

public final class JsonGeneratorUtil {
    public static final String RANDOM = "Random";
    public static final String DEFAULT = "Default";
    public static final String NONE = "None";
    public static final String FIRST = "First";
    public static final String DEFAULT_KEYWORD = "default";
    public static final String EXAMPLES_KEYWORD = "examples";
    public static final RegexpInputGeneratorInternal REGEX_GENERATOR = new RegexpInputGeneratorInternal(10000L);
    public static final Random NUMBER_GENERATOR = new Random();

    private JsonGeneratorUtil() {
    }

    public static boolean isValidJSON(URI contentUri) throws IOException {
        String uploadContent = new String(Files.readAllBytes(Paths.get(contentUri)));
        try {
            new JSONObject(uploadContent);
        }
        catch (JSONException ex) {
            try {
                new JSONArray(uploadContent);
            }
            catch (JSONException ex2) {
                return false;
            }
        }
        return true;
    }

    public static String randomPatternRegExp(String regexp, boolean generateRandom) {
        return REGEX_GENERATOR.generateMatchingInput(regexp, generateRandom);
    }

    public static String generateRandomString(int length) {
        String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        StringBuilder stringBuilder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            stringBuilder.append("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".charAt(NUMBER_GENERATOR.nextInt("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".length())));
        }
        return stringBuilder.toString();
    }

    private static URL getSchemaURL(String schemaSystemID) throws MalformedURLException {
        try {
            return new URL(schemaSystemID);
        }
        catch (MalformedURLException e) {
            return new File(schemaSystemID).toURI().toURL();
        }
    }

    private static InputStream getSchemaStream(URL schemaUrl) throws IOException {
        return schemaUrl.openStream();
    }

    private static JSONObject getJSONObjectFromInputStream(InputStream inputStream) throws IOException {
        InputStreamReader reader = new EncodingDetectorImpl().createReader(inputStream, "", null, "UTF-8", null);
        return new JSONObject(new JSONTokener((Reader)reader));
    }

    public static Schema loadSchemaThroughItsSystemID(String schemaSystemID, SchemaClient clientResolver) throws JSONGenerationException {
        try {
            JSONObject rawSchema = JsonGeneratorUtil.getJSONObjectFromInputStream(JsonGeneratorUtil.getSchemaStream(JsonGeneratorUtil.getSchemaURL(schemaSystemID)));
            return clientResolver == null ? SchemaLoader.load((JSONObject)rawSchema) : SchemaLoader.load((JSONObject)rawSchema, (SchemaClient)clientResolver);
        }
        catch (MalformedURLException e) {
            throw new JSONGenerationException("Malformed schema URL", e);
        }
        catch (IOException e) {
            throw new JSONGenerationException("Cannot read schema: " + schemaSystemID, e);
        }
        catch (SchemaException | JSONException e) {
            throw new JSONGenerationException("Invalid JSON Schema: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new JSONGenerationException("Cannot load schema: " + schemaSystemID, e);
        }
    }

    public static Schema loadSchemaSourceStream(InputStream schemaStream, SchemaClient schemaClientResolver) throws JSONGenerationException {
        try {
            JSONObject rawSchema = JsonGeneratorUtil.getJSONObjectFromInputStream(schemaStream);
            if (schemaClientResolver != null) {
                return SchemaLoader.load((JSONObject)rawSchema, (SchemaClient)schemaClientResolver);
            }
            return SchemaLoader.load((JSONObject)rawSchema);
        }
        catch (JSONException e) {
            throw new JSONGenerationException("Invalid JSON Schema", e);
        }
        catch (Exception e) {
            throw new JSONGenerationException("Cannot load schema: " + e.getMessage(), e);
        }
    }
}

