/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.action.Chevron;
import com.jidesoft.action.CommandBar;
import com.jidesoft.action.CommandBarTitleBar;
import com.jidesoft.action.DockableBar;
import com.jidesoft.plaf.CommandBarTitleBarUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.SpecialIcon;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class BasicCommandBarTitleBarUI
extends CommandBarTitleBarUI {
    private JideButton _closeButton;
    private Chevron _chevron;
    private CommandBarTitleBar _titleBar;
    protected JLabel _title;
    private int _height = 17;
    private int _gap = 1;
    private Color _background;
    private Color _foreground;
    private Font _font;
    private ThemePainter _painter;
    protected PropertyChangeListener propertyListener;

    public BasicCommandBarTitleBarUI(CommandBarTitleBar titleBar) {
        this._titleBar = titleBar;
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicCommandBarTitleBarUI((CommandBarTitleBar)c);
    }

    @Override
    public void installUI(JComponent c) {
        this._titleBar = (CommandBarTitleBar)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        if (c != this._titleBar) {
            throw new IllegalComponentStateException(this + " was asked to deinstall() " + c + " when it only knows about " + this._titleBar + ".");
        }
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
    }

    protected void installComponents() {
        this._titleBar.setForeground(this._foreground);
        this._title = new JLabel(this._titleBar.getTitle());
        this._title.setOpaque(false);
        this._title.setVerticalAlignment(0);
        this._title.setForeground(this._foreground);
        this._title.setFont(this._font);
        this._titleBar.add(this._title);
        this._closeButton = new JideUIButton();
        this._closeButton.setIcon(new SpecialIcon(0, 0));
        this._closeButton.setRolloverIcon(new SpecialIcon(0, 2));
        this._titleBar.add(this._closeButton);
        this._closeButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Container comp = BasicCommandBarTitleBarUI.this._titleBar.getParent();
                if (comp instanceof CommandBar) {
                    ((CommandBar)comp).getDockableBarManager().hideDockableBar(((CommandBar)comp).getKey());
                }
            }
        });
        this._chevron = new Chevron();
        this._titleBar.add(this._chevron);
    }

    protected void uninstallComponents() {
        this._titleBar.remove(this._closeButton);
        this._closeButton = null;
        this._titleBar.remove(this._chevron);
        this._chevron = null;
        this._titleBar.remove(this._title);
        this._title = null;
    }

    protected void installDefaults() {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        this._titleBar.setLayout(this.createLayout());
        this._height = UIDefaultsLookup.getInt("CommandBar.titleBarSize");
        this._gap = UIDefaultsLookup.getInt("CommandBar.titleBarButtonGap");
        this._background = UIDefaultsLookup.getColor("CommandBar.titleBarBackground");
        this._foreground = UIDefaultsLookup.getColor("CommandBar.titleBarForeground");
        this._font = UIDefaultsLookup.getFont("CommandBar.titleBarFont");
    }

    protected void uninstallDefaults() {
        this._painter = null;
        this._background = null;
        this._foreground = null;
        this._font = null;
    }

    protected void installListeners() {
        this.propertyListener = this.createPropertyListener();
        if (this.propertyListener != null) {
            this._titleBar.addPropertyChangeListener(this.propertyListener);
        }
    }

    protected void uninstallListeners() {
        if (this.propertyListener != null) {
            this._titleBar.removePropertyChangeListener(this.propertyListener);
            this.propertyListener = null;
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this._title.setOpaque(false);
        this._title.setFont(this._font);
        this._title.setForeground(this._foreground);
        CommandBarTitleBar titlebar = (CommandBarTitleBar)c;
        int width = titlebar.getWidth();
        int height = titlebar.getHeight();
        this.getPainter().paintCommandBarTitlePane(titlebar, g, new Rectangle(0, 0, width, height), 0, 0);
    }

    protected LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    public ThemePainter getPainter() {
        return this._painter;
    }

    protected PropertyChangeListener createPropertyListener() {
        return new PropertyListener();
    }

    protected class PropertyListener
    implements PropertyChangeListener {
        protected PropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("title")) {
                BasicCommandBarTitleBarUI.this._title.setText(BasicCommandBarTitleBarUI.this._titleBar.getTitle());
            }
        }
    }

    private static class JideUIButton
    extends JideButton
    implements UIResource {
        public JideUIButton() {
            this.setRequestFocusEnabled(false);
            this.setFocusable(false);
            this.setRolloverEnabled(true);
            this.setForeground(null);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setForeground(null);
        }
    }

    public class TitlePaneLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return new Dimension(BasicCommandBarTitleBarUI.this._height, BasicCommandBarTitleBarUI.this._height);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container c) {
            Object object = c.getTreeLock();
            synchronized (object) {
                Rectangle rect = new Rectangle(c.getWidth() - BasicCommandBarTitleBarUI.this._height, 0, BasicCommandBarTitleBarUI.this._height, BasicCommandBarTitleBarUI.this._height);
                Container comp = BasicCommandBarTitleBarUI.this._titleBar.getParent();
                if (comp instanceof DockableBar) {
                    DockableBar dockableBar = (DockableBar)comp;
                    if (dockableBar.isHidable() && (dockableBar.getDockableBarManager() == null || dockableBar.getDockableBarManager().isHidable())) {
                        BasicCommandBarTitleBarUI.this._closeButton.setBounds(rect);
                        BasicCommandBarTitleBarUI.this._closeButton.setVisible(true);
                        rect.x -= BasicCommandBarTitleBarUI.this._height + BasicCommandBarTitleBarUI.this._gap;
                    } else {
                        BasicCommandBarTitleBarUI.this._closeButton.setVisible(false);
                    }
                    if (BasicCommandBarTitleBarUI.this._chevron.isShowOptions() || BasicCommandBarTitleBarUI.this._chevron.isShowMore()) {
                        BasicCommandBarTitleBarUI.this._chevron.setBounds(rect);
                        BasicCommandBarTitleBarUI.this._chevron.setVisible(true);
                    } else {
                        BasicCommandBarTitleBarUI.this._chevron.setVisible(false);
                    }
                }
                BasicCommandBarTitleBarUI.this._title.setBounds(3, 0, rect.x, BasicCommandBarTitleBarUI.this._height);
            }
        }
    }
}

