/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.AutoHideContainer;
import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.ContainerContainerDivider;
import com.jidesoft.docking.Dockable;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockableHolder;
import com.jidesoft.docking.DockedFrameContainer;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.FloatingContainer;
import com.jidesoft.docking.FrameContainer;
import com.jidesoft.docking.PreviousState;
import com.jidesoft.docking.SlidingOverFrameContainer;
import com.jidesoft.docking.Workspace;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicDockableFrameTitlePane;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSplitPaneDivider;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.swing.SidePaneItem;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SystemInfo;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

class DockingUtils {
    DockingUtils() {
    }

    static int sideOfComponent(Component comp, int x, int y, int sensitiveAreaSize, boolean considerTitlePaneAsNorth) {
        int sensitiveX = Math.min(sensitiveAreaSize, comp.getWidth() / 3);
        int sensitiveY = Math.min(sensitiveAreaSize, comp.getHeight() / 3);
        if (x >= 0 && x < sensitiveX && y >= 0 && y < comp.getHeight()) {
            return 8;
        }
        if (x >= comp.getWidth() - sensitiveX && x < comp.getWidth() && y >= 0 && y <= comp.getHeight()) {
            return 4;
        }
        if (y >= 0 && y < sensitiveY + (comp instanceof FrameContainer && considerTitlePaneAsNorth ? DockingUtils.getTitleBarHeight((FrameContainer)comp) : 0) && x >= 0 && x < comp.getWidth()) {
            return 1;
        }
        if (y >= comp.getHeight() - sensitiveY - (comp instanceof FrameContainer && ((FrameContainer)comp).isTabShown() ? 22 : 0) && y < comp.getHeight() && x >= 0 && x <= comp.getWidth()) {
            return 2;
        }
        if (x > sensitiveX && x < comp.getWidth() - sensitiveX && y > sensitiveY && y < comp.getHeight() - sensitiveY) {
            return 16;
        }
        return 32;
    }

    static int getTitleBarHeight(FrameContainer frameContainer) {
        DockableFrame frame = frameContainer.getSelectedFrame();
        if (frame != null && frame.getUI() != null && frame.getUI().getTitlePane() != null) {
            return frame.getUI().getTitlePane().getHeight();
        }
        return 0;
    }

    static int outsideOfComponent(Component comp, int x, int y, int sensitiveAreaSize) {
        int sensitiveX = Math.min(sensitiveAreaSize, comp.getWidth() / 3);
        int sensitiveY = Math.min(sensitiveAreaSize, comp.getHeight() / 3);
        if (x < 0 && x >= -sensitiveX && y >= 0 && y < comp.getHeight()) {
            return 8;
        }
        if (x < comp.getWidth() + sensitiveX && x >= comp.getWidth() && y >= 0 && y <= comp.getHeight()) {
            return 4;
        }
        if (y < 0 && y >= -sensitiveY && x >= 0 && x < comp.getWidth()) {
            return 1;
        }
        if (y < comp.getHeight() + sensitiveY && y >= comp.getHeight() && x >= 0 && x <= comp.getWidth()) {
            return 2;
        }
        return 32;
    }

    static void dequeueMouseEvents(Map<Component, List<MouseEvent>> unsendEvents, Component comp) {
        List<MouseEvent> eventsOriginal = unsendEvents.remove(comp);
        if (eventsOriginal != null) {
            for (MouseEvent mouseEvent : eventsOriginal) {
                MouseEvent m2 = SwingUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, mouseEvent.getComponent());
                mouseEvent.getComponent().dispatchEvent(m2);
            }
        }
    }

    static Window getWindowFor(Component comp) {
        if (comp instanceof Window) {
            return (Window)comp;
        }
        return SwingUtilities.getWindowAncestor(comp);
    }

    private static boolean isDescendantOfFloatingContainer(Component c) {
        while (c != null) {
            if (c instanceof FloatingContainer) {
                return true;
            }
            c = c.getParent();
        }
        return false;
    }

    static Component getValidParentOf(Component c, DockableFrame f, boolean isSingle) {
        if (c == null) {
            return null;
        }
        if (!f.isFloatable() && DockingUtils.isDescendantOfFloatingContainer(c)) {
            return null;
        }
        if (c instanceof FrameContainer && ((FrameContainer)c).getTabCount() == 1 && ((FrameContainer)c).isAncestorOf(f)) {
            return null;
        }
        if (c instanceof FrameContainer && !isSingle && c.equals(f.getParent())) {
            return null;
        }
        if (DockingUtils.isValidComponent(c, f, isSingle)) {
            return c;
        }
        do {
            if (f.equals(c) && ((FrameContainer)c.getParent()).getTabCount() == 1) {
                return null;
            }
            if (c instanceof BasicDockableFrameTitlePane && c.getParent().equals(f) && ((FrameContainer)c.getParent().getParent()).getTabCount() == 1) {
                return null;
            }
            if (c.getParent() == null) {
                return null;
            }
            if (!isSingle && c.getParent().equals(f.getParent())) {
                return null;
            }
            if ((c = c.getParent()) == null) {
                return null;
            }
            if (!(c instanceof FrameContainer) || ((FrameContainer)c).getTabCount() != 1 || !((FrameContainer)c).isAncestorOf(f)) continue;
            return null;
        } while (!DockingUtils.isValidComponent(c, f, isSingle));
        return c;
    }

    static Component getManagedDockableHolder(DockingManager dockingManager, Class<? extends DockableHolder> clazz, Component c) {
        if (c == null) {
            return null;
        }
        if (clazz.isInstance(c) && c instanceof DockableHolder && ((DockableHolder)((Object)c)).getDockingManager() == dockingManager) {
            return c;
        }
        do {
            if ((c = c.getParent()) != null) continue;
            return null;
        } while (!clazz.isInstance(c) || !(c instanceof DockableHolder) || ((DockableHolder)((Object)c)).getDockingManager() != dockingManager);
        if (!clazz.isInstance(c)) {
            return null;
        }
        return c;
    }

    static List<DockingManager> getDockingManagers(Component c) {
        ArrayList<DockingManager> dockingManagers = new ArrayList<DockingManager>();
        while (c != null) {
            DockingManager dockingManager = null;
            if (c instanceof DockableFrame) {
                dockingManager = ((DockableFrame)c).getDockingManager();
            } else if (c instanceof Workspace) {
                dockingManager = ((Workspace)c).getDockingManager();
            }
            if (dockingManager != null && !dockingManagers.contains(dockingManager)) {
                dockingManagers.add(0, dockingManager);
            }
            c = c.getParent();
        }
        return dockingManagers;
    }

    static boolean isDockingManagerAncestor(Component c, DockingManager dockingManagerFind) {
        while (c != null) {
            DockingManager dockingManager = null;
            if (c instanceof DockableFrame) {
                dockingManager = ((DockableFrame)c).getDockingManager();
            } else if (c instanceof Workspace) {
                dockingManager = ((Workspace)c).getDockingManager();
            }
            if (dockingManager == dockingManagerFind) {
                return true;
            }
            c = c.getParent();
        }
        return false;
    }

    static boolean hasDockingManagerAncestor(Component c) {
        while (c != null) {
            DockingManager dockingManager = null;
            if (c instanceof DockableFrame) {
                dockingManager = ((DockableFrame)c).getDockingManager();
            } else if (c instanceof Workspace) {
                dockingManager = ((Workspace)c).getDockingManager();
            }
            if (dockingManager != null) {
                return true;
            }
            c = c.getParent();
        }
        return false;
    }

    static Component getDockableFrameOrWorkspace(DockingManager dockingManager, Component c) {
        return DockingUtils.getDockableFrameOrWorkspace(dockingManager, c, false);
    }

    static Component getDockableFrameOrWorkspace(DockingManager dockingManager, Component c, boolean firstOccurence) {
        if (c == null) {
            return null;
        }
        if (DockingUtils.isDockableFrameOrWorkspace(dockingManager, c)) {
            return c;
        }
        if (firstOccurence) {
            do {
                if ((c = c.getParent()) != null) continue;
                return null;
            } while (!DockingUtils.isDockableFrameOrWorkspace(c));
            if (c instanceof Workspace && ((Workspace)c).getDockingManager() != dockingManager) {
                c = null;
            } else if (c instanceof DockableFrame && ((DockableFrame)c).getDockingManager() != dockingManager) {
                c = null;
            }
        } else {
            do {
                if ((c = c.getParent()) != null) continue;
                return null;
            } while (!DockingUtils.isDockableFrameOrWorkspace(dockingManager, c));
        }
        return c;
    }

    private static boolean isDockableFrameOrWorkspace(DockingManager dockingManager, Component c) {
        return c instanceof DockableFrame && ((DockableFrame)c).getDockingManager() == dockingManager || c instanceof Workspace && c == dockingManager.getWorkspace();
    }

    private static boolean isDockableFrameOrWorkspace(Component c) {
        return c instanceof DockableFrame || c instanceof Workspace;
    }

    private static boolean isValidComponent(Component c, DockableFrame f, boolean isSingle) {
        return DockingUtils.isValidTargetComponent(c, f, isSingle) && DockingUtils.isSameDockingManager(c, f);
    }

    public static DockingManager getDockingManager(Component c) {
        if (c instanceof BasicDockableFrameTitlePane && c.getParent() instanceof DockableFrame) {
            return ((DockableFrame)c.getParent()).getDockingManager();
        }
        if (c instanceof ContainerContainerDivider && c.getParent() instanceof ContainerContainer) {
            return ((ContainerContainer)c.getParent()).getDockingManager();
        }
        if (c instanceof DockableFrame) {
            return ((DockableFrame)c).getDockingManager();
        }
        if (c instanceof Workspace) {
            return ((Workspace)c).getDockingManager();
        }
        if (c instanceof ContainerContainer) {
            return ((ContainerContainer)c).getDockingManager();
        }
        if (c instanceof FrameContainer) {
            return ((FrameContainer)c).getDockingManager();
        }
        if (c instanceof FloatingContainer) {
            return ((FloatingContainer)((Object)c)).getDockingManager();
        }
        return null;
    }

    public static boolean isSameDockingManager(Component c, DockableFrame f) {
        DockingManager draggingDm = f.getDockingManager();
        DockingManager droppingDm = DockingUtils.getDockingManager(c);
        if (droppingDm != null && draggingDm != null && droppingDm != draggingDm) {
            return draggingDm.isCrossDraggingAllowed() && droppingDm.isCrossDroppingAllowed();
        }
        return droppingDm != null && draggingDm != null;
    }

    private static boolean isValidTargetComponent(Component c, DockableFrame f, boolean isSingle) {
        return c instanceof BasicDockableFrameTitlePane && c.getParent() instanceof DockableFrame && ((DockableFrame)c.getParent()).isTabDockAllowed() && !((DockableFrame)c.getParent()).isMaximized() && c.getParent().getParent() != f.getParent() || c instanceof ContainerContainerDivider && c.getParent() instanceof ContainerContainer && (isSingle && f.getParent() != null && ((FrameContainer)f.getParent()).getTabCount() > 1 || !((ContainerContainer)c.getParent()).isComponentNextToDivider((ContainerContainerDivider)c, f.getParent())) || c instanceof DockableFrame && ((DockableFrame)c).isMaximized() || c instanceof DockableFrame && ((DockableFrame)c).isAutohideShowing() || c instanceof Workspace || c instanceof ContainerContainer || c instanceof FrameContainer || c instanceof FloatingContainer;
    }

    static void floatizeChildrenOf(Container c, DockingManager dockingManager) throws PropertyVetoException {
        for (Component comp : c.getComponents()) {
            if (comp instanceof Container) {
                DockingUtils.floatizeChildrenOf((Container)comp, dockingManager);
            }
            if (!(comp instanceof DockableFrame) || ((DockableFrame)comp).getDockingManager() != dockingManager) continue;
            ((DockableFrame)comp).setFloated(true);
        }
    }

    protected static void dockizeChildrenOf(Container c, DockingManager dockingManager) throws PropertyVetoException {
        for (int i = 0; i < c.getComponentCount(); ++i) {
            if (c.getComponent(i) instanceof Container) {
                DockingUtils.floatizeChildrenOf((Container)c.getComponent(i), dockingManager);
            }
            if (!(c.getComponent(i) instanceof DockableFrame) || ((DockableFrame)c.getComponent(i)).getDockingManager() != dockingManager) continue;
            ((DockableFrame)c.getComponent(i)).setDocked(true);
        }
    }

    protected static Container getValidFloatableParent(DockableFrame f) {
        Container c = f;
        while (!DockingUtils.isValidFloatableComponent(c)) {
            if ((c = c.getParent()) != null) continue;
            return null;
        }
        return c;
    }

    private static boolean isValidFloatableComponent(Component c) {
        return c instanceof ContainerContainer || c instanceof FrameContainer;
    }

    private static void printTabs(int tabs) {
        for (int i = 0; i < tabs; ++i) {
            System.out.print("\t");
        }
    }

    static void printLayout(DockedFrameContainer dockableFrameContainer, int tabs) {
        DockingUtils.printLayout((ContainerContainer)dockableFrameContainer.getNormalContainer().getComponent(0), tabs);
    }

    static void printLayout(ContainerContainer container, int tabs) {
        DockingUtils.printTabs(++tabs);
        Map<Component, Object> maps = ((JideBoxLayout)container.getLayout()).getConstraintMap();
        System.out.println("ContainerContainer " + (container.getOrientation() == 1 ? "(Horizontal) " : "(Vertical) ") + " Count = " + container.getPaneCount());
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            DockingUtils.printTabs(tabs);
            System.out.println("Constraint: " + maps.get(component));
            if (component instanceof ContainerContainerDivider) {
                DockingUtils.printTabs(tabs);
                System.out.println("Divider Size = " + (container.getOrientation() == 1 ? component.getWidth() : component.getHeight()));
                continue;
            }
            if (component instanceof ContainerContainer) {
                DockingUtils.printLayout((ContainerContainer)component, tabs);
                continue;
            }
            if (component instanceof FrameContainer) {
                DockingUtils.printLayout((FrameContainer)component, tabs);
                continue;
            }
            if (component instanceof DockableFrame) {
                DockingUtils.printLayout((DockableFrame)component, tabs);
                continue;
            }
            if (component instanceof Workspace) {
                DockingUtils.printLayout((Workspace)component, tabs);
                continue;
            }
            DockingUtils.printLayout(component, tabs);
        }
    }

    private static void printLayout(FrameContainer container, int tabs) {
        DockingUtils.printTabs(++tabs);
        System.out.println("FrameContainer  Count = " + container.getTabCount() + " DockedWidth = " + container.getDockedWidth() + " DockedHeight = " + container.getDockedHeight() + " AutohideWidth = " + container.getAutohideWidth() + " AutohideHeight = " + container.getAutohideWidth() + " UndockedBounds = " + container.getUndockedBounds());
        for (int i = 0; i < container.getTabCount(); ++i) {
            Component component = container.getComponentAt(i);
            if (component instanceof DockableFrame) {
                DockingUtils.printLayout((DockableFrame)component, tabs);
                continue;
            }
            DockingUtils.printLayout(component, tabs);
        }
    }

    private static void printLayout(Workspace workspace, int tabs) {
        DockingUtils.printTabs(++tabs);
        System.out.println("Workspace");
    }

    private static void printLayout(DockableFrame frame, int tabs) {
        DockingUtils.printTabs(++tabs);
        System.out.println("TitledFrame \"" + frame.getTitle() + "\" Mode = " + frame.getContext().getCurrentMode() + " Side = " + frame.getContext().getCurrentDockSide() + " DockedWidth = " + frame.getDockedWidth() + " DockedHeight = " + frame.getDockedHeight() + " AutohideWidth = " + frame.getAutohideWidth() + " AutohideHeight = " + frame.getAutohideWidth() + " UndockedBounds = " + frame.getUndockedBounds());
    }

    private static void printLayout(Component component, int tabs) {
        DockingUtils.printTabs(++tabs);
    }

    static Container getRootContainer(Component c) {
        if (c instanceof DockedFrameContainer) {
            return (DockedFrameContainer)c;
        }
        if (c instanceof FloatingContainer) {
            return (Container)c;
        }
        Container parent = c.getParent();
        do {
            if (parent == null) {
                return null;
            }
            if (parent instanceof DockedFrameContainer) {
                return parent;
            }
            if (!(parent instanceof FloatingContainer)) continue;
            return parent;
        } while ((parent = parent.getParent()) != null);
        return null;
    }

    static ContainerContainer getContainContainer(Component c) {
        if (c == null) {
            return null;
        }
        Container parent = c.getParent();
        do {
            if (parent != null && parent instanceof ContainerContainer) {
                return (ContainerContainer)parent;
            }
            if (parent != null) continue;
            return null;
        } while ((parent = parent.getParent()) != null);
        return null;
    }

    static boolean containsInMainContainer(DockedFrameContainer dockedFrameContainer, Component c) {
        return c == dockedFrameContainer || dockedFrameContainer.isAncestorOf(c);
    }

    static int sideOf(Rectangle rect1, Rectangle rect2) {
        if (rect1.x >= rect2.x + rect2.width) {
            return 8;
        }
        if (rect1.x + rect1.width <= rect2.x) {
            return 4;
        }
        if (rect1.y >= rect2.y + rect1.height) {
            return 1;
        }
        if (rect1.y + rect1.height <= rect2.y) {
            return 2;
        }
        return 32;
    }

    static Container getContainerContainerOnSide(int side, Container mainContainer, Workspace workspace) {
        if (mainContainer == null || !(mainContainer.getComponent(0) instanceof ContainerContainer)) {
            return null;
        }
        Rectangle wsBounds = DockingUtils.getBounds(workspace);
        Container container = (Container)mainContainer.getComponent(0);
        return DockingUtils.getContainerSideOf(container, wsBounds, side);
    }

    private static Container getContainerSideOf(Container container, Rectangle wsBounds, int side) {
        Rectangle ccBounds = DockingUtils.getBounds(container);
        if ((container instanceof ContainerContainer || container instanceof FrameContainer) && DockingUtils.sideOf(wsBounds, ccBounds) == side) {
            return container;
        }
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Container childContainer;
            Component component = container.getComponent(i);
            if (component instanceof Workspace || component instanceof JideSplitPaneDivider || !(container instanceof Container) || (childContainer = DockingUtils.getContainerSideOf((Container)component, wsBounds, side)) == null) continue;
            return childContainer;
        }
        return null;
    }

    private static Rectangle getBounds(Component component) {
        Rectangle wsBounds = component.getBounds();
        Point wsLocation = wsBounds.getLocation();
        SwingUtilities.convertPointToScreen(wsLocation, component);
        wsBounds.setLocation(wsLocation);
        return wsBounds;
    }

    static int getFrameContainerCount(DockingManager dockingManager, Container container) {
        int count = 0;
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof ContainerContainerDivider) continue;
            if (component instanceof ContainerContainer) {
                count += DockingUtils.getFrameContainerCount(dockingManager, (ContainerContainer)component);
                continue;
            }
            if (component instanceof FrameContainer) {
                if (((FrameContainer)component).getDockingManager() != dockingManager) continue;
                ++count;
                continue;
            }
            if (!(component instanceof DockableFrame) || ((DockableFrame)component).getDockingManager() != dockingManager) continue;
            ++count;
        }
        return count;
    }

    static int getDockableFrameCount(DockingManager dockingManager, Container container) {
        int count = 0;
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof ContainerContainerDivider) continue;
            if (component instanceof ContainerContainer) {
                count += DockingUtils.getDockableFrameCount(dockingManager, (ContainerContainer)component);
                continue;
            }
            if (component instanceof FrameContainer) {
                count += DockingUtils.getDockableFrameCount(dockingManager, (FrameContainer)component);
                continue;
            }
            if (!(component instanceof DockableFrame) || ((DockableFrame)component).getDockingManager() != dockingManager) continue;
            ++count;
        }
        return count;
    }

    static boolean isTabVisible(Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof ContainerContainerDivider) continue;
            if (component instanceof ContainerContainer) {
                return DockingUtils.isTabVisible((ContainerContainer)component);
            }
            if (!(component instanceof FrameContainer)) continue;
            return ((FrameContainer)component).getTabCount() > 1 || !((FrameContainer)component).isHideOneTab();
        }
        return false;
    }

    static void setFrameContainerBorder(Container container, Border border) {
        if (container instanceof FrameContainer) {
            FrameContainer frameContainer = (FrameContainer)container;
            Border b = frameContainer.getBorder();
            if (b == null || b instanceof UIResource) {
                frameContainer.setBorder(border);
            }
            return;
        }
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof ContainerContainer) {
                DockingUtils.setFrameContainerBorder((ContainerContainer)component, border);
                continue;
            }
            if (!(component instanceof FrameContainer)) continue;
            ((FrameContainer)component).setBorder(border);
        }
    }

    static void setDockableFrameBorder(Container container, Border border) {
        if (container instanceof DockableFrame) {
            DockableFrame dockableFrame = (DockableFrame)container;
            Border b = dockableFrame.getBorder();
            if (b == null || b instanceof UIResource) {
                dockableFrame.setBorder(border);
            }
            return;
        }
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof ContainerContainer) {
                DockingUtils.setDockableFrameBorder((ContainerContainer)component, border);
                continue;
            }
            if (component instanceof FrameContainer) {
                DockingUtils.setDockableFrameBorder((FrameContainer)component, border);
                continue;
            }
            if (!(component instanceof DockableFrame)) continue;
            ((DockableFrame)component).setBorder(border);
        }
    }

    static List<Component> getAllChildrenOf(ContainerContainer container) {
        ArrayList<Component> list = new ArrayList<Component>();
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof ContainerContainerDivider) continue;
            if (component instanceof Workspace) {
                list.add(component);
            }
            if (component instanceof ContainerContainer) {
                list.addAll(DockingUtils.getAllChildrenOf((ContainerContainer)component));
                continue;
            }
            if (component instanceof FrameContainer) {
                list.addAll(DockingUtils.getAllChildrenOf((FrameContainer)component));
                continue;
            }
            if (!(component instanceof DockableFrame)) continue;
            list.add(component);
        }
        return list;
    }

    static List<Component> getAllChildrenOf(FrameContainer container) {
        ArrayList<Component> list = new ArrayList<Component>();
        for (int i = 0; i < container.getTabCount(); ++i) {
            list.add(container.getComponentAt(i));
        }
        return list;
    }

    static ArrayList<Integer> getAllChildrenIDOf(ContainerContainer container) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof Workspace) {
                list.add(-1);
                continue;
            }
            if (!(component instanceof Dockable)) continue;
            list.add(((Dockable)((Object)component)).getDockID());
        }
        return list;
    }

    static ArrayList<Integer> getAllChildrenIDOf(FrameContainer container) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < container.getTabCount(); ++i) {
            Component comp = container.getComponentAt(i);
            if (!(comp instanceof DockableFrame)) continue;
            list.add(((DockableFrame)comp).getDockID());
        }
        return list;
    }

    static List<DockableFrame> getAllDockableFrameOf(FrameContainer container) {
        ArrayList<DockableFrame> list = new ArrayList<DockableFrame>();
        for (int i = 0; i < container.getTabCount(); ++i) {
            Component comp = container.getComponentAt(i);
            if (!(comp instanceof DockableFrame)) continue;
            list.add((DockableFrame)comp);
        }
        return list;
    }

    static List<DockableFrame> getAllDockableFrameOf(Container container) {
        if (container instanceof ContainerContainer) {
            return DockingUtils.getAllDockableFrameOf((ContainerContainer)container);
        }
        if (container instanceof FrameContainer) {
            return DockingUtils.getAllDockableFrameOf((FrameContainer)container);
        }
        final ArrayList<DockableFrame> frames = new ArrayList<DockableFrame>();
        JideSwingUtilities.setRecursively(container, new JideSwingUtilities.Handler(){

            @Override
            public boolean condition(Component c) {
                return c instanceof DockableFrame;
            }

            @Override
            public void action(Component c) {
                frames.add((DockableFrame)c);
            }

            @Override
            public void postAction(Component c) {
            }
        });
        return frames;
    }

    static List<DockableFrame> getAllDockableFrameOf(ContainerContainer container) {
        ArrayList<DockableFrame> list = new ArrayList<DockableFrame>();
        for (int i = 0; i < container.getPaneCount(); ++i) {
            Component component = container.getPaneAt(i);
            if (component instanceof DockableFrame) {
                list.add((DockableFrame)component);
            }
            if (component instanceof FrameContainer) {
                list.addAll(DockingUtils.getAllDockableFrameOf((FrameContainer)component));
                continue;
            }
            if (!(component instanceof ContainerContainer)) continue;
            list.addAll(DockingUtils.getAllDockableFrameOf((ContainerContainer)component));
        }
        return list;
    }

    static int convertToDockSide(int side) {
        int dockSide = 32;
        switch (side) {
            case 3: {
                dockSide = 4;
                break;
            }
            case 7: {
                dockSide = 8;
                break;
            }
            case 1: {
                dockSide = 1;
                break;
            }
            case 5: {
                dockSide = 2;
            }
        }
        return dockSide;
    }

    static int[] reorderIndex(int start, int end, int index, int delim) {
        if (delim == -1) {
            return DockingUtils.reorderIndex(start, end, index);
        }
        if (delim > index) {
            return DockingUtils.reorderIndex(start, delim, index);
        }
        if (delim < index) {
            return DockingUtils.reorderIndex(delim, end, index);
        }
        return new int[0];
    }

    static int[] reorderIndex(int start, int end, int index) {
        int count = end - start + 1;
        if (count <= 0) {
            return new int[0];
        }
        int[] idx = new int[count - 1];
        int maxDist = Math.max(index - start, end - index);
        int[] tempIdx = new int[maxDist * 2];
        for (int i = 0; i < maxDist; ++i) {
            tempIdx[2 * i] = index + (i + 1);
            tempIdx[2 * i + 1] = index - (i + 1);
        }
        int j = 0;
        for (int i = 0; i < maxDist * 2; ++i) {
            if (tempIdx[i] < start || tempIdx[i] > end) continue;
            idx[j] = tempIdx[i];
            ++j;
        }
        return idx;
    }

    public static void main(String[] args) {
        int[] indices;
        System.out.println("[0,2] --- 0, 2");
        for (int indice : indices = DockingUtils.reorderIndex(0, 2, 0, 1)) {
            System.out.print(indice + " ");
        }
        System.out.println();
        System.out.println("[0,1] --- 0");
        for (int indice1 : indices = DockingUtils.reorderIndex(0, 1, 0)) {
            System.out.print(indice1 + " ");
        }
        System.out.println();
        System.out.println("[0, 3] --- 0");
        for (int indice2 : indices = DockingUtils.reorderIndex(0, 3, 0)) {
            System.out.print(indice2 + " ");
        }
        System.out.println();
        System.out.println("[0, 7] --- 4");
        for (int indice3 : indices = DockingUtils.reorderIndex(0, 7, 4)) {
            System.out.print(indice3 + " ");
        }
        System.out.println();
        System.out.println("[3, 8] --- 6");
        for (int indice4 : indices = DockingUtils.reorderIndex(3, 8, 6)) {
            System.out.print(indice4 + " ");
        }
        System.out.println();
    }

    static void validateLocations(DockedFrameContainer dockableFrameContainer, Workspace ws) {
        if (dockableFrameContainer != null && dockableFrameContainer.getNormalContainer().getComponentCount() > 0) {
            DockingUtils.validateLocations(ws.getDockingManager(), (ContainerContainer)dockableFrameContainer.getNormalContainer().getComponent(0), ws);
        }
    }

    static void validateLocations(DockingManager dockingManager, Container container, Workspace ws) {
        if (container instanceof ContainerContainer) {
            DockingUtils.validateLocations(dockingManager, (ContainerContainer)container, ws);
        } else {
            DockingUtils.validateLocations(dockingManager, ws);
        }
    }

    static void validateLocations(DockingManager dockingManager, Workspace ws) {
        for (int i = 0; i < ws.getComponentCount(); ++i) {
            Component component = ws.getComponent(i);
            if (!(component instanceof Container)) continue;
            DockingUtils.setLocation(dockingManager, (Container)component, 16);
        }
    }

    static void validateLocations(DockingManager dockingManager, ContainerContainer container, Workspace ws) {
        boolean foundWS = false;
        int orientation = container.getOrientation();
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (!(component instanceof Container)) continue;
            if (!foundWS && (((Container)component).isAncestorOf(ws) || component.equals(ws))) {
                foundWS = true;
                DockingUtils.validateLocations(dockingManager, (Container)component, ws);
                continue;
            }
            if (foundWS) {
                DockingUtils.setLocation(dockingManager, (Container)component, orientation == 1 ? 4 : 2);
                continue;
            }
            DockingUtils.setLocation(dockingManager, (Container)component, orientation == 1 ? 8 : 1);
        }
    }

    static void setLocation(DockingManager dockingManager, Container c, int side) {
        for (int i = 0; i < c.getComponentCount(); ++i) {
            DockableFrame dockableFrame;
            Component component = c.getComponent(i);
            if (component instanceof Container) {
                DockingUtils.setLocation(dockingManager, (Container)component, side);
            }
            if (!(component instanceof DockableFrame) || (dockableFrame = (DockableFrame)component).getDockingManager() != dockingManager || dockableFrame.getContext().getCurrentDockSide() == side) continue;
            dockableFrame.getContext().setCurrentDockSide(side);
        }
    }

    static DockingManager getDockingManager(AWTEvent event, boolean includeFrameControls) {
        Component component;
        Component source = null;
        if (event instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)event;
            Component c = mouseEvent.getComponent();
            if (c == null) {
                return null;
            }
            source = SwingUtilities.getDeepestComponentAt(c, mouseEvent.getX(), mouseEvent.getY());
        } else if (event instanceof KeyEvent && event.getSource() instanceof Component) {
            source = PortingUtils.getCurrentFocusComponent(event);
        } else if (event instanceof FocusEvent) {
            source = PortingUtils.getCurrentFocusComponent(event);
        }
        if (!includeFrameControls && source instanceof JComponent && ((JComponent)source).getClientProperty("ignoreClickToActivate") instanceof Boolean && ((Boolean)((JComponent)source).getClientProperty("ignoreClickToActivate")).booleanValue()) {
            return null;
        }
        if (source instanceof AutoHideContainer && event instanceof MouseEvent) {
            AutoHideContainer ahc = (AutoHideContainer)source;
            int i = ahc.getSelectedItemIndex(((MouseEvent)event).getPoint());
            SidePaneItem spi = null;
            if (i != -1) {
                spi = ahc.getItemForIndex(i);
            }
            if (spi != null && spi.getComponent() instanceof DockableFrame) {
                source = spi.getComponent();
            }
        }
        if (!(source instanceof Workspace) && SwingUtilities.getAncestorOfClass(FrameContainer.class, source) != null && SwingUtilities.getAncestorOfClass(SlidingOverFrameContainer.class, source) == null || source instanceof FrameContainer) {
            FrameContainer container;
            if (!(source instanceof FrameContainer)) {
                source = SwingUtilities.getAncestorOfClass(FrameContainer.class, source);
            }
            source = (container = (FrameContainer)source).getSelectedFrame() != null ? container.getSelectedFrame().getComponent(0) : null;
        }
        if ((component = DockingUtils.getDockableFrameOrWorkspace(source)) instanceof DockableFrame) {
            return ((DockableFrame)component).getDockingManager();
        }
        if (component instanceof Workspace) {
            return ((Workspace)component).getDockingManager();
        }
        return null;
    }

    static Component getDockableFrameOrWorkspace(Component c) {
        if (c == null) {
            return null;
        }
        if (DockingUtils.isDockableFrameOrWorkspace(c)) {
            return c;
        }
        do {
            if ((c = c.getParent()) != null) continue;
            return null;
        } while (!DockingUtils.isDockableFrameOrWorkspace(c));
        return c;
    }

    public static Container getAncestorOfClassButNot(Class<?> c, Component comp, Class<?> not) {
        Container parent;
        if (comp == null || c == null) {
            return null;
        }
        for (parent = comp.getParent(); parent != null && !c.isInstance(parent); parent = parent.getParent()) {
            if (!not.isInstance(parent)) continue;
            return null;
        }
        return parent;
    }

    static Component getSource(DockingManager dockingManager, AWTEvent event, boolean includeFrameControls, boolean firstOccurence) {
        boolean isInWorkspace;
        Component source = null;
        if (event instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)event;
            Component c = mouseEvent.getComponent();
            if (c == null) {
                return null;
            }
            source = SwingUtilities.getDeepestComponentAt(c, mouseEvent.getX(), mouseEvent.getY());
        } else if (event instanceof KeyEvent && event.getSource() instanceof Component) {
            source = PortingUtils.getCurrentFocusComponent(event);
        } else if (event instanceof FocusEvent) {
            source = PortingUtils.getCurrentFocusComponent(event);
        }
        if (!includeFrameControls && source instanceof JComponent && ((JComponent)source).getClientProperty("ignoreClickToActivate") instanceof Boolean && ((Boolean)((JComponent)source).getClientProperty("ignoreClickToActivate")).booleanValue()) {
            return null;
        }
        if (source instanceof AutoHideContainer && event instanceof MouseEvent) {
            AutoHideContainer ahc = (AutoHideContainer)source;
            int i = ahc.getSelectedItemIndex(((MouseEvent)event).getPoint());
            SidePaneItem spi = null;
            if (i != -1) {
                spi = ahc.getItemForIndex(i);
            }
            if (spi != null && spi.getComponent() instanceof DockableFrame) {
                source = spi.getComponent();
            }
        }
        boolean bl = isInWorkspace = source instanceof Workspace || DockingUtils.getAncestorOfClassButNot(Workspace.class, source, FrameContainer.class) != null;
        if (!isInWorkspace && SwingUtilities.getAncestorOfClass(FrameContainer.class, source) != null && SwingUtilities.getAncestorOfClass(SlidingOverFrameContainer.class, source) == null || source instanceof FrameContainer) {
            FrameContainer container;
            Component originalSource = source;
            if (!(source instanceof FrameContainer)) {
                source = SwingUtilities.getAncestorOfClass(FrameContainer.class, source);
            }
            source = (container = (FrameContainer)source).getSelectedFrame() != null ? container.getSelectedFrame().getComponent(0) : null;
            if (event instanceof MouseEvent && event.getSource() instanceof Component && !(originalSource instanceof JideTabbedPane.NoFocusButton)) {
                Point point = SwingUtilities.convertPoint((Component)event.getSource(), ((MouseEvent)event).getPoint(), container);
                int tabIndex = container.getUI().tabForCoordinate(container, point.x, point.y);
                if (tabIndex >= 0 && tabIndex != container.getSelectedIndex() && tabIndex < container.getTabCount() && container.getFrame(tabIndex) != null) {
                    source = container.getFrame(tabIndex).getComponent(0);
                }
            }
        }
        return DockingUtils.getDockableFrameOrWorkspace(dockingManager, source, firstOccurence);
    }

    static void saveClosePreviousState(DockableFrame dockableFrame) {
        if (dockableFrame.isMaximized()) {
            PreviousState.disposePreviousState(dockableFrame.getClosePreviousState());
            dockableFrame.setClosePreviousState(dockableFrame.getMaximizedPreviousState());
        } else {
            PreviousState.disposePreviousState(dockableFrame.getClosePreviousState());
            dockableFrame.setClosePreviousState(PreviousState.createPreviousState(dockableFrame));
        }
    }

    static void saveHiddenPreviousState(DockableFrame dockableFrame) {
        if (dockableFrame.isMaximized()) {
            PreviousState.disposePreviousState(dockableFrame.getHiddenPreviousState());
            dockableFrame.setHiddenPreviousState(dockableFrame.getMaximizedPreviousState());
        } else {
            PreviousState.disposePreviousState(dockableFrame.getHiddenPreviousState());
            dockableFrame.setHiddenPreviousState(PreviousState.createPreviousState(dockableFrame));
        }
    }

    static void saveAvailablePreviousState(DockableFrame dockableFrame) {
        PreviousState.disposePreviousState(dockableFrame.getAvailablePreviousState());
        dockableFrame.setAvailablePreviousState(PreviousState.createPreviousState(dockableFrame));
    }

    static void saveMaximizedPreviousState(DockableFrame dockableFrame) {
        PreviousState.disposePreviousState(dockableFrame.getMaximizedPreviousState());
        dockableFrame.setMaximizedPreviousState(PreviousState.createPreviousState(dockableFrame));
    }

    static void saveDockPreviousState(DockableFrame dockableFrame, boolean isSingle) {
        if (isSingle) {
            PreviousState.disposePreviousState(dockableFrame.getDockPreviousState());
            dockableFrame.setDockPreviousState(PreviousState.createPreviousState(dockableFrame));
        } else {
            FrameContainer fc = (FrameContainer)dockableFrame.getParent();
            for (int i = fc.getTabCount() - 1; i >= 0; --i) {
                DockableFrame selectedFrame = (DockableFrame)fc.getComponentAt(i);
                PreviousState dockState = PreviousState.createPreviousState(selectedFrame);
                PreviousState.disposePreviousState(selectedFrame.getDockPreviousState());
                selectedFrame.setDockPreviousState(dockState);
            }
        }
    }

    static void saveFloatPreviousState(DockableFrame dockableFrame, boolean isSingle) {
        if (isSingle) {
            PreviousState.disposePreviousState(dockableFrame.getFloatPreviousState());
            dockableFrame.setFloatPreviousState(PreviousState.createPreviousState(dockableFrame));
        } else {
            FrameContainer fc = (FrameContainer)dockableFrame.getParent();
            for (int i = fc.getTabCount() - 1; i >= 0; --i) {
                DockableFrame selectedFrame = (DockableFrame)fc.getComponentAt(i);
                PreviousState floatingState = PreviousState.createPreviousState(selectedFrame);
                PreviousState.disposePreviousState(selectedFrame.getFloatPreviousState());
                selectedFrame.setFloatPreviousState(floatingState);
            }
        }
    }

    static void saveAutohidePreviousState(DockableFrame dockableFrame) {
        PreviousState.disposePreviousState(dockableFrame.getAutohidePreviousState());
        dockableFrame.setAutohidePreviousState(PreviousState.createPreviousState(dockableFrame));
    }

    static boolean attachToContainerContainer(DockingManager dockingManager, Container rootContainer, PreviousState.ParentState pState, JComponent parentFrame, boolean done) {
        int index = pState.ccChildren.indexOf(new Integer(pState.myID));
        int wsIndex = pState.ccChildren.indexOf(new Integer(-1));
        Component possibleCc = PreviousState.findComponentByDockID(dockingManager, rootContainer, pState.ccID);
        JideSwingUtilities.removeFromParentWithFocusTransfer(parentFrame);
        if (possibleCc != null && possibleCc instanceof ContainerContainer) {
            ContainerContainer cc = (ContainerContainer)possibleCc;
            if (!done) {
                int[] indices;
                for (int i : indices = DockingUtils.reorderIndex(0, pState.ccChildren.size() - 1, index, wsIndex)) {
                    Component possibleCcChild;
                    Component comp = PreviousState.findComponentByDockID(dockingManager, cc, pState.ccChildren.get(i));
                    if (comp == null || (possibleCcChild = PreviousState.findComponentByDockID(dockingManager, rootContainer, pState.ccID)) == null || !(possibleCcChild instanceof ContainerContainer)) continue;
                    ContainerContainer ccChild = (ContainerContainer)possibleCcChild;
                    int indexOfComp = cc.indexOfPane(comp);
                    if (indexOfComp == -1) continue;
                    ccChild.insertPane(parentFrame, indexOfComp + (i > index ? 0 : 1));
                    done = true;
                    break;
                }
            }
            if (!done) {
                if (index < wsIndex) {
                    cc.insertPane(parentFrame, 0);
                } else {
                    cc.add(parentFrame);
                }
                done = true;
            }
        }
        return done;
    }

    static boolean attachToFrameContainer(DockingManager dockingManager, Container rootContainer, PreviousState state, DockableFrame dockableFrame) {
        Component possibleFc = PreviousState.findComponentByDockID(dockingManager, rootContainer, state.fcID);
        ArrayList<Integer> fcChildren = state.fcChildren;
        if (fcChildren == null) {
            return false;
        }
        int index = fcChildren.indexOf(new Integer(state.dockID));
        boolean done = false;
        if (possibleFc != null && possibleFc instanceof FrameContainer) {
            FrameContainer fc = (FrameContainer)possibleFc;
            if (index != -1) {
                int[] indices;
                for (int i : indices = DockingUtils.reorderIndex(0, state.fcChildren.size() - 1, index)) {
                    Component comp = PreviousState.findComponentByDockID(dockingManager, fc, state.fcChildren.get(i));
                    if (comp == null) continue;
                    int realIndex = fc.indexOfComponent(comp);
                    int insertIndex = realIndex + (i > index ? 0 : 1);
                    JideSwingUtilities.removeFromParentWithFocusTransfer(dockableFrame);
                    fc.insertTab(dockableFrame, insertIndex, true);
                    done = true;
                    break;
                }
            }
            if (!done) {
                fc.addTab(dockableFrame, true);
                return true;
            }
        }
        return done;
    }

    static boolean isFloatingContainerNotDockable(FloatingContainer floatingContainer) {
        DockableFrame frame;
        List<DockableFrame> list;
        return floatingContainer != null && floatingContainer.getContentPane().getComponentCount() == 1 && (list = DockingUtils.getAllDockableFrameOf((Container)floatingContainer.getContentPane().getComponent(0))) != null && list.size() == 1 && !(frame = list.get(0)).isDockable();
    }

    static int getDockableFrameCount(FloatingContainer floatingContainer) {
        List<DockableFrame> list;
        if (floatingContainer != null && floatingContainer.getContentPane().getComponentCount() == 1 && (list = DockingUtils.getAllDockableFrameOf((Container)floatingContainer.getContentPane().getComponent(0))) != null) {
            return list.size();
        }
        return 0;
    }

    public static Insets getFloatingContainerInsets(DockingManager dockingManager) {
        Insets insets;
        if (dockingManager.isUseDecoratedFloatingContainer()) {
            switch (dockingManager.getFloatingContainerType()) {
                case 1: {
                    JFrame frame = new JFrame();
                    insets = frame.getInsets();
                    break;
                }
                case 2: {
                    JWindow window = new JWindow();
                    insets = window.getInsets();
                    break;
                }
                default: {
                    JDialog dialog = new JDialog();
                    insets = dialog.getInsets();
                    break;
                }
            }
        } else {
            Border border = UIDefaultsLookup.getBorder("Resizable.resizeBorder");
            insets = border.getBorderInsets(new JPanel());
            if (!SystemInfo.isJdk14Above()) {
                insets.top = 22;
            }
        }
        return insets;
    }

    public static boolean isFloatingContainerDecorated(FloatingContainer fc) {
        return !fc.isUndecorated() || fc instanceof RootPaneContainer && ((RootPaneContainer)((Object)fc)).getRootPane().getWindowDecorationStyle() != 0;
    }

    public static boolean shouldUseDecoratedFloatingContainer(DockingManager dockingManager, Container container) {
        return dockingManager.isUseDecoratedFloatingContainer() || DockingUtils.getFrameContainerCount(dockingManager, container) > 1 || DockingUtils.getFrameContainerCount(dockingManager, container) == 1 && DockingUtils.getDockableFrameCount(dockingManager, container) > 1 && !dockingManager.isDragAllTabs();
    }

    public static boolean isInPopup(Component src) {
        for (Component c = src; c != null && !(c instanceof Applet) && !(c instanceof Window); c = c.getParent()) {
            if (!(c instanceof JPopupMenu)) continue;
            return true;
        }
        return false;
    }

    static void setGlassPaneVisible(DockingManager dockingManager, boolean visible) {
        List<FloatingContainer> floatingContainers;
        if (dockingManager == null) {
            return;
        }
        if (dockingManager.getRootPaneContainer().getGlassPane() != null) {
            dockingManager.getRootPaneContainer().getGlassPane().setVisible(visible);
        }
        if ((floatingContainers = dockingManager.getFloatingFrames()) != null) {
            for (FloatingContainer container : floatingContainers) {
                Container topLevelAncestor;
                if (!(container.getContentPane() instanceof JComponent) || !((topLevelAncestor = ((JComponent)container.getContentPane()).getTopLevelAncestor()) instanceof RootPaneContainer) || ((RootPaneContainer)((Object)topLevelAncestor)).getGlassPane() == null) continue;
                ((RootPaneContainer)((Object)topLevelAncestor)).getGlassPane().setVisible(visible);
            }
        }
    }

    static void updateGlassPaneCursor(DockingManager dockingManager, Cursor cursor) {
        List<FloatingContainer> floatingContainers;
        if (dockingManager == null) {
            return;
        }
        if (cursor == Cursor.getDefaultCursor()) {
            DockingUtils.clearGlassPaneCursor(dockingManager);
            return;
        }
        if (dockingManager.getRootPaneContainer().getGlassPane() != null) {
            dockingManager.getRootPaneContainer().getGlassPane().setCursor(cursor);
        }
        if ((floatingContainers = dockingManager.getFloatingFrames()) != null) {
            for (FloatingContainer container : floatingContainers) {
                Container topLevelAncestor;
                if (!(container.getContentPane() instanceof JComponent) || !((topLevelAncestor = ((JComponent)container.getContentPane()).getTopLevelAncestor()) instanceof RootPaneContainer) || ((RootPaneContainer)((Object)topLevelAncestor)).getGlassPane() == null) continue;
                ((RootPaneContainer)((Object)topLevelAncestor)).getGlassPane().setCursor(cursor);
            }
        }
    }

    static void clearGlassPaneCursor(DockingManager dockingManager) {
        List<FloatingContainer> floatingContainers;
        if (dockingManager == null) {
            return;
        }
        if (dockingManager.getRootPaneContainer().getGlassPane() != null) {
            dockingManager.getRootPaneContainer().getGlassPane().setCursor(Cursor.getDefaultCursor());
        }
        if ((floatingContainers = dockingManager.getFloatingFrames()) != null) {
            for (FloatingContainer container : floatingContainers) {
                Container topLevelAncestor;
                if (!(container.getContentPane() instanceof JComponent) || !((topLevelAncestor = ((JComponent)container.getContentPane()).getTopLevelAncestor()) instanceof RootPaneContainer) || ((RootPaneContainer)((Object)topLevelAncestor)).getGlassPane() == null) continue;
                ((RootPaneContainer)((Object)topLevelAncestor)).getGlassPane().setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    public static void closeFloatingContainer(DockingManager dockingManager, FloatingContainer container) {
        DockableFrame frame;
        if (dockingManager == null) {
            return;
        }
        switch (dockingManager.getFloatingContainerCloseBehavior()) {
            case 0: {
                if (dockingManager.isHidable()) break;
                return;
            }
            case 1: {
                if (dockingManager.isFloatable()) break;
                return;
            }
        }
        ArrayList<String> framesToBeClosed = new ArrayList<String>();
        DockableFrame activeFrame = dockingManager.getFrame(dockingManager.getActiveFrameKey());
        if (activeFrame != null && SwingUtilities.isDescendingFrom(activeFrame, (Component)((Object)container)) && !activeFrame.isHidden() && activeFrame.isHidable() && !activeFrame.shouldVetoHiding() && !framesToBeClosed.contains(activeFrame.getKey())) {
            framesToBeClosed.add(activeFrame.getKey());
        }
        List<String> frameNames = dockingManager.getAllFrameNames();
        for (String key : frameNames) {
            frame = dockingManager.getFrame(key);
            if (frame == null || !SwingUtilities.isDescendingFrom(frame, (Component)((Object)container)) || frame.isHidden() || !frame.isHidable() || frame.shouldVetoHiding() || framesToBeClosed.contains(key)) continue;
            framesToBeClosed.add(key);
        }
        if (framesToBeClosed.size() > 0) {
            switch (dockingManager.getFloatingContainerCloseBehavior()) {
                case 0: {
                    dockingManager.addUndo(dockingManager.getResourceString("Undo.hide"));
                    for (String key : framesToBeClosed) {
                        Action closeAction;
                        frame = dockingManager.getFrame(key);
                        if (frame == null || (closeAction = frame.getCloseAction()) == null || !closeAction.isEnabled()) continue;
                        ActionEvent event = new ActionEvent(container, 1001, "hiddenByParentContainer");
                        closeAction.actionPerformed(event);
                    }
                    break;
                }
                case 1: {
                    dockingManager.addUndo(dockingManager.getResourceString("Undo.toggle"));
                    for (String key : framesToBeClosed) {
                        Action floatingAction;
                        frame = dockingManager.getFrame(key);
                        if (frame == null || (floatingAction = frame.getFloatingAction(true)) == null || !floatingAction.isEnabled()) continue;
                        ActionEvent event = new ActionEvent(container, 1001, "hiddenByParentContainer");
                        floatingAction.actionPerformed(event);
                    }
                    break;
                }
            }
        }
    }
}

