/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.AutoHideContainer;
import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.DefaultDockingManager;
import com.jidesoft.docking.DockContext;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockableFrameFactory;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.DockingUtils;
import com.jidesoft.docking.FloatingContainer;
import com.jidesoft.docking.FloatingFrames;
import com.jidesoft.docking.FrameContainer;
import com.jidesoft.docking.FrameFloatingContainer;
import com.jidesoft.docking.HiddenFrames;
import com.jidesoft.docking.PreviousState;
import com.jidesoft.docking.Workspace;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.PersistenceUtils;
import com.jidesoft.swing.SidePaneGroup;
import com.jidesoft.swing.SidePaneItem;
import com.jidesoft.utils.PersistenceUtilsCallback;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DockingPersistenceUtils {
    private static final String NODE_CONTEXT = "DockContext";
    private static final String NODE_PREVIOUS_STATE = "DockPreviousState";
    private static final String NODE_CHILD = "DockChild";
    private static final String NODE_PARENT_STATE = "DockParentState";
    private static final String NODE_AUTO_HIDE_CONTAINER = "AutoHideContainer";
    private static final String NODE_SIDE_PANE_GROUP = "SidePaneGroup";
    private static final String NODE_SIDE_PANE_ITEM = "SidePaneItem";
    private static final String NODE_HIDDEN_FRAME = "HiddenFrame";
    private static final String NODE_UNDOCKED_BOUNDS = "UndockedBounds";
    private static final String NODE_INIT_UNDOCKED_BOUNDS = "InitUndockedBounds";
    private static final String NODE_BOUNDS = "Bounds";
    private static final String NODE_CONTAINER_CONTAINER = "ContainerContainer";
    private static final String NODE_FRAME_CONTAINER = "FrameContainer";
    private static final String NODE_DOCKABLE_FRAME = "DockableFrame";
    private static final String NODE_WORKSPACE = "Workspace";
    private static final String NODE_FLOATING_CONTAINER = "FloatingContainer";
    private static final String ATTRIBUTE_FRAME_STATE = "frameState";
    private static final String ATTRIBUTE_MAXIMIZED_FRAME = "maximizedFrame";
    private static final String ATTRIBUTE_KEY = "key";
    private static final String ATTRIBUTE_DOCK_ID = "dockId";
    private static final String ATTRIBUTE_INIT_SIDE = "initSide";
    private static final String ATTRIBUTE_INIT_INDEX = "initIndex";
    private static final String ATTRIBUTE_INIT_POSITION = "initPosition";
    private static final String ATTRIBUTE_INIT_MODE = "initMode";
    private static final String ATTRIBUTE_CAN_MODE = "canMode";
    private static final String ATTRIBUTE_CURRENT_MODE = "currentMode";
    private static final String ATTRIBUTE_AVAILABLE = "available";
    private static final String ATTRIBUTE_CURRENT_DOCK_SIDE = "currentDockSide";
    private static final String ATTRIBUTE_DOCKED_WIDTH = "dockedWidth";
    private static final String ATTRIBUTE_DOCKED_HEIGHT = "dockedHeight";
    private static final String ATTRIBUTE_AUTOHIDE_WIDTH = "autohideWidth";
    private static final String ATTRIBUTE_AUTOHIDE_HEIGHT = "autohideHeight";
    private static final String ATTRIBUTE_INIT_AUTOHIDE_WIDTH = "initAutohideWidth";
    private static final String ATTRIBUTE_INIT_AUTOHIDE_HEIGHT = "initAutohideHeight";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_MODE = "mode";
    private static final String ATTRIBUTE_ROOT_ID = "rootId";
    private static final String ATTRIBUTE_SIDE = "side";
    private static final String ATTRIBUTE_INDEX = "index";
    private static final String ATTRIBUTE_FC_ID = "fcId";
    private static final String ATTRIBUTE_CC_ID = "ccId";
    private static final String ATTRIBUTE_ORIENTATION = "orientation";
    private static final String ATTRIBUTE_PROPORTION_LAYOUT = "proportionLayout";
    private static final String ATTRIBUTE_INITIALLY_EVEN = "initiallyEven";
    private static final String ATTRIBUTE_PROPORTION = "proportion";
    private static final String ATTRIBUTE_PREFERRED_WIDTH = "preferredWidth";
    private static final String ATTRIBUTE_PREFERRED_HEIGHT = "preferredHeight";
    private static final String ATTRIBUTE_SELECTED_INDEX = "selectedIndex";
    private static final String ATTRIBUTE_ACTIVE_FRAME = "activeFrame";
    private static final String ATTRIBUTE_ACCEPT_DOCKABLE_FRAME = "acceptDockableFrame";
    private static final String ATTRIBUTE_X = "x";
    private static final String ATTRIBUTE_Y = "y";
    private static final String ATTRIBUTE_WIDTH = "width";
    private static final String ATTRIBUTE_HEIGHT = "height";
    private static final String PREVIOUS_STATE_HIDDEN = "hidden";
    private static final String PREVIOUS_STATE_DOCK = "dock";
    private static final String PREVIOUS_STATE_CLOSE = "close";
    private static final String PREVIOUS_STATE_FLOAT = "float";
    private static final String PREVIOUS_STATE_AUTOHIDE = "autohide";
    private static final String PREVIOUS_STATE_AVAILABLE = "available";
    private static final Logger LOGGER = Logger.getLogger(DefaultDockingManager.class.getName());
    private static final int HIDE_OFFSCREEN_OFFSET = 10000;

    public static void save(DefaultDockingManager manager, String fileName) throws ParserConfigurationException, IOException {
        DockingPersistenceUtils.save(manager, fileName, PersistenceUtils.getDefaultXmlEncoding());
    }

    public static void save(DefaultDockingManager manager, String fileName, String encoding) throws ParserConfigurationException, IOException {
        DockingPersistenceUtils.save(manager, fileName, encoding, null);
    }

    public static void save(final DefaultDockingManager manager, final String fileName, final String encoding, final PersistenceUtilsCallback.Save callback) throws ParserConfigurationException, IOException {
        if (SwingUtilities.isEventDispatchThread()) {
            Document document = DockingPersistenceUtils.save(manager, callback);
            PersistenceUtils.saveXMLDocumentToFile(document, fileName, encoding);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Document document = DockingPersistenceUtils.save(manager, callback);
                        PersistenceUtils.saveXMLDocumentToFile(document, fileName, encoding);
                    }
                    catch (ParserConfigurationException document) {
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public static void save(DefaultDockingManager manager, OutputStream out) throws ParserConfigurationException, IOException {
        DockingPersistenceUtils.save(manager, out, PersistenceUtils.getDefaultXmlEncoding());
    }

    public static void save(DefaultDockingManager manager, OutputStream out, String encoding) throws ParserConfigurationException, IOException {
        DockingPersistenceUtils.save(manager, out, encoding, null);
    }

    public static void save(final DefaultDockingManager manager, final OutputStream out, final String encoding, final PersistenceUtilsCallback.Save callback) throws ParserConfigurationException, IOException {
        if (SwingUtilities.isEventDispatchThread()) {
            Document document = DockingPersistenceUtils.save(manager, callback);
            PersistenceUtils.saveXMLDocumentToStream(document, out, encoding);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Document document = DockingPersistenceUtils.save(manager, callback);
                            PersistenceUtils.saveXMLDocumentToStream(document, out, encoding);
                        }
                        catch (ParserConfigurationException document) {
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Document save(DefaultDockingManager manager, PersistenceUtilsCallback.Save callback) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        DockingPersistenceUtils.saveToDocument(manager, document, callback);
        return document;
    }

    static void saveToDocument(DefaultDockingManager manager, Document document, PersistenceUtilsCallback.Save callback) {
        HiddenFrames hiddenFrames;
        Rectangle bounds;
        if (manager == null || manager.isLoadingLayoutData()) {
            return;
        }
        if (manager.getDockedFrameContainer() != null && manager.getDockedFrameContainer().getNormalContainer().getComponentCount() <= 0) {
            throw new IllegalStateException("There is no component in getDockedFrameContainer().getNormalContainer(). Did you remove all the components before saving the layout? If so, please don't do it until the layout is saved.");
        }
        String maximizedFrame = manager.getMaximizedFrameKey();
        String activeFrameKey = manager.getActiveFrameKey();
        if (maximizedFrame != null) {
            manager.internalRestoreFrame(false);
        }
        if (manager.getDockedFrameContainer() == null) {
            return;
        }
        DockingUtils.validateLocations(manager.getDockedFrameContainer(), manager.getWorkspace());
        manager.removeExtraContainerContainer();
        manager.saveCurrentContext();
        Node component = document.getElementsByTagName("LayoutPersistence").item(0);
        if (component == null) {
            component = document.createElement("LayoutPersistence");
            document.appendChild(component);
        }
        Element rootElement = document.createElement("DockingManager");
        component.appendChild(rootElement);
        rootElement.setAttribute("version", "" + manager.getVersion());
        if (manager.getLayoutPersistenceName() != null) {
            rootElement.setAttribute("persistenceName", manager.getLayoutPersistenceName());
        }
        if ((bounds = manager._unmaximizedBounds) != null) {
            Element boundsElement = document.createElement(NODE_BOUNDS);
            rootElement.appendChild(boundsElement);
            boundsElement.setAttribute(ATTRIBUTE_X, "" + bounds.x);
            boundsElement.setAttribute(ATTRIBUTE_Y, "" + bounds.y);
            boundsElement.setAttribute(ATTRIBUTE_WIDTH, "" + bounds.width);
            boundsElement.setAttribute(ATTRIBUTE_HEIGHT, "" + bounds.height);
        }
        if (manager.getActiveFrameKey() != null) {
            rootElement.setAttribute(ATTRIBUTE_ACTIVE_FRAME, manager.getActiveFrameKey());
        }
        if (manager.getRootPaneContainer() instanceof Frame) {
            rootElement.setAttribute(ATTRIBUTE_FRAME_STATE, "" + PortingUtils.getFrameState((Frame)((Object)manager.getRootPaneContainer())));
        }
        if (maximizedFrame != null) {
            rootElement.setAttribute(ATTRIBUTE_MAXIMIZED_FRAME, maximizedFrame);
        }
        DockingPersistenceUtils.writeAllContexts(document, rootElement, manager, callback);
        DockingPersistenceUtils.writeComponent(document, rootElement, manager, manager.getDockedFrameContainer().getNormalContainer().getComponent(0), callback);
        DockingPersistenceUtils.writeAutohideContainer(document, rootElement, manager, 4, callback);
        DockingPersistenceUtils.writeAutohideContainer(document, rootElement, manager, 8, callback);
        DockingPersistenceUtils.writeAutohideContainer(document, rootElement, manager, 2, callback);
        DockingPersistenceUtils.writeAutohideContainer(document, rootElement, manager, 1, callback);
        List<FloatingContainer> floatingFrames = manager.getFloatingFrames();
        if (floatingFrames != null && floatingFrames.size() > 0) {
            for (FloatingContainer floatingContainer : floatingFrames) {
                if (!(floatingContainer instanceof Component)) continue;
                DockingPersistenceUtils.writeComponent(document, rootElement, manager, (Component)((Object)floatingContainer), callback);
            }
        }
        if ((hiddenFrames = manager.getHiddenFrames()) != null) {
            for (String name : hiddenFrames) {
                Element hiddenFrameElement = document.createElement(NODE_HIDDEN_FRAME);
                rootElement.appendChild(hiddenFrameElement);
                hiddenFrameElement.setAttribute(ATTRIBUTE_KEY, name);
            }
        }
        if (maximizedFrame != null) {
            manager.internalMaximizeFrame(manager.getFrame(maximizedFrame), false);
        }
        if (activeFrameKey != null && manager.isDockingManagerFocused()) {
            manager.activateFrame(activeFrameKey);
        }
        if (callback != null) {
            callback.save(document, rootElement, manager);
        }
    }

    private static void writeAutohideContainer(Document document, Element element, DefaultDockingManager manager, int side, PersistenceUtilsCallback.Save callback) {
        AutoHideContainer autoHideContainer = manager.getAutoHideContainer(side);
        if (autoHideContainer == null) {
            return;
        }
        Element autoHideContainerElement = document.createElement(NODE_AUTO_HIDE_CONTAINER);
        element.appendChild(autoHideContainerElement);
        autoHideContainerElement.setAttribute(ATTRIBUTE_SIDE, "" + autoHideContainer.getAttachedSide());
        for (int i = 0; i < autoHideContainer.getGroups().size(); ++i) {
            DockingPersistenceUtils.writeSideGroup(document, autoHideContainerElement, autoHideContainer.getGroups().get(i), manager, callback);
        }
        if (callback != null) {
            callback.save(document, autoHideContainerElement, autoHideContainer);
        }
    }

    private static void writeSideGroup(Document document, Element element, SidePaneGroup group, DefaultDockingManager manager, PersistenceUtilsCallback.Save callback) {
        if (group.size() <= 0) {
            return;
        }
        Element groupElement = document.createElement(NODE_SIDE_PANE_GROUP);
        element.appendChild(groupElement);
        groupElement.setAttribute(ATTRIBUTE_SELECTED_INDEX, "" + group.getSelectedIndex());
        for (SidePaneItem item : group) {
            DockingPersistenceUtils.writeSideItem(document, groupElement, item, manager, callback);
        }
        if (callback != null) {
            callback.save(document, groupElement, group);
        }
    }

    private static void writeSideItem(Document document, Element element, SidePaneItem item, DefaultDockingManager manager, PersistenceUtilsCallback.Save callback) {
        Element itemElement = document.createElement(NODE_SIDE_PANE_ITEM);
        element.appendChild(itemElement);
        DockingPersistenceUtils.writeComponent(document, itemElement, manager, item.getComponent(), callback);
    }

    private static void writeComponent(Document document, Element element, DefaultDockingManager manager, Component component, PersistenceUtilsCallback.Save callback) {
        if (component instanceof ContainerContainer) {
            DockingPersistenceUtils.writeContainerContainer(document, element, manager, (ContainerContainer)component, callback);
        } else if (component instanceof FrameContainer) {
            DockingPersistenceUtils.writeFrameContainer(document, element, (FrameContainer)component, callback);
        } else if (component instanceof DockableFrame) {
            DockingPersistenceUtils.writeDockableFrame(document, element, (DockableFrame)component, callback);
        } else if (component instanceof Workspace) {
            DockingPersistenceUtils.writeWorkspace(document, element, manager, (Workspace)component, callback);
        } else if (component instanceof FloatingContainer) {
            DockingPersistenceUtils.writeFloatingContainer(document, element, manager, (FloatingContainer)((Object)component), callback);
        }
    }

    private static void writeContainerContainer(Document document, Element element, DefaultDockingManager manager, ContainerContainer containerContainer, PersistenceUtilsCallback.Save callback) {
        Element containerContainerElement = document.createElement(NODE_CONTAINER_CONTAINER);
        element.appendChild(containerContainerElement);
        containerContainerElement.setAttribute(ATTRIBUTE_ORIENTATION, "" + containerContainer.getOrientation());
        containerContainerElement.setAttribute(ATTRIBUTE_DOCK_ID, "" + containerContainer.getDockID());
        containerContainerElement.setAttribute(ATTRIBUTE_PROPORTION_LAYOUT, containerContainer.isProportionalLayout() ? "1" : "0");
        containerContainerElement.setAttribute(ATTRIBUTE_INITIALLY_EVEN, containerContainer.isInitiallyEven() ? "1" : "0");
        if (containerContainer.isProportionalLayout() && containerContainer.getProportions() != null) {
            StringBuffer buffer = new StringBuffer();
            for (double p : containerContainer.getProportions()) {
                buffer.append(p).append(';');
            }
            containerContainerElement.setAttribute(ATTRIBUTE_PROPORTION, "" + buffer.substring(0, buffer.length() - 1));
        }
        if (containerContainer.getPreferredSize() != null && (!SystemInfo.isJdk15Above() || containerContainer.isPreferredSizeSet())) {
            containerContainerElement.setAttribute(ATTRIBUTE_PREFERRED_WIDTH, "" + containerContainer.getPreferredSize().width);
            containerContainerElement.setAttribute(ATTRIBUTE_PREFERRED_HEIGHT, "" + containerContainer.getPreferredSize().height);
        }
        for (int i = 0; i < containerContainer.getPaneCount(); ++i) {
            DockingPersistenceUtils.writeComponent(document, containerContainerElement, manager, containerContainer.getPaneAt(i), callback);
        }
        if (callback != null) {
            callback.save(document, containerContainerElement, containerContainer);
        }
    }

    private static void writeFrameContainer(Document document, Element element, FrameContainer frameContainer, PersistenceUtilsCallback.Save callback) {
        Element frameContainerElement = document.createElement(NODE_FRAME_CONTAINER);
        element.appendChild(frameContainerElement);
        frameContainerElement.setAttribute(ATTRIBUTE_DOCK_ID, "" + frameContainer.getDockID());
        if (frameContainer.getPreferredSize() != null && (!SystemInfo.isJdk15Above() || frameContainer.isPreferredSizeSet())) {
            frameContainerElement.setAttribute(ATTRIBUTE_PREFERRED_WIDTH, "" + frameContainer.getPreferredSize().width);
            frameContainerElement.setAttribute(ATTRIBUTE_PREFERRED_HEIGHT, "" + frameContainer.getPreferredSize().height);
        }
        frameContainerElement.setAttribute(ATTRIBUTE_SELECTED_INDEX, "" + frameContainer.getSelectedIndex());
        for (int i = 0; i < frameContainer.getTabCount(); ++i) {
            DockableFrame f;
            Component component = frameContainer.getComponentAt(i);
            if (!(component instanceof DockableFrame) || (f = (DockableFrame)component).isTransient()) continue;
            DockingPersistenceUtils.writeDockableFrame(document, frameContainerElement, f, callback);
        }
        if (callback != null) {
            callback.save(document, frameContainerElement, frameContainer);
        }
    }

    private static void writeDockableFrame(Document document, Element element, DockableFrame dockableFrame, PersistenceUtilsCallback.Save callback) {
        Element dockableFrameElement = document.createElement(NODE_DOCKABLE_FRAME);
        element.appendChild(dockableFrameElement);
        dockableFrameElement.setAttribute(ATTRIBUTE_KEY, "" + dockableFrame.getKey());
        if (callback != null) {
            callback.save(document, dockableFrameElement, dockableFrame);
        }
    }

    private static void writeWorkspace(Document document, Element element, DefaultDockingManager manager, Workspace workspace, PersistenceUtilsCallback.Save callback) {
        Element workspaceElement = document.createElement(NODE_WORKSPACE);
        element.appendChild(workspaceElement);
        workspaceElement.setAttribute(ATTRIBUTE_ACCEPT_DOCKABLE_FRAME, workspace.isAcceptDockableFrame() ? "1" : "0");
        if (workspace.isAcceptDockableFrame()) {
            for (int i = 0; i < workspace.getComponentCount(); ++i) {
                DockingPersistenceUtils.writeComponent(document, workspaceElement, manager, workspace.getComponent(i), callback);
            }
        }
        if (callback != null) {
            callback.save(document, workspaceElement, workspace);
        }
    }

    private static void writeFloatingContainer(Document document, Element element, DefaultDockingManager manager, FloatingContainer floatingContainer, PersistenceUtilsCallback.Save callback) {
        Element floatingContainerElement = document.createElement(NODE_FLOATING_CONTAINER);
        element.appendChild(floatingContainerElement);
        Rectangle bounds = floatingContainer.getBounds();
        if (bounds != null) {
            boolean visible;
            int contY = bounds.y;
            boolean bl = visible = contY >= -5000;
            if (!visible) {
                bounds.y += 10000;
            }
            Element boundsElement = document.createElement(NODE_BOUNDS);
            floatingContainerElement.appendChild(boundsElement);
            boundsElement.setAttribute(ATTRIBUTE_X, "" + bounds.x);
            boundsElement.setAttribute(ATTRIBUTE_Y, "" + bounds.y);
            boundsElement.setAttribute(ATTRIBUTE_WIDTH, "" + bounds.width);
            boundsElement.setAttribute(ATTRIBUTE_HEIGHT, "" + bounds.height);
        }
        for (int i = 0; i < floatingContainer.getContentPane().getComponentCount(); ++i) {
            DockingPersistenceUtils.writeComponent(document, floatingContainerElement, manager, floatingContainer.getContentPane().getComponent(i), callback);
        }
    }

    private static void writeAllContexts(Document document, Element element, DefaultDockingManager manager, PersistenceUtilsCallback.Save callback) {
        Map<String, DockContext> contexts = manager.getAllContexts();
        Set<String> set = contexts.keySet();
        for (String key : set) {
            Element previousStateElement;
            Rectangle initBounds;
            Element contextElement = document.createElement(NODE_CONTEXT);
            element.appendChild(contextElement);
            contextElement.setAttribute(ATTRIBUTE_KEY, key);
            DockContext context = contexts.get(key);
            contextElement.setAttribute(ATTRIBUTE_DOCK_ID, "" + context.getDockID());
            contextElement.setAttribute(ATTRIBUTE_INIT_SIDE, "" + context.getInitSide());
            contextElement.setAttribute(ATTRIBUTE_INIT_INDEX, "" + context.getInitIndex());
            contextElement.setAttribute(ATTRIBUTE_INIT_POSITION, context.isInitPosition() ? "1" : "0");
            contextElement.setAttribute(ATTRIBUTE_INIT_MODE, "" + context.getInitMode());
            contextElement.setAttribute(ATTRIBUTE_CAN_MODE, "" + context.getCanMode());
            contextElement.setAttribute(ATTRIBUTE_CURRENT_MODE, "" + context.getCurrentMode());
            contextElement.setAttribute(ATTRIBUTE_CURRENT_DOCK_SIDE, "" + context.getCurrentDockSide());
            contextElement.setAttribute("available", context.isAvailable() ? "1" : "0");
            contextElement.setAttribute(ATTRIBUTE_DOCKED_WIDTH, "" + context.getDockedWidth());
            contextElement.setAttribute(ATTRIBUTE_DOCKED_HEIGHT, "" + context.getDockedHeight());
            contextElement.setAttribute(ATTRIBUTE_AUTOHIDE_WIDTH, "" + context.getAutohideWidth());
            contextElement.setAttribute(ATTRIBUTE_AUTOHIDE_HEIGHT, "" + context.getAutohideHeight());
            contextElement.setAttribute(ATTRIBUTE_INIT_AUTOHIDE_WIDTH, "" + context.getInitAutohideWidth());
            contextElement.setAttribute(ATTRIBUTE_INIT_AUTOHIDE_HEIGHT, "" + context.getInitAutohideHeight());
            Rectangle bounds = context.getUndockedBounds();
            if (bounds != null) {
                Element boundsElement = document.createElement(NODE_UNDOCKED_BOUNDS);
                contextElement.appendChild(boundsElement);
                boundsElement.setAttribute(ATTRIBUTE_X, "" + bounds.x);
                boundsElement.setAttribute(ATTRIBUTE_Y, "" + bounds.y);
                boundsElement.setAttribute(ATTRIBUTE_WIDTH, "" + bounds.width);
                boundsElement.setAttribute(ATTRIBUTE_HEIGHT, "" + bounds.height);
            }
            if ((initBounds = context.getInitUndockedBounds()) != null) {
                Element boundsElement = document.createElement(NODE_INIT_UNDOCKED_BOUNDS);
                contextElement.appendChild(boundsElement);
                boundsElement.setAttribute(ATTRIBUTE_X, "" + initBounds.x);
                boundsElement.setAttribute(ATTRIBUTE_Y, "" + initBounds.y);
                boundsElement.setAttribute(ATTRIBUTE_WIDTH, "" + initBounds.width);
                boundsElement.setAttribute(ATTRIBUTE_HEIGHT, "" + initBounds.height);
            }
            if (context.getHiddenPreviousState() != null) {
                previousStateElement = document.createElement(NODE_PREVIOUS_STATE);
                contextElement.appendChild(previousStateElement);
                previousStateElement.setAttribute(ATTRIBUTE_TYPE, PREVIOUS_STATE_HIDDEN);
                DockingPersistenceUtils.writePreviousState(document, previousStateElement, context.getHiddenPreviousState(), callback);
            }
            if (context.getDockPreviousState() != null) {
                previousStateElement = document.createElement(NODE_PREVIOUS_STATE);
                contextElement.appendChild(previousStateElement);
                previousStateElement.setAttribute(ATTRIBUTE_TYPE, PREVIOUS_STATE_DOCK);
                DockingPersistenceUtils.writePreviousState(document, previousStateElement, context.getDockPreviousState(), callback);
            }
            if (context.getClosePreviousState() != null) {
                previousStateElement = document.createElement(NODE_PREVIOUS_STATE);
                contextElement.appendChild(previousStateElement);
                previousStateElement.setAttribute(ATTRIBUTE_TYPE, PREVIOUS_STATE_CLOSE);
                DockingPersistenceUtils.writePreviousState(document, previousStateElement, context.getClosePreviousState(), callback);
            }
            if (context.getFloatPreviousState() != null) {
                previousStateElement = document.createElement(NODE_PREVIOUS_STATE);
                contextElement.appendChild(previousStateElement);
                previousStateElement.setAttribute(ATTRIBUTE_TYPE, PREVIOUS_STATE_FLOAT);
                DockingPersistenceUtils.writePreviousState(document, previousStateElement, context.getFloatPreviousState(), callback);
            }
            if (context.getAutohidePreviousState() != null) {
                previousStateElement = document.createElement(NODE_PREVIOUS_STATE);
                contextElement.appendChild(previousStateElement);
                previousStateElement.setAttribute(ATTRIBUTE_TYPE, PREVIOUS_STATE_AUTOHIDE);
                DockingPersistenceUtils.writePreviousState(document, previousStateElement, context.getAutohidePreviousState(), callback);
            }
            if (context.getAvailablePreviousState() != null) {
                previousStateElement = document.createElement(NODE_PREVIOUS_STATE);
                contextElement.appendChild(previousStateElement);
                previousStateElement.setAttribute(ATTRIBUTE_TYPE, "available");
                DockingPersistenceUtils.writePreviousState(document, previousStateElement, context.getAvailablePreviousState(), callback);
            }
            if (callback == null) continue;
            callback.save(document, contextElement, context);
        }
    }

    private static void writePreviousState(Document document, Element element, PreviousState state, PersistenceUtilsCallback.Save callback) {
        element.setAttribute(ATTRIBUTE_MODE, "" + state.mode);
        element.setAttribute(ATTRIBUTE_DOCK_ID, "" + state.dockID);
        element.setAttribute(ATTRIBUTE_ROOT_ID, "" + state.rootID);
        element.setAttribute(ATTRIBUTE_SIDE, "" + state.side);
        element.setAttribute(ATTRIBUTE_INDEX, "" + state.index);
        element.setAttribute(ATTRIBUTE_FC_ID, "" + state.fcID);
        Rectangle bounds = state.rcBounds;
        if (bounds != null) {
            Element boundsElement = document.createElement(NODE_BOUNDS);
            element.appendChild(boundsElement);
            boundsElement.setAttribute(ATTRIBUTE_X, "" + bounds.x);
            boundsElement.setAttribute(ATTRIBUTE_Y, "" + bounds.y);
            boundsElement.setAttribute(ATTRIBUTE_WIDTH, "" + bounds.width);
            boundsElement.setAttribute(ATTRIBUTE_HEIGHT, "" + bounds.height);
        }
        if (state.fcChildren != null) {
            for (Integer childDockID : state.fcChildren) {
                Element childElement = document.createElement(NODE_CHILD);
                element.appendChild(childElement);
                childElement.setAttribute(ATTRIBUTE_DOCK_ID, "" + childDockID);
            }
        }
        if (state.parentStates != null) {
            for (PreviousState.ParentState pState : state.parentStates) {
                Element parentStateElement = document.createElement(NODE_PARENT_STATE);
                element.appendChild(parentStateElement);
                parentStateElement.setAttribute(ATTRIBUTE_CC_ID, "" + pState.ccID);
                parentStateElement.setAttribute(ATTRIBUTE_DOCK_ID, "" + pState.myID);
                parentStateElement.setAttribute(ATTRIBUTE_ORIENTATION, "" + pState.orientation);
                if (pState.ccChildren == null) continue;
                for (Integer childDockID : pState.ccChildren) {
                    Element childElement = document.createElement(NODE_CHILD);
                    parentStateElement.appendChild(childElement);
                    childElement.setAttribute(ATTRIBUTE_DOCK_ID, "" + childDockID);
                }
            }
        }
        if (callback != null) {
            callback.save(document, element, state);
        }
    }

    public static boolean load(DefaultDockingManager manager, InputStream in) throws ParserConfigurationException, SAXException, IOException {
        return DockingPersistenceUtils.load(manager, in, null);
    }

    public static boolean load(DefaultDockingManager manager, InputStream in, PersistenceUtilsCallback.Load callback) throws ParserConfigurationException, SAXException, IOException {
        return DockingPersistenceUtils.load(manager, PersistenceUtils.getDocument(in), callback);
    }

    public static boolean load(DefaultDockingManager manager, String fileName) throws ParserConfigurationException, SAXException, IOException {
        return DockingPersistenceUtils.load(manager, fileName, null);
    }

    public static boolean load(DefaultDockingManager manager, String fileName, PersistenceUtilsCallback.Load callback) throws ParserConfigurationException, SAXException, IOException {
        return DockingPersistenceUtils.load(manager, PersistenceUtils.getDocument(fileName), callback);
    }

    public static boolean load(final DefaultDockingManager manager, final Document document, final PersistenceUtilsCallback.Load callback) {
        if (SwingUtilities.isEventDispatchThread()) {
            return DockingPersistenceUtils.internalLoad(manager, document, callback);
        }
        final boolean[] results = new boolean[]{false};
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    results[0] = DockingPersistenceUtils.internalLoad(manager, document, callback);
                }
            });
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        return results[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean internalLoad(DefaultDockingManager manager, Document document, PersistenceUtilsCallback.Load callback) {
        boolean loadDataSuccessful = false;
        boolean previousLoadingData = manager.isLoadingLayoutData();
        manager.setLoadingLayoutData(true);
        try {
            RuntimeException error = null;
            if (document == null) {
                manager.loadDataErrorHandler();
                boolean bl = false;
                return bl;
            }
            manager.setRealized(false);
            try {
                String frameKey;
                int i;
                DockableFrame dockableFrame;
                if (manager.getMaximizedFrameKey() != null) {
                    manager.internalRestoreFrame(false);
                }
                if (manager.getAutohideShowingFrame() != null) {
                    manager.stopShowingAutohideFrameImmediately();
                }
                manager.clearLayout();
                String maximizeFrameKey = null;
                String version = null;
                String activeFrameKey = null;
                String frameState = null;
                HiddenFrames previousHiddenFrames = new HiddenFrames();
                HiddenFrames previousExistingFrames = new HiddenFrames();
                manager._floatingFrames = new FloatingFrames();
                Node component = document.getElementsByTagName("LayoutPersistence").item(0);
                Node dockableFrames = null;
                if (component != null) {
                    NodeList list = component.getChildNodes();
                    for (int index = 0; index < list.getLength(); ++index) {
                        Node node = list.item(index);
                        if (!"DockingManager".equals(node.getNodeName())) continue;
                        String persistenceName = null;
                        NamedNodeMap attributes = node.getAttributes();
                        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                            Node attribute = attributes.item(i2);
                            if (!"persistenceName".equals(attribute.getNodeName())) continue;
                            persistenceName = attribute.getNodeValue();
                            break;
                        }
                        if (!JideSwingUtilities.equals(persistenceName, manager.getLayoutPersistenceName())) continue;
                        dockableFrames = node;
                        break;
                    }
                }
                if (dockableFrames == null) {
                    manager.loadDataErrorHandler();
                    boolean list = false;
                    return list;
                }
                NamedNodeMap componentAttributes = dockableFrames.getAttributes();
                for (int i3 = 0; i3 < componentAttributes.getLength(); ++i3) {
                    Node attribute = componentAttributes.item(i3);
                    if ("version".equals(attribute.getNodeName())) {
                        version = attribute.getNodeValue();
                        continue;
                    }
                    if (ATTRIBUTE_ACTIVE_FRAME.equals(attribute.getNodeName())) {
                        activeFrameKey = attribute.getNodeValue();
                        continue;
                    }
                    if (ATTRIBUTE_FRAME_STATE.equals(attribute.getNodeName())) {
                        frameState = attribute.getNodeValue();
                        continue;
                    }
                    if (!ATTRIBUTE_MAXIMIZED_FRAME.equals(attribute.getNodeName())) continue;
                    maximizeFrameKey = attribute.getNodeValue();
                }
                if (version != null) {
                    manager.setVersion(Short.valueOf(version));
                }
                HashMap<String, DockContext> contextCopy = new HashMap<String, DockContext>(manager.getAllContexts());
                manager.getAllContexts().clear();
                NodeList list = dockableFrames.getChildNodes();
                for (int index = 0; index < list.getLength(); ++index) {
                    Node node = list.item(index);
                    if (!NODE_CONTEXT.equals(node.getNodeName())) continue;
                    String key = DockingPersistenceUtils.readContext(document, manager, node, manager.getAllContexts(), callback);
                    String[] loadedContext = manager.getAllContexts().get(key);
                    DockContext previousContext = (DockContext)contextCopy.remove(key);
                    if (loadedContext == null || previousContext == null) continue;
                    loadedContext.setInitAutohideHeight(previousContext.getInitAutohideHeight());
                    loadedContext.setInitAutohideWidth(previousContext.getInitAutohideWidth());
                    loadedContext.setInitIndex(previousContext.getInitIndex());
                    loadedContext.setInitMode(previousContext.getInitMode());
                    loadedContext.setInitSide(previousContext.getInitSide());
                    loadedContext.setInitUndockedBounds(previousContext.getInitUndockedBounds());
                }
                HiddenFrames hiddenFrames = new HiddenFrames();
                manager.setHiddenFrames(hiddenFrames);
                Map<String, DockContext> allContexts = manager.getAllContexts();
                allContexts.putAll(contextCopy);
                if (allContexts != null) {
                    String[] col;
                    for (String key : col = allContexts.keySet().toArray(new String[allContexts.size()])) {
                        DockableFrameFactory factory;
                        if (error != null) continue;
                        dockableFrame = manager.getFrame(key);
                        if (dockableFrame == null && (factory = manager.getDockableFrameFactory()) != null) {
                            try {
                                dockableFrame = factory.create(key);
                            }
                            catch (Throwable t) {
                                error = new RuntimeException("DockableFrameFactory threw an unexpected exception while creating '" + key + "'.", t);
                            }
                            if (dockableFrame != null) {
                                boolean wasRealized = manager.isRealized();
                                manager.setRealized(false);
                                manager.addFrame(dockableFrame);
                                manager.setRealized(wasRealized);
                            }
                        }
                        if (dockableFrame != null) {
                            dockableFrame.setContext(allContexts.get(key));
                            if (dockableFrame.getContext().getDockedWidth() > 0 || dockableFrame.getContext().getDockedHeight() > 0) {
                                dockableFrame.internalSetPreferredSize();
                            }
                            if (!allContexts.get(key).isAvailable()) continue;
                            hiddenFrames.add(key);
                            continue;
                        }
                        allContexts.remove(key);
                    }
                }
                for (int index = 0; index < list.getLength(); ++index) {
                    String hiddenFrameName;
                    Node node = list.item(index);
                    if (NODE_BOUNDS.equals(node.getNodeName()) && manager.isUseFrameBounds()) {
                        manager._unmaximizedBounds = DockingPersistenceUtils.readBounds(node);
                        continue;
                    }
                    if (NODE_CONTAINER_CONTAINER.equals(node.getNodeName()) || NODE_FRAME_CONTAINER.equals(node.getNodeName()) || NODE_WORKSPACE.equals(node.getNodeName()) || NODE_DOCKABLE_FRAME.equals(node.getNodeName())) {
                        Component comp = DockingPersistenceUtils.readComponent(document, manager, node, previousExistingFrames, callback);
                        if (comp == null) continue;
                        manager.getDockedFrameContainer().getNormalContainer().add(comp, "Center");
                        continue;
                    }
                    if (NODE_FLOATING_CONTAINER.equals(node.getNodeName())) {
                        FloatingContainer floatingContainer = DockingPersistenceUtils.readFloatingContainer(document, manager, node, previousExistingFrames, callback);
                        if (floatingContainer == null) continue;
                        manager.getFloatingFrames().add(floatingContainer);
                        continue;
                    }
                    if (NODE_AUTO_HIDE_CONTAINER.equals(node.getNodeName())) {
                        AutoHideContainer container = DockingPersistenceUtils.readAutohideContainer(document, manager, node, previousExistingFrames, callback);
                        switch (container.getAttachedSide()) {
                            case 3: {
                                manager._eastContainer = container;
                                break;
                            }
                            case 7: {
                                manager._westContainer = container;
                                break;
                            }
                            case 5: {
                                manager._southContainer = container;
                                break;
                            }
                            case 1: {
                                manager._northContainer = container;
                            }
                        }
                        continue;
                    }
                    if (!NODE_HIDDEN_FRAME.equals(node.getNodeName()) || (hiddenFrameName = DockingPersistenceUtils.readHiddenFrame(node)) == null) continue;
                    previousHiddenFrames.add(hiddenFrameName);
                }
                if (callback != null && dockableFrames instanceof Element) {
                    callback.load(document, (Element)dockableFrames, manager);
                }
                HiddenFrames newlyAddedFrame = new HiddenFrames();
                for (String s : contextCopy.keySet()) {
                    newlyAddedFrame.add(s);
                }
                if (manager.isHideNewlyAddedFrames()) {
                    for (String newFrame : newlyAddedFrame) {
                        DockableFrame frame = manager.getFrame(newFrame);
                        if (frame == null || !frame.isHidable()) continue;
                        previousHiddenFrames.add(newFrame);
                    }
                } else if (newlyAddedFrame != null && manager instanceof DefaultDockingManager) {
                    manager.handleNewlyAddedFrames(newlyAddedFrame.toArray(new String[newlyAddedFrame.size()]));
                }
                if (frameState != null) {
                    manager._state = Integer.valueOf(frameState);
                }
                hiddenFrames.removeAll(previousExistingFrames);
                if (manager._eastContainer == null) {
                    manager._eastContainer = manager.createAutoHideContainer(3);
                }
                manager._eastContainer.setRollover(manager.isSidebarRollover());
                if (manager._westContainer == null) {
                    manager._westContainer = manager.createAutoHideContainer(7);
                }
                manager._westContainer.setRollover(manager.isSidebarRollover());
                if (manager._southContainer == null) {
                    manager._southContainer = manager.createAutoHideContainer(5);
                }
                manager._southContainer.setRollover(manager.isSidebarRollover());
                if (manager._northContainer == null) {
                    manager._northContainer = manager.createAutoHideContainer(1);
                }
                manager._northContainer.setRollover(manager.isSidebarRollover());
                manager.listenToAutohideContainers();
                manager._dockedHiddenContainer.add((Component)manager.createScrollPaneForAutoHideContainer(manager._westContainer), "Before");
                manager._dockedHiddenContainer.add((Component)manager.createScrollPaneForAutoHideContainer(manager._eastContainer), "After");
                manager._dockedHiddenContainer.add((Component)manager.createScrollPaneForAutoHideContainer(manager._northContainer), "First");
                manager._dockedHiddenContainer.add((Component)manager.createScrollPaneForAutoHideContainer(manager._southContainer), "Last");
                manager._orderedFloatingFrames = new Vector<Component>();
                for (FloatingContainer floatingContainer : manager.getFloatingFrames()) {
                    floatingContainer.addWindowListener(manager.getFloatingContainerWindowListener());
                    if (!(floatingContainer instanceof Component)) continue;
                    manager._orderedFloatingFrames.add((Component)((Object)floatingContainer));
                }
                if (manager.getRootPaneContainer() instanceof Window) {
                    manager._orderedFloatingFrames.add((Window)((Object)manager.getRootPaneContainer()));
                    ((Window)((Object)manager.getRootPaneContainer())).addWindowListener(manager.getFloatingContainerWindowListener());
                }
                ArrayList<DockableFrame> saveFramesDockedInitPosition = new ArrayList<DockableFrame>();
                List<String> _allFrameKeys = manager.getAllFrameNames();
                for (i = _allFrameKeys.size() - 1; i >= 0; --i) {
                    frameKey = _allFrameKeys.get(i);
                    if (hiddenFrames.contains(frameKey)) continue;
                    dockableFrame = manager.getFrame(_allFrameKeys.get(i));
                    manager.addToZOrder(dockableFrame);
                }
                for (i = _allFrameKeys.size() - 1; i >= 0; --i) {
                    FrameContainer fc;
                    frameKey = _allFrameKeys.get(i);
                    if (hiddenFrames.contains(frameKey) || !((dockableFrame = manager.getFrame(_allFrameKeys.get(i))).getParent() instanceof FrameContainer) || (fc = (FrameContainer)dockableFrame.getParent()).getSelectedFrame() != dockableFrame) continue;
                    manager.adjustZorderWhileLoadingLayout(dockableFrame);
                }
                for (i = hiddenFrames.size() - 1; i >= 0; --i) {
                    int dockSide;
                    DockableFrame frame;
                    frameKey = (String)hiddenFrames.get(i);
                    if (previousHiddenFrames.contains(frameKey)) {
                        frame = manager.getFrame(frameKey);
                        if (frame == null || (dockSide = frame.getContext().getInitSide()) != 0) continue;
                        frame.getContext().setCurrentDockSide(dockSide);
                        continue;
                    }
                    frame = manager.getFrame(frameKey);
                    if (frame == null || frame.isHidden() || !frame.isAvailable()) continue;
                    JideSwingUtilities.removeFromParentWithFocusTransfer(frame);
                    frame.setVisible(false);
                    if (manager.getUnknownFrameBehaviorOnLoading() == 1) {
                        frame.setHidden(true);
                        continue;
                    }
                    dockSide = frame.getContext().getInitSide();
                    frame.getContext().setCurrentDockSide(dockSide);
                    switch (frame.getInitMode()) {
                        case 2: 
                        case 3: {
                            AutoHideContainer autoHideContainer = manager.getAutoHideContainer(dockSide);
                            if (manager.isGroupAllowedOnSidePane()) {
                                autoHideContainer.addFrame(frame);
                            } else {
                                autoHideContainer.addFrame(frame, autoHideContainer.getGroups().size());
                            }
                            hiddenFrames.remove(i);
                            break;
                        }
                        case 1: {
                            manager.internalFloatFrame(frame, frame.getContext().getUndockedBounds(), true, true);
                            hiddenFrames.remove(i);
                            break;
                        }
                        case 4: {
                            if (frame.getParent() == null || !(frame.getParent() instanceof FrameContainer)) {
                                if (!DefaultDockingManager.checkForInitPosition() || frame.getContext().isInitPosition()) {
                                    manager.dockFrame(frame.getKey(), frame.getContext().getInitSide(), frame.getContext().getInitIndex());
                                    frame.getContext().setInitPosition(true);
                                    saveFramesDockedInitPosition.add(frame);
                                } else {
                                    manager.internalDockFrame((JComponent)frame, (Component)manager.getDockedFrameContainer(), dockSide);
                                }
                            }
                            hiddenFrames.remove(i);
                            break;
                        }
                    }
                    manager.addToZOrder(frame);
                }
                for (DockableFrame frame : saveFramesDockedInitPosition) {
                    frame.getContext().setInitPosition(false);
                }
                for (FloatingContainer floatingContainer : manager.getFloatingFrames()) {
                    if (floatingContainer == null) continue;
                    Rectangle bounds = floatingContainer.getInitialBounds(floatingContainer.getBounds());
                    floatingContainer.pack();
                    floatingContainer.setBounds(bounds);
                    floatingContainer.setVisible(true);
                }
                manager.resetLayout();
                manager.setRealized(true);
                manager.fireFrameEvents();
                manager.setBoundsState();
                if (maximizeFrameKey != null && maximizeFrameKey.trim().length() > 0) {
                    manager.internalMaximizeFrame(manager.getFrame(maximizeFrameKey), false);
                }
                if (activeFrameKey != null && activeFrameKey.trim().length() > 0) {
                    manager.activateFrame(activeFrameKey);
                }
                loadDataSuccessful = true;
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Error loading layout - " + e.getLocalizedMessage(), e);
                }
                manager.loadDataErrorHandler();
            }
            finally {
                manager.setRealized(true);
            }
            if (error != null) {
                throw error;
            }
        }
        catch (Exception e) {
            loadDataSuccessful = false;
            manager.loadDataErrorHandler();
        }
        finally {
            manager.setLoadingLayoutData(previousLoadingData);
        }
        return loadDataSuccessful;
    }

    private static String readContext(Document document, DockingManager dockingManager, Node node, Map<String, DockContext> contexts, PersistenceUtilsCallback.Load callback) {
        String key = null;
        String dockID = null;
        String initSide = null;
        String initIndex = null;
        String initPosition = null;
        String initMode = null;
        String canMode = null;
        String currentMode = null;
        String currentDockSide = null;
        String available = null;
        String dockedWidth = null;
        String dockedHeight = null;
        String autohideWidth = null;
        String autohideHeight = null;
        String initAutohideWidth = null;
        String initAutohideHeight = null;
        DockContext context = new DockContext();
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (ATTRIBUTE_KEY.equals(attribute.getNodeName())) {
                key = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_DOCK_ID.equals(attribute.getNodeName())) {
                dockID = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_INIT_SIDE.equals(attribute.getNodeName())) {
                initSide = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_INIT_INDEX.equals(attribute.getNodeName())) {
                initIndex = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_INIT_POSITION.equals(attribute.getNodeName())) {
                initPosition = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_INIT_MODE.equals(attribute.getNodeName())) {
                initMode = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_CAN_MODE.equals(attribute.getNodeName())) {
                canMode = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_CURRENT_MODE.equals(attribute.getNodeName())) {
                currentMode = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_CURRENT_DOCK_SIDE.equals(attribute.getNodeName())) {
                currentDockSide = attribute.getNodeValue();
                continue;
            }
            if ("available".equals(attribute.getNodeName())) {
                available = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_DOCKED_WIDTH.equals(attribute.getNodeName())) {
                dockedWidth = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_DOCKED_HEIGHT.equals(attribute.getNodeName())) {
                dockedHeight = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_AUTOHIDE_WIDTH.equals(attribute.getNodeName())) {
                autohideWidth = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_AUTOHIDE_HEIGHT.equals(attribute.getNodeName())) {
                autohideHeight = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_INIT_AUTOHIDE_WIDTH.equals(attribute.getNodeName())) {
                initAutohideWidth = attribute.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_INIT_AUTOHIDE_HEIGHT.equals(attribute.getNodeName())) continue;
            initAutohideHeight = attribute.getNodeValue();
        }
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node childNode = nodes.item(i);
            if (NODE_UNDOCKED_BOUNDS.equals(childNode.getNodeName())) {
                context.setUndockedBounds(DockingPersistenceUtils.readBounds(childNode));
            }
            if (NODE_INIT_UNDOCKED_BOUNDS.equals(childNode.getNodeName())) {
                context.setInitUndockedBounds(DockingPersistenceUtils.readBounds(childNode));
                continue;
            }
            if (!NODE_PREVIOUS_STATE.equals(childNode.getNodeName())) continue;
            NamedNodeMap childNodeAttributes = childNode.getAttributes();
            for (int j = 0; j < childNodeAttributes.getLength(); ++j) {
                Node attribute = childNodeAttributes.item(j);
                if (!ATTRIBUTE_TYPE.equals(attribute.getNodeName())) continue;
                String type = attribute.getNodeValue();
                if (PREVIOUS_STATE_HIDDEN.equals(type)) {
                    context.setHiddenPreviousState(DockingPersistenceUtils.readPreviousState(document, childNode, callback));
                    continue;
                }
                if (PREVIOUS_STATE_DOCK.equals(type)) {
                    context.setDockPreviousState(DockingPersistenceUtils.readPreviousState(document, childNode, callback));
                    continue;
                }
                if (PREVIOUS_STATE_CLOSE.equals(type)) {
                    context.setClosePreviousState(DockingPersistenceUtils.readPreviousState(document, childNode, callback));
                    continue;
                }
                if (PREVIOUS_STATE_FLOAT.equals(type)) {
                    context.setFloatPreviousState(DockingPersistenceUtils.readPreviousState(document, childNode, callback));
                    continue;
                }
                if (PREVIOUS_STATE_AUTOHIDE.equals(type)) {
                    context.setAutohidePreviousState(DockingPersistenceUtils.readPreviousState(document, childNode, callback));
                    continue;
                }
                if (!"available".equals(type)) continue;
                context.setAvailablePreviousState(DockingPersistenceUtils.readPreviousState(document, childNode, callback));
            }
        }
        if (dockID != null) {
            context.setDockID(dockingManager, Integer.valueOf(dockID));
        }
        if (initSide != null) {
            context.setInitSide(Integer.valueOf(initSide));
        }
        if (initIndex != null) {
            context.setInitIndex(Integer.valueOf(initIndex));
        }
        context.setInitPosition("1".equals(initPosition));
        if (initMode != null) {
            context.setInitMode(Integer.valueOf(initMode));
        }
        if (canMode != null) {
            context.setCanMode(Integer.valueOf(canMode));
        }
        if (currentMode != null) {
            context.setCurrentMode(Integer.valueOf(currentMode));
        }
        if (context.isAutohideShowing()) {
            context.setCurrentMode(2);
        }
        if (currentDockSide != null) {
            context.setCurrentDockSide(Integer.valueOf(currentDockSide));
        }
        context.setAvailable("1".equals(available));
        if (dockedWidth != null) {
            context.setDockedWidth(Integer.valueOf(dockedWidth));
        }
        if (dockedHeight != null) {
            context.setDockedHeight(Integer.valueOf(dockedHeight));
        }
        if (autohideWidth != null) {
            context.setAutohideWidth(Integer.valueOf(autohideWidth));
        }
        if (autohideHeight != null) {
            context.setAutohideHeight(Integer.valueOf(autohideHeight));
        }
        if (initAutohideWidth != null) {
            context.setInitAutohideWidth(Integer.valueOf(initAutohideWidth));
        }
        if (initAutohideHeight != null) {
            context.setInitAutohideHeight(Integer.valueOf(initAutohideHeight));
        }
        if (contexts != null) {
            contexts.put(key, context);
        }
        if (callback != null && node instanceof Element) {
            callback.load(document, (Element)node, context);
        }
        return key;
    }

    private static Rectangle readBounds(Node node) {
        String x = null;
        String y = null;
        String width = null;
        String height = null;
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (ATTRIBUTE_X.equals(attribute.getNodeName())) {
                x = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_Y.equals(attribute.getNodeName())) {
                y = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_WIDTH.equals(attribute.getNodeName())) {
                width = attribute.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_HEIGHT.equals(attribute.getNodeName())) continue;
            height = attribute.getNodeValue();
        }
        Rectangle bounds = new Rectangle();
        if (x != null) {
            bounds.x = Integer.valueOf(x);
        }
        if (y != null) {
            bounds.y = Integer.valueOf(y);
        }
        if (width != null) {
            bounds.width = Integer.valueOf(width);
        }
        if (height != null) {
            bounds.height = Integer.valueOf(height);
        }
        return bounds;
    }

    private static PreviousState readPreviousState(Document document, Node node, PersistenceUtilsCallback.Load callback) {
        PreviousState state = new PreviousState();
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (ATTRIBUTE_MODE.equals(attribute.getNodeName())) {
                state.mode = Integer.valueOf(attribute.getNodeValue());
                continue;
            }
            if (ATTRIBUTE_DOCK_ID.equals(attribute.getNodeName())) {
                state.dockID = Integer.valueOf(attribute.getNodeValue());
                continue;
            }
            if (ATTRIBUTE_ROOT_ID.equals(attribute.getNodeName())) {
                state.rootID = Integer.valueOf(attribute.getNodeValue());
                continue;
            }
            if (ATTRIBUTE_SIDE.equals(attribute.getNodeName())) {
                state.side = Integer.valueOf(attribute.getNodeValue());
                continue;
            }
            if (ATTRIBUTE_INDEX.equals(attribute.getNodeName())) {
                state.index = Integer.valueOf(attribute.getNodeValue());
                continue;
            }
            if (!ATTRIBUTE_FC_ID.equals(attribute.getNodeName())) continue;
            state.fcID = Integer.valueOf(attribute.getNodeValue());
        }
        state.fcChildren = new ArrayList();
        state.parentStates = new ArrayList();
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node childNode = nodes.item(i);
            if (NODE_BOUNDS.equals(childNode.getNodeName())) {
                state.rcBounds = DockingPersistenceUtils.readBounds(childNode);
                continue;
            }
            if (NODE_CHILD.equals(childNode.getNodeName())) {
                NamedNodeMap childAttributes = childNode.getAttributes();
                for (int j = 0; j < childAttributes.getLength(); ++j) {
                    Node attribute = childAttributes.item(j);
                    if (!ATTRIBUTE_DOCK_ID.equals(attribute.getNodeName())) continue;
                    state.fcChildren.add(Integer.valueOf(attribute.getNodeValue()));
                }
                continue;
            }
            if (!NODE_PARENT_STATE.equals(childNode.getNodeName())) continue;
            state.parentStates.add(DockingPersistenceUtils.readParentState(childNode));
        }
        if (callback != null && node instanceof Element) {
            callback.load(document, (Element)node, state);
        }
        return state;
    }

    private static PreviousState.ParentState readParentState(Node node) {
        PreviousState.ParentState pState = new PreviousState.ParentState();
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (ATTRIBUTE_CC_ID.equals(attribute.getNodeName())) {
                pState.ccID = Integer.valueOf(attribute.getNodeValue());
                continue;
            }
            if (ATTRIBUTE_DOCK_ID.equals(attribute.getNodeName())) {
                pState.myID = Integer.valueOf(attribute.getNodeValue());
                continue;
            }
            if (!ATTRIBUTE_ORIENTATION.equals(attribute.getNodeName())) continue;
            pState.orientation = Integer.valueOf(attribute.getNodeValue());
        }
        pState.ccChildren = new ArrayList();
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node childNode = nodes.item(i);
            if (!NODE_CHILD.equals(childNode.getNodeName())) continue;
            NamedNodeMap childAttributes = childNode.getAttributes();
            for (int j = 0; j < childAttributes.getLength(); ++j) {
                Node attribute = childAttributes.item(j);
                if (!ATTRIBUTE_DOCK_ID.equals(attribute.getNodeName())) continue;
                pState.ccChildren.add(Integer.valueOf(attribute.getNodeValue()));
            }
        }
        return pState;
    }

    private static Component readComponent(Document document, DockingManager dockingManager, Node node, HiddenFrames previousExistingFrames, PersistenceUtilsCallback.Load callback) {
        if (NODE_CONTAINER_CONTAINER.equals(node.getNodeName())) {
            return DockingPersistenceUtils.readContainerContainer(document, dockingManager, node, previousExistingFrames, callback);
        }
        if (NODE_FRAME_CONTAINER.equals(node.getNodeName())) {
            return DockingPersistenceUtils.readFrameContainer(document, dockingManager, node, previousExistingFrames, callback);
        }
        if (NODE_DOCKABLE_FRAME.equals(node.getNodeName())) {
            return DockingPersistenceUtils.readDockableFrame(document, dockingManager, node, previousExistingFrames, callback);
        }
        if (NODE_FLOATING_CONTAINER.equals(node.getNodeName())) {
            return (Component)((Object)DockingPersistenceUtils.readFloatingContainer(document, dockingManager, node, previousExistingFrames, callback));
        }
        if (NODE_WORKSPACE.equals(node.getNodeName())) {
            return DockingPersistenceUtils.readWorkspace(document, dockingManager, node, previousExistingFrames, callback);
        }
        return null;
    }

    private static ContainerContainer readContainerContainer(Document document, DockingManager dockingManager, Node node, HiddenFrames previousExistingFrames, PersistenceUtilsCallback.Load callback) {
        ContainerContainer cc = dockingManager != null ? dockingManager.createContainerContainer() : new ContainerContainer();
        String orientation = null;
        String dockID = null;
        String proportionLayout = null;
        String initiallyEven = null;
        String proportion = null;
        String preferredWidth = null;
        String preferredHeight = null;
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (ATTRIBUTE_ORIENTATION.equals(attribute.getNodeName())) {
                orientation = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_DOCK_ID.equals(attribute.getNodeName())) {
                dockID = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_PROPORTION_LAYOUT.equals(attribute.getNodeName())) {
                proportionLayout = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_INITIALLY_EVEN.equals(attribute.getNodeName())) {
                initiallyEven = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_PROPORTION.equals(attribute.getNodeName())) {
                proportion = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_PREFERRED_WIDTH.equals(attribute.getNodeName())) {
                preferredWidth = attribute.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_PREFERRED_HEIGHT.equals(attribute.getNodeName())) continue;
            preferredHeight = attribute.getNodeValue();
        }
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Component comp;
            Node childNode = nodes.item(i);
            if (!NODE_CONTAINER_CONTAINER.equals(childNode.getNodeName()) && !NODE_FRAME_CONTAINER.equals(childNode.getNodeName()) && !NODE_DOCKABLE_FRAME.equals(childNode.getNodeName()) && !NODE_WORKSPACE.equals(childNode.getNodeName()) || (comp = DockingPersistenceUtils.readComponent(document, dockingManager, childNode, previousExistingFrames, callback)) == null) continue;
            cc.add(comp);
        }
        if (orientation != null) {
            cc.setOrientation(Integer.valueOf(orientation));
        }
        if (dockID != null) {
            cc.setDockID(Integer.valueOf(dockID));
        }
        cc.setProportionalLayout("1".equals(proportionLayout));
        boolean hasProportions = false;
        if (cc.isProportionalLayout()) {
            cc.setInitiallyEven("1".equals(initiallyEven));
            if (proportion != null) {
                String[] strings = proportion.split(";");
                double[] p = new double[strings.length];
                for (int i = 0; i < p.length; ++i) {
                    p[i] = Double.valueOf(strings[i]);
                }
                cc.setEventualProportions(p);
                hasProportions = true;
            }
        }
        if (preferredWidth != null && preferredHeight != null && (Integer.valueOf(preferredWidth) != 0 || Integer.valueOf(preferredHeight) != 0)) {
            cc.setPreferredSize(new Dimension(Integer.valueOf(preferredWidth), Integer.valueOf(preferredHeight)));
        }
        if (cc.getComponentCount() == 0 && !hasProportions) {
            return null;
        }
        if (callback != null && node instanceof Element) {
            callback.load(document, (Element)node, cc);
        }
        return cc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FrameContainer readFrameContainer(Document document, DockingManager dockingManager, Node node, HiddenFrames previousExistingFrames, PersistenceUtilsCallback.Load callback) {
        FrameContainer frameContainer = dockingManager != null ? dockingManager.createFrameContainer() : new FrameContainer();
        String dockID = null;
        String preferredWidth = null;
        String preferredHeight = null;
        String selectedIndex = null;
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (ATTRIBUTE_DOCK_ID.equals(attribute.getNodeName())) {
                dockID = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_PREFERRED_WIDTH.equals(attribute.getNodeName())) {
                preferredWidth = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_PREFERRED_HEIGHT.equals(attribute.getNodeName())) {
                preferredHeight = attribute.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_SELECTED_INDEX.equals(attribute.getNodeName())) continue;
            selectedIndex = attribute.getNodeValue();
        }
        NodeList nodes = node.getChildNodes();
        frameContainer.setSuppressSetSelectedIndex(true);
        frameContainer.setSuppressStateChangedEvents(true);
        try {
            for (int i = 0; i < nodes.getLength(); ++i) {
                DockableFrame dockableFrame;
                Node childNode = nodes.item(i);
                if (!NODE_DOCKABLE_FRAME.equals(childNode.getNodeName()) || (dockableFrame = DockingPersistenceUtils.readDockableFrame(document, dockingManager, childNode, previousExistingFrames, callback)) == null || dockableFrame.getContext() == null || !dockableFrame.isAvailable() || dockableFrame.shouldVetoShowing()) continue;
                frameContainer.addTab(dockableFrame);
            }
        }
        finally {
            frameContainer.setSuppressSetSelectedIndex(false);
            frameContainer.setSuppressStateChangedEvents(false);
        }
        if (frameContainer.getTabCount() == 0) {
            return null;
        }
        if (dockID != null) {
            frameContainer.setDockID(Integer.valueOf(dockID));
        }
        if (preferredWidth != null && preferredHeight != null) {
            frameContainer.setPreferredSize(new Dimension(Integer.valueOf(preferredWidth), Integer.valueOf(preferredHeight)));
        }
        int selected = -1;
        if (selectedIndex != null) {
            selected = Integer.valueOf(selectedIndex);
        }
        if (selected >= 0 && selected < frameContainer.getTabCount()) {
            frameContainer.setSelectedIndex(selected);
        } else if (frameContainer.getTabCount() > 0) {
            frameContainer.setSelectedIndex(0);
        }
        frameContainer.setPreviousSelectedFrame(frameContainer.getSelectedFrame());
        if (callback != null && node instanceof Element) {
            callback.load(document, (Element)node, frameContainer);
        }
        return frameContainer;
    }

    private static DockableFrame readDockableFrame(Document document, DockingManager dockingManager, Node node, HiddenFrames previousExistingFrames, PersistenceUtilsCallback.Load callback) {
        DockableFrame frame;
        String name = null;
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (!ATTRIBUTE_KEY.equals(attribute.getNodeName())) continue;
            name = attribute.getNodeValue();
        }
        if (dockingManager != null) {
            frame = dockingManager.getFrame(name);
        } else {
            frame = new DockableFrame();
            frame.setKey(name);
        }
        if (frame != null) {
            DockContext dockContext = null;
            if (!frame.isTransient() && dockingManager != null) {
                dockContext = dockingManager.getContextOf(name);
            }
            if (dockContext != null) {
                frame.setContext(dockContext);
            }
            if (!frame.isHidden()) {
                previousExistingFrames.add(name);
            }
            frame.setAvailable(true);
        }
        if (callback != null && node instanceof Element) {
            callback.load(document, (Element)node, frame);
        }
        return frame;
    }

    private static FloatingContainer readFloatingContainer(Document document, DockingManager dockingManager, Node node, HiddenFrames previousExistingFrames, PersistenceUtilsCallback.Load callback) {
        FloatingContainer floatingContainer;
        if (dockingManager != null) {
            RootPaneContainer container = dockingManager.getRootPaneContainer();
            if (container == null) {
                throw new IllegalStateException("Failed to create floating frame because the top level window is not available. Please make sure you load the layout after the contentContainer is added to Swing component tree hierarchy or make sure you pass in a valid rootPaneContainer in the constructor of DefaultDockingManager.");
            }
            floatingContainer = dockingManager.createFloatingContainer(SwingUtilities.getWindowAncestor(container.getRootPane()));
            DockingManager.FloatingContainerCustomizer customizer = dockingManager.getFloatingContainerCustomizer();
            if (customizer != null) {
                customizer.customize(floatingContainer);
            }
        } else {
            floatingContainer = new FrameFloatingContainer();
        }
        Rectangle bounds = null;
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Component comp;
            Node childNode = nodes.item(i);
            if (NODE_BOUNDS.equals(childNode.getNodeName())) {
                bounds = DockingPersistenceUtils.readBounds(childNode);
                continue;
            }
            if (!NODE_CONTAINER_CONTAINER.equals(childNode.getNodeName()) && !NODE_FRAME_CONTAINER.equals(childNode.getNodeName()) && !NODE_DOCKABLE_FRAME.equals(childNode.getNodeName()) && !NODE_WORKSPACE.equals(childNode.getNodeName()) || (comp = DockingPersistenceUtils.readComponent(document, dockingManager, childNode, previousExistingFrames, callback)) == null) continue;
            floatingContainer.getContentPane().add(comp);
        }
        if (floatingContainer.getContentPane().getComponentCount() == 0 || bounds == null || bounds.isEmpty()) {
            floatingContainer.dispose();
            return null;
        }
        final int[] count = new int[]{0};
        JideSwingUtilities.setRecursively(floatingContainer.getContentPane(), new JideSwingUtilities.Handler(){

            @Override
            public boolean condition(Component c) {
                return c instanceof DockableFrame;
            }

            @Override
            public void action(Component c) {
                count[0] = count[0] + 1;
            }

            @Override
            public void postAction(Component c) {
            }
        });
        if (count[0] <= 0) {
            floatingContainer.dispose();
            return null;
        }
        Rectangle floatingContainerBounds = PortingUtils.overlapWithScreenBounds((Component)((Object)floatingContainer), bounds);
        if (dockingManager instanceof DefaultDockingManager) {
            ((DefaultDockingManager)dockingManager).adjustBoundsForSnap(new Rectangle(), floatingContainerBounds);
        }
        floatingContainer.setBounds(floatingContainerBounds);
        if (dockingManager != null) {
            floatingContainer.updateUndecorated();
        }
        if (callback != null && node instanceof Element) {
            callback.load(document, (Element)node, floatingContainer);
        }
        return floatingContainer;
    }

    private static Workspace readWorkspace(Document document, DockingManager dockingManager, Node node, HiddenFrames previousExistingFrames, PersistenceUtilsCallback.Load callback) {
        Workspace ws = dockingManager != null ? dockingManager.getWorkspace() : new Workspace();
        String acceptDockableFrame = null;
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (!ATTRIBUTE_ACCEPT_DOCKABLE_FRAME.equals(attribute.getNodeName())) continue;
            acceptDockableFrame = attribute.getNodeValue();
        }
        if (acceptDockableFrame != null) {
            ws.setAcceptDockableFrame("1".equals(acceptDockableFrame));
        }
        if (ws.isAcceptDockableFrame()) {
            ws.removeAll();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Component comp;
                Node childNode = nodes.item(i);
                if (!NODE_CONTAINER_CONTAINER.equals(childNode.getNodeName()) && !NODE_FRAME_CONTAINER.equals(childNode.getNodeName()) && !NODE_DOCKABLE_FRAME.equals(childNode.getNodeName()) && !NODE_WORKSPACE.equals(childNode.getNodeName()) || (comp = DockingPersistenceUtils.readComponent(document, dockingManager, childNode, previousExistingFrames, callback)) == null) continue;
                ws.add(comp);
            }
        }
        if (callback != null && node instanceof Element) {
            callback.load(document, (Element)node, ws);
        }
        return ws;
    }

    private static AutoHideContainer readAutohideContainer(Document document, DefaultDockingManager dockingManager, Node node, HiddenFrames previousExistingFrames, PersistenceUtilsCallback.Load callback) {
        NamedNodeMap attributes = node.getAttributes();
        String side = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (!ATTRIBUTE_SIDE.equals(attribute.getNodeName())) continue;
            side = attribute.getNodeValue();
        }
        if (side == null) {
            return null;
        }
        AutoHideContainer autoHideContainer = dockingManager != null ? dockingManager.createAutoHideContainer(Integer.valueOf(side)) : new AutoHideContainer(Integer.valueOf(side));
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            SidePaneGroup group;
            Node childNode = nodes.item(i);
            if (!NODE_SIDE_PANE_GROUP.equals(childNode.getNodeName()) || (group = DockingPersistenceUtils.readSideGroup(document, dockingManager, childNode, DockingUtils.convertToDockSide(autoHideContainer.getAttachedSide()), previousExistingFrames, callback)) == null) continue;
            autoHideContainer.addGroup(group);
        }
        if (callback != null && node instanceof Element) {
            callback.load(document, (Element)node, autoHideContainer);
        }
        return autoHideContainer;
    }

    private static SidePaneGroup readSideGroup(Document document, DefaultDockingManager dockingManager, Node node, int side, HiddenFrames previousExistingFrames, PersistenceUtilsCallback.Load callback) {
        SidePaneGroup group = new SidePaneGroup();
        NamedNodeMap attributes = node.getAttributes();
        String selectedIndex = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (!ATTRIBUTE_SELECTED_INDEX.equals(attribute.getNodeName())) continue;
            selectedIndex = attribute.getNodeValue();
        }
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            SidePaneItem item;
            Node childNode = nodes.item(i);
            if (!NODE_SIDE_PANE_ITEM.equals(childNode.getNodeName()) || (item = DockingPersistenceUtils.readSideItem(document, dockingManager, childNode, side, previousExistingFrames, callback)) == null) continue;
            group.add(item);
        }
        int selected = -1;
        if (selectedIndex != null) {
            selected = Integer.valueOf(selectedIndex);
        }
        if (selected >= 0 && selected < group.size()) {
            group.setSelectedIndex(selected);
        }
        if (group.size() > 0) {
            if (callback != null && node instanceof Element) {
                callback.load(document, (Element)node, group);
            }
            return group;
        }
        return null;
    }

    private static SidePaneItem readSideItem(Document document, DefaultDockingManager dockingManager, Node node, int side, HiddenFrames previousExistingFrames, PersistenceUtilsCallback.Load callback) {
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            DockableFrame dockableFrame;
            Node childNode = nodes.item(i);
            if (!NODE_DOCKABLE_FRAME.equals(childNode.getNodeName()) || (dockableFrame = DockingPersistenceUtils.readDockableFrame(document, dockingManager, childNode, previousExistingFrames, callback)) == null || dockableFrame.getContext() == null || !dockableFrame.isAvailable() || dockableFrame.shouldVetoShowing()) continue;
            SidePaneItem item = new SidePaneItem(dockableFrame.getSideTitle(), dockableFrame.getFrameIcon(), dockableFrame, dockingManager != null ? dockingManager.getInternalEventManager().createAutoHideMouseInputListener(dockableFrame, side) : null);
            item.setSelected(false);
            if (callback != null && node instanceof Element) {
                callback.load(document, (Element)node, item);
            }
            return item;
        }
        return null;
    }

    private static String readHiddenFrame(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (!ATTRIBUTE_KEY.equals(attribute.getNodeName())) continue;
            return attribute.getNodeValue();
        }
        return null;
    }

    public static boolean compare(Document document1, Document document2) {
        return DockingPersistenceUtils.compare(document1, null, document2, null);
    }

    public static boolean compare(Document document1, String layoutName1, Document document2, String layoutName2) {
        Node component1 = document1.getElementsByTagName("LayoutPersistence").item(0);
        Node dockableFramesNode1 = null;
        if (component1 != null) {
            NodeList list = component1.getChildNodes();
            for (int index = 0; index < list.getLength(); ++index) {
                Node node = list.item(index);
                if (!"DockingManager".equals(node.getNodeName())) continue;
                String persistenceName = null;
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attribute = attributes.item(i);
                    if (!"persistenceName".equals(attribute.getNodeName())) continue;
                    persistenceName = attribute.getNodeValue();
                    break;
                }
                if (dockableFramesNode1 == null) {
                    dockableFramesNode1 = node;
                }
                if (!JideSwingUtilities.equals(persistenceName, layoutName1)) continue;
                dockableFramesNode1 = node;
                break;
            }
        }
        Node component2 = document2.getElementsByTagName("LayoutPersistence").item(0);
        Node dockableFramesNode2 = null;
        if (component2 != null) {
            NodeList list = component2.getChildNodes();
            for (int index = 0; index < list.getLength(); ++index) {
                Node node = list.item(index);
                if (!"DockingManager".equals(node.getNodeName())) continue;
                String persistenceName = null;
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attribute = attributes.item(i);
                    if (!"persistenceName".equals(attribute.getNodeName())) continue;
                    persistenceName = attribute.getNodeValue();
                    break;
                }
                if (dockableFramesNode2 == null) {
                    dockableFramesNode2 = node;
                }
                if (!JideSwingUtilities.equals(persistenceName, layoutName2)) continue;
                dockableFramesNode2 = node;
                break;
            }
        }
        if (dockableFramesNode1 == null || dockableFramesNode2 == null) {
            return false;
        }
        String activeFrameKey1 = null;
        String frameState1 = null;
        String maximizeFrameKey1 = null;
        NamedNodeMap componentAttributes1 = dockableFramesNode1.getAttributes();
        for (int i = 0; i < componentAttributes1.getLength(); ++i) {
            Node attribute = componentAttributes1.item(i);
            if (ATTRIBUTE_ACTIVE_FRAME.equals(attribute.getNodeName())) {
                activeFrameKey1 = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_FRAME_STATE.equals(attribute.getNodeName())) {
                frameState1 = attribute.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_MAXIMIZED_FRAME.equals(attribute.getNodeName())) continue;
            maximizeFrameKey1 = attribute.getNodeValue();
        }
        String activeFrameKey2 = null;
        String frameState2 = null;
        String maximizeFrameKey2 = null;
        NamedNodeMap componentAttributes2 = dockableFramesNode2.getAttributes();
        for (int i = 0; i < componentAttributes2.getLength(); ++i) {
            Node attribute = componentAttributes2.item(i);
            if (ATTRIBUTE_ACTIVE_FRAME.equals(attribute.getNodeName())) {
                activeFrameKey2 = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_FRAME_STATE.equals(attribute.getNodeName())) {
                frameState2 = attribute.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_MAXIMIZED_FRAME.equals(attribute.getNodeName())) continue;
            maximizeFrameKey2 = attribute.getNodeValue();
        }
        if (!(JideSwingUtilities.equals(activeFrameKey1, activeFrameKey2) && JideSwingUtilities.equals(frameState1, frameState2) && JideSwingUtilities.equals(maximizeFrameKey1, maximizeFrameKey2))) {
            return false;
        }
        HashMap<String, DockContext> contexts1 = new HashMap<String, DockContext>();
        Rectangle _unmaximizedBounds1 = null;
        Component mainContainerComp1 = null;
        FloatingFrames floatingFrames1 = new FloatingFrames();
        AutoHideContainer eastContainer1 = null;
        AutoHideContainer westContainer1 = null;
        AutoHideContainer southContainer1 = null;
        AutoHideContainer northContainer1 = null;
        HiddenFrames hiddenFrames1 = new HiddenFrames();
        HiddenFrames previousExistingFrames1 = new HiddenFrames();
        NodeList list1 = dockableFramesNode1.getChildNodes();
        for (int index = 0; index < list1.getLength(); ++index) {
            String hiddenFrameName;
            Node node = list1.item(index);
            if (NODE_CONTEXT.equals(node.getNodeName())) {
                DockingPersistenceUtils.readContext(document1, null, node, contexts1, null);
                continue;
            }
            if (NODE_BOUNDS.equals(node.getNodeName())) {
                _unmaximizedBounds1 = DockingPersistenceUtils.readBounds(node);
                continue;
            }
            if (NODE_CONTAINER_CONTAINER.equals(node.getNodeName()) || NODE_FRAME_CONTAINER.equals(node.getNodeName()) || NODE_WORKSPACE.equals(node.getNodeName()) || NODE_DOCKABLE_FRAME.equals(node.getNodeName())) {
                mainContainerComp1 = DockingPersistenceUtils.readComponent(document1, null, node, previousExistingFrames1, null);
                continue;
            }
            if (NODE_FLOATING_CONTAINER.equals(node.getNodeName())) {
                FloatingContainer floatingContainer = DockingPersistenceUtils.readFloatingContainer(document1, null, node, previousExistingFrames1, null);
                if (floatingContainer == null) continue;
                floatingFrames1.add(floatingContainer);
                continue;
            }
            if (NODE_AUTO_HIDE_CONTAINER.equals(node.getNodeName())) {
                AutoHideContainer container = DockingPersistenceUtils.readAutohideContainer(document1, null, node, previousExistingFrames1, null);
                switch (container.getAttachedSide()) {
                    case 3: {
                        eastContainer1 = container;
                        break;
                    }
                    case 7: {
                        westContainer1 = container;
                        break;
                    }
                    case 5: {
                        southContainer1 = container;
                        break;
                    }
                    case 1: {
                        northContainer1 = container;
                    }
                }
                continue;
            }
            if (!NODE_HIDDEN_FRAME.equals(node.getNodeName()) || (hiddenFrameName = DockingPersistenceUtils.readHiddenFrame(node)) == null) continue;
            hiddenFrames1.add(hiddenFrameName);
        }
        HashMap<String, DockContext> contexts2 = new HashMap<String, DockContext>();
        Rectangle _unmaximizedBounds2 = null;
        Component mainContainerComp2 = null;
        FloatingFrames floatingFrames2 = new FloatingFrames();
        AutoHideContainer eastContainer2 = null;
        AutoHideContainer westContainer2 = null;
        AutoHideContainer southContainer2 = null;
        AutoHideContainer northContainer2 = null;
        HiddenFrames hiddenFrames2 = new HiddenFrames();
        HiddenFrames previousExistingFrames2 = new HiddenFrames();
        NodeList list2 = dockableFramesNode2.getChildNodes();
        for (int index = 0; index < list2.getLength(); ++index) {
            String hiddenFrameName;
            Node node = list2.item(index);
            if (NODE_CONTEXT.equals(node.getNodeName())) {
                DockingPersistenceUtils.readContext(document2, null, node, contexts2, null);
                continue;
            }
            if (NODE_BOUNDS.equals(node.getNodeName())) {
                _unmaximizedBounds2 = DockingPersistenceUtils.readBounds(node);
                continue;
            }
            if (NODE_CONTAINER_CONTAINER.equals(node.getNodeName()) || NODE_FRAME_CONTAINER.equals(node.getNodeName()) || NODE_WORKSPACE.equals(node.getNodeName()) || NODE_DOCKABLE_FRAME.equals(node.getNodeName())) {
                mainContainerComp2 = DockingPersistenceUtils.readComponent(document2, null, node, previousExistingFrames2, null);
                continue;
            }
            if (NODE_FLOATING_CONTAINER.equals(node.getNodeName())) {
                FloatingContainer floatingContainer = DockingPersistenceUtils.readFloatingContainer(document2, null, node, previousExistingFrames2, null);
                if (floatingContainer == null) continue;
                floatingFrames2.add(floatingContainer);
                continue;
            }
            if (NODE_AUTO_HIDE_CONTAINER.equals(node.getNodeName())) {
                AutoHideContainer container = DockingPersistenceUtils.readAutohideContainer(document2, null, node, previousExistingFrames2, null);
                switch (container.getAttachedSide()) {
                    case 3: {
                        eastContainer2 = container;
                        break;
                    }
                    case 7: {
                        westContainer2 = container;
                        break;
                    }
                    case 5: {
                        southContainer2 = container;
                        break;
                    }
                    case 1: {
                        northContainer2 = container;
                    }
                }
                continue;
            }
            if (!NODE_HIDDEN_FRAME.equals(node.getNodeName()) || (hiddenFrameName = DockingPersistenceUtils.readHiddenFrame(node)) == null) continue;
            hiddenFrames2.add(hiddenFrameName);
        }
        if (!JideSwingUtilities.equals(_unmaximizedBounds1, _unmaximizedBounds2) || contexts1.size() != contexts2.size() || hiddenFrames1.size() != hiddenFrames2.size() || previousExistingFrames1.size() != previousExistingFrames2.size() || floatingFrames1.size() != floatingFrames2.size()) {
            return false;
        }
        HashMap<Integer, String> dockIDMap1 = new HashMap<Integer, String>();
        HashMap<Integer, String> dockIDMap2 = new HashMap<Integer, String>();
        for (String key : contexts1.keySet()) {
            DockContext context1 = (DockContext)contexts1.get(key);
            DockContext context2 = (DockContext)contexts2.get(key);
            if (context1 == null || context2 == null) {
                if (context1 == context2) continue;
                return false;
            }
            if (!JideSwingUtilities.equals(context1.getUndockedBounds(), context2.getUndockedBounds()) || !JideSwingUtilities.equals(context1.getInitUndockedBounds(), context2.getInitUndockedBounds()) || context1.getInitSide() != context2.getInitSide() || context1.getInitIndex() != context2.getInitIndex() || context1.isInitPosition() != context2.isInitPosition() || context1.getInitMode() != context2.getInitMode() || context1.getCanMode() != context2.getCanMode() || context1.getCurrentMode() != context2.getCurrentMode() || context1.getCurrentDockSide() != context2.getCurrentDockSide() || context1.isAvailable() != context2.isAvailable() || context1.getDockedWidth() != context2.getDockedWidth() || context1.getDockedHeight() != context2.getDockedHeight() || context1.getAutohideWidth() != context2.getAutohideWidth() || context1.getAutohideHeight() != context2.getAutohideHeight() || context1.getInitAutohideWidth() != context2.getInitAutohideWidth() || context1.getInitAutohideHeight() != context2.getInitAutohideHeight()) {
                return false;
            }
            dockIDMap1.put(context1.getDockID(), key);
            dockIDMap2.put(context2.getDockID(), key);
        }
        if (!DockingPersistenceUtils.compareComponent(mainContainerComp1, mainContainerComp2, dockIDMap1, dockIDMap2)) {
            return false;
        }
        for (FloatingContainer container1 : floatingFrames1) {
            boolean foundMatch = false;
            for (int i = 0; i < floatingFrames2.size(); ++i) {
                if (!DockingPersistenceUtils.compareComponent((Component)((Object)container1), (Component)floatingFrames2.get(i), dockIDMap1, dockIDMap2)) continue;
                foundMatch = true;
                floatingFrames2.remove(i);
                break;
            }
            if (foundMatch) continue;
            return false;
        }
        if (!(eastContainer1 == null && eastContainer2 == null || DockingPersistenceUtils.compareComponent(eastContainer1, eastContainer2, dockIDMap1, dockIDMap2))) {
            return false;
        }
        if (!(westContainer1 == null && westContainer2 == null || DockingPersistenceUtils.compareComponent(westContainer1, westContainer2, dockIDMap1, dockIDMap2))) {
            return false;
        }
        if (!(southContainer1 == null && southContainer2 == null || DockingPersistenceUtils.compareComponent(southContainer1, southContainer2, dockIDMap1, dockIDMap2))) {
            return false;
        }
        if (!(northContainer1 == null && northContainer2 == null || DockingPersistenceUtils.compareComponent(northContainer1, northContainer2, dockIDMap1, dockIDMap2))) {
            return false;
        }
        for (String key : hiddenFrames1) {
            if (hiddenFrames2.contains(key)) continue;
            return false;
        }
        for (String key : previousExistingFrames1) {
            if (previousExistingFrames2.contains(key)) continue;
            return false;
        }
        for (String key : contexts1.keySet()) {
            DockContext context1 = (DockContext)contexts1.get(key);
            DockContext context2 = (DockContext)contexts2.get(key);
            if (!DockingPersistenceUtils.comparePreviousState(context1.getHiddenPreviousState(), context2.getHiddenPreviousState(), dockIDMap1, dockIDMap2)) {
                return false;
            }
            if (!DockingPersistenceUtils.comparePreviousState(context1.getDockPreviousState(), context2.getDockPreviousState(), dockIDMap1, dockIDMap2)) {
                return false;
            }
            if (!DockingPersistenceUtils.comparePreviousState(context1.getClosePreviousState(), context2.getClosePreviousState(), dockIDMap1, dockIDMap2)) {
                return false;
            }
            if (!DockingPersistenceUtils.comparePreviousState(context1.getFloatPreviousState(), context2.getFloatPreviousState(), dockIDMap1, dockIDMap2)) {
                return false;
            }
            if (!DockingPersistenceUtils.comparePreviousState(context1.getAutohidePreviousState(), context2.getAutohidePreviousState(), dockIDMap1, dockIDMap2)) {
                return false;
            }
            if (DockingPersistenceUtils.comparePreviousState(context1.getAvailablePreviousState(), context2.getAvailablePreviousState(), dockIDMap1, dockIDMap2)) continue;
            return false;
        }
        return true;
    }

    private static boolean compareParentState(PreviousState.ParentState state1, PreviousState.ParentState state2, Map<Integer, String> dockIDMap1, Map<Integer, String> dockIDMap2) {
        if (state1 == null && state2 == null) {
            return true;
        }
        if (state1 == null || state2 == null) {
            return false;
        }
        if (state1.orientation != state2.orientation || !JideSwingUtilities.equals(dockIDMap1.get(state1.ccID), dockIDMap2.get(state2.ccID)) || !JideSwingUtilities.equals(dockIDMap1.get(state1.myID), dockIDMap2.get(state2.myID)) || state1.ccChildren.size() != state2.ccChildren.size()) {
            return false;
        }
        for (int dockID1 : state1.ccChildren) {
            String name = dockIDMap1.get(dockID1);
            boolean foundMatch = false;
            for (int dockID2 : state2.ccChildren) {
                if (!JideSwingUtilities.equals(name, dockIDMap2.get(dockID2))) continue;
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            return false;
        }
        return true;
    }

    private static boolean comparePreviousState(PreviousState state1, PreviousState state2, Map<Integer, String> dockIDMap1, Map<Integer, String> dockIDMap2) {
        if (state1 == null && state2 == null) {
            return true;
        }
        if (state1 == null || state2 == null) {
            return false;
        }
        if (!(state1.mode == state2.mode && state1.side == state2.side && state1.index == state2.index && JideSwingUtilities.equals(dockIDMap1.get(state1.dockID), dockIDMap2.get(state2.dockID)) && JideSwingUtilities.equals(dockIDMap1.get(state1.rootID), dockIDMap2.get(state2.rootID)) && JideSwingUtilities.equals(dockIDMap1.get(state1.fcID), dockIDMap2.get(state2.fcID)) && JideSwingUtilities.equals(state1.rcBounds, state2.rcBounds) && state1.fcChildren.size() == state2.fcChildren.size() && state1.parentStates.size() == state2.parentStates.size())) {
            return false;
        }
        Iterator<Serializable> iterator = state1.fcChildren.iterator();
        while (iterator.hasNext()) {
            int dockID1 = iterator.next();
            String name = dockIDMap1.get(dockID1);
            boolean foundMatch = false;
            for (int dockID2 : state2.fcChildren) {
                if (!JideSwingUtilities.equals(name, dockIDMap2.get(dockID2))) continue;
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            return false;
        }
        for (PreviousState.ParentState parentState1 : state1.parentStates) {
            boolean foundMatch = false;
            for (PreviousState.ParentState parentState2 : state2.parentStates) {
                if (!DockingPersistenceUtils.compareParentState(parentState1, parentState2, dockIDMap1, dockIDMap2)) continue;
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            return false;
        }
        return true;
    }

    private static boolean compareComponent(Component comp1, Component comp2, Map<Integer, String> dockIDMap1, Map<Integer, String> dockIDMap2) {
        block12: {
            block15: {
                block14: {
                    block13: {
                        block11: {
                            if (comp1 == null && comp2 == null) {
                                return true;
                            }
                            if (comp1 == null || comp2 == null || comp1.getClass() != comp2.getClass()) {
                                return false;
                            }
                            if (!(comp1 instanceof ContainerContainer) || !(comp2 instanceof ContainerContainer)) break block11;
                            if (((ContainerContainer)comp1).getOrientation() != ((ContainerContainer)comp2).getOrientation() || ((ContainerContainer)comp1).isProportionalLayout() != ((ContainerContainer)comp2).isProportionalLayout() || ((ContainerContainer)comp1).isInitiallyEven() != ((ContainerContainer)comp2).isInitiallyEven() || !JideSwingUtilities.equals(((ContainerContainer)comp1).getProportions(), ((ContainerContainer)comp1).getProportions(), true) || !JideSwingUtilities.equals(comp1.getPreferredSize(), comp2.getPreferredSize()) || ((ContainerContainer)comp1).getPaneCount() != ((ContainerContainer)comp2).getPaneCount()) {
                                return false;
                            }
                            for (int i = 0; i < ((ContainerContainer)comp1).getPaneCount(); ++i) {
                                if (DockingPersistenceUtils.compareComponent(((ContainerContainer)comp1).getPaneAt(i), ((ContainerContainer)comp2).getPaneAt(i), dockIDMap1, dockIDMap2)) continue;
                                return false;
                            }
                            String containerName = NODE_CONTAINER_CONTAINER + ((ContainerContainer)comp1).getDockID();
                            dockIDMap1.put(((ContainerContainer)comp1).getDockID(), containerName);
                            dockIDMap2.put(((ContainerContainer)comp2).getDockID(), containerName);
                            break block12;
                        }
                        if (!(comp1 instanceof FrameContainer) || !(comp2 instanceof FrameContainer)) break block13;
                        if (((FrameContainer)comp1).getSelectedIndex() != ((FrameContainer)comp2).getSelectedIndex() || !JideSwingUtilities.equals(comp1.getPreferredSize(), comp2.getPreferredSize()) || ((FrameContainer)comp1).getTabCount() != ((FrameContainer)comp2).getTabCount()) {
                            return false;
                        }
                        for (int i = 0; i < ((FrameContainer)comp1).getTabCount(); ++i) {
                            if (DockingPersistenceUtils.compareComponent(((FrameContainer)comp1).getComponentAt(i), ((FrameContainer)comp2).getComponentAt(i), dockIDMap1, dockIDMap2)) continue;
                            return false;
                        }
                        String containerName = NODE_FRAME_CONTAINER + ((FrameContainer)comp1).getDockID();
                        dockIDMap1.put(((FrameContainer)comp1).getDockID(), containerName);
                        dockIDMap2.put(((FrameContainer)comp2).getDockID(), containerName);
                        break block12;
                    }
                    if (!(comp1 instanceof DockableFrame) || !(comp2 instanceof DockableFrame)) break block14;
                    if (!JideSwingUtilities.equals(((DockableFrame)comp1).getKey(), ((DockableFrame)comp2).getKey())) {
                        return false;
                    }
                    break block12;
                }
                if (!(comp1 instanceof Workspace) || !(comp2 instanceof Workspace)) break block15;
                if (((Workspace)comp1).isAcceptDockableFrame() != ((Workspace)comp2).isAcceptDockableFrame() || ((Workspace)comp1).getComponentCount() != ((Workspace)comp2).getComponentCount()) {
                    return false;
                }
                for (int i = 0; i < ((Workspace)comp1).getComponentCount(); ++i) {
                    if (DockingPersistenceUtils.compareComponent(((Workspace)comp1).getComponent(i), ((Workspace)comp2).getComponent(i), dockIDMap1, dockIDMap2)) continue;
                    return false;
                }
                break block12;
            }
            if (!(comp1 instanceof FloatingContainer) || !(comp2 instanceof FloatingContainer)) break block12;
            if (!JideSwingUtilities.equals(comp1.getBounds(), comp2.getBounds()) || ((FloatingContainer)((Object)comp1)).getContentPane().getComponentCount() != ((FloatingContainer)((Object)comp2)).getContentPane().getComponentCount()) {
                return false;
            }
            for (int i = 0; i < ((FloatingContainer)((Object)comp1)).getContentPane().getComponentCount(); ++i) {
                if (DockingPersistenceUtils.compareComponent(((FloatingContainer)((Object)comp1)).getContentPane().getComponent(i), ((FloatingContainer)((Object)comp2)).getContentPane().getComponent(i), dockIDMap1, dockIDMap2)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean containsFrameKey(DockingManager manager, byte[] layoutData, String frameKey) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(layoutData);
        try {
            Node node;
            int index;
            NodeList list2;
            Document document = PersistenceUtils.getDocument(inputStream);
            Node component = document.getElementsByTagName("LayoutPersistence").item(0);
            Node dockableFrames = null;
            if (component != null) {
                list2 = component.getChildNodes();
                for (index = 0; index < list2.getLength(); ++index) {
                    node = list2.item(index);
                    if (!"DockingManager".equals(node.getNodeName())) continue;
                    String persistenceName = null;
                    NamedNodeMap attributes = node.getAttributes();
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        Node attribute = attributes.item(i);
                        if (!"persistenceName".equals(attribute.getNodeName())) continue;
                        persistenceName = attribute.getNodeValue();
                        break;
                    }
                    if (!JideSwingUtilities.equals(persistenceName, manager.getLayoutPersistenceName())) continue;
                    dockableFrames = node;
                    break;
                }
            }
            if (dockableFrames == null) {
                boolean list2 = false;
                return list2;
            }
            list2 = dockableFrames.getChildNodes();
            index = 0;
            while (index < list2.getLength()) {
                String key;
                node = list2.item(index);
                if (NODE_CONTEXT.equals(node.getNodeName()) && JideSwingUtilities.equals(key = DockingPersistenceUtils.readContext(document, manager, node, null, null), frameKey)) {
                    boolean bl = true;
                    return bl;
                }
                ++index;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException index) {}
        }
    }
}

