/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.converter.XmlUtils;
import com.jidesoft.docking.AutoHideContainer;
import com.jidesoft.docking.AutoHideMouseListener;
import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.ContainerContainerDivider;
import com.jidesoft.docking.DialogFloatingContainer;
import com.jidesoft.docking.DockContext;
import com.jidesoft.docking.DockID;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockableFrameFactory;
import com.jidesoft.docking.DockableHolder;
import com.jidesoft.docking.DockedFrameContainer;
import com.jidesoft.docking.DockingFrameworkContour;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.DockingManagerGroup;
import com.jidesoft.docking.DockingManagerUndoableEdit;
import com.jidesoft.docking.DockingPersistenceUtils;
import com.jidesoft.docking.DockingUtils;
import com.jidesoft.docking.FloatingContainer;
import com.jidesoft.docking.FloatingFrames;
import com.jidesoft.docking.FrameContainer;
import com.jidesoft.docking.FrameFloatingContainer;
import com.jidesoft.docking.HiddenFrames;
import com.jidesoft.docking.OutlineContour;
import com.jidesoft.docking.PopupMenuCustomizer;
import com.jidesoft.docking.PreviousState;
import com.jidesoft.docking.Refocusable;
import com.jidesoft.docking.Resource;
import com.jidesoft.docking.SaveUtils;
import com.jidesoft.docking.SlidingAnimator;
import com.jidesoft.docking.SlidingOverFrameContainer;
import com.jidesoft.docking.WindowFloatingContainer;
import com.jidesoft.docking.Workspace;
import com.jidesoft.docking.event.DockableFrameDropListener;
import com.jidesoft.docking.event.DockableFrameEvent;
import com.jidesoft.docking.event.DockableFrameListener;
import com.jidesoft.plaf.JideTabbedPaneUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicDockableFrameTitlePane;
import com.jidesoft.plaf.basic.BasicJideTabbedPaneUI;
import com.jidesoft.swing.AbstractLayoutPersistence;
import com.jidesoft.swing.DelegateAction;
import com.jidesoft.swing.HeavyweightWrapper;
import com.jidesoft.swing.JideBorderLayout;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.swing.LayoutPersistence;
import com.jidesoft.swing.PersistenceUtils;
import com.jidesoft.swing.ResizableDialog;
import com.jidesoft.swing.ResizableFrame;
import com.jidesoft.swing.ResizableWindow;
import com.jidesoft.swing.SidePaneGroup;
import com.jidesoft.swing.SidePaneItem;
import com.jidesoft.swing.SimpleScrollPane;
import com.jidesoft.swing.TopLevelMenuContainer;
import com.jidesoft.swing.UndoableSupport;
import com.jidesoft.swing.event.SidePaneEvent;
import com.jidesoft.swing.event.SidePaneListener;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JApplet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DefaultDockingManager
extends AbstractLayoutPersistence
implements DockingManager,
LayoutPersistence,
UndoableSupport {
    private static final Logger LOGGER;
    private static final Logger LOGGER_FOCUS;
    private static final Logger LOGGER_MOUSE_EVENTS;
    private static final Logger LOGGER_DROP_LISTENER;
    private static final String WORKSPACE_KEY = "#Workspace";
    private final Map<String, DockableFrame> _allFrames = new HashMap<String, DockableFrame>();
    private final List<String> _allFrameKeys = new ArrayList<String>();
    private final Map<String, DockContext> _allContexts = new HashMap<String, DockContext>();
    private Container _contentContainer;
    private RootPaneContainer _rootPaneContainer;
    private MainPanel _panelMain;
    private DockedHiddenSlidingContainer _dockedHiddenSlidingContainer;
    JPanel _dockedHiddenContainer;
    private SlidingOverFrameContainer _slidingContainer;
    private DockedFrameContainer _dockedFrameContainer;
    AutoHideContainer _eastContainer;
    AutoHideContainer _westContainer;
    AutoHideContainer _northContainer;
    AutoHideContainer _southContainer;
    private Workspace _workspace;
    private DockableFrame _activeFrame;
    FloatingFrames _floatingFrames;
    List<Component> _orderedFloatingFrames;
    private HiddenFrames _hiddenFrames;
    private DockableFrame _maximizedFrame;
    private int _maximizeFramePreviousState;
    private DockableFrame[] _maximizedOtherFloatingFrames;
    private int _initDelay = 250;
    private int _stepDelay = 20;
    private int _steps = 5;
    private int _gridSize = 1;
    private SlidingAnimator _slidingAnimator;
    private DockableFrame _startingAutohideShow;
    private DockingFrameworkContour _dragContour;
    private Vector<Container> _tempCs = new Vector();
    private Vector<ContainerContainer> _tempCCs = new Vector();
    private boolean _dragAllTabs = true;
    private boolean _autohideAllTabs = true;
    private boolean _hideAllTabs = false;
    private boolean _floatAllTabs = true;
    private boolean _maximizeAllTabs = true;
    private boolean _floatable = true;
    private boolean _autohidable = true;
    private boolean _hidable = true;
    private boolean _rearrangable = true;
    private boolean _resizable = true;
    private boolean _floatingFramesResizable = true;
    private boolean _dockedFramesResizable = true;
    private boolean _groupAllowedOnSidePane = true;
    private boolean _continuousLayout = false;
    private DockingManager.TabbedPaneCustomizer _tabbedPaneCustomizer;
    private PopupMenuCustomizer _popupMenuCustomizer;
    private boolean _showContextMenu = true;
    private boolean _realized = false;
    private static boolean _processingFocusEvent;
    private boolean _togglingWindowVisibility = false;
    protected PropertyChangeListener _focusPropertyChangeListener;
    private boolean _hasFocus = false;
    private boolean _active = false;
    private DockingManagerGroup _group = null;
    private Rectangle _initBounds = new Rectangle();
    private int _initState;
    private int _sensitiveAreaSize = 40;
    private int _outsideSensitiveAreaSize = 40;
    private int _outlineMode;
    private boolean _withinFrameBoundsOnDragging = false;
    private boolean _withinScreenBoundsOnDragging = false;
    private boolean _autohideShowingContentHidden = true;
    private boolean _hideFloatingFramesWhenDeactivate = false;
    private boolean _hideFloatingFramesOnSwitchOutOfApplication = false;
    private static final List<DockingManager> _dockingManagers;
    private static boolean _exclusive;
    private boolean _showFloatingFrames = true;
    private boolean _floatingFramesVisible = true;
    private Component _escapeKeyTargetComponent;
    private int _doubleClickAction = 0;
    private ChangeListener _changeListener = this.createChangeListener();
    private SidePaneListener _sidePaneListener = this.createSidePaneListener();
    private int _initSplitPriority = 1;
    private int[] _customInitSplitPriority = null;
    private int _initCenterSplit = 1;
    private int _initEastSplit = 0;
    private int _initNorthSplit = 1;
    private int _initWestSplit = 0;
    private int _initSouthSplit = 1;
    int _state;
    Rectangle _unmaximizedBounds = new Rectangle();
    public ComponentAdapter _componentListener;
    private WindowListener _windowListener;
    private WindowStateListener _windowStateListener;
    private boolean _showInitial = true;
    private boolean _showInitialInvoked = false;
    private KeyEventDispatcher _keyEventDispatcher;
    private static AWTEventListener _AWTEventListener;
    private static ChangeListener _listenerMenuChangeStateListener;
    private boolean _easyTabDock = false;
    private boolean _tabDockAllowed = true;
    private boolean _sideDockAllowed = true;
    private boolean _tabReorderAllowed = true;
    private boolean _nestedFloatingAllowed = true;
    private boolean _showGripper = false;
    private boolean _showDividerGripper = false;
    private boolean _dragGripperOnly = false;
    private boolean _showTitleBar = true;
    private boolean _showWorkspace = true;
    private boolean _isWorkspaceActive = false;
    private boolean _sidebarRollover = true;
    private boolean _autoDocking = true;
    private boolean _autoDockingAsDefault = true;
    private boolean _preserveStateOnDragging = false;
    private int _allowedDockSides = 31;
    private UndoManager _undoManager;
    private UndoableEditSupport _undoableEditSupport;
    private boolean _preserveAvailableProperty = true;
    private PropertyChangeListener _dockableFramePropertyChangeListener;
    private boolean _loadDataSuccessful = true;
    private boolean _useDecoratedFloatingContainer = false;
    private boolean _glassPaneVisibility;
    private List<DockingManager.FrameHandle> _zorderFrameHandles = new ArrayList<DockingManager.FrameHandle>();
    private boolean _skipActivateSelectedFrame = false;
    private DockableFrameListener _internalRoutingFrameListener;
    private WindowAdapter _floatingContainerWindowListener;
    private InternalEventManager _internalEventManager;
    private boolean _heavyweightComponentEnabled = false;
    private boolean _useGlassPaneEnabled = true;
    private boolean _crossDraggingAllowed = false;
    private boolean _crossDroppingAllowed = false;
    private boolean _hideNewlyAddedFrames = false;
    private Color _notificationBackground = Color.RED;
    private Color _notificationForeground = Color.WHITE;
    private int _notificationSteps = 20;
    private int _notificationDelay = 500;
    private boolean _showTitleOnOutline = false;
    private DelegateAction _escAction;
    private Point _startingPosition = new Point(60, 60);
    private int _floatingContainerType = 0;
    private DockingManager.FloatingContainerCustomizer _floatingContainerCustomizer = null;
    private boolean _autoActivateFocusOwner = true;
    private WeakReference<Component> _temporarilyFocusedComponent = null;
    private WeakHashMap<Component, List<MouseEvent>> _unsentMouseEvents = new WeakHashMap();
    private static List<DockingManager> _zorderDockingManagers;
    private EventListenerList listenerList = new EventListenerList();
    private ComponentAdapter _floatingContainerComponentListener;
    private String _frameToActivate;
    private int _priority;
    private int _unknownFrameBehaviorOnLoading = 0;
    private boolean _layoutSaveToXml = false;
    private int _floatingContainerCloseBehavior = 0;
    private Window _windowActive = null;
    private Point _startingPoint;
    private boolean ignoreFocus;
    private DockableFrameFactory _dockableFrameFactory;
    private static final String NODE_MANAGERS = "Managers";
    private static final String NODE_DOCKING_MANAGER = "DockingManager";
    private static final String NODE_DOCKABLE_FRAMES = "DockableFrames";
    private static final String NODE_DOCKABLE_FRAME = "DockableFrame";
    private static final String ATTRIBUTE_KEY = "key";
    private boolean _proportionalSplits;
    private MouseInputListener _mouseInputListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultDockingManager(RootPaneContainer rootPaneContainer, Container contentContainer) {
        this.switchRootPaneContainer(rootPaneContainer);
        Method method = null;
        try {
            method = contentContainer.getClass().getMethod("getContentPane", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (method != null) {
            try {
                Object contentPane = method.invoke((Object)contentContainer, new Object[0]);
                if (contentPane instanceof Container) {
                    ((Container)contentPane).removeAll();
                }
            }
            catch (Exception contentPane) {}
        } else {
            contentContainer.removeAll();
        }
        this._internalEventManager = new InternalEventManager();
        this._workspace = this.createWorkspace();
        this._workspace.setVisible(this.isShowWorkspace());
        if (this.isShowWorkspace()) {
            this.addToZOrder(this.getWorkspace());
            this.moveToFront(this.getWorkspace());
        }
        this.getWorkspace().setDockingManager(this);
        this.getWorkspace().setMinimumSize(new Dimension(40, 40));
        this._contentContainer = contentContainer;
        this._dockedFrameContainer = new DockedFrameContainer();
        this.getDockedFrameContainer().addComponentListener(this._componentListener);
        this.getContentContainer().setBackground(UIDefaultsLookup.getColor("ContentContainer.background"));
        this.getContentContainer().setLayout(new BorderLayout());
        this._dockedHiddenSlidingContainer = new DockedHiddenSlidingContainer();
        this._dockedHiddenContainer = new JPanel();
        this._dockedHiddenContainer.setName("DockedHiddenContainer");
        this._dockedHiddenContainer.setOpaque(false);
        this._dockedHiddenContainer.setLayout(new JideBorderLayout(UIDefaultsLookup.getInt("ContentContainer.hgap"), UIDefaultsLookup.getInt("ContentContainer.vgap")));
        ContainerContainer containerContainer = this.createContainerContainer();
        containerContainer.add(this._dockedFrameContainer);
        this._dockedHiddenContainer.add((Component)containerContainer, "Center");
        this._slidingContainer = new SlidingOverFrameContainer(this._dockedHiddenContainer);
        this._slidingContainer.setVisible(false);
        this._dockedHiddenSlidingContainer.add(this._slidingContainer);
        this._dockedHiddenSlidingContainer.add(this._dockedHiddenContainer);
        this._panelMain = new MainPanel();
        this._panelMain.setLayout(new BorderLayout());
        this._panelMain.setName("MainDockingContainer");
        this._panelMain.setFocusable(true);
        this._panelMain.setOpaque(false);
        this._panelMain.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                LOGGER_FOCUS.fine(DefaultDockingManager.this.getProfileKey() + ":_panelMain focusGained");
                DefaultDockingManager.this._hasFocus = true;
                if (DefaultDockingManager.this._unsentMouseEvents.size() == 0) {
                    DefaultDockingManager.this.reFocusActiveFrame(false);
                }
            }
        });
        this.getContentContainer().add((Component)this._panelMain, "Center");
        this._panelMain.add((Component)this._dockedHiddenSlidingContainer, "Center");
        this.addFocusOwnerChangeListener();
        this._escAction = new DelegateAction(){

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public boolean delegateActionPerformed(ActionEvent e) {
                DefaultDockingManager.this.internalHandleEscapeKey(e);
                return false;
            }
        };
        DelegateAction.replaceAction(this.getMainContainer(), 1, KeyStroke.getKeyStroke(27, 0), this._escAction);
        this.setRealized(false);
        this.setUndoLimit(0);
        this.setOutlineMode(SystemInfo.isJdk6Above() ? 2 : 0);
        List<DockingManager> list = _dockingManagers;
        synchronized (list) {
            _dockingManagers.add(this);
            if (_dockingManagers.size() == 1) {
                DefaultDockingManager.addMouseEventHandler();
                _listenerMenuChangeStateListener = new MenuChangeStateListener();
                MenuSelectionManager.defaultManager().addChangeListener(_listenerMenuChangeStateListener);
            }
        }
        this._dockableFramePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (DefaultDockingManager.ATTRIBUTE_KEY.equals(evt.getPropertyName())) {
                    DefaultDockingManager.this.updateKey((String)evt.getOldValue(), (String)evt.getNewValue());
                } else if ("transient".equals(evt.getPropertyName())) {
                    DockableFrame frame = (DockableFrame)evt.getSource();
                    if (Boolean.TRUE.equals(evt.getNewValue())) {
                        DefaultDockingManager.this.removeContext(frame.getKey());
                    } else {
                        DefaultDockingManager.this.addContext(frame.getKey(), frame.getContext());
                    }
                }
            }
        };
        this.setPriority(-1);
    }

    @Override
    public void switchRootPaneContainer(RootPaneContainer rootContainer) {
        if (this._rootPaneContainer instanceof Component) {
            ((Component)((Object)this._rootPaneContainer)).removeComponentListener(this._componentListener);
        }
        if (this._rootPaneContainer instanceof Window) {
            ((Window)((Object)this._rootPaneContainer)).removeWindowListener(this._windowListener);
            ((Window)((Object)this._rootPaneContainer)).removeWindowStateListener(this._windowStateListener);
            ((Window)((Object)this._rootPaneContainer)).removeWindowListener(this.getFloatingContainerWindowListener());
            if (this._orderedFloatingFrames != null) {
                Component comp = (Component)((Object)this._rootPaneContainer);
                this._orderedFloatingFrames.remove(comp);
            }
        }
        this._rootPaneContainer = rootContainer;
        RootPaneContainer rootPaneContainer = this.getRootPaneContainer();
        if (rootPaneContainer instanceof JApplet) {
            this.setFloatable(false);
        }
        if (rootPaneContainer instanceof Component) {
            this._componentListener = new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent e) {
                    this.getWindowGeometry(e);
                    this.clearUp();
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                    this.clearUp();
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    DefaultDockingManager.this.internalSetFloatingFramesVisible(true);
                }

                @Override
                public void componentResized(ComponentEvent e) {
                    this.getWindowGeometry(e);
                    this.clearUp();
                }

                private void clearUp() {
                    if (DefaultDockingManager.this.isDragging()) {
                        DefaultDockingManager.this.cancelDragging();
                    }
                }

                private void getWindowGeometry(ComponentEvent e) {
                    if (e.getComponent() instanceof Frame) {
                        Frame frame = (Frame)e.getComponent();
                        if (PortingUtils.getFrameState(frame) != 6) {
                            DefaultDockingManager.this._unmaximizedBounds.x = frame.getX();
                            DefaultDockingManager.this._unmaximizedBounds.y = frame.getY();
                            DefaultDockingManager.this._unmaximizedBounds.width = frame.getWidth();
                            DefaultDockingManager.this._unmaximizedBounds.height = frame.getHeight();
                        }
                    } else if (e.getComponent() instanceof Window) {
                        Window window = (Window)e.getComponent();
                        DefaultDockingManager.this._unmaximizedBounds.x = window.getX();
                        DefaultDockingManager.this._unmaximizedBounds.y = window.getY();
                        DefaultDockingManager.this._unmaximizedBounds.width = window.getWidth();
                        DefaultDockingManager.this._unmaximizedBounds.height = window.getHeight();
                    }
                }
            };
            ((Component)((Object)rootPaneContainer)).addComponentListener(this._componentListener);
        }
        if (rootPaneContainer instanceof Window) {
            ((Window)((Object)this._rootPaneContainer)).removeWindowListener(this.getFloatingContainerWindowListener());
            ((Window)((Object)this._rootPaneContainer)).addWindowListener(this.getFloatingContainerWindowListener());
            if (this._orderedFloatingFrames != null) {
                Component comp = (Component)((Object)this._rootPaneContainer);
                this._orderedFloatingFrames.add(comp);
            }
            this._windowStateListener = new WindowStateListener(){

                @Override
                public void windowStateChanged(WindowEvent e) {
                    String frame = DefaultDockingManager.this.getAutohideShowingFrame();
                    if (frame != null) {
                        DefaultDockingManager.this.stopShowingAutohideFrameImmediately();
                    }
                }
            };
            this._windowListener = new WindowAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void windowActivated(WindowEvent event) {
                    if (event.getOppositeWindow() instanceof FloatingContainer) {
                        return;
                    }
                    DefaultDockingManager.this._togglingWindowVisibility = true;
                    if (DefaultDockingManager.isExclusive()) {
                        List list = _dockingManagers;
                        synchronized (list) {
                            DockingManager[] dockMgrs;
                            for (DockingManager dockMgr : dockMgrs = _dockingManagers.toArray(new DockingManager[_dockingManagers.size()])) {
                                if (!(dockMgr instanceof DefaultDockingManager) || dockMgr == DefaultDockingManager.this || !DefaultDockingManager.this.isHideFloatingFramesWhenDeactivate()) continue;
                                ((DefaultDockingManager)dockMgr).internalSetFloatingFramesVisible(false);
                            }
                        }
                    }
                    if (DefaultDockingManager.this.isHideFloatingFramesWhenDeactivate()) {
                        DefaultDockingManager.this.internalSetFloatingFramesVisible(true);
                    }
                    DefaultDockingManager.this._togglingWindowVisibility = false;
                }

                @Override
                public void windowDeactivated(WindowEvent event) {
                    Window opposite = event.getOppositeWindow();
                    DefaultDockingManager.this._togglingWindowVisibility = true;
                    boolean hideFloatingFrames = false;
                    if (opposite == null) {
                        if (DefaultDockingManager.this.isDragging()) {
                            DefaultDockingManager.this.cancelDragging();
                        }
                        if (DefaultDockingManager.this.isHideFloatingFramesOnSwitchOutOfApplication()) {
                            hideFloatingFrames = true;
                        }
                    } else if (!(DefaultDockingManager.this.isOwnedWindow(opposite) || DefaultDockingManager.this.isOwnedFloatingFrame(opposite) || DefaultDockingManager.this.isModalDialog(opposite))) {
                        if (DefaultDockingManager.this.isDragging()) {
                            DefaultDockingManager.this.cancelDragging();
                        }
                        hideFloatingFrames = true;
                    }
                    if (hideFloatingFrames && DefaultDockingManager.this.isHideFloatingFramesWhenDeactivate()) {
                        DefaultDockingManager.this.internalSetFloatingFramesVisible(false);
                    }
                    DefaultDockingManager.this._togglingWindowVisibility = false;
                }
            };
            ((Window)((Object)rootPaneContainer)).removeWindowListener(this._windowListener);
            ((Window)((Object)rootPaneContainer)).addWindowListener(this._windowListener);
            ((Window)((Object)rootPaneContainer)).removeWindowStateListener(this._windowStateListener);
            ((Window)((Object)rootPaneContainer)).addWindowStateListener(this._windowStateListener);
        }
    }

    @Override
    public void setFloatingFramesVisible(boolean show) {
        this._showFloatingFrames = show;
        this.internalSetFloatingFramesVisible(show);
    }

    private void internalSetFloatingFramesVisible(boolean show) {
        if (this._floatingFrames == null) {
            return;
        }
        this._togglingWindowVisibility = true;
        this._floatingFramesVisible = show;
        for (int i = this._floatingFrames.size() - 1; i >= 0; --i) {
            FloatingContainer floatingContainer = (FloatingContainer)this._floatingFrames.get(i);
            if (this._showFloatingFrames && show) {
                floatingContainer.setVisible(show);
                continue;
            }
            floatingContainer.setVisible(false);
        }
        this._togglingWindowVisibility = false;
    }

    protected boolean isModalDialog(Window window) {
        return window instanceof Dialog && !(window instanceof FloatingContainer) && ((Dialog)window).isModal();
    }

    protected boolean isOwnedFloatingFrame(Window window) {
        return this._floatingFrames != null && this._floatingFrames.size() != 0 && window != null && this._floatingFrames.contains(window);
    }

    private static boolean isAncestorOf(Container container, Object ancestor) {
        for (Container p = container; p != null; p = p.getParent()) {
            if (p != ancestor) continue;
            return true;
        }
        return false;
    }

    protected boolean isOwnedWindow(Window window) {
        RootPaneContainer rootPaneContainer = this.getRootPaneContainer();
        return window != null && rootPaneContainer instanceof Container && ((Container)((Object)rootPaneContainer)).isAncestorOf(window);
    }

    protected void internalFloatingFrameDeactivated(WindowEvent event) {
        boolean deactivate = false;
        if (event == null) {
            deactivate = true;
        } else if (event.getOppositeWindow() == null) {
            if (this.isHideFloatingFramesOnSwitchOutOfApplication()) {
                deactivate = true;
            }
        } else if (event.getOppositeWindow() != this.getRootPaneContainer() && !this.isOwnedWindow(event.getOppositeWindow()) && !this.isOwnedFloatingFrame(event.getOppositeWindow())) {
            deactivate = true;
        }
        if (deactivate && this.isHideFloatingFramesWhenDeactivate()) {
            this.internalSetFloatingFramesVisible(false);
        }
    }

    public void internalFloatingFrameActivated(WindowEvent windowEvent) {
    }

    @Override
    public FloatingContainer findFloatingComponentAt(int x, int y) {
        for (Component container : this._orderedFloatingFrames) {
            Rectangle bounds;
            FloatingContainer floatingFrame;
            if (!(container instanceof FloatingContainer) || DockingUtils.isFloatingContainerNotDockable(floatingFrame = (FloatingContainer)((Object)container)) || !(bounds = floatingFrame.getBounds()).contains(x, y)) continue;
            Point p = new Point(x, y);
            SwingUtilities.convertPointFromScreen(p, container);
            Component c = floatingFrame.getContentPane().findComponentAt(p.x, p.y);
            DockingManager dockingManager = DockingUtils.getDockingManager(DockingUtils.getContainContainer(c));
            if (dockingManager != this) continue;
            return floatingFrame;
        }
        return null;
    }

    private void addGlobalEventHandler() {
        try {
            this._keyEventDispatcher = new KeyEventDispatcher(){

                @Override
                public boolean dispatchKeyEvent(KeyEvent e) {
                    DefaultDockingManager.this.handleKeyEvent(e);
                    return false;
                }
            };
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this._keyEventDispatcher);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static void addMouseEventHandler() {
        if (DefaultDockingManager.shouldAWTEventListenerBeUsed()) {
            return;
        }
        if (_AWTEventListener == null) {
            _AWTEventListener = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    MouseInputListener listener;
                    DockingManager currentDockingManager = DockingUtils.getDockingManager(event, false);
                    if (SystemInfo.isMacOSX() && SystemInfo.isJdk7Above() && !SystemInfo.isJdk8Above() && event.getID() == 502 && currentDockingManager != null && currentDockingManager.isDragging() && (listener = currentDockingManager.getActiveMouseInputListener()) != null) {
                        listener.mouseReleased((MouseEvent)event);
                    }
                    ArrayList<DockingManager> dockingManagers = new ArrayList<DockingManager>();
                    if (currentDockingManager != null) {
                        for (DockingManager manager : _dockingManagers) {
                            if (manager == currentDockingManager) {
                                dockingManagers.add(manager);
                                continue;
                            }
                            if (DockingUtils.isDockingManagerAncestor(currentDockingManager.getMainContainer(), manager)) {
                                dockingManagers.add(manager);
                                continue;
                            }
                            if (!DockingUtils.isDockingManagerAncestor(manager.getMainContainer(), currentDockingManager)) continue;
                            dockingManagers.add(manager);
                        }
                    }
                    if (dockingManagers.size() != 0) {
                        DockingManager[] dockMgrs;
                        if (event.getID() == 1004) {
                            Collections.sort(dockingManagers, new Comparator<DockingManager>(){

                                @Override
                                public int compare(DockingManager o1, DockingManager o2) {
                                    if (DockingUtils.isDockingManagerAncestor(o1.getMainContainer(), o2)) {
                                        return 1;
                                    }
                                    if (DockingUtils.isDockingManagerAncestor(o2.getMainContainer(), o1)) {
                                        return -1;
                                    }
                                    return 0;
                                }
                            });
                        } else if (event.getID() == 501) {
                            Collections.sort(dockingManagers, new Comparator<DockingManager>(){

                                @Override
                                public int compare(DockingManager o1, DockingManager o2) {
                                    if (DockingUtils.isDockingManagerAncestor(o1.getMainContainer(), o2)) {
                                        return -1;
                                    }
                                    if (DockingUtils.isDockingManagerAncestor(o2.getMainContainer(), o1)) {
                                        return 1;
                                    }
                                    return 0;
                                }
                            });
                        }
                        if (event.getID() == 501 || event.getID() == 502 || event.getID() == 500 || event.getID() == 1004) {
                            LOGGER_MOUSE_EVENTS.fine("GlobalDockingManagerEventHandler: detected event:" + event);
                        }
                        boolean shouldConsumeEvent = false;
                        for (DockingManager dockingManager : dockMgrs = dockingManagers.toArray(new DockingManager[dockingManagers.size()])) {
                            boolean wantsConsume = dockingManager.handleEvent(event);
                            if (!wantsConsume) continue;
                            shouldConsumeEvent = true;
                        }
                        if (shouldConsumeEvent && event instanceof MouseEvent) {
                            LOGGER_MOUSE_EVENTS.fine("GlobalDockingManagerEventHandler: consuming event:" + event);
                            ((MouseEvent)event).consume();
                        }
                    }
                }
            };
            try {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        Toolkit.getDefaultToolkit().addAWTEventListener(_AWTEventListener, 524340L);
                        return null;
                    }
                });
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static boolean shouldAWTEventListenerBeUsed() {
        return SecurityUtils.isAWTEventListenerDisabled() || "true".equals(SecurityUtils.getProperty("jide.disableAWTEventListener", "false"));
    }

    private void removeGlobalEventHandler() {
        try {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this._keyEventDispatcher);
            this._keyEventDispatcher = null;
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static void removeMouseEventHandler() {
        if (DefaultDockingManager.shouldAWTEventListenerBeUsed()) {
            return;
        }
        if (_AWTEventListener != null) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        if (_AWTEventListener != null) {
                            Toolkit.getDefaultToolkit().removeAWTEventListener(_AWTEventListener);
                        }
                        _AWTEventListener = null;
                        return null;
                    }
                });
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    @Deprecated
    public boolean isAutoActivateFocusOwner() {
        return this._autoActivateFocusOwner;
    }

    @Override
    @Deprecated
    public void setAutoActivateFocusOwner(boolean autoActivateFocusOwner) {
        this._autoActivateFocusOwner = autoActivateFocusOwner;
    }

    @Override
    public boolean handleEvent(AWTEvent event) {
        if (event.getSource() instanceof ContainerContainerDivider) {
            return false;
        }
        if (event.getSource() instanceof AutoHideContainer && !(event instanceof MouseEvent)) {
            return false;
        }
        if (this.getContentContainer() instanceof JComponent && ((JComponent)this.getContentContainer()).getTopLevelAncestor() instanceof Window && !((Window)((JComponent)this.getContentContainer()).getTopLevelAncestor()).getFocusableWindowState()) {
            return false;
        }
        if (this._togglingWindowVisibility) {
            return false;
        }
        if (event.getID() == 1004) {
            FocusEvent fe = (FocusEvent)event;
            if (fe.getComponent() instanceof DockedHiddenSlidingContainer) {
                return false;
            }
            if (fe.getComponent() instanceof Window && this._hasFocus) {
                DockableFrame frame = this.getFrame(this.getActiveFrameKey());
                if (frame != null && SwingUtilities.isDescendingFrom(frame, fe.getComponent()) || !(fe.getComponent() instanceof FloatingContainer) || ((FloatingContainer)((Object)fe.getComponent())).getDockingManager() == this) {
                    // empty if block
                }
                return false;
            }
            if (fe.getComponent() instanceof JRootPane && SwingUtilities.getWindowAncestor(fe.getComponent()) == SwingUtilities.getWindowAncestor(this.getMainContainer()) && this._hasFocus) {
                if (LOGGER_FOCUS.isLoggable(Level.FINE)) {
                    LOGGER_FOCUS.fine(this.getProfileKey() + ":_temporarilyFocusedComponent=" + this._temporarilyFocusedComponent);
                }
                this._temporarilyFocusedComponent = new WeakReference<Component>(fe.getOppositeComponent());
                return false;
            }
            if (this._temporarilyFocusedComponent != null && this._temporarilyFocusedComponent.get() == fe.getComponent()) {
                DockableFrameWorkspaceHandle handleFound;
                DockableFrameWorkspaceHandle dockableFrameWorkspaceHandle = handleFound = this._zorderFrameHandles == null || this._zorderFrameHandles.size() == 0 ? null : (DockableFrameWorkspaceHandle)this._zorderFrameHandles.get(0);
                if (handleFound != null && fe.getComponent() != null && !SwingUtilities.isDescendingFrom(fe.getComponent(), (Component)handleFound.untyped)) {
                    this.reFocusActiveFrame(((FocusEvent)event).getOppositeComponent() == this.getRootPaneContainer().getRootPane());
                }
                this._temporarilyFocusedComponent = null;
                if (LOGGER_FOCUS.isLoggable(Level.FINE)) {
                    LOGGER_FOCUS.fine(this.getProfileKey() + ":_temporarilyFocusedComponent cleared.");
                }
                return false;
            }
            Component comp = this.getEventSource(event, true, false);
            if (this._unsentMouseEvents.size() > 0 && !this._unsentMouseEvents.containsKey(comp)) {
                return false;
            }
            if (LOGGER_FOCUS.isLoggable(Level.FINE)) {
                LOGGER_FOCUS.fine(this.getProfileKey() + ":handleEvent:responding to FOCUS_GAINED=" + comp);
            }
            boolean oldProcessingFocusEvent = _processingFocusEvent;
            _processingFocusEvent = true;
            if (comp instanceof DockableFrame) {
                if (LOGGER_FOCUS.isLoggable(Level.FINE)) {
                    LOGGER_FOCUS.fine(this.getProfileKey() + ":handleEvent:responding to FOCUS_GAINED activateFrame : " + ((DockableFrame)comp).getTabTitle());
                }
                if (!((DockableFrame)comp).isActive() && JideSwingUtilities.passesFocusabilityTest(comp) && !this.isAutohideShowingInProgress()) {
                    this.activateFrame(((DockableFrame)comp).getKey());
                }
            } else if (comp instanceof Workspace && !this.isWorkspaceActive() && JideSwingUtilities.passesFocusabilityTest(comp) && !this.isAutohideShowingInProgress()) {
                this.setWorkspaceActive(true);
            }
            _processingFocusEvent = oldProcessingFocusEvent;
            if (LOGGER_MOUSE_EVENTS.isLoggable(Level.FINE) && this._unsentMouseEvents.size() > 0) {
                LOGGER_MOUSE_EVENTS.fine(this.getProfileKey() + ":handleEvent: dequeuing " + this._unsentMouseEvents.size() + " mouseevents for " + comp);
            }
            DockingUtils.dequeueMouseEvents(this._unsentMouseEvents, comp);
        } else if (event.getID() == 501 || event.getID() == 500 || event.getID() == 502) {
            DockableFrameWorkspaceHandle handleFound;
            FrameContainer frameContainer;
            int index;
            if (LOGGER_MOUSE_EVENTS.isLoggable(Level.FINE)) {
                LOGGER_MOUSE_EVENTS.fine(this.getProfileKey() + ":handleEvent: about to process " + event);
            }
            if (event.getID() == 501 && !SwingUtilities.isLeftMouseButton((MouseEvent)event) && this.isDragging()) {
                if (this.isDragging()) {
                    this.cancelDragging();
                }
                if (LOGGER_MOUSE_EVENTS.isLoggable(Level.FINE)) {
                    LOGGER_MOUSE_EVENTS.fine(this.getProfileKey() + ":handleEvent: consuming event due to drag " + event);
                }
                ((MouseEvent)event).consume();
                return false;
            }
            if (!this.shouldSwitchFocus(event)) {
                return false;
            }
            Component comp = this.getEventSource(event, true, true);
            if (comp instanceof DockableFrame && comp.getParent() instanceof FrameContainer && (index = (frameContainer = (FrameContainer)comp.getParent()).indexOfComponent(comp)) >= 0 && index < frameContainer.getTabCount() && !frameContainer.isEnabledAt(index)) {
                return false;
            }
            if (LOGGER_MOUSE_EVENTS.isLoggable(Level.FINE)) {
                LOGGER_MOUSE_EVENTS.fine(this.getProfileKey() + ":handleEvent: component to process " + comp);
            }
            if (this._slidingAnimator != null && (comp instanceof DockableFrame || comp instanceof Workspace) && comp != this._slidingAnimator.getSlidingFrame() && event instanceof MouseEvent) {
                DefaultDockingManager.hidePopupMenuIfNecessary((MouseEvent)event);
            }
            DockableFrameWorkspaceHandle dockableFrameWorkspaceHandle = handleFound = this._zorderFrameHandles == null || this._zorderFrameHandles.size() == 0 ? null : (DockableFrameWorkspaceHandle)this._zorderFrameHandles.get(0);
            if (handleFound == null || comp == null) {
                if (LOGGER_MOUSE_EVENTS.isLoggable(Level.FINE)) {
                    LOGGER_MOUSE_EVENTS.fine(this.getProfileKey() + ":handleEvent: no handle found for " + comp);
                }
                this.getEventSource(event, true, false);
                return false;
            }
            Container parent = comp.getParent();
            boolean needQueueEvent = true;
            if (event.getID() == 501 && comp instanceof DockableFrame && parent instanceof FrameContainer && ((FrameContainer)parent).getSelectedFrame() != comp && ((FrameContainer)parent).indexOfComponent(comp) >= 0) {
                needQueueEvent = false;
            }
            this._hasFocus = true;
            if (handleFound.untyped != comp || comp instanceof DockableFrame && !((DockableFrame)comp).isActive() || comp instanceof Workspace && !this.isWorkspaceActive()) {
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (needQueueEvent && (focusOwner == null || !SwingUtilities.isDescendingFrom(focusOwner, comp))) {
                    boolean success;
                    String focusWorkaround;
                    if (event.getSource() instanceof AutoHideContainer) {
                        if (LOGGER_MOUSE_EVENTS.isLoggable(Level.FINE)) {
                            LOGGER_MOUSE_EVENTS.fine(this.getProfileKey() + ":handleEvent: doing nothing because source is an AutoHideContainer");
                        }
                        return false;
                    }
                    List<MouseEvent> eventsOriginal = this._unsentMouseEvents.get(comp);
                    if (eventsOriginal == null) {
                        eventsOriginal = new LinkedList<MouseEvent>();
                        this._unsentMouseEvents.put(comp, eventsOriginal);
                    }
                    eventsOriginal.add((MouseEvent)event);
                    if (LOGGER_MOUSE_EVENTS.isLoggable(Level.FINE)) {
                        LOGGER_MOUSE_EVENTS.fine(this.getProfileKey() + ":handleEvent: queuing " + this._unsentMouseEvents.size() + " until focusgained :" + event);
                    }
                    if ("true".equals(focusWorkaround = SecurityUtils.getProperty("docking.focusWorkaround1", "false"))) {
                        comp.requestFocus();
                    }
                    if (!(success = ((Refocusable)((Object)comp)).requestFocusInInternalWindow()) && !JideSwingUtilities.passesFocusabilityTest(comp)) {
                        if (LOGGER_MOUSE_EVENTS.isLoggable(Level.FINE)) {
                            LOGGER_MOUSE_EVENTS.fine(this.getProfileKey() + ":handleEvent: removing event from queue because no focusable component was found for " + comp);
                        }
                        MouseEvent mouseEvent = (MouseEvent)event;
                        eventsOriginal.remove(mouseEvent);
                        if (eventsOriginal.size() == 0) {
                            this._unsentMouseEvents.remove(comp);
                        }
                        return false;
                    }
                    return true;
                }
            } else {
                List<MouseEvent> eventsOriginal = this._unsentMouseEvents.get(comp);
                if (eventsOriginal != null && eventsOriginal.size() > 0) {
                    eventsOriginal.add((MouseEvent)event);
                    if (LOGGER_MOUSE_EVENTS.isLoggable(Level.FINE)) {
                        LOGGER_MOUSE_EVENTS.fine(this.getProfileKey() + ":handleEvent " + event + " was received while waiting on a focus event!");
                        for (MouseEvent mouseEvent : eventsOriginal) {
                            LOGGER_MOUSE_EVENTS.fine(this.getProfileKey() + ":handleEvent : reordered mouseEvent : " + mouseEvent);
                        }
                    }
                    DockingUtils.dequeueMouseEvents(this._unsentMouseEvents, comp);
                    return true;
                }
            }
        } else if (!(event.getID() != 503 && event.getID() != 506 || this.getAutohideShowingFrame() == null || event.getSource() instanceof ContainerContainerDivider || this._slidingAnimator == null)) {
            Component comp = this.getEventSource(event, true, false);
            if (comp instanceof DockableFrame && comp == this._slidingAnimator.getSlidingFrame()) {
                this.startShowingAutohideFrame(this._slidingAnimator.getSlidingFrame().getKey(), this._slidingAnimator.getSlidingFrame().getContext().getCurrentDockSide(), this.getInitDelay());
            } else if (comp != this._slidingAnimator.getSlidingFrame() && !this._slidingAnimator.getSlidingFrame().isActive()) {
                this.stopShowingAutohideFrame((int)((double)this.getInitDelay() * 1.5), false);
            } else if (event.getID() == 506 && !this._slidingAnimator.getSlidingFrame().contains(((MouseEvent)event).getPoint()) && this._slidingAnimator.getSlidingFrame().isAutohideWhenActive()) {
                this.stopShowingAutohideFrame((int)((double)this.getInitDelay() * 1.5), false);
            }
        }
        return false;
    }

    protected boolean shouldSwitchFocus(AWTEvent event) {
        if (event == null) {
            return false;
        }
        if (event.getID() == 502) {
            return false;
        }
        if (!(event.getID() != 501 && event.getID() != 500 || SwingUtilities.isLeftMouseButton((MouseEvent)event))) {
            return false;
        }
        return this.shouldSwitchFocus(event.getSource());
    }

    protected boolean shouldSwitchFocus(Object component) {
        return !(component instanceof JideTabbedPane.NoFocusButton) || ((JideTabbedPane.NoFocusButton)component).getType() != 0;
    }

    protected Component getEventSource(AWTEvent event, boolean includeFrameControls, boolean first) {
        return DockingUtils.getSource(this, event, includeFrameControls, first);
    }

    private void addFocusOwnerChangeListener() {
        if (this._focusPropertyChangeListener == null) {
            this._focusPropertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!evt.getPropertyName().equals("permanentFocusOwner") || KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner() == null || KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner() instanceof JRootPane) {
                        return;
                    }
                    if (evt.getNewValue() instanceof Component) {
                        Component component = (Component)evt.getNewValue();
                        if (component == null) {
                            return;
                        }
                        boolean changed = false;
                        if (null != DockingUtils.getManagedDockableHolder(DefaultDockingManager.this, MainPanel.class, component)) {
                            if (!DefaultDockingManager.this._hasFocus || DefaultDockingManager.this.getGroup() != null && !DefaultDockingManager.this.getGroup().isSelected(DefaultDockingManager.this)) {
                                DefaultDockingManager.this._hasFocus = true;
                                changed = true;
                            }
                        } else if (null != DockingUtils.getManagedDockableHolder(DefaultDockingManager.this, FloatingContainer.class, component)) {
                            if (!DefaultDockingManager.this._hasFocus || DefaultDockingManager.this.getGroup() != null && !DefaultDockingManager.this.getGroup().isSelected(DefaultDockingManager.this)) {
                                DefaultDockingManager.this._hasFocus = true;
                                changed = true;
                            }
                        } else if (SwingUtilities.getWindowAncestor(component) == SwingUtilities.getWindowAncestor(DefaultDockingManager.this.getMainContainer()) && DefaultDockingManager.this._hasFocus) {
                            DefaultDockingManager.this._hasFocus = false;
                            changed = true;
                        }
                        if (changed && DefaultDockingManager.this._hasFocus) {
                            boolean oldProcessingFocusEvent = _processingFocusEvent;
                            _processingFocusEvent = true;
                            DefaultDockingManager.this.setActive(true);
                            _processingFocusEvent = oldProcessingFocusEvent;
                            _zorderDockingManagers.remove(DefaultDockingManager.this);
                            _zorderDockingManagers.add(0, DefaultDockingManager.this);
                        }
                    }
                }
            };
            DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this._focusPropertyChangeListener);
        }
    }

    private void removeFocusOwnerChangeListener() {
        if (this._focusPropertyChangeListener != null) {
            DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this._focusPropertyChangeListener);
            this._focusPropertyChangeListener = null;
        }
    }

    protected boolean isDockingManagerFocused() {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        Component frameOrWorkspace = DockingUtils.getDockableFrameOrWorkspace(focusOwner);
        return frameOrWorkspace instanceof DockableFrame ? ((DockableFrame)frameOrWorkspace).getDockingManager() == this : frameOrWorkspace instanceof Workspace && ((Workspace)frameOrWorkspace).getDockingManager() == this;
    }

    private static Component hidePopupMenuIfNecessary(MouseEvent event) {
        MenuElement[] selectedPath = MenuSelectionManager.defaultManager().getSelectedPath();
        if (!(selectedPath == null || selectedPath.length <= 0 || event.getSource() instanceof JComboBox || event.getSource() instanceof Component && ((Component)event.getSource()).getParent() instanceof JComboBox || event.getSource() instanceof Component && ((Component)event.getSource()).getParent() instanceof TopLevelMenuContainer || event.getSource() instanceof JMenu || DockingUtils.isInPopup(event.getComponent()))) {
            Component invoker = null;
            if (selectedPath[0] instanceof JPopupMenu) {
                invoker = ((JPopupMenu)selectedPath[0]).getInvoker();
            }
            MenuSelectionManager.defaultManager().clearSelectedPath();
            return invoker;
        }
        return null;
    }

    private void handleKeyEvent(AWTEvent event) {
        if (event instanceof KeyEvent) {
            if (((KeyEvent)event).getKeyCode() == 27) {
                if (this.isDragging()) {
                    this.cancelDragging();
                } else {
                    this.internalHandleEscapeKey(event);
                }
            } else if (event.getID() == 401 && ((KeyEvent)event).getKeyCode() == 17) {
                this.enableDraggingFrameDocking(!this.isAutoDockingAsDefault());
            } else if (event.getID() == 402 && ((KeyEvent)event).getKeyCode() == 17) {
                this.enableDraggingFrameDocking(this.isAutoDockingAsDefault());
            }
        }
    }

    public void internalHandleEscapeKey(AWTEvent event) {
        Component escapeTarget;
        MenuElement[] selectedPath = MenuSelectionManager.defaultManager().getSelectedPath();
        if (selectedPath != null && selectedPath.length > 0) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
            return;
        }
        if (this.getAutohideShowingFrame() != null) {
            this.stopShowingAutohideFrame(0, true);
            return;
        }
        if (this.getInternalMaximizedFrame() != null) {
            this.restoreFrame();
            return;
        }
        Component comp = PortingUtils.getCurrentFocusComponent(event);
        DockableFrame dockableFrame = comp instanceof DockableFrame ? (DockableFrame)comp : (DockableFrame)SwingUtilities.getAncestorOfClass(DockableFrame.class, comp);
        if (dockableFrame == null || dockableFrame.getDockingManager() != this) {
            return;
        }
        int escapeBehavior = dockableFrame.getDefaultEscapeAction();
        if (escapeBehavior == 2) {
            if (!dockableFrame.isHidden() && !dockableFrame.shouldVetoHiding()) {
                this.addUndo(this.getResourceString("Undo.hide"));
                this.hideFrame(dockableFrame.getKey());
            }
        } else if (escapeBehavior == 3) {
            if (this.getFrame(dockableFrame.getKey()) != null && !dockableFrame.shouldVetoRemoving()) {
                this.removeFrame(dockableFrame.getKey());
            }
        } else if (!(escapeBehavior != 0 || (escapeTarget = this.getEscapeKeyTargetComponent()) == null || comp != null && SwingUtilities.isDescendingFrom(comp, escapeTarget))) {
            if (escapeTarget instanceof Refocusable) {
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
                if (focusOwner != null && !SwingUtilities.isDescendingFrom(focusOwner, escapeTarget)) {
                    ((Refocusable)((Object)escapeTarget)).requestFocusInInternalWindow();
                }
            } else {
                JideSwingUtilities.compositeRequestFocus(escapeTarget);
            }
        }
    }

    @Override
    public String getResourceString(String key) {
        return Resource.getResourceBundle(Locale.getDefault()).getString(key);
    }

    protected void loadDataErrorHandler() {
        this.resetToDefault();
    }

    @Override
    public void resetToDefault() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalResetToDefault();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockingManager.this.internalResetToDefault();
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    protected SimpleScrollPane createScrollPaneForAutoHideContainer(AutoHideContainer autoHideContainer) {
        switch (autoHideContainer.getAttachedSide()) {
            case 3: 
            case 7: {
                SimpleScrollPane simpleScrollPane = new SimpleScrollPane(autoHideContainer, 20, 31);
                simpleScrollPane.setOpaque(false);
                simpleScrollPane.getViewport().setOpaque(false);
                simpleScrollPane.setBorder(BorderFactory.createEmptyBorder());
                return simpleScrollPane;
            }
            case 1: 
            case 5: {
                SimpleScrollPane simpleScrollPane = new SimpleScrollPane(autoHideContainer, 21, 30);
                simpleScrollPane.setOpaque(false);
                simpleScrollPane.getViewport().setOpaque(false);
                simpleScrollPane.setBorder(BorderFactory.createEmptyBorder());
                return simpleScrollPane;
            }
        }
        throw new IllegalArgumentException("The attached side of the AutoHideContainer is invalid: " + autoHideContainer.getAttachedSide());
    }

    private void internalResetToDefault() {
        SidePaneGroup[] northGroups;
        SidePaneGroup[] southGroups;
        SidePaneGroup[] sidePaneGroupArray;
        SidePaneGroup[] eastGroups;
        this.setRealized(false);
        if (this.getInternalMaximizedFrame() != null) {
            this.internalRestoreFrame(true);
        }
        if (this.getAutohideShowingFrame() != null) {
            this.stopShowingAutohideFrameImmediately();
        }
        this.clearLayout();
        this._unmaximizedBounds = (Rectangle)this.getInitBounds().clone();
        this._state = this.getInitState();
        this._hiddenFrames = new HiddenFrames();
        this._floatingFrames = new FloatingFrames();
        this._orderedFloatingFrames = new Vector<Component>();
        if (this.getRootPaneContainerAsComponent() instanceof Window) {
            this._orderedFloatingFrames.add(this.getRootPaneContainerAsComponent());
            ((Window)this.getRootPaneContainerAsComponent()).removeWindowListener(this.getFloatingContainerWindowListener());
            ((Window)this.getRootPaneContainerAsComponent()).addWindowListener(this.getFloatingContainerWindowListener());
        }
        this._westContainer = this.createAutoHideContainer(7);
        this._westContainer.setRollover(this.isSidebarRollover());
        this._eastContainer = this.createAutoHideContainer(3);
        this._eastContainer.setRollover(this.isSidebarRollover());
        this._northContainer = this.createAutoHideContainer(1);
        this._northContainer.setRollover(this.isSidebarRollover());
        this._southContainer = this.createAutoHideContainer(5);
        this._southContainer.setRollover(this.isSidebarRollover());
        this._dockedHiddenContainer.add((Component)this.createScrollPaneForAutoHideContainer(this._westContainer), "Before");
        this._dockedHiddenContainer.add((Component)this.createScrollPaneForAutoHideContainer(this._eastContainer), "After");
        this._dockedHiddenContainer.add((Component)this.createScrollPaneForAutoHideContainer(this._northContainer), "First");
        this._dockedHiddenContainer.add((Component)this.createScrollPaneForAutoHideContainer(this._southContainer), "Last");
        ArrayList<DockableFrame> westFrames = new ArrayList<DockableFrame>();
        ArrayList<DockableFrame> eastFrames = new ArrayList<DockableFrame>();
        ArrayList<DockableFrame> northFrames = new ArrayList<DockableFrame>();
        ArrayList<DockableFrame> southFrames = new ArrayList<DockableFrame>();
        ArrayList<DockableFrame> centerFrames = new ArrayList<DockableFrame>();
        ArrayList<DockableFrame> eastSlidingFrames = new ArrayList<DockableFrame>();
        ArrayList<DockableFrame> westSlidingFrames = new ArrayList<DockableFrame>();
        ArrayList<DockableFrame> northSlidingFrames = new ArrayList<DockableFrame>();
        ArrayList<DockableFrame> southSlidingFrames = new ArrayList<DockableFrame>();
        ArrayList<DockableFrame> floatingFrames = new ArrayList<DockableFrame>();
        for (String string : this._allFrameKeys) {
            int dockSide;
            DockableFrame dockableFrame = this.getFrame(string);
            dockableFrame.getContext().setInitPosition(true);
            dockableFrame.getContext().setDockedHeight(0);
            dockableFrame.getContext().setDockedWidth(0);
            dockableFrame.getContext().setAutohideHeight(0);
            dockableFrame.getContext().setAutohideWidth(0);
            dockableFrame.getContext().setUndockedBounds(null);
            dockableFrame.resetPreferredSize();
            try {
                dockableFrame.setMaximized(false);
            }
            catch (PropertyVetoException e) {
                throw new RuntimeException(e);
            }
            dockableFrame.setAvailable(true);
            int oldMode = dockableFrame.getContext().getCurrentMode();
            int mode = dockableFrame.getInitMode();
            dockableFrame.getContext().setCurrentMode(mode < 0 ? 0 : mode);
            boolean isDocked = dockableFrame.isDocked();
            boolean isFloated = dockableFrame.isFloated();
            boolean isAutohide = dockableFrame.isAutohide();
            boolean isAutohideShowing = dockableFrame.isAutohideShowing();
            boolean isHidden = dockableFrame.isHidden();
            dockableFrame.getContext().setCurrentMode(oldMode);
            try {
                if (isDocked) {
                    dockableFrame.setDocked(true);
                } else if (isFloated) {
                    dockableFrame.setFloated(true);
                } else if (isAutohide) {
                    dockableFrame.setAutohide(true);
                } else if (isAutohideShowing) {
                    dockableFrame.setAutohideShowing(true);
                } else if (isHidden) {
                    dockableFrame.setHidden(true);
                }
            }
            catch (PropertyVetoException e) {
                throw new RuntimeException(e);
            }
            if (dockableFrame.isHidden()) {
                this._hiddenFrames.add(dockableFrame.getKey());
            } else {
                this.addToZOrder(dockableFrame);
            }
            if (dockableFrame.isAutohide() || dockableFrame.isAutohideShowing()) {
                dockSide = dockableFrame.getContext().getInitSide();
                dockableFrame.getContext().setCurrentDockSide(dockSide);
                switch (dockSide) {
                    case 4: {
                        eastSlidingFrames.add(dockableFrame);
                        break;
                    }
                    case 8: {
                        westSlidingFrames.add(dockableFrame);
                        break;
                    }
                    case 1: {
                        northSlidingFrames.add(dockableFrame);
                        break;
                    }
                    case 2: {
                        southSlidingFrames.add(dockableFrame);
                    }
                }
                continue;
            }
            if (dockableFrame.isDocked()) {
                dockSide = dockableFrame.getContext().getInitSide();
                dockableFrame.getContext().setCurrentDockSide(dockSide);
                switch (dockSide) {
                    case 4: {
                        eastFrames.add(dockableFrame);
                        break;
                    }
                    case 8: {
                        westFrames.add(dockableFrame);
                        break;
                    }
                    case 1: {
                        northFrames.add(dockableFrame);
                        break;
                    }
                    case 2: {
                        southFrames.add(dockableFrame);
                        break;
                    }
                    case 16: {
                        centerFrames.add(dockableFrame);
                    }
                }
                continue;
            }
            if (!dockableFrame.isFloated()) continue;
            floatingFrames.add(dockableFrame);
        }
        this.internalSetupInitialLayout(eastFrames, southFrames, westFrames, northFrames, centerFrames);
        for (SidePaneGroup eastGroup : eastGroups = this.createSidePaneGroups(eastSlidingFrames, 4)) {
            this._eastContainer.addGroup(eastGroup);
        }
        for (SidePaneGroup westGroup : sidePaneGroupArray = this.createSidePaneGroups(westSlidingFrames, 8)) {
            this._westContainer.addGroup(westGroup);
        }
        for (SidePaneGroup southGroup : southGroups = this.createSidePaneGroups(southSlidingFrames, 2)) {
            this._southContainer.addGroup(southGroup);
        }
        for (SidePaneGroup northGroup : northGroups = this.createSidePaneGroups(northSlidingFrames, 1)) {
            this._northContainer.addGroup(northGroup);
        }
        this.listenToAutohideContainers();
        this.createFloatedContainer(floatingFrames);
        this.resetLayout();
        this.setRealized(true);
        this.fireFrameEvents();
        this.setBoundsState();
        if (this.isShowWorkspace()) {
            this.addToZOrder(this.getWorkspace());
            this.moveToFront(this.getWorkspace());
        }
        if (LOGGER_FOCUS.isLoggable(Level.FINE)) {
            LOGGER_FOCUS.fine(this.getProfileKey() + ":internalResetToDefault");
        }
    }

    @Override
    public AutoHideContainer createAutoHideContainer(int side) {
        return new AutoHideContainer(side, this, this.getInternalEventManager());
    }

    @Override
    public int getInitSplitPriority() {
        return this._initSplitPriority;
    }

    @Override
    public void setInitSplitPriority(int initSplitPriority) {
        if (initSplitPriority == -1 || initSplitPriority == 0 || initSplitPriority == 1 || initSplitPriority == 2 || initSplitPriority == 3) {
            int old = this._initSplitPriority;
            if (this._initSplitPriority != initSplitPriority) {
                this._initSplitPriority = initSplitPriority;
                this.firePropertyChange("initSplitPriority", old, this._initSplitPriority);
            }
        } else {
            throw new IllegalArgumentException("initSplitPriority must be one the following value: SPLIT_CUSTOM, SPLIT_EAST_WEST_SOUTH_NORTH, or SPLIT_SOUTH_NORTH_EAST_WEST, or SPLIT_EAST_SOUTH_WEST_NORTH, or SPLIT_WEST_SOUTH_EAST_NORTH");
        }
    }

    @Override
    public int[] getCustomInitSplitPriority() {
        return this._customInitSplitPriority;
    }

    @Override
    public void setCustomInitSplitPriority(int[] customInitSplitPriority) {
        int[] old = this._customInitSplitPriority;
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i : customInitSplitPriority) {
            if (i != 4 && i != 2 && i != 8 && i != 1) {
                throw new IllegalArgumentException("The int in customInitSplitPriority must be one of following values, DockContext.DOCK_SIDE_WEST, DockContext.DOCK_SIDE_EAST, DockContext.DOCK_SIDE_NORTH, or DockContext.DOCK_SIDE_SOUTH");
            }
            if (set.contains(i)) {
                throw new IllegalArgumentException("The int values in customInitSplitPriority must be unique.");
            }
            set.add(i);
        }
        this._customInitSplitPriority = customInitSplitPriority;
        this.firePropertyChange("customInitSplitPriority", old, customInitSplitPriority);
    }

    @Override
    public int getInitCenterSplit() {
        return this._initCenterSplit;
    }

    @Override
    public void setInitCenterSplit(int initCenterSplit) {
        if (initCenterSplit == 1 || initCenterSplit == 0) {
            int old = this._initCenterSplit;
            if (this._initCenterSplit != initCenterSplit) {
                this._initCenterSplit = initCenterSplit;
                this.firePropertyChange("initCenterSplit", old, this._initCenterSplit);
            }
        } else {
            throw new IllegalArgumentException("initCenterSplit must be one the following value: JideSplitPane.HORIZONTAL_SPLIT, or JideSplitPane.VERTICAL_SPLIT");
        }
    }

    @Override
    public int getInitEastSplit() {
        return this._initEastSplit;
    }

    @Override
    public void setInitEastSplit(int initEastSplit) {
        if (initEastSplit == 1 || initEastSplit == 0) {
            int old = this._initEastSplit;
            if (this._initEastSplit != initEastSplit) {
                this._initEastSplit = initEastSplit;
                this.firePropertyChange("initEastSplit", old, this._initEastSplit);
            }
        } else {
            throw new IllegalArgumentException("initEastSplit must be one the following value: JideSplitPane.HORIZONTAL_SPLIT, or JideSplitPane.VERTICAL_SPLIT");
        }
    }

    @Override
    public int getInitWestSplit() {
        return this._initWestSplit;
    }

    @Override
    public void setInitWestSplit(int initWestSplit) {
        if (initWestSplit == 1 || initWestSplit == 0) {
            int old = this._initWestSplit;
            if (this._initWestSplit != initWestSplit) {
                this._initWestSplit = initWestSplit;
                this.firePropertyChange("initWestSplit", old, this._initWestSplit);
            }
        } else {
            throw new IllegalArgumentException("initWestSplit must be one the following value: JideSplitPane.HORIZONTAL_SPLIT, or JideSplitPane.VERTICAL_SPLIT");
        }
    }

    @Override
    public int getInitNorthSplit() {
        return this._initNorthSplit;
    }

    @Override
    public void setInitNorthSplit(int initNorthSplit) {
        if (initNorthSplit == 1 || initNorthSplit == 0) {
            int old = this._initNorthSplit;
            if (this._initNorthSplit != initNorthSplit) {
                this._initNorthSplit = initNorthSplit;
                this.firePropertyChange("initNorthSplit", old, this._initNorthSplit);
            }
        } else {
            throw new IllegalArgumentException("initNorthSplit must be one the following value: JideSplitPane.HORIZONTAL_SPLIT, or JideSplitPane.VERTICAL_SPLIT");
        }
    }

    @Override
    public int getInitSouthSplit() {
        return this._initSouthSplit;
    }

    @Override
    public void setInitSouthSplit(int initSouthSplit) {
        if (initSouthSplit == 1 || initSouthSplit == 0) {
            int old = this._initSouthSplit;
            if (this._initSouthSplit != initSouthSplit) {
                this._initSouthSplit = initSouthSplit;
                this.firePropertyChange("initSouthSplit", old, this._initSouthSplit);
            }
        } else {
            throw new IllegalArgumentException("initSouthSplit must be one the following value: JideSplitPane.HORIZONTAL_SPLIT, or JideSplitPane.VERTICAL_SPLIT");
        }
    }

    @Override
    public boolean isLoadDataSuccessful() {
        return this._loadDataSuccessful;
    }

    private void internalSetupInitialLayout(List<DockableFrame> eastFrames, List<DockableFrame> southFrames, List<DockableFrame> westFrames, List<DockableFrame> northFrames, List<DockableFrame> centerFrames) {
        int[] splits;
        int[] cs = this.getCustomInitSplitPriority();
        if (cs == null) {
            switch (this.getInitSplitPriority()) {
                case 0: {
                    splits = new int[]{1, 3, 2, 4};
                    break;
                }
                case 1: {
                    splits = new int[]{2, 4, 1, 3};
                    break;
                }
                case 2: {
                    splits = new int[]{1, 2, 3, 4};
                    break;
                }
                case 3: {
                    splits = new int[]{3, 2, 1, 4};
                    break;
                }
                default: {
                    splits = new int[]{1, 3, 2, 4};
                    break;
                }
            }
        } else {
            splits = new int[4];
            for (int i = 0; i < cs.length; ++i) {
                int s = cs[i];
                if (s == 4) {
                    splits[i] = 1;
                    continue;
                }
                if (s == 2) {
                    splits[i] = 2;
                    continue;
                }
                if (s == 8) {
                    splits[i] = 3;
                    continue;
                }
                if (s != 1) continue;
                splits[i] = 4;
            }
        }
        Component[] components = new Component[]{this.getWorkspace(), this.createDockedContainer(eastFrames, this.getInitEastSplit()), this.createDockedContainer(southFrames, this.getInitSouthSplit()), this.createDockedContainer(westFrames, this.getInitWestSplit()), this.createDockedContainer(northFrames, this.getInitNorthSplit())};
        for (int i = splits.length - 1; i >= 0; --i) {
            int split = splits[i];
            if (components[split] != null) {
                ContainerContainer container;
                ContainerContainer c;
                if (split <= 2) {
                    if (components[0] instanceof ContainerContainer && ((ContainerContainer)components[0]).getOrientation() == split % 2) {
                        ((ContainerContainer)components[0]).add(components[split]);
                        continue;
                    }
                    c = this.createContainerContainer();
                    c.setOrientation(split % 2);
                    if (components[0] == this.getWorkspace()) {
                        container = this.createContainerContainer();
                        container.setOrientation((split + 1) % 2);
                        container.add(components[0]);
                        components[0] = container;
                    }
                    c.add(components[0]);
                    c.add(components[split]);
                    components[0] = c;
                    continue;
                }
                if (split <= 2) continue;
                if (components[0] instanceof ContainerContainer && ((ContainerContainer)components[0]).getOrientation() == split % 2) {
                    ((ContainerContainer)components[0]).add(components[split], 0);
                    continue;
                }
                c = this.createContainerContainer();
                c.setOrientation(split % 2);
                c.add(components[split]);
                if (components[0] == this.getWorkspace()) {
                    container = this.createContainerContainer();
                    container.setOrientation((split + 1) % 2);
                    container.add(components[0]);
                    components[0] = container;
                }
                c.add(components[0]);
                components[0] = c;
                continue;
            }
            if (components[0] != this.getWorkspace() && (!(components[0] instanceof ContainerContainer) || ((ContainerContainer)components[0]).getPaneCount() != 1 || ((ContainerContainer)components[0]).getOrientation() == split % 2)) continue;
            ContainerContainer container = this.createContainerContainer();
            container.setOrientation(split % 2);
            container.add(components[0]);
            components[0] = container;
        }
        this.getDockedFrameContainer().getNormalContainer().add(components[0], "Center");
        Container centerFrameContainer = this.createDockedContainer(centerFrames, this.getInitCenterSplit());
        if (centerFrameContainer != null) {
            this.getWorkspace().setAcceptDockableFrame(true);
            if (centerFrameContainer instanceof FrameContainer) {
                ContainerContainer containerContainer = this.createContainerContainer();
                containerContainer.setOrientation(this.getInitCenterSplit());
                containerContainer.addPane(centerFrameContainer);
                this.getWorkspace().add((Component)containerContainer, "Center");
            } else {
                this.getWorkspace().add((Component)centerFrameContainer, "Center");
            }
        }
    }

    private void createFloatedContainer(List<DockableFrame> frames) {
        if (frames.size() == 0) {
            return;
        }
        List<Integer> list = this.sortFramesByIndex(frames);
        for (int i : list) {
            if (this.isNestedFloatingAllowed()) {
                FrameContainer frameContainer = this.createFrameContainer();
                for (DockableFrame frame : frames) {
                    if (i != frame.getContext().getInitIndex()) continue;
                    frameContainer.addTab(frame);
                }
                DockableFrame selectedFrame = frameContainer.getSelectedFrame();
                if (selectedFrame == null) continue;
                this.floatFrame(selectedFrame.getKey(), selectedFrame.getContext().getUndockedBounds(), false);
                this.adjustStartingPosition();
                continue;
            }
            for (DockableFrame frame : frames) {
                if (i != frame.getContext().getInitIndex()) continue;
                this.floatFrame(frame.getKey(), frame.getContext().getUndockedBounds(), true);
                this.adjustStartingPosition();
            }
        }
    }

    private void adjustStartingPosition() {
        this._startingPosition.x += 40;
        this._startingPosition.y += 40;
        Rectangle bounds = PortingUtils.getScreenBounds(this.getRootPaneContainerAsComponent());
        if (this._startingPosition.x > bounds.x + bounds.width) {
            this._startingPosition.x = bounds.x;
        }
        if (this._startingPosition.y > bounds.y + bounds.height) {
            this._startingPosition.y = bounds.y;
        }
    }

    private SidePaneGroup[] createSidePaneGroups(List<DockableFrame> frames, int side) {
        List<Integer> list = this.sortFramesByIndex(frames);
        if (list.size() == 0) {
            return new SidePaneGroup[0];
        }
        SidePaneGroup[] sidePaneGroups = new SidePaneGroup[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Integer integer = list.get(i);
            SidePaneGroup group = new SidePaneGroup();
            for (DockableFrame dockableFrame : frames) {
                if (integer.intValue() != dockableFrame.getContext().getInitIndex()) continue;
                SidePaneItem item = new SidePaneItem(dockableFrame.getSideTitle(), dockableFrame.getFrameIcon(), dockableFrame, this.internalCreateAutoHideMouseInputListener(dockableFrame, side));
                group.add(item);
                group.setSelectedItem(item);
            }
            sidePaneGroups[i] = group;
        }
        return sidePaneGroups;
    }

    private Container createDockedContainer(List<DockableFrame> frames, int orientation) {
        if (this.isTabDockAllowed()) {
            List<Integer> list = this.sortFramesByIndex(frames);
            if (list.size() == 0) {
                return null;
            }
            if (list.size() == 1) {
                FrameContainer frameContainer = this.createFrameContainer();
                for (DockableFrame frame : frames) {
                    frameContainer.addTab(frame);
                }
                return frameContainer;
            }
            ContainerContainer containerContainer = this.createContainerContainer();
            containerContainer.setOrientation(orientation);
            for (Integer integer : list) {
                FrameContainer frameContainer = this.createFrameContainer();
                for (DockableFrame frame : frames) {
                    if (integer.intValue() != frame.getContext().getInitIndex()) continue;
                    frameContainer.addTab(frame);
                }
                containerContainer.addPane(frameContainer);
            }
            return containerContainer;
        }
        if (frames.size() > 1) {
            Collections.sort(frames, new Comparator<DockableFrame>(){

                @Override
                public int compare(DockableFrame o1, DockableFrame o2) {
                    if (o1.getInitIndex() > o2.getInitIndex()) {
                        return 1;
                    }
                    if (o1.getInitIndex() < o2.getInitIndex()) {
                        return -1;
                    }
                    return 0;
                }
            });
            ContainerContainer containerContainer = this.createContainerContainer();
            containerContainer.setOrientation(orientation);
            for (DockableFrame frame : frames) {
                FrameContainer frameContainer = this.createFrameContainer();
                frameContainer.addTab(frame);
                containerContainer.addPane(frameContainer);
            }
            return containerContainer;
        }
        if (frames.size() == 1) {
            FrameContainer frameContainer = this.createFrameContainer();
            frameContainer.addTab(frames.get(0));
            return frameContainer;
        }
        return null;
    }

    private List<Integer> sortFramesByIndex(List<DockableFrame> frames) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (DockableFrame dockableFrame : frames) {
            Integer index = dockableFrame.getContext().getInitIndex();
            if (list.indexOf(index) != -1) continue;
            list.add(index);
        }
        Collections.sort(list);
        return list;
    }

    @Override
    public DockableFrame getFrame(String key) {
        return this._allFrames.get(key);
    }

    @Override
    public void addFrame(DockableFrame frame) {
        if (frame == null) {
            return;
        }
        final DockableFrame f = frame;
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalAddFrame(f);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockingManager.this.internalAddFrame(f);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    private void internalAddFrame(DockableFrame f) {
        String maximizedFrameKey;
        if (f == null) {
            return;
        }
        if (f.getKey() == null || f.getKey().trim().length() == 0) {
            throw new IllegalArgumentException("The DockableFrame has a null or empty key. Please call setKey() method to set a non-empty string as the key before adding it to DockingManager.");
        }
        if (this._allFrames.containsKey(f.getKey()) || WORKSPACE_KEY.equals(f.getKey())) {
            throw new IllegalArgumentException("The DockableFrame exists with key \"" + f.getKey() + "\". Please specify a new key for the frame.");
        }
        List<String> oldFrameKeys = this.getAllFrameNames();
        this._allFrames.put(f.getKey(), f);
        this._allFrameKeys.add(f.getKey());
        f.addDockableFrameListener(this.getInternalRoutingFrameListener());
        f.addPropertyChangeListener(this._dockableFramePropertyChangeListener);
        f.setDockingManager(this);
        if (!this.isAutohidable()) {
            f.firePropertyChange("autohidable", true, this.isAutohidable());
        }
        if (!this.isHidable()) {
            f.firePropertyChange("hidable", true, this.isHidable());
        }
        if (!this.isFloatable()) {
            f.firePropertyChange("floatable", true, this.isFloatable());
        }
        if ((maximizedFrameKey = this.getMaximizedFrameKey()) != null) {
            this.restoreFrame();
        }
        DockContext dockContext = null;
        if (!f.isTransient()) {
            dockContext = this.getContextOf(f.getKey());
        }
        if (dockContext == null) {
            if (!f.isTransient()) {
                this.addContext(f.getKey(), f.getContext());
            }
            if (this.isRealized()) {
                if (f.isHidden()) {
                    this._hiddenFrames.add(f.getKey());
                } else {
                    this.loadClosePreviousState(f, true);
                    if (f.isHidden()) {
                        if (!this._hiddenFrames.contains(f.getKey())) {
                            this._hiddenFrames.add(f.getKey());
                        }
                    } else {
                        this._hiddenFrames.remove(f.getKey());
                    }
                }
            }
            this.addToZOrder(f);
            f.getContext().setInitPosition(true);
            f.setPreferredSizeWithDockedWidthAndHeight();
        } else {
            f.setContext(dockContext);
            f.internalSetPreferredSize();
            if (this.isRealized()) {
                if (!dockContext.isHidden()) {
                    this.loadClosePreviousState(f, false);
                    this._hiddenFrames.remove(f.getKey());
                    this.addToZOrder(f);
                }
                if (!f.isHidden() && this.internalShowFrame(f)) {
                    f.fireDockableFrameEvent(4001);
                }
                if (f.isActive()) {
                    this.moveToFront(f);
                }
                this.reFocusActiveFrame(false);
            }
        }
        if (LOGGER_FOCUS.isLoggable(Level.FINE)) {
            LOGGER_FOCUS.fine(this.getProfileKey() + ":internalAddFrame");
        }
        this.firePropertyChange("managedFrames", oldFrameKeys, this.getAllFrameNames());
        if (f.isFloated() && maximizedFrameKey != null) {
            this.maximizeFrame(maximizedFrameKey);
        }
    }

    @Override
    public void removeAllFrames() {
        List<String> list = this.getAllFrameNames();
        for (String key : list) {
            this.removeFrame(key);
        }
    }

    @Override
    public void removeFrame(String key) {
        this.checkFrameKey(key, "removeFrame");
        this.removeFrame(key, false);
    }

    @Override
    public void removeFrame(String key, boolean keepPreviousState) {
        final DockableFrame frame = this.getFrame(key);
        if (frame == null) {
            return;
        }
        final boolean kps = keepPreviousState;
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalRemoveFrame(frame, kps);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockingManager.this.internalRemoveFrame(frame, kps);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    private void internalRemoveFrame(DockableFrame f, boolean keepPreviousState) {
        if (!this._allFrames.containsKey(f.getKey())) {
            return;
        }
        int currentState = -1;
        if (keepPreviousState && f.getDockingManager() == this) {
            DockingUtils.saveClosePreviousState(f);
            currentState = f.getContext().getCurrentMode();
        }
        if (this.isRealized() && !f.isHidden() && f.getDockingManager() == this) {
            try {
                this.internalHideFrameImpl(f, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!this._allFrames.containsKey(f.getKey())) {
            return;
        }
        List<String> oldFrameKeys = this.getAllFrameNames();
        this._allFrames.remove(f.getKey());
        this._allFrameKeys.remove(f.getKey());
        this.removeFromZOrder(f);
        this.firePropertyChange("managedFrames", oldFrameKeys, this.getAllFrameNames());
        if (this._hiddenFrames != null && this._hiddenFrames.contains(f.getKey())) {
            this._hiddenFrames.remove(f.getKey());
        }
        if (!keepPreviousState || f.getDockingManager() != this) {
            this.removeContext(f.getKey());
        } else {
            f.getContext().setCurrentMode(currentState);
            try {
                f.setContext((DockContext)f.getContext().clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        if (f.getDockingManager() == this) {
            f.fireDockableFrameEvent(4000);
            f.setDockingManager(null);
        }
        f.removePropertyChangeListener(this._dockableFramePropertyChangeListener);
        f.removeDockableFrameListener(this.getInternalRoutingFrameListener());
        if (this._activeFrame == f) {
            this._activeFrame = null;
        }
        if (f == this._maximizedFrame) {
            this._maximizedFrame = null;
            this._maximizedOtherFloatingFrames = null;
            this._maximizeFramePreviousState = -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean internalShowFrame(DockableFrame f) {
        boolean wasInHiddenFrames;
        if (f.getContext() == null) return false;
        if (!f.isAvailable()) {
            return false;
        }
        if (!this._allFrames.containsKey(f.getKey())) {
            this.addFrame(f);
        }
        String maximizedFrameKey = null;
        if (!f.isMaximized() && this.getMaximizedFrameKey() != null) {
            maximizedFrameKey = this.getMaximizedFrameKey();
            this.restoreFrame();
        }
        boolean bl = wasInHiddenFrames = this._hiddenFrames != null && this._hiddenFrames.contains(f.getKey());
        if (wasInHiddenFrames) {
            this._hiddenFrames.remove(f.getKey());
            f.setVisible(false);
            this.addToZOrder(f);
        }
        if (wasInHiddenFrames && this.loadHiddenPreviousState(f)) {
            if (!f.isFloated()) return false;
            if (maximizedFrameKey == null) return false;
            this.maximizeFrame(maximizedFrameKey);
            return false;
        }
        if (f.isAutohideShowing()) {
            return false;
        }
        if (f.isAutohide()) {
            this.internalStartShowingAutohideFrame(f, f.getContext().getCurrentDockSide(), 0);
            if (maximizedFrameKey == null) return false;
            this.maximizeFrame(maximizedFrameKey);
            return false;
        }
        if (!f.isFloated()) {
            if (f.isDocked()) {
                if (!(f.getParent() instanceof FrameContainer)) return false;
                if (((FrameContainer)f.getParent()).getSelectedFrame() == f) return false;
                ((FrameContainer)f.getParent()).setSelectedComponent(f);
                return false;
            }
            if (f.isDockable()) {
                this.internalDockFrame(f, this.getDockedFrameContainer(), true);
                return true;
            }
            this.internalFloatOutFrame(f);
            if (maximizedFrameKey == null) return true;
            this.maximizeFrame(maximizedFrameKey);
            return true;
        }
        if (f.getParent() instanceof FrameContainer && ((FrameContainer)f.getParent()).getSelectedFrame() != f) {
            ((FrameContainer)f.getParent()).setSelectedComponent(f);
        }
        if (maximizedFrameKey == null) return true;
        this.maximizeFrame(maximizedFrameKey);
        return true;
    }

    @Override
    public void showFrame(String key) {
        this.showFrame(key, true);
    }

    @Override
    public void showFrame(String key, boolean active) {
        final DockableFrame frame = this.getFrame(key);
        if (frame == null || frame.shouldVetoShowing()) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalShowFrame(frame);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockingManager.this.internalShowFrame(frame);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
        if (active) {
            this.activateFrame(key);
        }
    }

    @Override
    public void notifyFrame(String key) {
        this.checkFrameKey(key, "notifyFrame");
        final DockableFrame frame = this.getFrame(key);
        if (frame == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalNotifyFrame(frame);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockingManager.this.internalNotifyFrame(frame);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    private void internalNotifyFrame(DockableFrame f) {
        if (f.getContext() == null || !f.isAvailable()) {
            return;
        }
        f.setNotified(true);
    }

    @Override
    public void denotifyFrame(String key) {
        final DockableFrame frame = this.getFrame(key);
        if (frame == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalDenotifyFrame(frame);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockingManager.this.internalDenotifyFrame(frame);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    private void internalDenotifyFrame(DockableFrame f) {
        if (f.getContext() == null || !f.isAvailable()) {
            return;
        }
        f.setNotified(false);
    }

    @Override
    public void hideFrame(String key) {
        this.checkFrameKey(key, "hideFrame");
        final DockableFrame frame = this.getFrame(key);
        if (frame == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalHideFrame(frame, true);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockingManager.this.internalHideFrame(frame, true);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    private void internalHideFrame(DockableFrame f, boolean setFrameState) {
        if (f.getContext() == null || !f.isAvailable()) {
            return;
        }
        if (!this._allFrames.containsKey(f.getKey())) {
            throw new IllegalArgumentException("The frame is not managed by the docking manager.");
        }
        Container parent = f.getParent();
        if (this.isHideAllTabs() && parent != null && parent instanceof FrameContainer) {
            FrameContainer frameContainer = (FrameContainer)parent;
            for (int i = frameContainer.getTabCount() - 1; i >= 0; --i) {
                DockableFrame dockableFrame = (DockableFrame)frameContainer.getComponentAt(i);
                if (!this.isHidable() || !dockableFrame.isHidable() || dockableFrame.isHidden()) continue;
                this.internalHideFrameImpl(dockableFrame, setFrameState);
            }
        } else if (this.isHidable() && f.isHidable() && !f.isHidden()) {
            this.internalHideFrameImpl(f, setFrameState);
        }
        if (f.isTransient()) {
            this.internalRemoveFrame(f, true);
        }
        if (this._activeFrame == f) {
            this._activeFrame = null;
        }
        if (LOGGER_FOCUS.isLoggable(Level.FINE)) {
            LOGGER_FOCUS.fine(this.getProfileKey() + ":internalHideFrame");
        }
        this.activateFront(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalHideFrameImpl(DockableFrame f, boolean setFrameState) {
        String maximizedFrameKey = this.getMaximizedFrameKey();
        if (f.isMaximized()) {
            if (f.getKey().equals(maximizedFrameKey)) {
                FrameContainer frameContainer;
                int count;
                Container parent;
                maximizedFrameKey = null;
                if (this.isMaximizeAllTabs() && (parent = f.getParent()) instanceof FrameContainer && (count = (frameContainer = (FrameContainer)parent).getTabCount()) > 1) {
                    for (int i = 0; i < count; ++i) {
                        DockableFrame dockableFrame = frameContainer.getFrame(i);
                        if (dockableFrame == f || dockableFrame == null) continue;
                        maximizedFrameKey = dockableFrame.getKey();
                    }
                }
            }
            this.restoreFrame();
        }
        try {
            f.setActive(false);
        }
        catch (PropertyVetoException parent) {
            // empty catch block
        }
        DockingUtils.saveHiddenPreviousState(f);
        if (f.isFloated() && f.isShowing()) {
            try {
                Point location = f.getLocationOnScreen();
                Dimension size = f.getSize();
                f.setSettingSize(true);
                f.setUndockedBounds(new Rectangle(location.x, location.y, size.width, size.height));
            }
            catch (Exception location) {
            }
            finally {
                f.setSettingSize(false);
            }
        }
        Container parentBeforeRemoval = f.getTopLevelAncestor();
        if (f.isFloated() && parentBeforeRemoval instanceof FloatingContainer) {
            FloatingContainer floatingAncestor = (FloatingContainer)((Object)parentBeforeRemoval);
            JideSwingUtilities.removeFromParentWithFocusTransfer(f);
            floatingAncestor.hideItselfIfEmpty();
            if (!floatingAncestor.isVisible()) {
                this.removeFloatingContainer(floatingAncestor);
                this.disposeFloatingContainer(floatingAncestor);
            }
        }
        if (!f.isAutohideShowing() && !f.isAutohide()) {
            this.saveState(f);
            JideSwingUtilities.removeFromParentWithFocusTransfer(f);
            this.loadState();
        } else {
            AutoHideContainer container;
            JideSwingUtilities.removeFromParentWithFocusTransfer(f);
            if (this._slidingAnimator != null && this._slidingAnimator.getSlidingComponent() == f) {
                this.stopShowingAutohideFrameImmediately();
            }
            if ((container = this.getAutoHideContainer(f.getContext().getCurrentDockSide())) != null) {
                container.removeFrame(f);
                container.repaint();
            }
        }
        try {
            this.removeFromZOrder(f);
            if (!f.isHidden()) {
                f.setHidden(true);
                f.setVisible(false);
                if (this._hiddenFrames != null && !this._hiddenFrames.contains(f.getKey())) {
                    this._hiddenFrames.add(f.getKey());
                }
                if (f.getParent() instanceof FrameContainer && ((FrameContainer)f.getParent()).getSelectedFrame() == f) {
                    f.fireDockableFrameEvent(4010);
                }
                f.fireDockableFrameEvent(4002);
            }
        }
        catch (PropertyVetoException e) {
            throw new RuntimeException(e);
        }
        DockableFrameWorkspaceHandle handleFound = this.findNonAutoHideHandle();
        if (handleFound != null) {
            if (handleFound.untyped instanceof DockableFrame && ((DockableFrame)handleFound.untyped).isHidden()) {
                this.removeFromZOrder(handleFound.untyped);
            } else {
                handleFound.toFront();
            }
        } else {
            this.internalActivateFrame(null);
        }
        if (maximizedFrameKey != null) {
            this.maximizeFrame(maximizedFrameKey);
        }
        this.resetLayout();
    }

    private void internalDockFrame(final DockableFrame f) {
        if (f.getContext() == null || !f.isAvailable()) {
            return;
        }
        DockingUtils.validateLocations(f.getDockingManager().getDockedFrameContainer(), this.getWorkspace());
        if (DockingUtils.containsInMainContainer(f.getDockingManager().getDockedFrameContainer(), f)) {
            try {
                f.setDocked(true);
            }
            catch (PropertyVetoException e) {
                throw new RuntimeException(e);
            }
        }
        if (!f.isFloated()) {
            try {
                f.setFloated(true);
            }
            catch (PropertyVetoException e) {
                throw new RuntimeException(e);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (f.getTopLevelAncestor() instanceof FloatingContainer) {
                    DefaultDockingManager.this.updateUndockedBounds(((FloatingContainer)((Object)f.getTopLevelAncestor())).getContentPane());
                }
            }
        });
    }

    @Override
    public void dockFrame(String key, final int side, final int index) {
        this.checkFrameKey(key, "dockFrame");
        final DockableFrame f = this.getFrame(key);
        if (f == null) {
            throw new IllegalArgumentException("DockableFrame " + key + " doesn't exist");
        }
        if (f.getContext() == null || !f.isAvailable() || f.shouldVetoShowing()) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalDockFrame(f, side, index);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockingManager.this.internalDockFrame(f, side, index);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    private void internalDockFrame(DockableFrame f, int side, int index) {
        Container container;
        SidePaneGroup group;
        AutoHideContainer autohideContainer;
        if (f.isAutohide() && (autohideContainer = this.getAutoHideContainer(f.getContext().getCurrentDockSide())) != null && (group = autohideContainer.getSidePaneGroup(f)) != null) {
            SidePaneItem itemToRemove = null;
            for (Object aGroup : group) {
                SidePaneItem item = (SidePaneItem)aGroup;
                DockableFrame dockableFrame = (DockableFrame)item.getComponent();
                if (dockableFrame != f) continue;
                itemToRemove = item;
                break;
            }
            if (group.size() == 1) {
                autohideContainer.removeGroup(group);
            } else {
                group.remove(itemToRemove);
            }
            autohideContainer.repaint();
        }
        if (side != 1 && side != 2 && side != 4 && side != 8 && side != 16) {
            throw new IllegalArgumentException("Invalid argument side. side must be one of following values, DockContext.DOCK_SIDE_WEST, DockContext.DOCK_SIDE_EAST, DockContext.DOCK_SIDE_NORTH, DockContext.DOCK_SIDE_SOUTH or DockContext.DOCK_SIDE_CENTER.");
        }
        if (index < 0) {
            throw new IllegalArgumentException("Argument index must be a positive integer.");
        }
        this.saveState(f);
        if (side != 16) {
            container = this.getOutermostContainer((Container)this.getDockedFrameContainer().getNormalContainer().getComponent(0), side);
        } else if (this.getWorkspace().isAcceptDockableFrame() && this.getWorkspace().getComponentCount() == 1) {
            container = (Container)this.getWorkspace().getComponent(0);
        } else {
            if (this.getWorkspace().isAcceptDockableFrame() && this.getWorkspace().getComponentCount() == 0) {
                FrameContainer targetFC = this.createFrameContainer();
                ContainerContainer targetCC = this.createContainerContainer();
                targetCC.addPane(targetFC);
                this.getWorkspace().add((Component)targetCC, "Center");
                this.internalDockFrame(f, targetFC, false);
                this.loadState();
                this.resetLayout();
                return;
            }
            container = this.getOutermostContainer((Container)this.getDockedFrameContainer().getNormalContainer().getComponent(0), 2);
        }
        List<DockableFrame> list = DockingUtils.getAllDockableFrameOf(container);
        if (list != null && list.size() > 0) {
            for (DockableFrame frame : list) {
                if (DefaultDockingManager.checkForInitPosition() && !frame.getContext().isInitPosition() || frame.getContext().getInitIndex() != index || !(frame.getUI().getTitlePane() instanceof BasicDockableFrameTitlePane)) continue;
                this.internalDockFrame(f, (BasicDockableFrameTitlePane)frame.getUI().getTitlePane());
                this.loadState();
                this.resetLayout();
                return;
            }
            for (DockableFrame frame : list) {
                if (DefaultDockingManager.checkForInitPosition() && !frame.getContext().isInitPosition()) continue;
                int splitOrientation = 1;
                if (side == 1) {
                    splitOrientation = this.getInitNorthSplit();
                } else if (side == 2) {
                    splitOrientation = this.getInitSouthSplit();
                } else if (side == 4) {
                    splitOrientation = this.getInitEastSplit();
                } else if (side == 8) {
                    splitOrientation = this.getInitWestSplit();
                }
                if (index < frame.getContext().getInitIndex()) {
                    this.internalDockFrame((JComponent)f, frame.getParent(), splitOrientation == 1 ? 8 : 1);
                } else if (index > frame.getContext().getInitIndex()) {
                    this.internalDockFrame((JComponent)f, frame.getParent(), splitOrientation == 1 ? 4 : 2);
                }
                this.loadState();
                this.resetLayout();
                return;
            }
            if (index == 0) {
                this.internalDockFrame((JComponent)f, list.get(0).getParent(), side == 1 || side == 2 ? 8 : 1);
            } else {
                this.internalDockFrame((JComponent)f, list.get(list.size() - 1).getParent(), side == 1 || side == 2 ? 4 : 2);
            }
        } else {
            this.internalDockFrame((JComponent)f, this.getDockedFrameContainer(), side, true);
        }
        this.loadState();
        this.resetLayout();
    }

    private boolean isValidOutermostContainer(Container container) {
        return container instanceof FrameContainer || container instanceof ContainerContainer && !container.isAncestorOf(this.getWorkspace());
    }

    private Container getOutermostContainer(Container container, int side) {
        if (container instanceof ContainerContainer) {
            Component component;
            ContainerContainer containerContainer = (ContainerContainer)container;
            if (containerContainer.getOrientation() == 1) {
                boolean ltr;
                if (side == 8 ? this.isValidOutermostContainer((Container)(component = containerContainer.getPaneAt((ltr = container.getComponentOrientation().isLeftToRight()) ? 0 : containerContainer.getPaneCount() - 1))) : side == 4 && this.isValidOutermostContainer((Container)(component = containerContainer.getPaneAt((ltr = container.getComponentOrientation().isLeftToRight()) ? containerContainer.getPaneCount() - 1 : 0)))) {
                    return (Container)component;
                }
            } else if (containerContainer.getOrientation() == 0) {
                Component component2;
                if (side == 1) {
                    Component component3 = containerContainer.getPaneAt(0);
                    if (this.isValidOutermostContainer((Container)component3)) {
                        return (Container)component3;
                    }
                } else if (side == 2 && this.isValidOutermostContainer((Container)(component2 = containerContainer.getPaneAt(containerContainer.getPaneCount() - 1)))) {
                    return (Container)component2;
                }
            }
            for (int i = 0; i < containerContainer.getPaneCount(); ++i) {
                component = containerContainer.getPaneAt(i);
                if (!((Container)component).isAncestorOf(this.getWorkspace()) || component.equals(this.getWorkspace())) continue;
                return this.getOutermostContainer((Container)component, side);
            }
        }
        return null;
    }

    @Override
    public void floatFrame(String key, Rectangle bounds, boolean isSingle) {
        this.checkFrameKey(key, "floatFrame");
        final DockableFrame frame = this.getFrame(key);
        if (frame == null || frame.shouldVetoShowing()) {
            return;
        }
        final Rectangle b = bounds;
        final boolean s = isSingle;
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalFloatFrame(frame, b, s, true);
            if (this._hiddenFrames.contains(frame.getKey())) {
                this._hiddenFrames.remove(frame.getKey());
            }
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockingManager.this.internalFloatFrame(frame, b, s, true);
                        if (DefaultDockingManager.this._hiddenFrames.contains(frame.getKey())) {
                            DefaultDockingManager.this._hiddenFrames.remove(frame.getKey());
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalFloatFrame(DockableFrame frame, Rectangle bounds, boolean isSingle, boolean isVisible) {
        if (frame.getContext() == null || !frame.isAvailable()) {
            return;
        }
        if (!this.isFloatable() || !frame.isFloatable()) {
            return;
        }
        if (frame.isAutohideShowing() || frame.isAutohide()) {
            SidePaneGroup group;
            AutoHideContainer autohideContainer = this.getAutoHideContainer(frame.getContext().getCurrentDockSide());
            if (autohideContainer != null && (group = autohideContainer.getSidePaneGroup(frame)) != null) {
                this.internalToggleAutohideState(frame, isSingle);
            }
        } else if (frame.isMaximized()) {
            this.internalRestoreFrame(true);
        }
        frame.resetDockID();
        if (bounds == null && (bounds = frame.getContext().getInitUndockedBounds()) == null) {
            Point start = this._startingPosition;
            if (this.getRootPaneContainerAsComponent() != null && this.getRootPaneContainerAsComponent().isShowing()) {
                try {
                    start = this.getRootPaneContainerAsComponent().getLocationOnScreen();
                }
                catch (IllegalComponentStateException group) {
                    // empty catch block
                }
            }
            bounds = new Rectangle(start, frame.getPreferredSize());
        }
        if (this.isWithinScreenBoundsOnDragging()) {
            bounds = PortingUtils.containsInScreenBounds(frame, bounds);
        }
        Rectangle screenBounds = PortingUtils.getScreenBounds(frame);
        if ((bounds.x < screenBounds.x && bounds.y < screenBounds.y || bounds.x == 60 && bounds.y == 60) && frame.getParent() instanceof FrameContainer && frame.getParent().isShowing()) {
            try {
                Point location;
                try {
                    location = frame.getParent().getLocationOnScreen();
                }
                catch (IllegalComponentStateException e) {
                    location = new Point(0, 0);
                }
                location.x += 20;
                location.y += 20;
                bounds.setLocation(location);
            }
            catch (Exception location) {
                // empty catch block
            }
        }
        Dimension minimumSize = frame.getMinimumSize();
        if (bounds.width < minimumSize.width) {
            bounds.width = minimumSize.width;
        }
        if (bounds.height < minimumSize.height) {
            bounds.height = minimumSize.height;
        }
        this.saveState(frame);
        boolean reuseFloatingContainer = false;
        FloatingContainer floatingContainer = null;
        Container ancestor = frame.getTopLevelAncestor();
        if (frame.isFloated() && ancestor instanceof FloatingContainer && DockingUtils.getFrameContainerCount(this, ((FloatingContainer)((Object)ancestor)).getContentPane()) == 1 && !isSingle) {
            reuseFloatingContainer = true;
            floatingContainer = (FloatingContainer)((Object)ancestor);
        }
        if (!reuseFloatingContainer) {
            ContainerContainer containerContainer;
            floatingContainer = this.createFloatingContainer(SwingUtilities.getWindowAncestor(this.getRootPaneContainer().getRootPane()));
            DockingManager.FloatingContainerCustomizer customizer = this.getFloatingContainerCustomizer();
            if (customizer != null) {
                customizer.customize(floatingContainer);
            }
            floatingContainer.setVisible(false);
            floatingContainer = this.updateUndecorated(floatingContainer);
            this.addFloatingContainer(floatingContainer);
            if (isSingle) {
                JideSwingUtilities.removeFromParentWithFocusTransfer(frame);
                containerContainer = this.createContainerContainer();
                floatingContainer.getContentPane().add(containerContainer);
                FrameContainer frameContainer = this.createFrameContainer();
                containerContainer.add(frameContainer);
                frameContainer.addTab(frame, false);
                frameContainer.setSelectedIndex(frameContainer.getFrameIndex(frame), true);
                frameContainer.scrollSelectedTabToVisible(true);
            } else {
                containerContainer = this.createContainerContainer();
                floatingContainer.getContentPane().add(containerContainer);
                if (frame.getParent() != null && frame.getParent() instanceof FrameContainer) {
                    FrameContainer fc = (FrameContainer)frame.getParent();
                    if (fc.isAllFloatable()) {
                        JideSwingUtilities.removeFromParentWithFocusTransfer(fc);
                        containerContainer.add(frame.getParent());
                    } else {
                        FrameContainer frameContainer = this.createFrameContainer();
                        ArrayList<Component> tabs = new ArrayList<Component>();
                        for (int i = 0; i < fc.getTabCount(); ++i) {
                            if (!((DockableFrame)fc.getComponentAt(i)).isFloatable()) continue;
                            tabs.add(fc.getComponentAt(i));
                        }
                        for (Component component : tabs) {
                            frameContainer.addTab((DockableFrame)component, true);
                        }
                        containerContainer.add(frameContainer);
                    }
                }
            }
            floatingContainer.updateBorders();
            if (!this.isResizable()) {
                floatingContainer.setResizable(false);
            }
        }
        Rectangle savedBounds = new Rectangle(bounds);
        boolean sameLocation = JideSwingUtilities.equals(savedBounds, frame.getUndockedBounds());
        Insets contentInsets = UIDefaultsLookup.getInsets("FrameContainer.contentBorderInsets");
        if (contentInsets == null && (contentInsets = UIDefaultsLookup.getInsets("JideTabbedPane.contentBorderInsets")) == null) {
            contentInsets = new Insets(0, 0, 0, 0);
        }
        BasicJideTabbedPaneUI.rotateInsets(contentInsets, contentInsets, ((FrameContainer)frame.getParent()).getTabPlacement());
        bounds.x -= contentInsets.left;
        bounds.y -= contentInsets.top;
        bounds.width += contentInsets.left + contentInsets.right;
        bounds.height += contentInsets.top + contentInsets.bottom;
        if (frame.getParent() != null && frame.getParent().getInsets() != null) {
            Insets insets = frame.getParent().getInsets();
            bounds.width += insets.left + insets.right;
            bounds.height += insets.top + insets.bottom;
        }
        floatingContainer.pack();
        if (DockingUtils.isTabVisible(floatingContainer.getContentPane())) {
            int tabPlacement = ((FrameContainer)frame.getParent()).getTabPlacement();
            if (tabPlacement == 1 || tabPlacement == 3) {
                int tabHeight = ((JideTabbedPaneUI)((FrameContainer)frame.getParent()).getUI()).getTabPanel().getHeight();
                bounds.height += tabHeight;
                if (tabPlacement == 1) {
                    bounds.y -= tabHeight;
                }
            } else {
                int tabWidth = ((JideTabbedPaneUI)((FrameContainer)frame.getParent()).getUI()).getTabPanel().getWidth();
                bounds.width += tabWidth;
                if (tabPlacement == 2) {
                    bounds.x -= tabWidth;
                }
            }
        }
        if (frame.isShowTitleBar() && frame.getUI().getTitlePane() != null) {
            int titleHeight = frame.getUI().getTitlePane().getHeight();
            if (bounds.y + titleHeight > screenBounds.y + screenBounds.height) {
                bounds.y = screenBounds.y + screenBounds.height - titleHeight;
            }
        } else if (bounds.y + bounds.height > screenBounds.y + screenBounds.height) {
            bounds.y = screenBounds.y + screenBounds.height - bounds.height;
        }
        if (bounds.y < screenBounds.y) {
            bounds.y = screenBounds.y;
        }
        if (bounds != null) {
            frame.getParent().setPreferredSize(bounds.getSize());
        }
        floatingContainer.pack();
        PreviousState floatPreviousState = !frame.isAvailable() ? frame.getAutohidePreviousState() : (frame.isHidden() ? frame.getHiddenPreviousState() : (frame.isAutohide() || frame.isAutohideShowing() ? frame.getAvailablePreviousState() : frame.getFloatPreviousState()));
        Point location = bounds.getLocation();
        if (sameLocation && floatPreviousState != null && floatPreviousState.rcBounds != null) {
            location = floatPreviousState.rcBounds.getLocation();
        } else if (floatPreviousState == null) {
            Insets insets = DockingUtils.getFloatingContainerInsets(this);
            location.x -= insets.left;
            location.y -= insets.top;
        }
        Rectangle floatingContainerBounds = floatingContainer.getBounds();
        floatingContainerBounds.setLocation(location);
        this.adjustBoundsForSnap(savedBounds, floatingContainerBounds);
        floatingContainer.setBounds(floatingContainerBounds);
        if (bounds != null && isVisible && this.shouldSetFloatingContainerVisible()) {
            floatingContainer.setVisible(true);
        }
        this.loadState();
        try {
            frame.setSettingSize(true);
            frame.setUndockedBounds(savedBounds);
        }
        finally {
            frame.setSettingSize(false);
        }
        if (isSingle) {
            try {
                frame.setFloated(true);
            }
            catch (PropertyVetoException e) {
                throw new RuntimeException(e);
            }
        }
        if (frame.getParent() != null && frame.getParent() instanceof FrameContainer) {
            try {
                DockingUtils.floatizeChildrenOf(frame.getParent(), this);
            }
            catch (PropertyVetoException e) {
                throw new RuntimeException(e);
            }
        }
        this.resetLayout();
    }

    protected boolean shouldSetFloatingContainerVisible() {
        return this.getRootPaneContainerAsComponent() != null && this.getRootPaneContainerAsComponent().isVisible();
    }

    void adjustBoundsForSnap(Rectangle savedBounds, Rectangle floatingContainerBounds) {
        int snapGridSize = this.getSnapGridSize();
        if (snapGridSize > 1) {
            if (floatingContainerBounds.x > 0) {
                if (floatingContainerBounds.x % snapGridSize >= snapGridSize / 2) {
                    floatingContainerBounds.x += snapGridSize - floatingContainerBounds.x % snapGridSize;
                    savedBounds.x += snapGridSize - floatingContainerBounds.x % snapGridSize;
                } else {
                    floatingContainerBounds.x -= floatingContainerBounds.x % snapGridSize;
                    savedBounds.x -= floatingContainerBounds.x % snapGridSize;
                }
            } else if (-floatingContainerBounds.x % snapGridSize >= snapGridSize / 2) {
                floatingContainerBounds.x -= snapGridSize - -floatingContainerBounds.x % snapGridSize;
                savedBounds.x -= snapGridSize - -floatingContainerBounds.x % snapGridSize;
            } else {
                floatingContainerBounds.x += -floatingContainerBounds.x % snapGridSize;
                savedBounds.x += -floatingContainerBounds.x % snapGridSize;
            }
            if (floatingContainerBounds.y > 0) {
                if (floatingContainerBounds.y % snapGridSize >= snapGridSize / 2) {
                    floatingContainerBounds.y += snapGridSize - floatingContainerBounds.y % snapGridSize;
                    savedBounds.y += snapGridSize - floatingContainerBounds.y % snapGridSize;
                } else {
                    floatingContainerBounds.y -= floatingContainerBounds.y % snapGridSize;
                    savedBounds.y -= floatingContainerBounds.y % snapGridSize;
                }
            } else if (-floatingContainerBounds.y % snapGridSize >= snapGridSize / 2) {
                floatingContainerBounds.y -= snapGridSize - -floatingContainerBounds.y % snapGridSize;
                savedBounds.y -= snapGridSize - -floatingContainerBounds.y % snapGridSize;
            } else {
                floatingContainerBounds.y += -floatingContainerBounds.y % snapGridSize;
                savedBounds.y += -floatingContainerBounds.y % snapGridSize;
            }
            if (floatingContainerBounds.width % snapGridSize >= snapGridSize / 2) {
                floatingContainerBounds.width += snapGridSize - floatingContainerBounds.width % snapGridSize;
                savedBounds.width += snapGridSize - floatingContainerBounds.width % snapGridSize;
            } else {
                floatingContainerBounds.width -= floatingContainerBounds.width % snapGridSize;
                savedBounds.width -= floatingContainerBounds.width % snapGridSize;
            }
            if (floatingContainerBounds.height % snapGridSize >= snapGridSize / 2) {
                floatingContainerBounds.height += snapGridSize - floatingContainerBounds.height % snapGridSize;
                savedBounds.height += snapGridSize - floatingContainerBounds.height % snapGridSize;
            } else {
                floatingContainerBounds.height -= floatingContainerBounds.height % snapGridSize;
                savedBounds.height -= floatingContainerBounds.height % snapGridSize;
            }
        }
    }

    @Override
    public FloatingContainer createFloatingContainer(Window owner) {
        Window floatingContainer;
        int floatingContainerType = this.getFloatingContainerType();
        if (this.getRootPaneContainer() instanceof Applet) {
            Frame f = JideSwingUtilities.getFrame(owner != null ? owner : (Applet)((Object)this.getRootPaneContainer()));
            if (floatingContainerType == 2) {
                floatingContainer = this.createWindowFloatingContainer(this.getInternalEventManager(), f);
            } else if (floatingContainerType == 1) {
                floatingContainer = this.createFrameFloatingContainer(this.getInternalEventManager());
                if (f != null) {
                    ((FrameFloatingContainer)floatingContainer).setIconImage(f.getIconImage());
                    if (SystemInfo.isJdk6Above()) {
                        ((FrameFloatingContainer)floatingContainer).setIconImages(f.getIconImages());
                    }
                }
            } else {
                floatingContainer = this.createDialogFloatingContainer(this.getInternalEventManager(), f);
            }
        } else {
            Window window = JideSwingUtilities.getWindowForComponent(owner != null ? owner : this._dockedHiddenContainer);
            if ((window == null || window.getClass().getName().indexOf("SharedOwnerFrame") != -1) && this.getRootPaneContainer() instanceof Window) {
                window = (Window)((Object)this.getRootPaneContainer());
            }
            if (floatingContainerType == 2) {
                floatingContainer = this.createWindowFloatingContainer(this.getInternalEventManager(), window);
            } else if (floatingContainerType == 1) {
                floatingContainer = this.createFrameFloatingContainer(this.getInternalEventManager());
                if (window instanceof Frame) {
                    ((FrameFloatingContainer)floatingContainer).setIconImage(((Frame)window).getIconImage());
                }
            } else {
                floatingContainer = this.createDialogFloatingContainer(this.getInternalEventManager(), window);
            }
        }
        if (floatingContainer != null) {
            floatingContainer.setResizable(this.isResizable());
            if (floatingContainer instanceof ResizableDialog) {
                ((ResizableDialog)floatingContainer).getResizable().setSnapGridSize(this.getSnapGridSize());
            } else if (floatingContainer instanceof ResizableFrame) {
                ((ResizableFrame)floatingContainer).getResizable().setSnapGridSize(this.getSnapGridSize());
            } else if (floatingContainer instanceof ResizableWindow) {
                ((ResizableWindow)floatingContainer).getResizable().setSnapGridSize(this.getSnapGridSize());
            }
        }
        if (this._floatingContainerComponentListener == null) {
            this._floatingContainerComponentListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                    Container container = ((FloatingContainer)e.getSource()).getContentPane();
                    DefaultDockingManager.this.updateUndockedBounds(container);
                }
            };
        }
        ((Component)floatingContainer).addComponentListener(this._floatingContainerComponentListener);
        return floatingContainer;
    }

    private void updateUndockedBounds(Container container) {
        JideSwingUtilities.setRecursively(container, new JideSwingUtilities.Handler(){

            @Override
            public boolean condition(Component c) {
                return c instanceof DockableFrame;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void action(Component c) {
                DockableFrame dockableFrame = (DockableFrame)c;
                Rectangle bounds = dockableFrame.getBounds();
                if (dockableFrame.isShowing()) {
                    try {
                        Point p = dockableFrame.getLocationOnScreen();
                        bounds.setLocation(p);
                        dockableFrame.setSettingSize(true);
                        dockableFrame.setUndockedBounds(bounds);
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        dockableFrame.setSettingSize(false);
                    }
                }
            }

            @Override
            public void postAction(Component c) {
            }
        });
    }

    protected FrameFloatingContainer createFrameFloatingContainer(InternalEventManager eventManager) {
        return new FrameFloatingContainer(this, eventManager);
    }

    protected WindowFloatingContainer createWindowFloatingContainer(InternalEventManager eventManager, Window window) {
        if (window instanceof Dialog) {
            return new WindowFloatingContainer((DockingManager)this, (FloatingContainer.FloatingContainerManager)eventManager, (Dialog)window);
        }
        if (window instanceof Frame) {
            return new WindowFloatingContainer((DockingManager)this, (FloatingContainer.FloatingContainerManager)eventManager, (Frame)window);
        }
        if (window != null) {
            return new WindowFloatingContainer((DockingManager)this, (FloatingContainer.FloatingContainerManager)eventManager, window);
        }
        throw new UnsupportedOperationException("JIDE Docking Framework doesn't support floating frames if rootPaneContainer is null");
    }

    protected DialogFloatingContainer createDialogFloatingContainer(InternalEventManager eventManager, Window window) {
        if (window instanceof Dialog) {
            return new DialogFloatingContainer((DockingManager)this, (FloatingContainer.FloatingContainerManager)eventManager, (Dialog)window);
        }
        if (window instanceof Frame) {
            return new DialogFloatingContainer((DockingManager)this, (FloatingContainer.FloatingContainerManager)eventManager, (Frame)window);
        }
        throw new UnsupportedOperationException("JIDE Docking Framework doesn't support floating frames if rootPaneContainer is " + (window == null ? "null" : window.getClass().getName()));
    }

    @Override
    public void startShowingAutohideFrameImmediately(String frame, int side) {
        this.startShowingAutohideFrame(frame, side, 0);
        if (this._slidingAnimator != null) {
            this._slidingAnimator.showImmediately();
        }
    }

    @Override
    public void startShowingAutohideFrame(String frameKey, int side, int delay) {
        final DockableFrame frame = this.getFrame(frameKey);
        if (frame == null) {
            return;
        }
        final int s = side;
        final int d = delay;
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalStartShowingAutohideFrame(frame, s, d);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockingManager.this.internalStartShowingAutohideFrame(frame, s, d);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    private void internalStartShowingAutohideFrame(DockableFrame f, int side, int initDelay) {
        if (f == null) {
            return;
        }
        AutoHideContainer container = this.getAutoHideContainer(f.getContext().getCurrentDockSide());
        SidePaneItem spi = container.getSidePaneItem(f);
        SidePaneGroup group = container.getSidePaneGroup(f);
        if (this._slidingAnimator != null && this._slidingAnimator.getSlidingFrame() == f && this._slidingAnimator.isOpening()) {
            return;
        }
        if (this._slidingAnimator != null && this._slidingAnimator.getSlidingFrame() == f && !this._slidingAnimator.isOpening()) {
            this._slidingAnimator.startOpen(initDelay);
            return;
        }
        if (!this._allFrames.containsKey(f.getKey())) {
            this.addFrame(f);
        }
        this._startingAutohideShow = f;
        boolean oldFrameFrameWasActive = false;
        if (this._slidingAnimator != null && this._slidingAnimator.getSlidingFrame() != f) {
            oldFrameFrameWasActive = this._slidingAnimator.getSlidingFrame().isActive();
            this.stopShowingAutohideFrameImmediately();
        }
        this._startingAutohideShow = null;
        if (oldFrameFrameWasActive) {
            this.moveToFront(f);
        }
        if (group != null) {
            group.setSelectedItem(spi);
            container.repaint();
        }
        if (this._slidingAnimator == null) {
            this._slidingAnimator = new SlidingAnimator(this, new DefaultDockingManagerAnimationHandler(), this.getDockedFrameContainer(), this._slidingContainer, f, side, this.getStepDelay(), this.getSteps());
            this._slidingAnimator.startOpen(initDelay);
        }
    }

    @Override
    public void stopShowingAutohideFrame(int initDelay, boolean forceComplete) {
        DockableFrameWorkspaceHandle handleReturn;
        if (this._slidingAnimator != null && this._slidingAnimator.isSliding() && !this._slidingAnimator.isOpening()) {
            return;
        }
        if (this._slidingAnimator != null && this._slidingAnimator.getSlidingFrame().isActive() && (handleReturn = this.findNonAutoHideHandle()) != null) {
            handleReturn.toFront();
        }
        if (this._slidingAnimator != null) {
            this._slidingAnimator.startHide(initDelay, forceComplete);
        }
    }

    @Override
    public void finishShowingAutohideFrame(String frame) {
    }

    @Override
    public void stopShowingAutohideFrameImmediately() {
        if (this._slidingAnimator == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            if (this._slidingAnimator != null) {
                this._slidingAnimator.hideImmediately();
            }
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (DefaultDockingManager.this._slidingAnimator != null) {
                            DefaultDockingManager.this._slidingAnimator.hideImmediately();
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    String getFrameToActivate() {
        return this._frameToActivate;
    }

    void setFrameToActivate(String frameToActivate) {
        this._frameToActivate = frameToActivate;
    }

    int getPriority() {
        return this._priority;
    }

    void setPriority(int priority) {
        this._priority = priority;
    }

    protected InternalEventManager getInternalEventManager() {
        return this._internalEventManager;
    }

    @Override
    public int getUnknownFrameBehaviorOnLoading() {
        return this._unknownFrameBehaviorOnLoading;
    }

    @Override
    public void setUnknownFrameBehaviorOnLoading(int unknownFrameBehaviorOnLoading) {
        this._unknownFrameBehaviorOnLoading = unknownFrameBehaviorOnLoading;
    }

    @Override
    public boolean isXmlFormat() {
        return this._layoutSaveToXml;
    }

    @Override
    public void setXmlFormat(boolean xmlFormat) {
        this._layoutSaveToXml = xmlFormat;
    }

    @Override
    public int getSnapGridSize() {
        return this._gridSize;
    }

    @Override
    public void setSnapGridSize(int snapGridSize) {
        this._gridSize = snapGridSize;
    }

    @Override
    public void activateFrame(String key) {
        final DockableFrame frame = this.getFrame(key);
        if (frame == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.moveToFront(frame);
            this.internalShowFrame(frame);
            this.internalActivateFrame(frame);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockingManager.this.moveToFront(frame);
                        DefaultDockingManager.this.internalShowFrame(frame);
                        DefaultDockingManager.this.internalActivateFrame(frame);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    private void internalActivateFrame(DockableFrame f) {
        if (!(f == null || f.getContext() != null && f.isAvailable() && f.getDockingManager() == this)) {
            return;
        }
        DockableFrame oldSelectedFrame = this._activeFrame;
        this._activeFrame = f;
        try {
            if (oldSelectedFrame != null && oldSelectedFrame != this._activeFrame && oldSelectedFrame.isActive()) {
                boolean oldProcessingFocus = _processingFocusEvent;
                _processingFocusEvent = true;
                oldSelectedFrame.setActive(false, f);
                _processingFocusEvent = oldProcessingFocus;
            }
        }
        catch (PropertyVetoException e) {
            return;
        }
        if (!(this._activeFrame != null && (this._activeFrame == oldSelectedFrame || this.getAutohideShowingFrame() == null || this._activeFrame.getKey().equals(this.getAutohideShowingFrame())) || this.getAutohideShowingFrame() == null || this.getFrame(this.getAutohideShowingFrame()) != this._slidingAnimator.getSlidingFrame() || this._slidingAnimator.getSlidingFrame().isActive() || this._slidingAnimator.isClosing())) {
            this.stopShowingAutohideFrame(0, true);
        }
        if (this._activeFrame != null && this._activeFrame.getContentPane() != null) {
            this._activeFrame.getContentPane().invalidate();
            this._activeFrame.getContentPane().repaint();
        }
        Container parent = null;
        if (f != null) {
            parent = f.getParent();
        }
        if (f != null && !f.isAutohideShowing()) {
            Object top;
            if (f.isAutohide()) {
                this.internalStartShowingAutohideFrame(f, f.getContext().getCurrentDockSide(), 0);
            } else if (f.isFloated() && (top = f.getTopLevelAncestor()) instanceof FloatingContainer && !this.isAutohideShowingInProgress() && this.isRealized() && this._hasFocus && !this._togglingWindowVisibility && !_processingFocusEvent) {
                ((FloatingContainer)top).toFront();
            }
        }
        if (parent != null && parent instanceof FrameContainer && ((FrameContainer)parent).indexOfComponent(f) >= 0) {
            ((FrameContainer)parent).setSelectedComponent(f);
        }
        if (f != null && f.isDocked()) {
            if (this._maximizedFrame != null && this._maximizedFrame.getParent() == parent) {
                this._maximizedFrame = f;
            } else if (this._maximizedFrame != null) {
                this.internalRestoreFrame(true);
                this.internalMaximizeFrame(f, true);
            }
        }
        if (oldSelectedFrame != this._activeFrame) {
            this.setWorkspaceActive(f == null && this.isShowWorkspace() && this.isActive());
            for (DockingManager manager : _dockingManagers) {
                if (manager == this || !(manager instanceof DefaultDockingManager)) continue;
                ((DefaultDockingManager)manager).setWorkspaceActive(false);
            }
        }
        try {
            if (f != null && oldSelectedFrame != this._activeFrame && !f.isActive()) {
                boolean oldProcessingFocus = _processingFocusEvent;
                _processingFocusEvent = true;
                f.setActive(true, oldSelectedFrame);
                _processingFocusEvent = oldProcessingFocus;
            }
        }
        catch (PropertyVetoException e) {
            return;
        }
        this.reFocusActiveFrame(true);
    }

    @Override
    public void beginDraggingFrame(JComponent f, int mouseX, int mouseY, double relativeX, double relativeY, boolean single) {
        if (!(f instanceof DockableFrame)) {
            return;
        }
        this.stopShowingAutohideFrame(0, true);
        this.removeExtraFloatingFrames();
        DockingUtils.validateLocations(this.getDockedFrameContainer(), this.getWorkspace());
        DockableFrame frame = (DockableFrame)f;
        this.moveToFront(frame);
        if (this.isUseGlassPaneEnabled()) {
            this._glassPaneVisibility = this.getRootPaneContainer().getGlassPane().isVisible();
        }
        if (this._dragContour != null) {
            this._dragContour.setVisible(false);
        }
        this._dragContour = new OutlineContour();
        this._dragContour.setDockingManager(this);
        this._dragContour.beginDraggingFrame(frame, mouseX, mouseY, relativeX, relativeY, (single || !this.isDragAllTabs()) && !frame.isAlwaysStayInGroup());
        this.addGlobalEventHandler();
    }

    @Override
    public void pauseDragFrame() {
        if (this._dragContour != null) {
            this._dragContour.pauseDragFrame();
        }
    }

    @Override
    public boolean isDragging() {
        return this._dragContour != null;
    }

    @Override
    public void cancelDragging() {
        this.removeGlobalEventHandler();
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalCancelDragging();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockingManager.this.internalCancelDragging();
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    private void internalCancelDragging() {
        if (this.isUseGlassPaneEnabled()) {
            DockingUtils.setGlassPaneVisible(this, false);
            this.getRootPaneContainer().getGlassPane().setVisible(this._glassPaneVisibility);
        }
        if (this._dragContour != null) {
            this._dragContour.cancelDragFrame();
            this._dragContour = null;
        }
    }

    private void enableDraggingFrameDocking(boolean enable) {
        if (this._dragContour != null) {
            if (this._dragContour.isAllowDocking() && !enable) {
                this._dragContour.setAllowDocking(false);
                this.dragFrame(this._dragContour.getSaveDraggedComponent(), this._dragContour.getSaveX(), this._dragContour.getSaveY(), this._dragContour.getSaveMouseModifier());
            } else if (!this._dragContour.isAllowDocking() && enable) {
                this._dragContour.setAllowDocking(true);
                this.dragFrame(this._dragContour.getSaveDraggedComponent(), this._dragContour.getSaveX(), this._dragContour.getSaveY(), this._dragContour.getSaveMouseModifier());
            }
        }
    }

    @Override
    public void dragFrame(JComponent f, int newX, int newY, int mouseModifiers) {
        if (this._dragContour == null) {
            return;
        }
        if (!(f instanceof DockableFrame)) {
            return;
        }
        if (this.isUseGlassPaneEnabled() && !this.getRootPaneContainer().getGlassPane().isVisible()) {
            DockingUtils.setGlassPaneVisible(this, true);
        }
        this._dragContour.dragFrame(f, newX, newY, mouseModifiers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endDraggingFrame(JComponent f) {
        this.removeGlobalEventHandler();
        if (this.isUseGlassPaneEnabled()) {
            DockingUtils.setGlassPaneVisible(this, false);
            this.getRootPaneContainer().getGlassPane().setVisible(this._glassPaneVisibility);
        }
        if (!(f instanceof DockableFrame)) {
            return;
        }
        if (this._dragContour != null && this._dragContour.isVisible()) {
            boolean isFloating;
            DockableFrame dockableFrame = (DockableFrame)f;
            Component attachedComponent = this._dragContour.getAttachedComponent();
            if (!this._dragContour.isFloating() && attachedComponent == null) {
                if (!dockableFrame.isShowing()) {
                    return;
                }
                Rectangle bounds = dockableFrame.getBounds();
                Point p = dockableFrame.getLocationOnScreen();
                bounds.setLocation(p);
                try {
                    dockableFrame.setSettingSize(true);
                    dockableFrame.setUndockedBounds(bounds);
                }
                finally {
                    dockableFrame.setSettingSize(false);
                }
                this._dragContour.setVisible(false);
                this._dragContour.cleanup();
                this._dragContour = null;
                return;
            }
            if (attachedComponent != null && this._dragContour.getAttachedDockingManager() != null && this._dragContour.getAttachedDockingManager() != dockableFrame.getDockingManager()) {
                FrameContainer frameContainer = (FrameContainer)dockableFrame.getParent();
                FrameContainer newFrameContainer = this.createFrameContainer();
                if (!this._dragContour.isSingle() && frameContainer.getTabCount() > 1) {
                    int selectedIndex = frameContainer.getSelectedIndex();
                    ArrayList<DockableFrame> frames = new ArrayList<DockableFrame>();
                    for (int i = 0; i < frameContainer.getTabCount(); ++i) {
                        frames.add(frameContainer.getFrame(i));
                    }
                    for (DockableFrame frame : frames) {
                        boolean transferred = false;
                        DockingManager oppositeDockingManager = null;
                        if (this._dragContour.getAttachedDockingManager().getFrame(frame.getKey()) == null) {
                            oppositeDockingManager = frame.getDockingManager();
                            oppositeDockingManager.removeFrame(frame.getKey());
                            transferred = true;
                        }
                        PreviousState.disposePreviousState(frame.getContext().getDockPreviousState());
                        PreviousState.disposePreviousState(frame.getContext().getFloatPreviousState());
                        PreviousState.disposePreviousState(frame.getContext().getClosePreviousState());
                        PreviousState.disposePreviousState(frame.getContext().getHiddenPreviousState());
                        PreviousState.disposePreviousState(frame.getContext().getAutohidePreviousState());
                        this._dragContour.getAttachedDockingManager().addFrame(frame);
                        if (transferred) {
                            frame.fireDockableFrameEvent(4013, oppositeDockingManager);
                        }
                        newFrameContainer.addTab(frame);
                    }
                    newFrameContainer.setSelectedIndex(selectedIndex);
                    if (this._dragContour.getAttachedDockingManager() != null) {
                        newFrameContainer.setDockingManager(this._dragContour.getAttachedDockingManager());
                    }
                } else {
                    boolean transferred = false;
                    DockingManager oppositeDockingManager = null;
                    if (this._dragContour.getAttachedDockingManager().getFrame(dockableFrame.getKey()) == null) {
                        oppositeDockingManager = dockableFrame.getDockingManager();
                        oppositeDockingManager.removeFrame(dockableFrame.getKey());
                        transferred = true;
                    }
                    PreviousState.disposePreviousState(dockableFrame.getContext().getDockPreviousState());
                    PreviousState.disposePreviousState(dockableFrame.getContext().getFloatPreviousState());
                    PreviousState.disposePreviousState(dockableFrame.getContext().getClosePreviousState());
                    PreviousState.disposePreviousState(dockableFrame.getContext().getHiddenPreviousState());
                    PreviousState.disposePreviousState(dockableFrame.getContext().getAutohidePreviousState());
                    this._dragContour.getAttachedDockingManager().addFrame(dockableFrame);
                    if (transferred) {
                        dockableFrame.fireDockableFrameEvent(4013, oppositeDockingManager);
                    }
                    this._dragContour.getAttachedDockingManager().activateFrame(dockableFrame.getKey());
                }
            }
            boolean bl = isFloating = this._dragContour.isFloating() || !DockingUtils.containsInMainContainer(this._dragContour.getAttachedDockingManager().getDockedFrameContainer(), attachedComponent);
            if (dockableFrame.isFloated() && !isFloating) {
                DockingUtils.saveFloatPreviousState(dockableFrame, this._dragContour.isSingle());
            } else if (dockableFrame.isDocked() && isFloating) {
                DockingUtils.saveDockPreviousState(dockableFrame, this._dragContour.isSingle());
            }
            if (this._dragContour.isFloating()) {
                this.addUndo(this.getResourceString("Undo.dragging"));
                this.saveState(f);
                Rectangle bounds = this._dragContour.getContourBounds();
                Point startPoint = new Point(bounds.x, bounds.y);
                Point p = this._dragContour.getLayeredPane().getLocation();
                SwingUtilities.convertPointToScreen(p, this._dragContour.getLayeredPane());
                startPoint.x += p.x;
                startPoint.y += p.y;
                bounds.x = startPoint.x;
                bounds.y = startPoint.y;
                this.floatFrame(dockableFrame.getKey(), bounds, this._dragContour.isSingle());
                this.activateFrame(dockableFrame.getKey());
            } else {
                this.addUndo(this.getResourceString("Undo.dragging"));
                this.saveState(f);
                dockableFrame.internalSetPreferredSize();
                if (this._dragContour.isTabDocking()) {
                    if (attachedComponent instanceof BasicDockableFrameTitlePane) {
                        if (!this._dragContour.isSingle() && dockableFrame.getParent() != null && dockableFrame.getParent() instanceof FrameContainer && ((FrameContainer)dockableFrame.getParent()).getTabCount() > 1) {
                            this.internalDockFrame((FrameContainer)dockableFrame.getParent(), (BasicDockableFrameTitlePane)attachedComponent);
                        } else {
                            this.internalDockFrame(dockableFrame, (BasicDockableFrameTitlePane)attachedComponent);
                        }
                        this.internalActivateFrame(dockableFrame);
                    } else if (attachedComponent instanceof FrameContainer) {
                        DockableFrame selectedFrame = ((FrameContainer)attachedComponent).getSelectedFrame();
                        if (!this._dragContour.isSingle() && dockableFrame.getParent() != null && dockableFrame.getParent() instanceof FrameContainer && ((FrameContainer)dockableFrame.getParent()).getTabCount() > 1) {
                            if (selectedFrame == null) {
                                this.internalDockFrame((FrameContainer)dockableFrame.getParent(), (FrameContainer)attachedComponent);
                            } else {
                                this.internalDockFrame((FrameContainer)dockableFrame.getParent(), selectedFrame);
                            }
                        } else if (selectedFrame == null) {
                            this.internalDockFrame(dockableFrame, (FrameContainer)attachedComponent, true);
                        } else {
                            this.internalDockFrame(dockableFrame, selectedFrame);
                        }
                    } else if (attachedComponent instanceof Workspace) {
                        FrameContainer targetFC = this.createFrameContainer();
                        ContainerContainer targetCC = this.createContainerContainer();
                        targetCC.addPane(targetFC);
                        this._dragContour.getAttachedDockingManager().getWorkspace().add((Component)targetCC, "Center");
                        if (!this._dragContour.isSingle() && dockableFrame.getParent() != null && dockableFrame.getParent() instanceof FrameContainer && ((FrameContainer)dockableFrame.getParent()).getTabCount() > 1) {
                            this.internalDockFrame((FrameContainer)dockableFrame.getParent(), targetFC);
                        } else {
                            this.internalDockFrame(dockableFrame, targetFC, true);
                        }
                        if (this._dragContour.getAttachedDockingManager() instanceof DefaultDockingManager && this._dragContour.getAttachedDockingManager() != this) {
                            targetFC.setDockingManager(this._dragContour.getAttachedDockingManager());
                            targetCC.setDockingManager(this._dragContour.getAttachedDockingManager());
                            for (int i = 0; i < targetFC.getTabCount(); ++i) {
                                DockableFrame frame = targetFC.getFrame(i);
                                if (frame == null) continue;
                                ((DefaultDockingManager)this._dragContour.getAttachedDockingManager())._hiddenFrames.remove(frame.getKey());
                            }
                        }
                    }
                } else if (attachedComponent instanceof ContainerContainerDivider) {
                    if (!this._dragContour.isSingle() && dockableFrame.getParent() != null && dockableFrame.getParent() instanceof FrameContainer && ((FrameContainer)dockableFrame.getParent()).getTabCount() > 1) {
                        this.internalDockFrame((JComponent)((FrameContainer)dockableFrame.getParent()), (ContainerContainerDivider)attachedComponent);
                    } else {
                        this.internalDockFrame((JComponent)dockableFrame, (ContainerContainerDivider)attachedComponent);
                    }
                } else {
                    int side = this._dragContour.getAttachedSide();
                    if (attachedComponent == this.getDockedFrameContainer()) {
                        if (!this._dragContour.isSingle() && dockableFrame.getParent() != null && dockableFrame.getParent() instanceof FrameContainer && ((FrameContainer)dockableFrame.getParent()).getTabCount() > 1) {
                            this.internalDockFrame((JComponent)((FrameContainer)dockableFrame.getParent()), (DockedFrameContainer)attachedComponent, side, false);
                        } else {
                            this.internalDockFrame((JComponent)dockableFrame, (DockedFrameContainer)attachedComponent, side, false);
                        }
                    } else if (attachedComponent != null) {
                        if (this.getWorkspace().isAncestorOf(attachedComponent)) {
                            attachedComponent = this.getWorkspace();
                        }
                        if (!this._dragContour.isSingle() && dockableFrame.getParent() != null && dockableFrame.getParent() instanceof FrameContainer && ((FrameContainer)dockableFrame.getParent()).getTabCount() > 1) {
                            this.internalDockFrame((FrameContainer)dockableFrame.getParent(), attachedComponent, side);
                        } else {
                            this.internalDockFrame((JComponent)dockableFrame, attachedComponent, side);
                        }
                    }
                }
            }
            this.loadState();
            this.resetLayout();
        }
        if (this._dragContour != null && this._dragContour.getLayeredPane() != null) {
            Container floatingContainer;
            Container topContainer = this._dragContour.getLayeredPane().getTopLevelAncestor();
            if (!this.isUseDecoratedFloatingContainer() && topContainer instanceof FloatingContainer && ((FloatingContainer)((Object)topContainer)).getDockingManager() == this) {
                this.updateUndecorated((FloatingContainer)((Object)topContainer));
            }
            if (this.isUseDecoratedFloatingContainer() && (floatingContainer = SwingUtilities.getAncestorOfClass(FloatingContainer.class, f)) instanceof FloatingContainer) {
                ((FloatingContainer)((Object)floatingContainer)).updateTitle();
            }
        }
        if (this._dragContour != null) {
            this._dragContour.setVisible(false);
            this._dragContour.cleanup();
            this._dragContour = null;
        }
        DockingUtils.validateLocations(this.getDockedFrameContainer(), this.getWorkspace());
        this.activateFront(false);
    }

    @Override
    public ContainerContainer createContainerContainer() {
        ContainerContainer container = new ContainerContainer(this);
        container.applyComponentOrientation(this.getDockedFrameContainer().getComponentOrientation());
        return container;
    }

    private boolean internalDockFrame(JComponent dockableComponent, ContainerContainer containerContainer, int side, boolean considerInitSplitPriority) {
        if (side == 1 || side == 2 || side == 8 || side == 4) {
            Container parent = containerContainer.getParent();
            JideSwingUtilities.removeFromParentWithFocusTransfer(dockableComponent);
            FrameContainer componentToBeDocked = this.wrapInFrameContainer(dockableComponent);
            if (parent != this.getDockedFrameContainer()) {
                if (parent.getParent() != null) {
                    if ((parent = parent.getParent()) != this.getDockedFrameContainer()) {
                        throw new RuntimeException("Cannot dock to ContainerContainer if its parent is not main container");
                    }
                } else {
                    throw new RuntimeException("Cannot dock to ContainerContainer if its parent is not main container");
                }
            }
            if (considerInitSplitPriority) {
                this.dockToContainerContainer(componentToBeDocked, containerContainer, side, parent);
            } else {
                this.dockToContainerContainerDuringDragging(componentToBeDocked, containerContainer, side, parent);
            }
            containerContainer.setVisible(true);
            componentToBeDocked.resetDockID();
            this.docknizeFrames(componentToBeDocked);
            return true;
        }
        return false;
    }

    private void docknizeFrames(JComponent dockableComponent) {
        DockingManager dockingManager = DockingUtils.getDockingManager(dockableComponent);
        if (dockingManager != null && !DockingUtils.containsInMainContainer(dockingManager.getDockedFrameContainer(), dockableComponent)) {
            if (dockableComponent instanceof DockableFrame) {
                try {
                    ((DockableFrame)dockableComponent).setFloated(true);
                }
                catch (PropertyVetoException e) {
                    throw new RuntimeException(e);
                }
            } else if (dockableComponent instanceof FrameContainer) {
                try {
                    DockingUtils.floatizeChildrenOf(dockableComponent, this);
                }
                catch (PropertyVetoException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            Border border = UIDefaultsLookup.getBorder("JideTabbedPane.border");
            DockingUtils.setFrameContainerBorder(dockableComponent, border);
            border = UIDefaultsLookup.getBorder("DockableFrame.border");
            DockingUtils.setDockableFrameBorder(dockableComponent, border);
            if (dockableComponent instanceof DockableFrame) {
                this.internalDockFrame((DockableFrame)dockableComponent);
            } else if (dockableComponent instanceof FrameContainer) {
                FrameContainer frameContainer = (FrameContainer)dockableComponent;
                for (int i = 0; i < frameContainer.getTabCount(); ++i) {
                    DockableFrame frame = (DockableFrame)frameContainer.getComponentAt(i);
                    this.internalDockFrame(frame);
                }
            }
            DockingUtils.validateLocations(this.getDockedFrameContainer(), this.getWorkspace());
        }
    }

    private FrameContainer wrapInFrameContainer(JComponent dockableComponent) {
        FrameContainer componentToBeDocked;
        if (dockableComponent instanceof DockableFrame) {
            DockableFrame frame = (DockableFrame)dockableComponent;
            FrameContainer frameContainer = this.createFrameContainer();
            frameContainer.setDockingManager(frame.getDockingManager());
            frameContainer.addTab(frame);
            componentToBeDocked = frameContainer;
        } else if (dockableComponent instanceof FrameContainer) {
            componentToBeDocked = (FrameContainer)dockableComponent;
            componentToBeDocked.updateUI();
        } else {
            throw new RuntimeException("Component cannot be docked.");
        }
        return componentToBeDocked;
    }

    private boolean internalDockFrame(JComponent componentToBeDocked, DockedFrameContainer dockedFrameContainer, int side, boolean considerInitSplitPriority) {
        for (int i = 0; i < dockedFrameContainer.getNormalContainer().getComponentCount(); ++i) {
            Component component = dockedFrameContainer.getNormalContainer().getComponent(i);
            if (!(component instanceof ContainerContainer)) continue;
            return this.internalDockFrame(componentToBeDocked, (ContainerContainer)component, side, considerInitSplitPriority);
        }
        return false;
    }

    private boolean internalDockFrame(DockableFrame f, DockedFrameContainer dockedFrameContainer, boolean init) {
        f.internalSetPreferredSize();
        if (init && this.dockFrameByInitState(dockedFrameContainer, (FrameContainer)f.getParent(), f)) {
            return true;
        }
        if (f.getContext().getInitSide() == 16) {
            this.internalDockFrame(f, 16, f.getContext().getInitIndex());
            return true;
        }
        return this.internalDockFrame((JComponent)f, dockedFrameContainer, f.getContext().getInitSide(), true);
    }

    private boolean dockFrameByInitState(DockedFrameContainer dockedFrameContainer, FrameContainer fc, DockableFrame f) {
        DockableFrame existingFrame = (DockableFrame)PreviousState.findDockedComponentByInitState(f.getDockingManager(), dockedFrameContainer, f.getContext().getInitSide(), f.getContext().getInitIndex());
        if (existingFrame != null) {
            if (fc == null || fc.getTabCount() == 0 || dockedFrameContainer == null || !dockedFrameContainer.isAncestorOf(fc)) {
                if (this.isTabDockAllowed()) {
                    this.internalDockFrame(f, existingFrame);
                } else {
                    int side = 2;
                    switch (f.getContext().getInitSide()) {
                        case 8: {
                            side = this.getInitWestSplit() == 0 ? 2 : 8;
                            break;
                        }
                        case 2: {
                            side = this.getInitSouthSplit() == 0 ? 2 : 4;
                            break;
                        }
                        case 1: {
                            side = this.getInitNorthSplit() == 0 ? 2 : 4;
                            break;
                        }
                        case 4: {
                            side = this.getInitEastSplit() == 0 ? 2 : 4;
                            break;
                        }
                        case 16: {
                            side = this.getInitCenterSplit() == 0 ? 2 : 4;
                        }
                    }
                    this.internalDockFrame((JComponent)f, existingFrame.getParent(), side);
                }
            } else {
                this.internalDockFrame(fc, existingFrame);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalDockFrame(JComponent dockableComponent, Component component, int side) {
        int newIndex;
        int index;
        Container parent = component.getParent();
        if (!(parent instanceof ContainerContainer)) {
            throw new RuntimeException("Cannot dock to a component whose parent is not a ContainerContainer");
        }
        ContainerContainer containerContainer = (ContainerContainer)parent;
        Object object = parent.getTreeLock();
        synchronized (object) {
            index = containerContainer.indexOfPane(component);
            JideSwingUtilities.removeFromParentWithFocusTransfer(dockableComponent);
            if (dockableComponent.getParent() instanceof FrameContainer) {
                FrameContainer frameContainer = (FrameContainer)dockableComponent.getParent();
                frameContainer.remove(dockableComponent);
                if (frameContainer.getSelectedFrame() != null) {
                    frameContainer.getSelectedFrame().fireDockableFrameEvent(4009);
                }
            } else if (dockableComponent.getParent() != null) {
                ContainerContainer cc = (ContainerContainer)dockableComponent.getParent();
                cc.remove(dockableComponent);
            }
            newIndex = containerContainer.indexOfPane(component);
        }
        int[] dividers = containerContainer.getDividerLocations();
        JideSwingUtilities.removeFromParentWithFocusTransfer(dockableComponent);
        FrameContainer componentToBeDocked = this.wrapInFrameContainer(dockableComponent);
        boolean ltr = dockableComponent.getComponentOrientation().isLeftToRight();
        int adjustSide = side == 8 && !ltr ? 4 : (side == 4 && !ltr ? 8 : side);
        switch (adjustSide) {
            case 8: {
                if (containerContainer.getOrientation() == 1) {
                    if (newIndex == -1) {
                        containerContainer.insertPane(componentToBeDocked, index);
                        break;
                    }
                    containerContainer.insertPane(componentToBeDocked, newIndex);
                    break;
                }
                ContainerContainer newContainer = this.createContainerContainer();
                DockingManager peerDockingManager = componentToBeDocked.getDockingManager();
                if (peerDockingManager != null && peerDockingManager != this) {
                    newContainer.setDockingManager(peerDockingManager);
                }
                newContainer.setOrientation(1);
                newContainer.add(componentToBeDocked);
                containerContainer.insertPane(newContainer, index);
                newContainer.add(component);
                break;
            }
            case 4: {
                if (containerContainer.getOrientation() == 1) {
                    if (newIndex == -1) {
                        containerContainer.insertPane(componentToBeDocked, index);
                        break;
                    }
                    containerContainer.insertPane(componentToBeDocked, newIndex + 1);
                    break;
                }
                ContainerContainer newContainer = this.createContainerContainer();
                DockingManager peerDockingManager = componentToBeDocked.getDockingManager();
                if (peerDockingManager != null && peerDockingManager != this) {
                    newContainer.setDockingManager(peerDockingManager);
                }
                newContainer.setOrientation(1);
                newContainer.add(componentToBeDocked);
                containerContainer.insertPane(newContainer, index);
                newContainer.add(component, 0);
                break;
            }
            case 1: {
                if (containerContainer.getOrientation() == 0) {
                    if (newIndex == -1) {
                        containerContainer.insertPane(componentToBeDocked, index);
                        break;
                    }
                    containerContainer.insertPane(componentToBeDocked, newIndex);
                    break;
                }
                ContainerContainer newContainer = this.createContainerContainer();
                DockingManager peerDockingManager = componentToBeDocked.getDockingManager();
                if (peerDockingManager != null && peerDockingManager != this) {
                    newContainer.setDockingManager(peerDockingManager);
                }
                newContainer.setOrientation(0);
                newContainer.add(componentToBeDocked);
                containerContainer.insertPane(newContainer, index);
                newContainer.add(component);
                break;
            }
            case 2: {
                if (containerContainer.getOrientation() == 0) {
                    if (newIndex == -1) {
                        containerContainer.insertPane(componentToBeDocked, index);
                        break;
                    }
                    containerContainer.insertPane(componentToBeDocked, newIndex + 1);
                    break;
                }
                ContainerContainer newContainer = this.createContainerContainer();
                DockingManager peerDockingManager = componentToBeDocked.getDockingManager();
                if (peerDockingManager != null && peerDockingManager != this) {
                    newContainer.setDockingManager(peerDockingManager);
                }
                newContainer.setOrientation(0);
                newContainer.add(componentToBeDocked);
                containerContainer.insertPane(newContainer, index);
                newContainer.add(component, 0);
                break;
            }
            default: {
                if (dockableComponent instanceof DockableFrame) {
                    this.internalDockFrame((DockableFrame)dockableComponent, 16, 0);
                }
                return;
            }
        }
        if (dividers.length == containerContainer.getPaneCount() - 1) {
            containerContainer.setDividerLocations(dividers);
        }
        componentToBeDocked.resetDockID();
        this.docknizeFrames(componentToBeDocked);
        DockingManager targetManager = containerContainer.getDockingManager();
        if (targetManager instanceof DefaultDockingManager && targetManager != this) {
            for (int i = 0; i < componentToBeDocked.getTabCount(); ++i) {
                DockableFrame frame = componentToBeDocked.getFrame(i);
                if (frame == null) continue;
                ((DefaultDockingManager)targetManager).internalDockFrame(frame);
                ((DefaultDockingManager)targetManager)._hiddenFrames.remove(frame.getKey());
            }
        }
    }

    private void internalDockFrame(JComponent dockableComponent, ContainerContainerDivider divider) {
        Container parent;
        JideSwingUtilities.removeFromParentWithFocusTransfer(dockableComponent);
        JideSplitPane pane = divider.getJideSplitPane();
        int dividerIndex = pane.indexOfDivider(divider);
        Container containerLeft = (Container)pane.getPaneAt(dividerIndex);
        boolean left = false;
        if (containerLeft != null && (containerLeft.equals(dockableComponent) || containerLeft.isAncestorOf(dockableComponent))) {
            left = true;
        }
        if ((parent = dockableComponent.getParent()) != null) {
            parent.remove(dockableComponent);
        }
        int newDividerIndex = pane.indexOfDivider(divider);
        FrameContainer componentToBeDocked = this.wrapInFrameContainer(dockableComponent);
        if (newDividerIndex == -1) {
            pane.insertPane(componentToBeDocked, left ? dividerIndex : dividerIndex + 1);
        } else {
            pane.insertPane(componentToBeDocked, newDividerIndex + 1);
        }
        pane.validate();
        componentToBeDocked.resetDockID();
        this.docknizeFrames(componentToBeDocked);
    }

    private void internalDockFrame(FrameContainer frameContainer, BasicDockableFrameTitlePane titleBar) {
        if (frameContainer.getTabCount() == 0) {
            return;
        }
        DockableFrame[] dockableFrames = new DockableFrame[frameContainer.getTabCount()];
        for (int i = 0; i < frameContainer.getTabCount(); ++i) {
            dockableFrames[i] = (DockableFrame)frameContainer.getComponentAt(i);
            if (dockableFrames[i] != titleBar.getParent()) continue;
            return;
        }
        frameContainer.removeAll();
        for (DockableFrame dockableFrame : dockableFrames) {
            this.internalDockFrame(dockableFrame, titleBar);
        }
    }

    private void internalDockFrame(FrameContainer frameContainer, DockableFrame existFrame) {
        if (frameContainer.getTabCount() == 0) {
            return;
        }
        DockableFrame[] dockableFrames = new DockableFrame[frameContainer.getTabCount()];
        for (int i = 0; i < frameContainer.getTabCount(); ++i) {
            dockableFrames[i] = (DockableFrame)frameContainer.getComponentAt(i);
        }
        frameContainer.removeAll();
        for (DockableFrame dockableFrame : dockableFrames) {
            this.internalDockFrame(dockableFrame, existFrame);
        }
    }

    private void internalDockFrame(FrameContainer frameContainer, FrameContainer existingFrameContainer) {
        if (frameContainer.getTabCount() == 0) {
            return;
        }
        DockableFrame[] dockableFrames = new DockableFrame[frameContainer.getTabCount()];
        for (int i = 0; i < frameContainer.getTabCount(); ++i) {
            dockableFrames[i] = (DockableFrame)frameContainer.getComponentAt(i);
        }
        frameContainer.removeAll();
        for (DockableFrame dockableFrame : dockableFrames) {
            this.internalDockFrame(dockableFrame, existingFrameContainer, true);
        }
    }

    @Override
    public void moveFrame(String frameKey, String destFrameKey) {
        final DockableFrame f = this.getFrame(frameKey);
        final DockableFrame destFrame = this.getFrame(destFrameKey);
        if (f == null) {
            throw new IllegalArgumentException("DockableFrame " + frameKey + " doesn't exist");
        }
        if (destFrame == null) {
            throw new IllegalArgumentException("DockableFrame " + destFrameKey + " doesn't exist");
        }
        if (destFrame == f) {
            return;
        }
        if (f.getContext() == null || !f.isAvailable()) {
            return;
        }
        if (destFrame.isHidden()) {
            return;
        }
        if (destFrame.isAutohide() || destFrame.isAutohideShowing()) {
            AutoHideContainer autohideContainer = this.getAutoHideContainer(destFrame.getContext().getCurrentDockSide());
            if (autohideContainer == null) {
                return;
            }
            this.autohideFrame(frameKey, destFrame.getContext().getCurrentDockSide(), autohideContainer.getGroupIndex(destFrame));
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            if (destFrame.isMaximized()) {
                this.internalRestoreFrame(true);
            }
            if (f.isAutohide() || f.isAutohideShowing()) {
                this.internalDockAutohideFrame(f, false);
            }
            this.internalDockFrame(f, (BasicDockableFrameTitlePane)destFrame.getUI().getTitlePane());
            this.moveToFront(f);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (destFrame.isMaximized()) {
                            DefaultDockingManager.this.internalRestoreFrame(true);
                        }
                        DefaultDockingManager.this.internalDockFrame(f, (BasicDockableFrameTitlePane)destFrame.getUI().getTitlePane());
                        DefaultDockingManager.this.moveToFront(f);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    @Override
    public void moveFrame(String frameKey, String destFrameKey, final int side) {
        if (side != 4 && side != 8 && side != 1 && side != 2) {
            this.moveFrame(frameKey, destFrameKey);
            return;
        }
        final DockableFrame f = this.getFrame(frameKey);
        final DockableFrame destFrame = this.getFrame(destFrameKey);
        if (f == null) {
            throw new IllegalArgumentException("DockableFrame " + frameKey + " doesn't exist");
        }
        if (destFrame == null) {
            throw new IllegalArgumentException("DockableFrame " + destFrameKey + " doesn't exist");
        }
        if (f.getContext() == null || !f.isAvailable()) {
            return;
        }
        if (destFrame.isAutohide() || destFrame.isAutohideShowing()) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            if (destFrame.isMaximized()) {
                this.internalRestoreFrame(true);
            }
            this.saveState(f);
            this.internalDockFrame((JComponent)f, destFrame.getParent(), side);
            this.moveToFront(f);
            this.loadState();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (destFrame.isMaximized()) {
                            DefaultDockingManager.this.internalRestoreFrame(true);
                        }
                        DefaultDockingManager.this.saveState(f);
                        DefaultDockingManager.this.internalDockFrame((JComponent)f, destFrame.getParent(), side);
                        DefaultDockingManager.this.moveToFront(f);
                        DefaultDockingManager.this.loadState();
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    private void internalDockFrame(DockableFrame dockableFrame, BasicDockableFrameTitlePane titleBar) {
        Container parent = titleBar.getParent();
        while (!(parent instanceof FrameContainer) && (parent = parent.getParent()) != null) {
        }
        boolean sameTitle = false;
        this.saveState(dockableFrame);
        DockableFrame existFrame = (DockableFrame)titleBar.getParent();
        if (existFrame.equals(dockableFrame)) {
            sameTitle = true;
        }
        if (parent != null) {
            FrameContainer frameContainer = (FrameContainer)parent;
            if (frameContainer.getTabCount() == 1 && sameTitle) {
                this.internalDockFrame(dockableFrame);
                this.loadState();
                return;
            }
            JideSwingUtilities.removeFromParentWithFocusTransfer(dockableFrame);
            frameContainer.addTab(dockableFrame, true);
            frameContainer.setSelectedIndex(frameContainer.getFrameIndex(dockableFrame), false);
            frameContainer.scrollSelectedTabToVisible(true);
            dockableFrame.resetDockID();
        } else if (existFrame.getParent() != null) {
            FrameContainer frameContainer = this.createFrameContainer();
            ContainerContainer container = (ContainerContainer)existFrame.getParent();
            container.add((Component)frameContainer, "Center");
            JideSwingUtilities.removeFromParentWithFocusTransfer(dockableFrame);
            frameContainer.addTab(dockableFrame, true);
            frameContainer.addTab(existFrame, true);
            frameContainer.setSelectedIndex(frameContainer.getFrameIndex(dockableFrame));
            dockableFrame.resetDockID();
        }
        this.internalDockFrame(dockableFrame);
        this.loadState();
    }

    private void internalDockFrame(DockableFrame dockableFrame, DockableFrame existFrame) {
        Container parent = SwingUtilities.getAncestorOfClass(FrameContainer.class, existFrame);
        boolean sameTitle = false;
        if (existFrame.equals(dockableFrame)) {
            sameTitle = true;
        }
        if (parent != null) {
            FrameContainer frameContainer = (FrameContainer)parent;
            if (frameContainer.getTabCount() == 1 && sameTitle) {
                this.internalDockFrame(dockableFrame);
                return;
            }
            JideSwingUtilities.removeFromParentWithFocusTransfer(dockableFrame);
            frameContainer.addTab(dockableFrame, true);
            frameContainer.setSelectedIndex(frameContainer.getFrameIndex(dockableFrame));
            frameContainer.scrollSelectedTabToVisible(true);
            dockableFrame.resetDockID();
        } else {
            FrameContainer frameContainer = this.createFrameContainer();
            ContainerContainer container = (ContainerContainer)SwingUtilities.getAncestorOfClass(ContainerContainer.class, existFrame);
            if (container != null) {
                container.add(frameContainer);
            }
            JideSwingUtilities.removeFromParentWithFocusTransfer(dockableFrame);
            JideSwingUtilities.removeFromParentWithFocusTransfer(existFrame);
            frameContainer.addTab(dockableFrame, true);
            frameContainer.addTab(existFrame, true);
            frameContainer.setSelectedIndex(frameContainer.getFrameIndex(dockableFrame));
            dockableFrame.resetDockID();
        }
        this.internalDockFrame(dockableFrame);
    }

    private void internalDockFrame(DockableFrame dockableFrame, FrameContainer parentContainer, boolean suppressEvent) {
        JideSwingUtilities.removeFromParentWithFocusTransfer(dockableFrame);
        parentContainer.addTab(dockableFrame, suppressEvent);
        dockableFrame.resetDockID();
        this.internalDockFrame(dockableFrame);
    }

    @Override
    public void beginResizingFrame(JComponent f, int direction) {
        Container container;
        if (this._slidingAnimator != null && f.equals(this._slidingAnimator.getSlidingFrame())) {
            this.moveToFront(this._slidingAnimator.getSlidingFrame());
            this._slidingAnimator.showImmediately();
        }
        if (f instanceof FrameContainer && (container = f.getTopLevelAncestor()) instanceof FloatingContainer) {
            this._startingPoint = container.getLocation();
        }
    }

    @Override
    public void resizingFrame(JComponent f, int newX, int newY, int newWidth, int newHeight) {
        if (!this.isResizable()) {
            return;
        }
        if (f instanceof FrameContainer) {
            Container container = f.getTopLevelAncestor();
            if (container instanceof FloatingContainer) {
                container.setBounds(this._startingPoint.x + newX, this._startingPoint.y + newY, newWidth, newHeight);
                f.setBounds(0, 0, newWidth, newHeight);
                for (Container c = f.getParent(); c != null && !(c instanceof FloatingContainer); c = c.getParent()) {
                    c.setBounds(0, 0, newWidth, newHeight);
                }
            }
        } else {
            Object clientProperty = f.getClientProperty("HeavyweightWrapper");
            if (clientProperty instanceof HeavyweightWrapper) {
                ((HeavyweightWrapper)clientProperty).delegateSetBounds(newX, newY, newWidth, newHeight);
                ((HeavyweightWrapper)clientProperty).validate();
            } else {
                f.setBounds(newX, newY, newWidth, newHeight);
                f.validate();
            }
        }
        if (this._slidingAnimator != null && f.equals(this._slidingAnimator.getSlidingFrame())) {
            this.updateAutohideWidthHeight(this._slidingAnimator.getSlidingFrame());
            Window parentWindow = SwingUtilities.getWindowAncestor(this._slidingContainer);
            if (parentWindow != null) {
                parentWindow.validate();
            }
            this._slidingContainer.invalidate();
            this._slidingContainer.doLayout();
        }
    }

    @Override
    public void endResizingFrame(JComponent f) {
        if (f instanceof FrameContainer) {
            Container container = f.getTopLevelAncestor();
            if (container instanceof FloatingContainer) {
                f.setBounds(0, 0, container.getWidth(), container.getHeight());
                for (Container c = f.getParent(); c != null && !(c instanceof FloatingContainer); c = c.getParent()) {
                    c.setBounds(0, 0, container.getWidth(), container.getHeight());
                }
            }
        } else {
            Object clientProperty = f.getClientProperty("HeavyweightWrapper");
            if (clientProperty instanceof HeavyweightWrapper) {
                ((HeavyweightWrapper)clientProperty).validate();
                ((HeavyweightWrapper)clientProperty).repaint();
                ((HeavyweightWrapper)clientProperty).doLayout();
            } else {
                f.validate();
                f.repaint();
            }
        }
        this._startingPoint = null;
    }

    private void internalFloatOutFrame(DockableFrame f) {
        if (f.getContext() == null || !f.isAvailable()) {
            return;
        }
        this.saveState(f);
        Rectangle rectangle = f.getUndockedBounds();
        if (rectangle.x == 0 && rectangle.y == 0) {
            Point location;
            try {
                location = f.getLocationOnScreen();
            }
            catch (Exception e) {
                location = new Point(0, 0);
            }
            location.x += 20;
            location.y += 20;
            rectangle.setLocation(location);
        }
        this.floatFrame(f.getKey(), rectangle, true);
        this.loadState();
    }

    private void internalSetFrameDockable(DockableFrame frame, boolean dockable) {
        if (!dockable && frame.isDockable()) {
            FloatingContainer floatingContainer;
            int count;
            if (frame.isDocked()) {
                PreviousState dockState = PreviousState.createPreviousState(frame);
                PreviousState.disposePreviousState(frame.getDockPreviousState());
                frame.setDockPreviousState(dockState);
                this.internalFloatOutFrame(frame);
            } else if (frame.isFloated() && frame.getTopLevelAncestor() instanceof FloatingContainer && (count = DockingUtils.getDockableFrameCount(floatingContainer = (FloatingContainer)((Object)frame.getTopLevelAncestor()))) > 1) {
                this.internalFloatOutFrame(frame);
            }
            frame.setDockable(false);
        } else if (dockable) {
            frame.setDockable(true);
        }
    }

    @Override
    public void toggleDockable(String key) {
        final DockableFrame f = this.getFrame(key);
        if (f == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalToggleDockable(f);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockingManager.this.internalToggleDockable(f);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    private void internalToggleDockable(DockableFrame frame) {
        if (frame != null) {
            frame.setVisible(true);
            this.moveToFront(frame);
            if (frame.isDockable()) {
                this.internalSetFrameDockable(frame, false);
            } else {
                this.internalSetFrameDockable(frame, true);
            }
        }
    }

    @Override
    public void toggleAutohideState(String key) {
        this.toggleAutohideState(key, false);
    }

    public void toggleAutohideState(String key, final boolean single) {
        final DockableFrame f = this.getFrame(key);
        if (f == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalToggleAutohideState(f, single);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockingManager.this.internalToggleAutohideState(f, single);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    private void internalToggleAutohideState(DockableFrame frame, boolean single) {
        if (frame != null) {
            if (frame.isAutohideShowing() || frame.isAutohide()) {
                this.internalDockAutohideFrame(frame, single);
            } else {
                this.internalAutohideFrame(frame, frame.getPreferredAutohideSide());
            }
        }
    }

    @Override
    public void autohideFrame(String frameKey, int side, int index) {
        final DockableFrame f = this.getFrame(frameKey);
        if (f == null || f.shouldVetoShowing()) {
            return;
        }
        if (side != 1 && side != 2 && side != 4 && side != 8) {
            throw new IllegalArgumentException("Invalid argument side. side must be one of following values, DockContext#DOCK_SIDE_WEST, DockContext#DOCK_SIDE_EAST, DockContext#DOCK_SIDE_NORTH and DockContext#DOCK_SIDE_SOUTH.");
        }
        if (index < 0) {
            throw new IllegalArgumentException("Argument index must be a positive integer.");
        }
        final int s = side;
        final int i = index;
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalAutohideFrame(f, s, i);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockingManager.this.internalAutohideFrame(f, s, i);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    private void internalAutohideFrame(DockableFrame f, int side, int index) {
        String autohideShowingFrame;
        if (f.getContext() == null || !f.isAvailable()) {
            return;
        }
        this.saveState(f);
        if (f.getParent() instanceof FrameContainer) {
            f.getParent().remove(f);
        }
        if ((autohideShowingFrame = this.getAutohideShowingFrame()) != null) {
            this.stopShowingAutohideFrameImmediately();
            if (autohideShowingFrame.equals(f.getKey()) && side != f.getContext().getCurrentDockSide()) {
                this.internalDockAutohideFrame(f, true);
                this.internalAutohideFrame(f, side, index);
                return;
            }
        }
        if (f.isAutohide()) {
            AutoHideContainer c = this.getAutoHideContainer(f.getContext().getCurrentDockSide());
            c.removeFrame(f);
        }
        AutoHideContainer container = this.getAutoHideContainer(side);
        if (this.isGroupAllowedOnSidePane()) {
            container.addFrame(f, index);
        } else {
            container.addFrame(f, container.getGroups().size());
        }
        container.invalidate();
        this.resetLayout();
        this.loadState();
    }

    private void internalAutohideFrame(DockableFrame f, int preferredSide) {
        if (f.getContext() == null || !f.isAvailable()) {
            return;
        }
        if (!this.isAutohidable() || !f.isAutohidable()) {
            return;
        }
        if (this._slidingAnimator != null) {
            this._slidingAnimator.removeImmediately();
            this._slidingAnimator = null;
        }
        this.internalRestoreFrame(true);
        Container parent = f.getParent();
        if (parent == null || !(parent instanceof FrameContainer)) {
            return;
        }
        this.saveState(f);
        FrameContainer frameContainer = (FrameContainer)parent;
        DockingUtils.validateLocations(this.getDockedFrameContainer(), this.getWorkspace());
        int side = preferredSide == -1 ? this.getPreferredAutohideSide(f) : preferredSide;
        AutoHideContainer container = this.getAutoHideContainer(side);
        if (container == null) {
            return;
        }
        if (this.isAutohideAllTabs()) {
            for (int i = 0; i < frameContainer.getTabCount(); ++i) {
                DockableFrame dockableFrame = (DockableFrame)frameContainer.getComponentAt(i);
                if (!dockableFrame.isAutohidable() || dockableFrame.getPreferredAutohideSide() != -1 && dockableFrame.getPreferredAutohideSide() != side) continue;
                DockingUtils.saveAutohidePreviousState(dockableFrame);
                if (dockableFrame.isActive()) continue;
                this.moveToBack(dockableFrame);
            }
            if (!frameContainer.isAllAutohidable(side)) {
                FrameContainer parentContainer = this.createFrameContainer();
                for (int i = frameContainer.getTabCount() - 1; i >= 0; --i) {
                    DockableFrame dockableFrame = (DockableFrame)frameContainer.getComponentAt(i);
                    if (!dockableFrame.isAutohidable() || dockableFrame.getPreferredAutohideSide() != -1 && dockableFrame.getPreferredAutohideSide() != side) continue;
                    JideSwingUtilities.removeFromParentWithFocusTransfer(dockableFrame);
                    parentContainer.addTab(dockableFrame, true);
                }
                container.addGroup(parentContainer);
            } else {
                JideSwingUtilities.removeFromParentWithFocusTransfer(frameContainer);
                container.addGroup(frameContainer);
            }
        } else if (f.isAutohidable() && (f.getPreferredAutohideSide() == -1 || f.getPreferredAutohideSide() == side)) {
            DockingUtils.saveAutohidePreviousState(f);
            if (!f.isActive()) {
                this.moveToBack(f);
            }
            this.updateAutohideWidthHeight(f);
            FrameContainer fc = this.createFrameContainer();
            fc.addTab(f, true);
            container.addGroup(fc);
        }
        this.listenToAutoHideContainer(container);
        container.repaint();
        this.loadState();
        this.resetLayout();
        if (f.isActive()) {
            if (this.isShowWorkspace()) {
                this.activateWorkspace();
            } else {
                DockableFrameWorkspaceHandle handleFound = this.findNonAutoHideHandle();
                if (handleFound != null) {
                    handleFound.toFront();
                } else {
                    this.internalActivateFrame(null);
                }
            }
        }
    }

    private int getPreferredAutohideSide(DockableFrame f) {
        int defaultDockSide = f.getContext().getCurrentDockSide();
        if (this.isShowWorkspace()) {
            return defaultDockSide;
        }
        Container parent = f.getParent();
        if (parent == null) {
            return defaultDockSide;
        }
        Rectangle rect = parent.getBounds();
        if (rect.isEmpty()) {
            return f.getInitSide();
        }
        rect = SwingUtilities.convertRectangle(parent.getParent(), rect, this.getDockedFrameContainer());
        Rectangle bounds = this.getDockedFrameContainer().getBounds();
        int left = rect.x - bounds.x;
        int right = bounds.x + bounds.width - (rect.x + rect.width);
        int top = rect.y - bounds.y;
        int bottom = bounds.y + bounds.height - (rect.y + rect.height);
        if (top == 0 && defaultDockSide == 1) {
            return defaultDockSide;
        }
        if (left == 0 && defaultDockSide == 8) {
            return defaultDockSide;
        }
        if (right == 0 && defaultDockSide == 4) {
            return defaultDockSide;
        }
        if (bottom == 0 && defaultDockSide == 2) {
            return defaultDockSide;
        }
        if (top <= left && top <= right && top <= bottom) {
            return 1;
        }
        if (bottom <= left && bottom <= right) {
            return 2;
        }
        if (right <= left) {
            return 4;
        }
        return 8;
    }

    private void internalDockAutohideFrame(DockableFrame frame, boolean single) {
        if (this._slidingAnimator != null) {
            this._slidingAnimator.removeImmediately();
            this._slidingAnimator = null;
        }
        this.restoreFrame();
        int side = frame.getContext().getCurrentDockSide();
        AutoHideContainer autohideContainer = this.getAutoHideContainer(frame.getContext().getCurrentDockSide());
        if (autohideContainer == null) {
            return;
        }
        SidePaneGroup group = autohideContainer.getSidePaneGroup(frame);
        if (group == null) {
            throw new IllegalArgumentException("DockableFrame \"" + frame.getKey() + "\" is not in autohide mode.");
        }
        FrameContainer frameContainer = this.createFrameContainer();
        int index = -1;
        SidePaneItem itemToRemove = null;
        for (Object aGroup : group) {
            SidePaneItem item = (SidePaneItem)aGroup;
            DockableFrame dockableFrame = (DockableFrame)item.getComponent();
            if (single && dockableFrame != frame) continue;
            frameContainer.addTab(dockableFrame, true);
            if (frame != dockableFrame) continue;
            index = frameContainer.getFrameIndex(frame);
            itemToRemove = item;
        }
        if (!single || group.size() == 1) {
            autohideContainer.removeGroup(group);
        } else {
            group.remove(itemToRemove);
        }
        autohideContainer.repaint();
        if (index != -1) {
            frameContainer.setSelectedIndex(index);
        }
        if (!this.loadAutohidePreviousState(frameContainer)) {
            this.internalDockFrame((JComponent)frameContainer, this._dockedFrameContainer, side, true);
        }
        this.docknizeFrames(frameContainer);
        this.resetLayout();
        if (LOGGER_FOCUS.isLoggable(Level.FINE)) {
            LOGGER_FOCUS.fine(this.getProfileKey() + ":internalDockAutohideFrame");
        }
        this._skipActivateSelectedFrame = true;
        this.activateFront(true);
        this._skipActivateSelectedFrame = false;
    }

    @Override
    public AutoHideContainer getAutoHideContainer(int side) {
        if (side != 1 && side != 2 && side != 4 && side != 8) {
            side = 2;
        }
        switch (side) {
            case 4: {
                return this._eastContainer;
            }
            case 8: {
                return this._westContainer;
            }
            case 1: {
                return this._northContainer;
            }
            case 2: {
                return this._southContainer;
            }
        }
        throw new IllegalArgumentException("Invalid argument side. side must be one of following values, DockContext#DOCK_SIDE_WEST, DockContext#DOCK_SIDE_EAST, DockContext#DOCK_SIDE_NORTH and DockContext#DOCK_SIDE_SOUTH.");
    }

    void removeExtraContainerContainer() {
    }

    private void removeExtraFloatingFrames() {
        if (this.getRootPaneContainerAsComponent() != null && !this.getRootPaneContainerAsComponent().isVisible()) {
            return;
        }
        if (this._floatingFrames != null) {
            for (int i = this._floatingFrames.size() - 1; i >= 0; --i) {
                FloatingContainer floatingFrame = (FloatingContainer)this._floatingFrames.get(i);
                if (floatingFrame.isVisible()) continue;
                this.removeFloatingContainer(floatingFrame);
            }
        }
    }

    private void printLayout() {
        int tabs = 0;
        DockingUtils.printLayout(this._dockedFrameContainer, tabs);
        for (FloatingContainer container : this._floatingFrames) {
            if (!container.isVisible() || container.getContentPane().getComponentCount() != 1 || !(container.getContentPane().getComponent(0) instanceof ContainerContainer)) continue;
            DockingUtils.printLayout((ContainerContainer)container.getContentPane().getComponent(0), tabs);
        }
    }

    @Override
    public List<DockingManager.FrameHandle> getOrderedFrames() {
        if (this._zorderFrameHandles == null) {
            return new ArrayList<DockingManager.FrameHandle>();
        }
        return Collections.unmodifiableList(this._zorderFrameHandles);
    }

    private void activateFront(boolean includeAutoHideFrames) {
        if (this._loadingLayoutData || this._zorderFrameHandles == null || this._zorderFrameHandles.size() == 0) {
            return;
        }
        DockableFrameWorkspaceHandle handleFound = includeAutoHideFrames ? (DockableFrameWorkspaceHandle)this._zorderFrameHandles.get(0) : this.findNonAutoHideHandle();
        if (handleFound == null) {
            return;
        }
        if (LOGGER_FOCUS.isLoggable(Level.FINE)) {
            LOGGER_FOCUS.fine(this.getProfileKey() + ":activateFront " + handleFound);
        }
        if (handleFound.untyped instanceof DockableFrame) {
            DockableFrame selectedFrame;
            DockableFrame frameActivate = (DockableFrame)handleFound.untyped;
            if (!this._skipActivateSelectedFrame && frameActivate.getParent() instanceof FrameContainer && (selectedFrame = ((FrameContainer)frameActivate.getParent()).getSelectedFrame()) != null) {
                frameActivate = selectedFrame;
            }
            this.internalShowFrame(frameActivate);
            this.internalActivateFrame(frameActivate);
        } else {
            this.internalActivateFrame(null);
        }
    }

    public void setIgnoreFocus(boolean ignoreFocus) {
        this.ignoreFocus = ignoreFocus;
    }

    private void reFocusActiveFrame(boolean activeActiveFrame) {
        if (this.ignoreFocus) {
            return;
        }
        DockableFrame activeFrame = this.getFrame(this.getActiveFrameKey());
        Refocusable r = null;
        if (activeFrame != null && (activeActiveFrame || activeFrame.getKey().equals(this.getAutohideShowingFrame()))) {
            r = activeFrame;
        } else if (this.findNonAutoHideHandle() != null) {
            r = (Refocusable)this.findNonAutoHideHandle().untyped;
        }
        if (r != null && this.isRealized() && this._hasFocus && !this._togglingWindowVisibility && !_processingFocusEvent) {
            if (r instanceof DockableFrame && this._slidingAnimator != null && this._slidingAnimator.isSliding() && ((DockableFrame)r).getKey().equals(this._slidingAnimator.getSlidingFrame().getKey())) {
                ((Component)((Object)r)).requestFocusInWindow();
            } else {
                r.requestFocusInInternalWindow();
            }
        }
        if (r instanceof DockableFrame && (((DockableFrame)r).isAutohide() || ((DockableFrame)r).isAutohideShowing())) {
            this.internalStartShowingAutohideFrame((DockableFrame)r, ((DockableFrame)r).getContext().getCurrentDockSide(), 0);
        }
    }

    private DockableFrameWorkspaceHandle findNonAutoHideHandle() {
        DockableFrameWorkspaceHandle handleFound = null;
        int location = 0;
        boolean checkAllFrames = true;
        if (this.getFloatingContainerType() == 1) {
            checkAllFrames = false;
        }
        Component focusOwnerFiltered = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        Window windowFocusedFiltered = null;
        if (focusOwnerFiltered != null) {
            windowFocusedFiltered = DockingUtils.getWindowFor(focusOwnerFiltered);
        }
        DockableFrameWorkspaceHandle workspaceHandle = null;
        while (handleFound == null && this._zorderFrameHandles != null && location < this._zorderFrameHandles.size()) {
            DockableFrameWorkspaceHandle handleTest = (DockableFrameWorkspaceHandle)this._zorderFrameHandles.get(location);
            Window windowTest = DockingUtils.getWindowFor((Component)handleTest.untyped);
            if (handleTest.untyped instanceof DockableFrame) {
                DockableFrame frameTest = (DockableFrame)handleTest.untyped;
                if (!(!checkAllFrames && windowFocusedFiltered != windowTest || frameTest.isAutohide() || frameTest.isAutohideShowing() || workspaceHandle != null && !((Workspace)workspaceHandle.untyped).isAncestorOf(frameTest))) {
                    handleFound = handleTest;
                }
            } else if (handleTest.untyped instanceof Workspace) {
                workspaceHandle = handleTest;
            }
            ++location;
        }
        if (workspaceHandle != null && handleFound == null) {
            handleFound = workspaceHandle;
        }
        return handleFound;
    }

    protected boolean allowActivate(Object source) {
        return true;
    }

    private boolean moveToFront(Object source) {
        if (!this.allowActivate(source)) {
            return false;
        }
        DockableFrameWorkspaceHandle handle = this.getHandleFor(source);
        if (handle == null || this._zorderFrameHandles == null) {
            return false;
        }
        if (this._zorderFrameHandles.get(0) == handle) {
            this.activateFront(true);
            return true;
        }
        this._zorderFrameHandles.remove(handle);
        this._zorderFrameHandles.add(0, handle);
        this.activateFront(true);
        List<DockingManager.FrameHandle> listAfter = Collections.unmodifiableList(this._zorderFrameHandles);
        this.firePropertyChange("zOrder", null, listAfter);
        return true;
    }

    boolean adjustZorderWhileLoadingLayout(Object source) {
        DockableFrameWorkspaceHandle handle = this.getHandleFor(source);
        if (handle == null || this._zorderFrameHandles == null) {
            return false;
        }
        if (this._zorderFrameHandles.get(0) == handle) {
            return true;
        }
        if (source instanceof DockableFrame && ((DockableFrame)source).getParent() instanceof FrameContainer) {
            FrameContainer fc = (FrameContainer)((DockableFrame)source).getParent();
            for (int i = 0; i < this._zorderFrameHandles.size(); ++i) {
                DockableFrameWorkspaceHandle h = (DockableFrameWorkspaceHandle)this._zorderFrameHandles.get(i);
                if (h.untyped == source || fc.indexOfComponent((Component)h.untyped) == -1) continue;
                this._zorderFrameHandles.remove(handle);
                this._zorderFrameHandles.add(i, handle);
                break;
            }
            List<DockingManager.FrameHandle> listAfter = Collections.unmodifiableList(this._zorderFrameHandles);
            this.firePropertyChange("zOrder", null, listAfter);
            return true;
        }
        return false;
    }

    private void moveToBack(Object source) {
        int backLocation;
        DockableFrameWorkspaceHandle handle = this.getHandleFor(source);
        if (handle == null || this._zorderFrameHandles == null) {
            return;
        }
        int originalLocation = this._zorderFrameHandles.indexOf(handle);
        this._zorderFrameHandles.remove(handle);
        if (handle.untyped instanceof DockableFrame && !((DockableFrame)handle.untyped).isAutohide()) {
            for (backLocation = this._zorderFrameHandles.size(); backLocation > 0 && ((DockableFrameWorkspaceHandle)this._zorderFrameHandles.get((int)(backLocation - 1))).untyped instanceof DockableFrame && ((DockableFrame)((DockableFrameWorkspaceHandle)this._zorderFrameHandles.get((int)(backLocation - 1))).untyped).isAutohide(); --backLocation) {
            }
        }
        this._zorderFrameHandles.add(backLocation, handle);
        if (LOGGER_FOCUS.isLoggable(Level.FINE)) {
            LOGGER_FOCUS.fine(this.getProfileKey() + ":moveToBack");
        }
        this.activateFront(false);
        if (originalLocation != this._zorderFrameHandles.indexOf(handle)) {
            List<DockingManager.FrameHandle> listAfter = Collections.unmodifiableList(this._zorderFrameHandles);
            this.firePropertyChange("zOrder", null, listAfter);
        }
    }

    private void removeFromZOrder(Object source) {
        DockableFrameWorkspaceHandle handle = this.getHandleFor(source);
        if (handle == null || this._zorderFrameHandles == null) {
            return;
        }
        if (this._zorderFrameHandles.size() == 0) {
            return;
        }
        this._zorderFrameHandles.remove(handle);
        handle.isManaged = false;
        List<DockingManager.FrameHandle> listAfter = Collections.unmodifiableList(this._zorderFrameHandles);
        this.firePropertyChange("zOrder", null, listAfter);
    }

    void addToZOrder(Object source) {
        if (source == null) {
            return;
        }
        DockableFrameWorkspaceHandle handle = this.getHandleFor(source);
        if (handle != null || this._zorderFrameHandles == null) {
            return;
        }
        handle = new DockableFrameWorkspaceHandle(source);
        this._zorderFrameHandles.add(this._zorderFrameHandles.size(), handle);
        List<DockingManager.FrameHandle> listAfter = Collections.unmodifiableList(this._zorderFrameHandles);
        this.firePropertyChange("zOrder", null, listAfter);
    }

    private DockableFrameWorkspaceHandle getHandleFor(Object source) {
        int index = -1;
        if (this._zorderFrameHandles != null) {
            for (int i = 0; i < this._zorderFrameHandles.size() && index == -1; ++i) {
                if (!((DockableFrameWorkspaceHandle)this._zorderFrameHandles.get((int)i)).untyped.equals(source)) continue;
                index = i;
            }
        }
        if (index == -1) {
            return null;
        }
        return (DockableFrameWorkspaceHandle)this._zorderFrameHandles.get(index);
    }

    private boolean loadHiddenPreviousState(DockableFrame dockableFrame) {
        PreviousState state = dockableFrame.getHiddenPreviousState();
        this.saveState(dockableFrame);
        if (state != null) {
            this.restorePreviousState(dockableFrame, state, true);
        } else if (dockableFrame.isFloated() || dockableFrame.isDocked() || dockableFrame.isHidden()) {
            int mode = dockableFrame.getInitMode();
            int actualMode = mode < 0 ? -mode : mode;
            switch (actualMode) {
                case 1: {
                    this.internalFloatFrame(dockableFrame, dockableFrame.getContext().getUndockedBounds(), true, true);
                    break;
                }
                case 2: {
                    this.internalAutohideFrame(dockableFrame, dockableFrame.getInitSide(), dockableFrame.getInitIndex());
                    break;
                }
                case 3: {
                    this.internalAutohideFrame(dockableFrame, dockableFrame.getInitSide(), dockableFrame.getInitIndex());
                    break;
                }
                default: {
                    if (dockableFrame.isDockable()) {
                        this.internalDockFrame(dockableFrame, this.getDockedFrameContainer(), true);
                        break;
                    }
                    this.internalFloatFrame(dockableFrame, dockableFrame.getUndockedBounds(), true, true);
                    break;
                }
            }
        } else {
            this.internalFloatFrame(dockableFrame, dockableFrame.getUndockedBounds(), true, true);
        }
        this.loadState();
        this.resetLayout();
        return true;
    }

    private boolean loadAvailablePreviousState(DockableFrame dockableFrame) {
        PreviousState state = dockableFrame.getAvailablePreviousState();
        if (state == null) {
            state = dockableFrame.getClosePreviousState();
        }
        this.saveState(dockableFrame);
        if (state != null) {
            this.restorePreviousState(dockableFrame, state, true);
        } else if (dockableFrame.isFloated()) {
            this.internalFloatFrame(dockableFrame, dockableFrame.getUndockedBounds(), true, true);
        } else if (dockableFrame.isDocked()) {
            this.internalDockFrame(dockableFrame, dockableFrame.getContext().getInitSide(), dockableFrame.getContext().getInitIndex());
        } else if (dockableFrame.isAutohide() || dockableFrame.isAutohideShowing()) {
            this.internalAutohideFrame(dockableFrame, dockableFrame.getContext().getInitSide(), dockableFrame.getContext().getInitIndex());
        }
        this.loadState();
        this.resetLayout();
        return true;
    }

    private boolean loadMaximizedPreviousState(DockableFrame dockableFrame) {
        PreviousState state = dockableFrame.getMaximizedPreviousState();
        this.saveState(dockableFrame);
        if (state != null) {
            this.restorePreviousState(dockableFrame, state, true);
        } else if (dockableFrame.isFloated()) {
            this.internalFloatFrame(dockableFrame, dockableFrame.getUndockedBounds(), true, true);
        } else if (dockableFrame.isDocked()) {
            this.internalDockFrame(dockableFrame, dockableFrame.getContext().getInitSide(), dockableFrame.getContext().getInitIndex());
        } else if (dockableFrame.isAutohide() || dockableFrame.isAutohideShowing()) {
            this.internalAutohideFrame(dockableFrame, dockableFrame.getContext().getInitSide(), dockableFrame.getContext().getInitIndex());
        }
        this.loadState();
        this.resetLayout();
        return true;
    }

    private boolean loadClosePreviousState(DockableFrame dockableFrame, boolean useInitMode) {
        PreviousState state = dockableFrame.getClosePreviousState();
        this.saveState(dockableFrame);
        if (state != null) {
            this.restorePreviousState(dockableFrame, state, true);
        } else if (useInitMode) {
            int mode = Math.abs(dockableFrame.getInitMode());
            if (mode == 1) {
                this.internalFloatFrame(dockableFrame, dockableFrame.getUndockedBounds(), true, dockableFrame.getInitMode() > 0);
            } else if (mode == 4) {
                dockableFrame.internalSetPreferredSize();
                this.internalDockFrame(dockableFrame, dockableFrame.getContext().getInitSide(), dockableFrame.getContext().getInitIndex());
            } else if (mode == 2 || mode == 3) {
                this.internalAutohideFrame(dockableFrame, dockableFrame.getContext().getInitSide(), dockableFrame.getContext().getInitIndex());
            }
            if (dockableFrame.getInitMode() <= 0) {
                this.internalHideFrame(dockableFrame, true);
            }
        } else if (dockableFrame.isFloated()) {
            this.internalFloatFrame(dockableFrame, dockableFrame.getUndockedBounds(), true, true);
        } else if (dockableFrame.isDocked()) {
            dockableFrame.internalSetPreferredSize();
            this.internalDockFrame(dockableFrame, dockableFrame.getContext().getInitSide(), dockableFrame.getContext().getInitIndex());
        } else if (dockableFrame.isAutohide() || dockableFrame.isAutohideShowing()) {
            this.internalAutohideFrame(dockableFrame, dockableFrame.getContext().getInitSide(), dockableFrame.getContext().getInitIndex());
        }
        this.loadState();
        this.resetLayout();
        return true;
    }

    private boolean loadDockPreviousState(DockableFrame dockableFrame, boolean single) {
        PreviousState state = dockableFrame.getDockPreviousState();
        this.saveState(dockableFrame);
        if (state != null) {
            this.restorePreviousState(dockableFrame, state, single);
        } else if (single || dockableFrame.getParent() instanceof FrameContainer && ((FrameContainer)dockableFrame.getParent()).getTabCount() == 1) {
            this.internalDockFrame(dockableFrame, this.getDockedFrameContainer(), true);
        } else {
            this.internalDockFrame((JComponent)((FrameContainer)dockableFrame.getParent()), this.getDockedFrameContainer(), dockableFrame.getContext().getInitSide(), true);
        }
        this.loadState();
        this.resetLayout();
        return true;
    }

    private boolean loadFloatPreviousState(DockableFrame dockableFrame, boolean single) {
        PreviousState state = dockableFrame.getFloatPreviousState();
        this.saveState(dockableFrame);
        if (state != null) {
            this.restorePreviousState(dockableFrame, state, single);
        } else {
            this.internalFloatFrame(dockableFrame, dockableFrame.getUndockedBounds(), single, true);
        }
        this.loadState();
        this.resetLayout();
        return true;
    }

    private boolean loadAutohidePreviousState(FrameContainer frameContainer) {
        DockableFrame dockableFrame = (DockableFrame)frameContainer.getComponentAt(0);
        PreviousState state = dockableFrame.getAutohidePreviousState();
        if (state != null && state.rootID == 2) {
            this.restorePreviousState(dockableFrame, state, false);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void restorePreviousState(DockableFrame dockableFrame, PreviousState state, boolean single) {
        block42: {
            if (single) {
                parentFrame = this.createFrameContainer();
            } else {
                parentFrame = (FrameContainer)dockableFrame.getParent();
                if (parentFrame == null) {
                    parentFrame = this.createFrameContainer();
                }
            }
            done = false;
            if (state == null) break block42;
            switch (state.mode) {
                case 4: {
                    if (state.rootID != 2) break;
                    fc = PreviousState.findComponentByDockID(this, this.getDockedFrameContainer().getNormalContainer(), state.fcID);
                    if (fc != null || DefaultDockingManager.checkForInitPosition() || !this.dockFrameByInitState(this.getDockedFrameContainer(), parentFrame, dockableFrame)) ** GOTO lbl17
                    done = true;
                    parentFrame = (FrameContainer)dockableFrame.getParent();
                    ** GOTO lbl93
lbl17:
                    // 1 sources

                    if (fc == null || !(fc instanceof FrameContainer)) ** GOTO lbl30
                    if (!single) {
                        for (i = parentFrame.getTabCount() - 1; i >= 0; --i) {
                            df = (DockableFrame)parentFrame.getComponentAt(i);
                            DockingUtils.attachToFrameContainer(this, this.getDockedFrameContainer().getNormalContainer(), state, df);
                        }
                    } else {
                        DockingUtils.attachToFrameContainer(this, this.getDockedFrameContainer().getNormalContainer(), state, dockableFrame);
                    }
                    done = true;
                    parentFrame = (FrameContainer)fc;
                    ** GOTO lbl93
lbl30:
                    // 1 sources

                    if (state.parentStates == null) ** GOTO lbl93
                    componentToBeInserted /* !! */  = parentFrame;
                    JideSwingUtilities.removeFromParentWithFocusTransfer(componentToBeInserted /* !! */ );
                    for (pStateIndex = 0; pStateIndex < state.parentStates.size(); ++pStateIndex) {
                        pState = state.parentStates.get(pStateIndex);
                        if (pState.ccID == 3 && this.getWorkspace().isAcceptDockableFrame()) {
                            needCreateContainerContainer = false;
                            if (this.getWorkspace().getComponentCount() == 1) {
                                if (this.getWorkspace().getComponent(0) instanceof ContainerContainer) {
                                    recoveredCC = (ContainerContainer)this.getWorkspace().getComponent(0);
                                    if (parentFrame.indexOfComponent(dockableFrame) == -1) {
                                        parentFrame.addTab(dockableFrame, true);
                                    }
                                    recoveredCC.addPane(parentFrame);
                                    recoveredCC.setDockID(pState.ccID);
                                } else {
                                    needCreateContainerContainer = true;
                                }
                            }
                            if (needCreateContainerContainer || this.getWorkspace().getComponentCount() == 0) {
                                targetCC = this.createContainerContainer();
                                if (parentFrame.indexOfComponent(dockableFrame) == -1) {
                                    parentFrame.addTab(dockableFrame, true);
                                }
                                targetCC.addPane(parentFrame);
                                this.getWorkspace().add((Component)targetCC, "Center");
                            }
                            done = true;
                            break;
                        }
                        cc = PreviousState.findComponentByDockID(this, this.getDockedFrameContainer().getNormalContainer(), pState.ccID);
                        if (cc == null || !(cc instanceof ContainerContainer)) ** GOTO lbl82
                        if (parentFrame.indexOfComponent(dockableFrame) == -1) {
                            JideSwingUtilities.removeFromParentWithFocusTransfer(dockableFrame);
                            parentFrame.addTab(dockableFrame);
                            if (SystemInfo.isJdk15Above() && !parentFrame.isPreferredSizeSet()) {
                                parentFrame.setPreferredSize(parentFrame.getPreferredSize());
                            }
                        }
                        done = DockingUtils.attachToContainerContainer(this, this.getDockedFrameContainer().getNormalContainer(), pState, componentToBeInserted /* !! */ , done);
                        ((ContainerContainer)cc).setProportions(pState.proportions);
                        parent = cc.getParent();
                        if (!(parent instanceof ContainerContainer) || ((ContainerContainer)cc).getOrientation() != ((ContainerContainer)parent).getOrientation()) ** GOTO lbl80
                        parent.invalidate();
                        parent.repaint();
                        if (parent.getLayout() instanceof JideBoxLayout) {
                            layout = (JideBoxLayout)parent.getLayout();
                            flag = layout.isResetWhenInvalidate();
                            layout.setResetWhenInvalidate(true);
                            try {
                                ((JideBoxLayout)parent.getLayout()).invalidateLayout(parent);
                            }
                            finally {
                                layout.setResetWhenInvalidate(flag);
                            }
                        }
                        parent.doLayout();
lbl80:
                        // 2 sources

                        if (!done) continue;
                        break;
lbl82:
                        // 1 sources

                        recoveredCC = this.createContainerContainer();
                        recoveredCC.setOrientation(pState.orientation);
                        if (parentFrame.indexOfComponent(dockableFrame) == -1) {
                            JideSwingUtilities.removeFromParentWithFocusTransfer(dockableFrame);
                            parentFrame.addTab(dockableFrame);
                        }
                        recoveredCC.addPane(parentFrame);
                        recoveredCC.setDockID(pState.ccID);
                        recoveredCC.setProportions(pState.proportions);
                        componentToBeInserted /* !! */  = recoveredCC;
                    }
lbl93:
                    // 6 sources

                    if (!done) {
                        if (parentFrame.indexOfComponent(dockableFrame) == -1) {
                            parentFrame.addTab(dockableFrame);
                        }
                        this.internalDockFrame((JComponent)parentFrame, this.getDockedFrameContainer(), state.side, true);
                    }
                    dockableFrame.setDockID(state.dockID);
                    parentFrame.setDockID(state.fcID);
                    this.resetLayout();
                    this.docknizeFrames(parentFrame);
                    break;
                }
                case 1: {
                    this.removeExtraFloatingFrames();
                    floatingContainer = null;
                    componentToBeInserted = this._floatingFrames.iterator();
                    while (componentToBeInserted.hasNext() && (floatingContainer = (FloatingContainer)(f = componentToBeInserted.next())).getDockID() != state.rootID) {
                    }
                    if (floatingContainer == null || !floatingContainer.isVisible()) ** GOTO lbl147
                    fc = PreviousState.findComponentByDockID(this, (Container)floatingContainer, state.fcID);
                    if (fc == null || !(fc instanceof FrameContainer)) ** GOTO lbl123
                    if (!single) {
                        for (i = parentFrame.getTabCount() - 1; i >= 0; --i) {
                            df = (DockableFrame)parentFrame.getComponentAt(i);
                            DockingUtils.attachToFrameContainer(this, (Container)floatingContainer, state, df);
                        }
                        done = true;
                    } else {
                        done = DockingUtils.attachToFrameContainer(this, (Container)floatingContainer, state, dockableFrame);
                    }
                    parentFrame = (FrameContainer)fc;
                    ** GOTO lbl147
lbl123:
                    // 1 sources

                    if (state.parentStates == null) ** GOTO lbl141
                    componentToBeInserted /* !! */  = parentFrame;
                    for (pStateIndex = 0; pStateIndex < state.parentStates.size(); ++pStateIndex) {
                        pState = state.parentStates.get(pStateIndex);
                        cc = PreviousState.findComponentByDockID(this, (Container)floatingContainer, pState.ccID);
                        if (cc == null || !(cc instanceof ContainerContainer)) ** GOTO lbl133
                        if (!(done = DockingUtils.attachToContainerContainer(this, (Container)floatingContainer, pState, componentToBeInserted /* !! */ , done))) continue;
                        if (parentFrame.indexOfComponent(dockableFrame) == -1) {
                            parentFrame.addTab(dockableFrame);
                        }
                        ** GOTO lbl147
lbl133:
                        // 1 sources

                        recoveredCC = this.createContainerContainer();
                        recoveredCC.setOrientation(pState.orientation);
                        recoveredCC.addPane(parentFrame);
                        recoveredCC.setDockID(pState.ccID);
                        componentToBeInserted /* !! */  = recoveredCC;
                    }
                    ** GOTO lbl147
lbl141:
                    // 1 sources

                    container = (ContainerContainer)floatingContainer.getContentPane().getComponent(0);
                    container.addPane(parentFrame);
                    done = true;
                    if (parentFrame.indexOfComponent(dockableFrame) == -1) {
                        parentFrame.addTab(dockableFrame);
                    }
lbl147:
                    // 7 sources

                    if (!done) {
                        bounds = dockableFrame.getUndockedBounds();
                        if (state.rcBounds != null) {
                            bounds.setLocation(state.rcBounds.getLocation());
                        }
                        this.floatFrame(dockableFrame.getKey(), state.rcBounds, single);
                        if (dockableFrame.getParent() != null) {
                            ((FrameContainer)dockableFrame.getParent()).setDockID(state.fcID);
                            if (state.parentStates != null && state.parentStates.size() > 0 && dockableFrame.getParent().getParent() instanceof ContainerContainer) {
                                ps = state.parentStates.get(0);
                                ((ContainerContainer)dockableFrame.getParent().getParent()).setDockID(ps.ccID);
                            }
                            ((FloatingContainer)DockingUtils.getRootContainer(dockableFrame)).setDockID(state.rootID);
                        }
                    }
                    dockableFrame.setDockID(state.dockID);
                    topContainer = dockableFrame.getTopLevelAncestor();
                    if (!this.isUseDecoratedFloatingContainer() && topContainer instanceof FloatingContainer && ((FloatingContainer)topContainer).getDockingManager() == this) {
                        this.updateUndecorated((FloatingContainer)topContainer);
                    }
                    this.resetLayout();
                    this.docknizeFrames(parentFrame);
                    break;
                }
                case 2: 
                case 3: {
                    if (state.index != -1) {
                        state.index = this.findGroupIndex(state);
                        this.internalAutohideFrame(dockableFrame, state.side, state.index);
                    } else {
                        this.internalAutohideFrame(dockableFrame, state.side, 0);
                    }
                    dockableFrame.getContext().setCurrentMode(2);
                    this.resetLayout();
                }
            }
        }
    }

    private int findGroupIndex(PreviousState state) {
        AutoHideContainer autoHideContainer = this.getAutoHideContainer(state.side);
        if (autoHideContainer == null || autoHideContainer.getGroups() == null || state.parentStates == null || state.parentStates.size() == 0) {
            return state.index;
        }
        List<SidePaneGroup> groups = autoHideContainer.getGroups();
        for (int i = 0; i < groups.size(); ++i) {
            SidePaneGroup group = groups.get(i);
            if (group == null) continue;
            for (SidePaneItem item : group) {
                if (item == null || !(item.getComponent() instanceof DockableFrame)) continue;
                DockableFrame frame = (DockableFrame)item.getComponent();
                for (PreviousState.ParentState parentState : state.parentStates) {
                    if (parentState == null || parentState.ccChildren == null || !parentState.ccChildren.contains(frame.getDockID())) continue;
                    return i;
                }
            }
        }
        return groups.size();
    }

    @Override
    public RootPaneContainer getRootPaneContainer() {
        Container topLevelAncestor;
        if (this._rootPaneContainer == null && this.getContentContainer() instanceof JComponent && (topLevelAncestor = ((JComponent)this.getContentContainer()).getTopLevelAncestor()) instanceof RootPaneContainer) {
            this.switchRootPaneContainer((RootPaneContainer)((Object)topLevelAncestor));
        }
        return this._rootPaneContainer;
    }

    private Component getRootPaneContainerAsComponent() {
        return (Component)((Object)this.getRootPaneContainer());
    }

    @Override
    public DockedFrameContainer getDockedFrameContainer() {
        return this._dockedFrameContainer;
    }

    @Override
    public Workspace createWorkspace() {
        return new Workspace();
    }

    @Override
    public Workspace getWorkspace() {
        return this._workspace;
    }

    @Override
    public void setShowWorkspace(final boolean showWorkspace) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalSetShowWorkspace(showWorkspace);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockingManager.this.internalSetShowWorkspace(showWorkspace);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    @Override
    public boolean isShowWorkspace() {
        return this._showWorkspace;
    }

    protected void internalSetShowWorkspace(boolean showWorkspace) {
        boolean old = this._showWorkspace;
        if (old == showWorkspace) {
            return;
        }
        this._showWorkspace = showWorkspace;
        this.getWorkspace().setVisible(this._showWorkspace);
        this.firePropertyChange("showWorkspace", old, showWorkspace);
        if (showWorkspace) {
            this.addToZOrder(this.getWorkspace());
            this.moveToFront(this.getWorkspace());
        } else {
            this.removeFromZOrder(this.getWorkspace());
        }
        if (LOGGER_FOCUS.isLoggable(Level.FINE)) {
            LOGGER_FOCUS.fine(this.getProfileKey() + ":internalSetShowWorkspace");
        }
        this.activateFront(false);
    }

    @Override
    public void activateWorkspace() {
        this.setWorkspaceActive(true);
    }

    @Override
    public boolean isWorkspaceActive() {
        return this._isWorkspaceActive;
    }

    private void setWorkspaceActive(boolean active) {
        boolean old = this._isWorkspaceActive;
        if (old != active) {
            this._isWorkspaceActive = active;
            this.firePropertyChange("activeWorkspace", old, active);
        }
        if (active) {
            this.moveToFront(this.getWorkspace());
        }
    }

    @Override
    public void beginLoadLayoutData() {
        this.setRealized(false);
    }

    void clearLayout() {
        if (this._dockedHiddenContainer != null) {
            if (this._eastContainer != null) {
                this._dockedHiddenContainer.remove(SwingUtilities.getAncestorOfClass(SimpleScrollPane.class, this._eastContainer));
            }
            if (this._westContainer != null) {
                this._dockedHiddenContainer.remove(SwingUtilities.getAncestorOfClass(SimpleScrollPane.class, this._westContainer));
            }
            if (this._northContainer != null) {
                this._dockedHiddenContainer.remove(SwingUtilities.getAncestorOfClass(SimpleScrollPane.class, this._northContainer));
            }
            if (this._southContainer != null) {
                this._dockedHiddenContainer.remove(SwingUtilities.getAncestorOfClass(SimpleScrollPane.class, this._southContainer));
            }
        }
        if (this.getWorkspace() != null && this.getWorkspace().isAcceptDockableFrame()) {
            this.getWorkspace().removeAll();
        }
        if (this.getDockedFrameContainer() != null) {
            this._dockedHiddenContainer.removeAll();
            this._dockedFrameContainer = new DockedFrameContainer();
            ContainerContainer containerContainer = this.createContainerContainer();
            containerContainer.add(this._dockedFrameContainer);
            this._dockedHiddenContainer.add((Component)containerContainer, "Center");
        }
        this.disposeAllFloatingFrames();
        if (this._hiddenFrames != null) {
            this._hiddenFrames.clear();
        }
        if (this._zorderFrameHandles != null) {
            this._zorderFrameHandles.clear();
        }
        if (this.isShowWorkspace()) {
            this.addToZOrder(this.getWorkspace());
        }
        DockID.getInstance(this).releaseAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadLayoutFrom(final Document document) {
        this._loadDataSuccessful = false;
        boolean previousLoadingData = this._loadingLayoutData;
        this._loadingLayoutData = true;
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this._loadDataSuccessful = DockingPersistenceUtils.internalLoad(this, document, this.getLoadCallback());
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            DefaultDockingManager.this._loadDataSuccessful = DockingPersistenceUtils.internalLoad(DefaultDockingManager.this, document, DefaultDockingManager.this.getLoadCallback());
                        }
                    });
                }
                catch (InterruptedException e) {
                    this._loadDataSuccessful = false;
                    this.loadDataErrorHandler();
                }
                catch (InvocationTargetException e) {
                    this._loadDataSuccessful = false;
                    this.loadDataErrorHandler();
                    JideSwingUtilities.throwInvocationTargetException(e);
                }
            }
        }
        finally {
            this._loadingLayoutData = previousLoadingData;
        }
        if (LOGGER_FOCUS.isLoggable(Level.FINE)) {
            LOGGER_FOCUS.fine(this.getProfileKey() + ":loadLayoutFrom");
        }
        return this._loadDataSuccessful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadLayoutFrom(final InputStream in) {
        this._loadDataSuccessful = false;
        boolean previousLoadingData = this._loadingLayoutData;
        this._loadingLayoutData = true;
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this._loadDataSuccessful = this.internalLoadLayoutDataFrom(in);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            DefaultDockingManager.this._loadDataSuccessful = DefaultDockingManager.this.internalLoadLayoutDataFrom(in);
                        }
                    });
                }
                catch (InterruptedException e) {
                    this._loadDataSuccessful = false;
                    this.loadDataErrorHandler();
                }
                catch (InvocationTargetException e) {
                    this._loadDataSuccessful = false;
                    this.loadDataErrorHandler();
                    JideSwingUtilities.throwInvocationTargetException(e);
                }
            }
        }
        finally {
            this._loadingLayoutData = previousLoadingData;
        }
        if (LOGGER_FOCUS.isLoggable(Level.FINE)) {
            LOGGER_FOCUS.fine(this.getProfileKey() + ":loadLayoutFrom");
        }
        return this._loadDataSuccessful;
    }

    protected void handleNewlyAddedFrames(String[] newlyAddedFrames) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalLoadLayoutDataFrom(InputStream inputStream) {
        boolean internalLoadDataSuccessful = false;
        RuntimeException error = null;
        if (inputStream == null) {
            this.loadDataErrorHandler();
            return internalLoadDataSuccessful;
        }
        InputStream in = inputStream;
        if (this.isNeedFormatCheck()) {
            byte[] buffer;
            try {
                buffer = PersistenceUtils.bufferStreamToArray(inputStream);
            }
            catch (IOException e) {
                this.loadDataErrorHandler();
                return internalLoadDataSuccessful;
            }
            in = new ByteArrayInputStream(buffer);
            if (PersistenceUtils.isXmlFormat(buffer)) {
                try {
                    DockingPersistenceUtils.load(this, in, this.getLoadCallback());
                }
                catch (ParserConfigurationException e) {
                    this.loadDataErrorHandler();
                    return false;
                }
                catch (SAXException e) {
                    this.loadDataErrorHandler();
                    return false;
                }
                catch (IOException e) {
                    this.loadDataErrorHandler();
                    return false;
                }
                return true;
            }
        }
        this.setRealized(false);
        try {
            DockableFrame dockableFrame;
            String frameKey;
            int i;
            if (this.getInternalMaximizedFrame() != null) {
                this.internalRestoreFrame(false);
            }
            if (this.getAutohideShowingFrame() != null) {
                this.stopShowingAutohideFrameImmediately();
            }
            this.clearLayout();
            DataInputStream stream = new DataInputStream(in);
            short version = SaveUtils.readVersion(stream);
            if (!this.isVersionCompatible(version)) {
                throw new IOException("Layout data version number changed. Ignore previous layout data");
            }
            Rectangle rectangle = SaveUtils.readRectangle(stream);
            if (this.isUseFrameBounds()) {
                this._unmaximizedBounds = rectangle;
            }
            this._state = SaveUtils.readInt(stream);
            HiddenFrames newlyAddedFrame = SaveUtils.readContext(this, stream, this._allContexts);
            this._hiddenFrames = new HiddenFrames();
            if (this._allContexts != null) {
                String[] col = this._allContexts.keySet().toArray(new String[this._allContexts.size()]);
                for (String key : col) {
                    DockableFrameFactory factory;
                    if (error != null) continue;
                    DockableFrame dockableFrame2 = this.getFrame(key);
                    if (dockableFrame2 == null && (factory = this.getDockableFrameFactory()) != null) {
                        try {
                            dockableFrame2 = factory.create(key);
                        }
                        catch (Throwable t) {
                            error = new RuntimeException("DockableFrameFactory threw an unexpected exception while creating '" + key + "'.", t);
                        }
                        if (dockableFrame2 != null) {
                            boolean wasRealized = this.isRealized();
                            this.setRealized(false);
                            this.addFrame(dockableFrame2);
                            this.setRealized(wasRealized);
                        }
                    }
                    if (dockableFrame2 != null) {
                        dockableFrame2.setContext(this._allContexts.get(key));
                        if (dockableFrame2.getContext().getDockedWidth() > 0 || dockableFrame2.getContext().getDockedHeight() > 0) {
                            dockableFrame2.internalSetPreferredSize();
                        }
                        if (!this._allContexts.get(key).isAvailable()) continue;
                        this._hiddenFrames.add(key);
                        continue;
                    }
                    this._allContexts.remove(key);
                }
            }
            this.setFrameToActivate(null);
            Component comp = SaveUtils.readComponent(this, version, stream);
            if (comp == null) {
                throw new IOException("Layout Data is corrupted. Layout will be reset.");
            }
            this.getDockedFrameContainer().getNormalContainer().add(comp, "Center");
            this._eastContainer = SaveUtils.readAutohideContainer(this, this.getInternalEventManager(), version, stream);
            this._eastContainer.setRollover(this.isSidebarRollover());
            this._westContainer = SaveUtils.readAutohideContainer(this, this.getInternalEventManager(), version, stream);
            this._westContainer.setRollover(this.isSidebarRollover());
            this._northContainer = SaveUtils.readAutohideContainer(this, this.getInternalEventManager(), version, stream);
            this._northContainer.setRollover(this.isSidebarRollover());
            this._southContainer = SaveUtils.readAutohideContainer(this, this.getInternalEventManager(), version, stream);
            this._southContainer.setRollover(this.isSidebarRollover());
            if (this._eastContainer == null || this._westContainer == null || this._northContainer == null || this._southContainer == null) {
                throw new IOException("Layout Data is corrupted. Layout will be reset.");
            }
            this.listenToAutohideContainers();
            this._dockedHiddenContainer.add((Component)this.createScrollPaneForAutoHideContainer(this._westContainer), "Before");
            this._dockedHiddenContainer.add((Component)this.createScrollPaneForAutoHideContainer(this._eastContainer), "After");
            this._dockedHiddenContainer.add((Component)this.createScrollPaneForAutoHideContainer(this._northContainer), "First");
            this._dockedHiddenContainer.add((Component)this.createScrollPaneForAutoHideContainer(this._southContainer), "Last");
            this._floatingFrames = SaveUtils.readFloatingFrames(this, version, stream);
            this._orderedFloatingFrames = new Vector<Component>();
            for (FloatingContainer floatingContainer : this._floatingFrames) {
                floatingContainer.addWindowListener(this.getFloatingContainerWindowListener());
                if (!(floatingContainer instanceof Component)) continue;
                this._orderedFloatingFrames.add((Component)((Object)floatingContainer));
            }
            if (this.getRootPaneContainerAsComponent() instanceof Window) {
                this._orderedFloatingFrames.add(this.getRootPaneContainerAsComponent());
                ((Window)this.getRootPaneContainerAsComponent()).removeWindowListener(this.getFloatingContainerWindowListener());
                ((Window)this.getRootPaneContainerAsComponent()).addWindowListener(this.getFloatingContainerWindowListener());
            }
            HiddenFrames previousHiddenFrame = SaveUtils.readHiddenFrames(stream);
            if (this.isHideNewlyAddedFrames()) {
                for (String newFrame : newlyAddedFrame) {
                    DockableFrame frame = this.getFrame(newFrame);
                    if (frame == null || !frame.isHidable()) continue;
                    previousHiddenFrame.add(newFrame);
                }
            } else if (newlyAddedFrame != null) {
                this.handleNewlyAddedFrames(newlyAddedFrame.toArray(new String[newlyAddedFrame.size()]));
            }
            newlyAddedFrame = null;
            String maximizeFrameKey = null;
            try {
                maximizeFrameKey = SaveUtils.readString(stream);
            }
            catch (IOException newFrame) {
                // empty catch block
            }
            ArrayList<DockableFrame> saveFramesDockedInitPosition = new ArrayList<DockableFrame>();
            for (i = this._allFrameKeys.size() - 1; i >= 0; --i) {
                frameKey = this._allFrameKeys.get(i);
                if (this._hiddenFrames.contains(frameKey)) continue;
                dockableFrame = this.getFrame(this._allFrameKeys.get(i));
                this.addToZOrder(dockableFrame);
            }
            for (i = this._allFrameKeys.size() - 1; i >= 0; --i) {
                FrameContainer fc;
                frameKey = this._allFrameKeys.get(i);
                if (this._hiddenFrames.contains(frameKey) || !((dockableFrame = this.getFrame(this._allFrameKeys.get(i))).getParent() instanceof FrameContainer) || (fc = (FrameContainer)dockableFrame.getParent()).getSelectedFrame() != dockableFrame) continue;
                this.adjustZorderWhileLoadingLayout(dockableFrame);
            }
            for (i = this._hiddenFrames.size() - 1; i >= 0; --i) {
                int dockSide;
                DockableFrame frame;
                frameKey = (String)this._hiddenFrames.get(i);
                if (previousHiddenFrame.contains(frameKey)) {
                    frame = this.getFrame(frameKey);
                    if (frame == null || (dockSide = frame.getContext().getInitSide()) != 0) continue;
                    frame.getContext().setCurrentDockSide(dockSide);
                    continue;
                }
                frame = this.getFrame(frameKey);
                if (frame == null || frame.isHidden() || !frame.isAvailable()) continue;
                JideSwingUtilities.removeFromParentWithFocusTransfer(frame);
                frame.setVisible(false);
                if (this.getUnknownFrameBehaviorOnLoading() == 1) {
                    frame.setHidden(true);
                    continue;
                }
                dockSide = frame.getContext().getInitSide();
                frame.getContext().setCurrentDockSide(dockSide);
                switch (frame.getInitMode()) {
                    case 2: 
                    case 3: {
                        AutoHideContainer autoHideContainer = this.getAutoHideContainer(dockSide);
                        if (this.isGroupAllowedOnSidePane()) {
                            autoHideContainer.addFrame(frame);
                        } else {
                            autoHideContainer.addFrame(frame, autoHideContainer.getGroups().size());
                        }
                        this._hiddenFrames.remove(i);
                        break;
                    }
                    case 1: {
                        this.internalFloatFrame(frame, frame.getContext().getUndockedBounds(), true, true);
                        this._hiddenFrames.remove(i);
                        break;
                    }
                    case 4: {
                        if (frame.getParent() == null || !(frame.getParent() instanceof FrameContainer)) {
                            if (!DefaultDockingManager.checkForInitPosition() || frame.getContext().isInitPosition()) {
                                this.dockFrame(frame.getKey(), frame.getContext().getInitSide(), frame.getContext().getInitIndex());
                                frame.getContext().setInitPosition(true);
                                saveFramesDockedInitPosition.add(frame);
                            } else {
                                this.internalDockFrame((JComponent)frame, (Component)this.getDockedFrameContainer(), dockSide);
                            }
                        }
                        this._hiddenFrames.remove(i);
                        break;
                    }
                }
                this.addToZOrder(frame);
            }
            for (DockableFrame frame : saveFramesDockedInitPosition) {
                frame.getContext().setInitPosition(false);
            }
            for (FloatingContainer floatingContainer : this._floatingFrames) {
                if (floatingContainer == null) continue;
                Rectangle bounds = floatingContainer.getInitialBounds(floatingContainer.getBounds());
                floatingContainer.pack();
                floatingContainer.setBounds(bounds);
                floatingContainer.setVisible(true);
            }
            this.resetLayout();
            this.setRealized(true);
            this.fireFrameEvents();
            this.setBoundsState();
            if (maximizeFrameKey != null && maximizeFrameKey.trim().length() > 0) {
                this.internalMaximizeFrame(this.getFrame(maximizeFrameKey), false);
            }
            if (this.getFrameToActivate() != null) {
                this.activateFrame(this.getFrameToActivate());
                this.setFrameToActivate(null);
            }
            internalLoadDataSuccessful = true;
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Error loading layout - " + e.getLocalizedMessage(), e);
            }
            this.loadDataErrorHandler();
        }
        finally {
            this.setRealized(true);
        }
        if (error != null) {
            throw error;
        }
        return internalLoadDataSuccessful;
    }

    static boolean checkForInitPosition() {
        return "true".equals(SecurityUtils.getProperty("docking.checkForInitPosition", "true"));
    }

    void fireFrameEvents() {
        List<String> allFrames = this.getAllFrameNames();
        for (String key : allFrames) {
            DockableFrame frame = this.getFrame(key);
            this.fireFrameEvent(frame);
        }
    }

    private void fireFrameEvent(DockableFrame frame) {
        if (frame != null) {
            if (!frame.isHidden()) {
                if (!frame.isRealized()) {
                    frame.setRealized(true);
                    if (frame.isDocked()) {
                        frame.fireDockableFrameEvent(4003);
                        if (frame.getParent() instanceof FrameContainer && ((FrameContainer)frame.getParent()).getSelectedFrame() == frame) {
                            frame.fireDockableFrameEvent(4009);
                        }
                    }
                    if (!frame.isAutohide()) {
                        frame.fireDockableFrameEvent(4001);
                    }
                    if (frame.isDocked() && frame.getParent() instanceof FrameContainer && ((FrameContainer)frame.getParent()).getSelectedFrame() != frame) {
                        frame.fireDockableFrameEvent(4010);
                    }
                }
            } else {
                frame.fireDockableFrameEvent(4002);
            }
        }
    }

    void listenToAutohideContainers() {
        this.listenToAutoHideContainer(this._northContainer);
        this.listenToAutoHideContainer(this._southContainer);
        this.listenToAutoHideContainer(this._eastContainer);
        this.listenToAutoHideContainer(this._westContainer);
    }

    private void listenToAutoHideContainer(AutoHideContainer ac) {
        if (ac == null) {
            return;
        }
        List<SidePaneGroup> groups = ac.getGroups();
        if (groups == null) {
            return;
        }
        for (SidePaneGroup group : groups) {
            group.addSidePaneListener(this._sidePaneListener);
        }
    }

    void setBoundsState() {
        if (this._useFrameBounds && this.getRootPaneContainerAsComponent() != null) {
            Component rootPaneContainerAsComponent = this.getRootPaneContainerAsComponent();
            this._unmaximizedBounds = PortingUtils.ensureVisible(rootPaneContainerAsComponent, this._unmaximizedBounds);
            if (rootPaneContainerAsComponent != null) {
                boolean wasVisible = rootPaneContainerAsComponent.isVisible();
                if (rootPaneContainerAsComponent instanceof DockableHolder) {
                    if (((DockableHolder)((Object)rootPaneContainerAsComponent)).getDockingManager() instanceof DefaultDockingManager && ((DefaultDockingManager)((DockableHolder)((Object)rootPaneContainerAsComponent)).getDockingManager()).shouldUseFrameBounds(wasVisible)) {
                        rootPaneContainerAsComponent.setBounds(this._unmaximizedBounds);
                    }
                } else if (this.shouldUseFrameBounds(wasVisible)) {
                    rootPaneContainerAsComponent.setBounds(this._unmaximizedBounds);
                }
            }
        }
        if (this.isShowInitial() || this._showInitialInvoked) {
            this.showInitial();
        }
    }

    @Override
    public void setShowInitial(boolean value) {
        this._showInitial = value;
    }

    @Override
    public boolean isShowInitial() {
        return this._showInitial;
    }

    @Override
    public void showInitial() {
        boolean wasVisible = false;
        Component rootPaneContainerAsComponent = this.getRootPaneContainerAsComponent();
        if (rootPaneContainerAsComponent != null) {
            wasVisible = rootPaneContainerAsComponent.isVisible();
        }
        if (this.shouldUseFrameBounds(wasVisible) && !SystemInfo.isJdk142Above() && rootPaneContainerAsComponent != null) {
            rootPaneContainerAsComponent.setVisible(true);
        }
        if (this.shouldUseFrameState(wasVisible) && rootPaneContainerAsComponent instanceof Frame) {
            PortingUtils.setFrameState((Frame)rootPaneContainerAsComponent, this._state);
        }
        if (this._floatingFrames != null) {
            for (FloatingContainer floatingContainer : this._floatingFrames) {
                floatingContainer.setVisible(true);
            }
        }
        if (this.shouldUseFrameBounds(wasVisible) && SystemInfo.isJdk142Above() && rootPaneContainerAsComponent != null) {
            rootPaneContainerAsComponent.setVisible(true);
        }
        this._showInitialInvoked = true;
    }

    @Override
    public void requestFocusInDockingManager() {
        if (!this._hasFocus) {
            this.getMainContainer().requestFocus();
        }
    }

    void saveCurrentContext() {
        DockableFrame frame;
        ArrayList<DockableFrame> unavailableFrames = new ArrayList<DockableFrame>();
        for (String key : this._allFrameKeys) {
            frame = this.getFrame(key);
            if (frame.isAvailable()) continue;
            this.internalSetFrameAvailable(frame);
            unavailableFrames.add(frame);
        }
        for (String key : this._allFrameKeys) {
            frame = this.getFrame(key);
            DockingUtils.saveClosePreviousState(frame);
        }
        if (this.isPreserveAvailableProperty()) {
            for (DockableFrame unavailableFrame : unavailableFrames) {
                this.internalSetFrameUnavailable(unavailableFrame);
            }
        }
    }

    @Override
    public void saveLayoutTo(Document document) {
        DockingPersistenceUtils.saveToDocument(this, document, this.getSaveCallback());
    }

    @Override
    public void saveLayoutTo(final OutputStream out) throws IOException {
        Collection<String> frameKeys = this.getAllFrames();
        boolean hasUnavailableFrame = false;
        for (String key : frameKeys) {
            DockableFrame frame = this.getFrame(key);
            if (frame.isAvailable()) continue;
            hasUnavailableFrame = true;
            break;
        }
        if (!hasUnavailableFrame || SwingUtilities.isEventDispatchThread()) {
            this.internalSaveLayoutTo(out);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        DefaultDockingManager.this.internalSaveLayoutTo(out);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private void internalSaveLayoutTo(OutputStream out) throws IOException {
        if (this._loadingLayoutData) {
            return;
        }
        if (this.isXmlFormat()) {
            try {
                DockingPersistenceUtils.save(this, out, PersistenceUtils.getDefaultXmlEncoding(), this.getSaveCallback());
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            return;
        }
        if (this.getDockedFrameContainer() != null && this.getDockedFrameContainer().getNormalContainer().getComponentCount() == 0) {
            throw new IllegalStateException("There is no component in getDockedFrameContainer().getNormalContainer(). Did you remove all the components before saving the layout? If so, please don't do it until the layout is saved.");
        }
        String activeFrameKey = this.getActiveFrameKey();
        DockableFrame maximizedFrame = this.getInternalMaximizedFrame();
        if (maximizedFrame != null) {
            this.internalRestoreFrame(false);
        }
        if (this.getDockedFrameContainer() == null) {
            return;
        }
        DockingUtils.validateLocations(this.getDockedFrameContainer(), this.getWorkspace());
        this.removeExtraContainerContainer();
        this.saveCurrentContext();
        DataOutputStream stream = new DataOutputStream(out);
        SaveUtils.writeVersion(stream, this._version);
        SaveUtils.writeRectangle(stream, this._unmaximizedBounds);
        if (this.getRootPaneContainerAsComponent() instanceof Frame) {
            SaveUtils.writeInt(stream, PortingUtils.getFrameState((Frame)this.getRootPaneContainerAsComponent()));
        } else {
            SaveUtils.writeInt(stream, 0);
        }
        SaveUtils.writeContext(stream, this._allContexts);
        if (this.getDockedFrameContainer() != null && this.getDockedFrameContainer().getNormalContainer().getComponentCount() > 0) {
            SaveUtils.writeComponent(stream, this._version, this.getDockedFrameContainer().getNormalContainer().getComponent(0));
            SaveUtils.writeAutohideContainer(stream, this._version, this._eastContainer);
            SaveUtils.writeAutohideContainer(stream, this._version, this._westContainer);
            SaveUtils.writeAutohideContainer(stream, this._version, this._northContainer);
            SaveUtils.writeAutohideContainer(stream, this._version, this._southContainer);
            SaveUtils.writeFloatingFrames(stream, this._version, this._floatingFrames);
            SaveUtils.writeHiddenFrames(stream, this._hiddenFrames);
        } else {
            SaveUtils.writeInt(stream, 65535);
        }
        if (maximizedFrame != null) {
            SaveUtils.writeString(stream, maximizedFrame.getKey());
        } else {
            SaveUtils.writeString(stream, "");
        }
        stream.close();
        if (maximizedFrame != null) {
            this.internalMaximizeFrame(maximizedFrame, false);
        }
        if (activeFrameKey != null && this.isDockingManagerFocused()) {
            this.activateFrame(activeFrameKey);
        }
    }

    @Override
    public Container getContentContainer() {
        return this._contentContainer;
    }

    @Override
    public JComponent getMainContainer() {
        return this._panelMain;
    }

    @Override
    public void resetLayout() {
        boolean isVisible = true;
        for (Container parent = this.getContentContainer(); parent != null; parent = parent.getParent()) {
            if (parent.isVisible()) {
                continue;
            }
            isVisible = false;
            break;
        }
        if (!isVisible) {
            return;
        }
        JideSwingUtilities.setRecursively(this.getContentContainer(), new JideSwingUtilities.Handler(){

            @Override
            public boolean condition(Component c) {
                return c instanceof ContainerContainer;
            }

            @Override
            public void action(Component c) {
                ((ContainerContainer)c).resetToPreferredSizes();
            }

            @Override
            public void postAction(Component c) {
            }
        });
        this.getContentContainer().validate();
        this.getDockedFrameContainer().getNormalContainer().validate();
        this.getWorkspace().validate();
        this.getContentContainer().repaint();
    }

    @Override
    public String getActiveFrameKey() {
        DockableFrame f = this._activeFrame;
        if (f == null) {
            return null;
        }
        return f.getKey();
    }

    private void saveState(Component f) {
        ContainerContainer tempCC;
        Container tempC = DockingUtils.getRootContainer(f);
        if (tempC != null) {
            this._tempCs.add(tempC);
        }
        if ((tempCC = DockingUtils.getContainContainer(f)) != null) {
            this._tempCCs.add(tempCC);
        }
    }

    private void loadState() {
        if (this._tempCCs.size() > 0 && this._tempCCs.get(this._tempCCs.size() - 1) != null) {
            this._tempCCs.get(this._tempCCs.size() - 1).hideItselfIfEmpty();
            this._tempCCs.remove(this._tempCCs.size() - 1);
        }
        if (this._tempCs.size() > 0 && this._tempCs.get(this._tempCs.size() - 1) != null) {
            if (this._tempCs.get(this._tempCs.size() - 1) instanceof FloatingContainer) {
                FloatingContainer floatingContainer = (FloatingContainer)((Object)this._tempCs.get(this._tempCs.size() - 1));
                floatingContainer.hideItselfIfEmpty();
                if (floatingContainer.isVisible()) {
                    this.updateUndecorated(floatingContainer);
                } else {
                    if (floatingContainer instanceof Component && ((Component)((Object)floatingContainer)).getParent() != null) {
                        ((Component)((Object)floatingContainer)).getParent().remove((Component)((Object)floatingContainer));
                    }
                    this.removeFloatingContainer(floatingContainer);
                    this.disposeFloatingContainer(floatingContainer);
                }
            }
            this._tempCs.remove(this._tempCs.size() - 1);
        }
    }

    protected void disposeFloatingContainer(FloatingContainer floatingContainer) {
        if (floatingContainer != null) {
            floatingContainer.dispose();
        }
    }

    protected FloatingContainer updateUndecorated(FloatingContainer floatingContainer) {
        if (!floatingContainer.hasTitleBar() && DockingUtils.shouldUseDecoratedFloatingContainer(this, floatingContainer.getContentPane())) {
            if (DockingUtils.isFloatingContainerDecorated(floatingContainer)) {
                return floatingContainer;
            }
            FloatingContainer newFloatingContainer = this.createFloatingContainer(SwingUtilities.getWindowAncestor(this.getRootPaneContainer().getRootPane()));
            DockingManager.FloatingContainerCustomizer customizer = this.getFloatingContainerCustomizer();
            if (customizer != null) {
                customizer.customize(newFloatingContainer);
            }
            Rectangle bounds = floatingContainer.getBounds();
            if (floatingContainer.getContentPane().getComponentCount() > 0) {
                Component[] components;
                for (Component component : components = floatingContainer.getContentPane().getComponents()) {
                    if (!(component instanceof ContainerContainer) && !(component instanceof FrameContainer)) continue;
                    newFloatingContainer.getContentPane().add(component);
                }
            }
            newFloatingContainer.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
            newFloatingContainer.updateUndecorated();
            this.removeFloatingContainer(floatingContainer);
            this.addFloatingContainer(newFloatingContainer);
            floatingContainer.removeAll();
            floatingContainer.setVisible(false);
            if (floatingContainer instanceof Component && ((Component)((Object)floatingContainer)).getParent() != null) {
                ((Component)((Object)floatingContainer)).getParent().remove((Component)((Object)floatingContainer));
            }
            this.disposeFloatingContainer(floatingContainer);
            floatingContainer = null;
            if (!this.isResizable()) {
                newFloatingContainer.setResizable(false);
            }
            return newFloatingContainer;
        }
        if (floatingContainer.hasTitleBar() && !DockingUtils.shouldUseDecoratedFloatingContainer(this, floatingContainer.getContentPane())) {
            if (!DockingUtils.isFloatingContainerDecorated(floatingContainer)) {
                return floatingContainer;
            }
            FloatingContainer newFloatingContainer = this.createFloatingContainer(SwingUtilities.getWindowAncestor(this.getRootPaneContainer().getRootPane()));
            DockingManager.FloatingContainerCustomizer customizer = this.getFloatingContainerCustomizer();
            if (customizer != null) {
                customizer.customize(newFloatingContainer);
            }
            Rectangle bounds = floatingContainer.getBounds();
            if (floatingContainer.getContentPane().getComponentCount() > 0) {
                Component[] components;
                for (Component component : components = floatingContainer.getContentPane().getComponents()) {
                    if (!(component instanceof ContainerContainer) && !(component instanceof FrameContainer)) continue;
                    newFloatingContainer.getContentPane().add(component);
                }
            }
            newFloatingContainer.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
            newFloatingContainer.updateUndecorated();
            this.removeFloatingContainer(floatingContainer);
            this.addFloatingContainer(newFloatingContainer);
            floatingContainer.removeAll();
            floatingContainer.setVisible(false);
            if (floatingContainer instanceof Component && ((Component)((Object)floatingContainer)).getParent() != null) {
                ((Component)((Object)floatingContainer)).getParent().remove((Component)((Object)floatingContainer));
            }
            this.disposeFloatingContainer(floatingContainer);
            floatingContainer = null;
            if (!this.isResizable()) {
                newFloatingContainer.setResizable(false);
            }
            return newFloatingContainer;
        }
        floatingContainer.updateBorders();
        if (!this.isResizable()) {
            floatingContainer.setResizable(false);
        }
        return floatingContainer;
    }

    private void addFloatingContainer(FloatingContainer floatingContainer) {
        if (!this._floatingFrames.contains(floatingContainer)) {
            this._floatingFrames.add(floatingContainer);
            if (floatingContainer instanceof Component) {
                Component container = (Component)((Object)floatingContainer);
                this._orderedFloatingFrames.add(container);
            }
            floatingContainer.addWindowListener(this.getFloatingContainerWindowListener());
        }
    }

    private void removeFloatingContainer(FloatingContainer floatingContainer) {
        this._floatingFrames.remove(floatingContainer);
        if (floatingContainer instanceof Component) {
            Component container = (Component)((Object)floatingContainer);
            this._orderedFloatingFrames.remove(container);
        }
        floatingContainer.removeWindowListener(this.getFloatingContainerWindowListener());
    }

    @Override
    public void autohideAll() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalAutohideAll();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockingManager.this.internalAutohideAll();
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    private void internalAutohideAll() {
        Collection<DockableFrame> frames = this._allFrames.values();
        for (DockableFrame frame : frames) {
            if (!frame.isDocked()) continue;
            this.internalAutohideFrame(frame, -1);
        }
    }

    @Override
    public void toggleMaximizeState(String key) {
        DockableFrame frame = this.getFrame(key);
        if (!frame.isAvailable()) {
            return;
        }
        if (frame.isMaximized()) {
            this.internalRestoreFrame(true);
        } else {
            this.internalMaximizeFrame(frame, true);
        }
    }

    @Override
    public void toggleState(String key, boolean single) {
        DockableFrame frame = this.getFrame(key);
        if (frame == null) {
            return;
        }
        this.internalToggleState(frame, single);
    }

    private void internalToggleState(DockableFrame frame, boolean single) {
        if (!frame.isAvailable()) {
            return;
        }
        if (!(this.isFloatable() && frame.isFloatable() && frame.isDockable())) {
            return;
        }
        boolean maximized = frame.isMaximized();
        this._togglingWindowVisibility = true;
        this.restoreFrame();
        if (maximized && frame.isFloated()) {
            return;
        }
        boolean isActive = frame.isActive();
        if (!single) {
            FrameContainer fc;
            if (frame.isAutohide() || frame.isAutohideShowing()) {
                this.internalToggleAutohideState(frame, single);
            }
            if ((fc = (FrameContainer)frame.getParent()) == null) {
                return;
            }
            if (frame.isFloated()) {
                fc.setPreferredSize(null);
                DockableFrame frameHasPreviousState = null;
                for (int i = fc.getTabCount() - 1; i >= 0; --i) {
                    DockableFrame f = (DockableFrame)fc.getComponentAt(i);
                    if (f == frame) continue;
                    PreviousState floatingState = PreviousState.createPreviousState(f);
                    PreviousState.disposePreviousState(f.getFloatPreviousState());
                    f.setFloatPreviousState(floatingState);
                    if (frame.getDockPreviousState() != null && f.getDockPreviousState() != null && f.getDockPreviousState().fcID != frame.getDockPreviousState().fcID) {
                        this.loadDockPreviousState(f, true);
                        continue;
                    }
                    if (frame.getDockPreviousState() != null || f.getDockPreviousState() == null) continue;
                    if (frameHasPreviousState == null) {
                        frameHasPreviousState = f;
                        continue;
                    }
                    if (frameHasPreviousState.getDockPreviousState() == null || frameHasPreviousState.getDockPreviousState().fcID == f.getDockPreviousState().fcID) continue;
                    frameHasPreviousState = frame;
                }
                PreviousState floatingState = PreviousState.createPreviousState(frame);
                PreviousState.disposePreviousState(frame.getFloatPreviousState());
                frame.setFloatPreviousState(floatingState);
                if (frameHasPreviousState == null || frameHasPreviousState == frame) {
                    this.loadDockPreviousState(frame, false);
                } else {
                    this.loadDockPreviousState(frameHasPreviousState, false);
                }
            } else {
                if (!frame.isFloatable() || !this.isFloatable()) {
                    return;
                }
                for (int i = fc.getTabCount() - 1; i >= 0; --i) {
                    DockableFrame f = (DockableFrame)fc.getComponentAt(i);
                    if (f == frame) continue;
                    PreviousState dockState = PreviousState.createPreviousState(f);
                    PreviousState.disposePreviousState(f.getDockPreviousState());
                    f.setDockPreviousState(dockState);
                    if (f.getFloatPreviousState() == null || frame.getFloatPreviousState() == null || f.getFloatPreviousState().fcID == frame.getFloatPreviousState().fcID) continue;
                    this.loadFloatPreviousState(f, true);
                }
                PreviousState dockState = PreviousState.createPreviousState(frame);
                PreviousState.disposePreviousState(frame.getDockPreviousState());
                frame.setDockPreviousState(dockState);
                this.loadFloatPreviousState(frame, false);
            }
        } else if (frame.isFloated()) {
            PreviousState state = PreviousState.createPreviousState(frame);
            PreviousState.disposePreviousState(frame.getFloatPreviousState());
            frame.setFloatPreviousState(state);
            this.loadDockPreviousState(frame, true);
        } else {
            if (!frame.isFloatable() || !this.isFloatable()) {
                return;
            }
            PreviousState state = PreviousState.createPreviousState(frame);
            PreviousState.disposePreviousState(frame.getDockPreviousState());
            frame.setDockPreviousState(state);
            this.loadFloatPreviousState(frame, true);
        }
        this._togglingWindowVisibility = false;
        if (LOGGER_FOCUS.isLoggable(Level.FINE)) {
            LOGGER_FOCUS.fine(this.getProfileKey() + ":internalToggleState");
        }
        if (isActive && frame.getParent() instanceof FrameContainer && ((FrameContainer)frame.getParent()).getSelectedFrame() != frame) {
            ((FrameContainer)frame.getParent()).setSelectedComponent(frame);
        }
        this.activateFront(true);
    }

    @Override
    public void removeFromHiddenFrames(String key) {
        this._hiddenFrames.remove(key);
    }

    @Override
    public boolean isAutohideAllTabs() {
        return this._autohideAllTabs;
    }

    @Override
    public void setAutohideAllTabs(boolean autohideAllTabs) {
        boolean old = this._autohideAllTabs;
        if (this._autohideAllTabs != autohideAllTabs) {
            this._autohideAllTabs = autohideAllTabs;
            this.firePropertyChange("autohideAllTabs", old, this._autohideAllTabs);
        }
    }

    @Override
    public boolean isHideAllTabs() {
        return this._hideAllTabs;
    }

    @Override
    public void setHideAllTabs(boolean hideAllTabs) {
        boolean old = this._hideAllTabs;
        if (this._hideAllTabs != hideAllTabs) {
            this._hideAllTabs = hideAllTabs;
            this.firePropertyChange("hideAllTabs", old, this._hideAllTabs);
        }
    }

    @Override
    public boolean isFloatAllTabs() {
        return this._floatAllTabs;
    }

    @Override
    public void setFloatAllTabs(boolean floatAllTabs) {
        boolean old = this._floatAllTabs;
        if (this._floatAllTabs != floatAllTabs) {
            this._floatAllTabs = floatAllTabs;
            this.firePropertyChange("floatAllTabs", old, this._floatAllTabs);
        }
    }

    @Override
    public boolean isMaximizeAllTabs() {
        return this._maximizeAllTabs;
    }

    @Override
    public void setMaximizeAllTabs(boolean maximizeAllTabs) {
        boolean old = this._maximizeAllTabs;
        if (this._maximizeAllTabs != maximizeAllTabs) {
            this._maximizeAllTabs = maximizeAllTabs;
            this.firePropertyChange("maximizeAllTabs", old, this._maximizeAllTabs);
        }
    }

    @Override
    public boolean isFloatable() {
        return this._floatable;
    }

    @Override
    public void setFloatable(boolean floatable) {
        boolean old = this._floatable;
        if (this._floatable != floatable) {
            this._floatable = floatable;
            List<String> frames = this.getAllFrameNames();
            for (String key : frames) {
                if (this._floatable) {
                    this.getFrame(key).firePropertyChange("floatable", false, true);
                    continue;
                }
                this.getFrame(key).firePropertyChange("floatable", true, false);
            }
            this.firePropertyChange("floatable", old, this._floatable);
        }
    }

    @Override
    public boolean isAutohidable() {
        return this._autohidable;
    }

    @Override
    public void setAutohidable(boolean autohidable) {
        boolean old = this._autohidable;
        if (this._autohidable != autohidable) {
            this._autohidable = autohidable;
            List<String> frames = this.getAllFrameNames();
            for (String key : frames) {
                if (this._autohidable) {
                    this.getFrame(key).firePropertyChange("autohidable", false, true);
                    continue;
                }
                this.getFrame(key).firePropertyChange("autohidable", true, false);
            }
            this.firePropertyChange("autohidable", old, this._autohidable);
        }
    }

    @Override
    public boolean isHidable() {
        return this._hidable;
    }

    @Override
    public void setHidable(boolean hidable) {
        boolean old = this._hidable;
        if (this._hidable != hidable) {
            this._hidable = hidable;
            List<String> frames = this.getAllFrameNames();
            for (String key : frames) {
                this.getFrame(key).firePropertyChange("hidable", old, this._hidable);
            }
            if (this._floatingFrames != null) {
                for (FloatingContainer floatingFrame : this._floatingFrames) {
                    if (floatingFrame instanceof JFrame) {
                        if (this._hidable) {
                            ((JFrame)((Object)floatingFrame)).setDefaultCloseOperation(2);
                        } else {
                            ((JFrame)((Object)floatingFrame)).setDefaultCloseOperation(0);
                        }
                    }
                    if (!(floatingFrame instanceof JDialog)) continue;
                    if (this._hidable) {
                        ((JDialog)((Object)floatingFrame)).setDefaultCloseOperation(2);
                        continue;
                    }
                    ((JDialog)((Object)floatingFrame)).setDefaultCloseOperation(0);
                }
            }
            this.firePropertyChange("hidable", old, this._hidable);
        }
    }

    @Override
    public boolean isRearrangable() {
        return this._rearrangable;
    }

    @Override
    public void setRearrangable(boolean rearrangable) {
        boolean old = this._rearrangable;
        if (this._rearrangable != rearrangable) {
            this._rearrangable = rearrangable;
            List<String> list = this.getAllFrameNames();
            for (String key : list) {
                this.getFrame(key).firePropertyChange("rearrangable", old, rearrangable);
            }
            this.firePropertyChange("rearrangable", old, this._rearrangable);
        }
    }

    @Override
    public boolean isFloatingFramesResizable() {
        return this._floatingFramesResizable;
    }

    @Override
    public void setFloatingFramesResizable(boolean resizable) {
        boolean old = this._floatingFramesResizable;
        if (this._floatingFramesResizable != resizable) {
            this._floatingFramesResizable = resizable;
            JideSwingUtilities.Handler handler = new JideSwingUtilities.Handler(){

                @Override
                public boolean condition(Component c) {
                    return c instanceof ContainerContainerDivider;
                }

                @Override
                public void action(Component c) {
                    ContainerContainerDivider divider = (ContainerContainerDivider)c;
                    if (DefaultDockingManager.this._floatingFramesResizable) {
                        divider.setDefaultResizeCursor();
                    } else {
                        divider.setCursor(Cursor.getDefaultCursor());
                    }
                }

                @Override
                public void postAction(Component c) {
                }
            };
            if (this._floatingFrames != null) {
                for (FloatingContainer container : this._floatingFrames) {
                    container.setResizable(this._floatingFramesResizable);
                    JideSwingUtilities.setRecursively((Component)((Object)container), handler);
                }
            }
            this.firePropertyChange("floatingFramesResizable", old, this._floatingFramesResizable);
        }
    }

    @Override
    public boolean isDockedFramesResizable() {
        return this._dockedFramesResizable;
    }

    @Override
    public void setDockedFramesResizable(boolean resizable) {
        boolean old = this._dockedFramesResizable;
        if (this._dockedFramesResizable != resizable) {
            this._dockedFramesResizable = resizable;
            JideSwingUtilities.Handler handler = new JideSwingUtilities.Handler(){

                @Override
                public boolean condition(Component c) {
                    return c instanceof ContainerContainerDivider;
                }

                @Override
                public void action(Component c) {
                    ContainerContainerDivider divider = (ContainerContainerDivider)c;
                    if (DefaultDockingManager.this._dockedFramesResizable) {
                        divider.setDefaultResizeCursor();
                    } else {
                        divider.setCursor(Cursor.getDefaultCursor());
                    }
                }

                @Override
                public void postAction(Component c) {
                }
            };
            JideSwingUtilities.setRecursively(this.getDockedFrameContainer(), handler);
            this.firePropertyChange("dockedFramesResizable", old, this._dockedFramesResizable);
        }
    }

    @Override
    @Deprecated
    public boolean isResizable() {
        return this._resizable;
    }

    @Override
    @Deprecated
    public void setResizable(boolean resizable) {
        this.setFloatingFramesResizable(true);
        this.setDockedFramesResizable(true);
        boolean old = this._resizable;
        if (this._resizable != resizable) {
            this._resizable = resizable;
            this.firePropertyChange("resizable", old, this._resizable);
        }
    }

    @Override
    public boolean isGroupAllowedOnSidePane() {
        return this._groupAllowedOnSidePane;
    }

    @Override
    public void setGroupAllowedOnSidePane(boolean groupAllowedOnSidePane) {
        boolean old = this._groupAllowedOnSidePane;
        if (this._groupAllowedOnSidePane != groupAllowedOnSidePane) {
            this._groupAllowedOnSidePane = groupAllowedOnSidePane;
            this.firePropertyChange("groupAllowedOnSidePane", old, this._groupAllowedOnSidePane);
        }
    }

    @Override
    public void updateComponentTreeUI() {
        if (this.getRootPaneContainerAsComponent() != null) {
            SwingUtilities.updateComponentTreeUI(this.getRootPaneContainerAsComponent());
        }
        if (this._floatingFrames != null) {
            for (FloatingContainer container : this._floatingFrames) {
                SwingUtilities.updateComponentTreeUI((Container)((Object)container));
                container.updateBorders();
                container.validate();
            }
        }
        List<String> list = this.getAllFrameNames();
        for (String s : list) {
            DockableFrame frame = this.getFrame(s);
            if (frame == null || !frame.isAutohide() && !frame.isAutohideShowing() && !frame.isHidden()) continue;
            SwingUtilities.updateComponentTreeUI(frame);
        }
        if (this.getContentContainer() != null) {
            this.getContentContainer().setBackground(UIDefaultsLookup.getColor("ContentContainer.background"));
        }
        if (this.getContentContainer().getLayout() instanceof JideBorderLayout) {
            ((JideBorderLayout)this._dockedHiddenContainer.getLayout()).setHgap(UIDefaultsLookup.getInt("ContentContainer.hgap"));
            ((JideBorderLayout)this._dockedHiddenContainer.getLayout()).setVgap(UIDefaultsLookup.getInt("ContentContainer.vgap"));
            this.getContentContainer().doLayout();
        }
    }

    @Override
    public Collection<String> getAllFrames() {
        return this._allFrames.keySet();
    }

    @Override
    public List<String> getAllFrameNames() {
        return new ArrayList<String>(this._allFrameKeys);
    }

    @Override
    public String[] getAllVisibleFrameKeys() {
        final ArrayList<String> list = new ArrayList<String>();
        JideSwingUtilities.Handler handler = new JideSwingUtilities.Handler(){

            @Override
            public boolean condition(Component c) {
                return c instanceof DockableFrame && ((DockableFrame)c).getDockingManager() == DefaultDockingManager.this;
            }

            @Override
            public void action(Component c) {
                list.add(((DockableFrame)c).getKey());
            }

            @Override
            public void postAction(Component c) {
            }
        };
        JideSwingUtilities.setRecursively(this.getDockedFrameContainer(), handler);
        AutoHideContainer autoHideContainer = this.getAutoHideContainer(1);
        if (autoHideContainer != null) {
            list.addAll(autoHideContainer.getAllFrameKeys());
        }
        if ((autoHideContainer = this.getAutoHideContainer(8)) != null) {
            list.addAll(autoHideContainer.getAllFrameKeys());
        }
        if ((autoHideContainer = this.getAutoHideContainer(4)) != null) {
            list.addAll(autoHideContainer.getAllFrameKeys());
        }
        if ((autoHideContainer = this.getAutoHideContainer(2)) != null) {
            list.addAll(autoHideContainer.getAllFrameKeys());
        }
        if (this._floatingFrames != null) {
            for (FloatingContainer container : this._floatingFrames) {
                if (container == null) continue;
                JideSwingUtilities.setRecursively((Container)((Object)container), handler);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public String getFirstFrameKey() {
        String[] keys = this.getAllVisibleFrameKeys();
        if (keys.length > 0) {
            return keys[0];
        }
        return null;
    }

    @Override
    public String getLastFrameKey() {
        String[] keys = this.getAllVisibleFrameKeys();
        if (keys.length > 0) {
            return keys[keys.length - 1];
        }
        return null;
    }

    @Override
    public String getNextFrame(String frame) {
        if (frame != null) {
            String[] keys = this.getAllVisibleFrameKeys();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (!key.equals(frame)) continue;
                if (i + 1 <= keys.length - 1) {
                    return keys[i + 1];
                }
                return keys[0];
            }
        }
        return this.getFirstFrameKey();
    }

    @Override
    public String getPreviousFrame(String frame) {
        if (frame != null) {
            String[] keys = this.getAllVisibleFrameKeys();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (!key.equals(frame)) continue;
                if (i - 1 >= 0) {
                    return keys[i - 1];
                }
                return keys[keys.length - 1];
            }
        }
        return this.getLastFrameKey();
    }

    @Override
    public boolean isContinuousLayout() {
        return this._continuousLayout;
    }

    @Override
    public void setContinuousLayout(boolean continuousLayout) {
        boolean old = this._continuousLayout;
        if (this._continuousLayout != continuousLayout) {
            this._continuousLayout = continuousLayout;
            this.firePropertyChange("continuousLayout", old, this._continuousLayout);
        }
    }

    boolean isRealized() {
        return this._realized;
    }

    void setRealized(boolean realized) {
        this._realized = realized;
    }

    @Override
    public FrameContainer createFrameContainer() {
        FrameContainer frameContainer = new FrameContainer(this);
        this.customizeFrameContainer(frameContainer);
        return frameContainer;
    }

    @Override
    public FrameContainer customizeFrameContainer(FrameContainer frameContainer) {
        frameContainer.addChangeListener(this._changeListener);
        if (this._tabbedPaneCustomizer != null) {
            this._tabbedPaneCustomizer.customize(frameContainer);
        }
        frameContainer.applyComponentOrientation(this.getDockedFrameContainer().getComponentOrientation());
        return frameContainer;
    }

    @Override
    public void setTabbedPaneCustomizer(DockingManager.TabbedPaneCustomizer customizer) {
        this._tabbedPaneCustomizer = customizer;
        if (this.getDockedFrameContainer() != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.internalSetTabbedPaneCustomizer();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            DefaultDockingManager.this.internalSetTabbedPaneCustomizer();
                        }
                    });
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    JideSwingUtilities.throwInvocationTargetException(e);
                }
            }
        }
    }

    private void internalSetTabbedPaneCustomizer() {
        JideSwingUtilities.Handler handler = new JideSwingUtilities.Handler(){

            @Override
            public boolean condition(Component c) {
                return c instanceof FrameContainer;
            }

            @Override
            public void action(Component c) {
                DefaultDockingManager.this._tabbedPaneCustomizer.customize((FrameContainer)c);
            }

            @Override
            public void postAction(Component c) {
            }
        };
        if (this.getDockedFrameContainer() != null) {
            JideSwingUtilities.setRecursively(this.getDockedFrameContainer(), handler);
            this.getDockedFrameContainer().validate();
            this.getDockedFrameContainer().repaint();
        }
        if (this._floatingFrames != null) {
            for (FloatingContainer container : this._floatingFrames) {
                if (container == null) continue;
                JideSwingUtilities.setRecursively((Container)((Object)container), handler);
                container.validate();
                container.repaint();
            }
        }
    }

    private void internalSetShowGripper() {
        List<String> list = this.getAllFrameNames();
        for (String key : list) {
            DockableFrame frame = this.getFrame(key);
            if (frame == null) continue;
            frame.setShowGripper(this.isShowGripper());
        }
        if (this.getDockedFrameContainer() != null) {
            this.getDockedFrameContainer().validate();
            this.getDockedFrameContainer().repaint();
        }
        if (this._floatingFrames != null) {
            for (FloatingContainer container : this._floatingFrames) {
                container.validate();
                container.repaint();
            }
        }
    }

    private void internalSetShowDividerGripper(final boolean show) {
        JideSwingUtilities.Handler handler = new JideSwingUtilities.Handler(){

            @Override
            public boolean condition(Component c) {
                return c instanceof ContainerContainer;
            }

            @Override
            public void action(Component c) {
                ((ContainerContainer)c).setShowGripper(show);
            }

            @Override
            public void postAction(Component c) {
            }
        };
        JideSwingUtilities.setRecursively(this.getDockedFrameContainer(), handler);
        this.getDockedFrameContainer().repaint();
        if (this._floatingFrames != null) {
            for (FloatingContainer container : this._floatingFrames) {
                JideSwingUtilities.setRecursively(container.getContentPane(), handler);
                container.getContentPane().repaint();
            }
        }
    }

    private void internalSetShowTitleBar() {
        JideSwingUtilities.Handler handler = new JideSwingUtilities.Handler(){

            @Override
            public boolean condition(Component c) {
                return c instanceof DockableFrame;
            }

            @Override
            public void action(Component c) {
                if (c instanceof DockableFrame && !((DockableFrame)c).isShowTitleBarConfigured()) {
                    ((DockableFrame)c).internalSetShowTitleBar(DefaultDockingManager.this.isShowTitleBar());
                }
            }

            @Override
            public void postAction(Component c) {
            }
        };
        if (this.getDockedFrameContainer() != null) {
            JideSwingUtilities.setRecursively(this.getDockedFrameContainer(), handler);
            this.getDockedFrameContainer().validate();
            this.getDockedFrameContainer().repaint();
        }
        if (this._floatingFrames != null) {
            for (FloatingContainer container : this._floatingFrames) {
                JideSwingUtilities.setRecursively((Container)((Object)container), handler);
                container.validate();
                container.repaint();
            }
        }
        List<String> list = this.getAllFrameNames();
        for (String s : list) {
            DockableFrame frame = this.getFrame(s);
            if (frame == null || !frame.isAutohide() && !frame.isAutohideShowing() && !frame.isHidden() || frame.isShowTitleBarConfigured()) continue;
            frame.internalSetShowTitleBar(this.isShowTitleBar());
        }
    }

    @Override
    public Rectangle getInitBounds() {
        if (this._initBounds.isEmpty()) {
            Dimension size = PortingUtils.getScreenSize(this.getRootPaneContainerAsComponent());
            if (size.width <= 1024) {
                this._initBounds.setBounds(0, 0, size.width, size.height);
            } else {
                this._initBounds.setBounds(0, 0, 1024, 768);
            }
        }
        return this._initBounds;
    }

    @Override
    public void setInitBounds(Rectangle initBounds) {
        if (initBounds == null) {
            throw new IllegalArgumentException("InitBounds value cannot be null.");
        }
        Rectangle old = this._initBounds;
        if (!initBounds.equals(old)) {
            this._initBounds = initBounds;
            this.firePropertyChange("initBounds", old, initBounds);
        }
    }

    private void addContext(String key, DockContext dockContext) {
        this._allContexts.put(key, dockContext);
    }

    @Override
    public void removeContext(String key) {
        this._allContexts.remove(key);
    }

    @Override
    public int getInitState() {
        Dimension size = PortingUtils.getScreenSize(this.getRootPaneContainerAsComponent());
        Rectangle bounds = this.getInitBounds();
        if (bounds.width > size.width || bounds.height > size.height) {
            return 6;
        }
        return this._initState;
    }

    @Override
    public void setInitState(int initState) {
        int old = this._initState;
        if (old != initState) {
            this._initState = initState;
            this.firePropertyChange("initState", old, initState);
        }
    }

    @Override
    public int getSensitiveAreaSize() {
        return this._sensitiveAreaSize;
    }

    @Override
    public void setSensitiveAreaSize(int sensitiveAreaSize) {
        this._sensitiveAreaSize = sensitiveAreaSize;
    }

    @Override
    public int getOutsideSensitiveAreaSize() {
        return this._outsideSensitiveAreaSize;
    }

    @Override
    public void setOutsideSensitiveAreaSize(int sensitiveAreaSize) {
        this._outsideSensitiveAreaSize = sensitiveAreaSize;
    }

    @Override
    public int getOutlineMode() {
        if (SecurityUtils.isTranslucentWindowFeatureDisabled()) {
            if (this.isHeavyweightComponentEnabled()) {
                return 2;
            }
            if (this._outlineMode == 4) {
                return 3;
            }
            if (this._outlineMode == 5) {
                return 2;
            }
            return this._outlineMode;
        }
        if (this.isHeavyweightComponentEnabled()) {
            if (this._outlineMode == 0 || this._outlineMode == 1) {
                return 5;
            }
            if (this._outlineMode == 3) {
                return 4;
            }
        }
        return this._outlineMode;
    }

    @Override
    public void setOutlineMode(int outlineMode) {
        int old = this._outlineMode;
        if (this._outlineMode != outlineMode) {
            this._outlineMode = outlineMode;
            this.firePropertyChange("outlineMode", old, this._outlineMode);
        }
    }

    @Override
    public DockContext getContextOf(String frameKey) {
        DockContext dockContext = this._allContexts.get(frameKey);
        if (dockContext != null) {
            return dockContext;
        }
        return null;
    }

    @Override
    public PopupMenuCustomizer getPopupMenuCustomizer() {
        return this._popupMenuCustomizer;
    }

    @Override
    public void setPopupMenuCustomizer(PopupMenuCustomizer customizer) {
        this._popupMenuCustomizer = customizer;
    }

    @Override
    public void showContextMenu(Component source, Point point, DockableFrame dockableFrame, boolean onTab) {
        JPopupMenu menu = this.getContextMenu(dockableFrame, onTab);
        if (this.getPopupMenuCustomizer() != null) {
            this.getPopupMenuCustomizer().customizePopupMenu(menu, this, dockableFrame, onTab);
        }
        if (menu.getComponentCount() != 0) {
            JideSwingUtilities.showPopupMenu(menu, source, point.x, point.y);
        }
    }

    private JPopupMenu getContextMenu(DockableFrame dockableFrame, boolean onTab) {
        JidePopupMenu popup = new JidePopupMenu();
        Action closeAction = dockableFrame.getCloseAction();
        JMenuItem closeMI = popup.add(new JMenuItem(closeAction));
        closeMI.setName("DockableFrameTitlePane.close");
        closeMI.setMnemonic(this.getResourceString("DockableFrameTitlePane.closeMnemonic").charAt(0));
        if (dockableFrame.isAutohideShowing()) {
            JMenuItem hideAutohideMI = popup.add(new JMenuItem(dockableFrame.getHideAutohideAction()));
            hideAutohideMI.setName("DockableFrameTitlePane.hideAutohide");
            hideAutohideMI.setMnemonic(this.getResourceString("DockableFrameTitlePane.hideAutohideMnemonic").charAt(0));
        }
        JCheckBoxMenuItem floatMI = (JCheckBoxMenuItem)popup.add(new JCheckBoxMenuItem(dockableFrame.getFloatingAction(onTab || !this.isFloatAllTabs())));
        floatMI.setName("DockableFrameTitlePane.toggleFloating");
        floatMI.setMnemonic(this.getResourceString("DockableFrameTitlePane.floatingMnemonic").charAt(0));
        floatMI.setSelected(dockableFrame.isFloated());
        JCheckBoxMenuItem autohideMI = (JCheckBoxMenuItem)popup.add(new JCheckBoxMenuItem(dockableFrame.getAutohideAction()));
        autohideMI.setName("DockableFrameTitlePane.toggleAutohide");
        autohideMI.setMnemonic(this.getResourceString("DockableFrameTitlePane.autohideMnemonic").charAt(0));
        autohideMI.setSelected(dockableFrame.isAutohide() || dockableFrame.isAutohideShowing());
        if (dockableFrame.isMaximizable()) {
            JMenuItem maximizedMI = popup.add(new JMenuItem(dockableFrame.getMaximizeAction()));
            maximizedMI.setName("DockableFrameTitlePane.toggleMaximize");
            if (dockableFrame.isMaximized()) {
                maximizedMI.setText(this.getResourceString("DockableFrameTitlePane.restoreText"));
                maximizedMI.setMnemonic(this.getResourceString("DockableFrameTitlePane.restoreMnemonic").charAt(0));
            } else {
                maximizedMI.setText(this.getResourceString("DockableFrameTitlePane.maximizeText"));
                maximizedMI.setMnemonic(this.getResourceString("DockableFrameTitlePane.maximizeMnemonic").charAt(0));
            }
        }
        popup.addSeparator();
        JCheckBoxMenuItem dockableMI = (JCheckBoxMenuItem)popup.add(new JCheckBoxMenuItem(dockableFrame.getDockableAction()));
        dockableMI.setName("DockableFrameTitlePane.toggleDockable");
        dockableMI.setMnemonic(this.getResourceString("DockableFrameTitlePane.dockableMnemonic").charAt(0));
        dockableMI.setSelected(dockableFrame.isDockable());
        return popup;
    }

    private ChangeListener createChangeListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof FrameContainer) {
                    FrameContainer frameContainer = (FrameContainer)e.getSource();
                    if (!DefaultDockingManager.this.isRealized()) {
                        return;
                    }
                    DockableFrame oldFrame = frameContainer.getPreviousSelectedFrame();
                    DockableFrame frame = frameContainer.getSelectedFrame();
                    if (oldFrame != null && oldFrame.equals(frame)) {
                        return;
                    }
                    if (oldFrame != null) {
                        oldFrame.setVisible(false);
                        oldFrame.fireDockableFrameEvent(4010);
                    }
                    if (frame != null) {
                        frame.setVisible(true);
                        frame.fireDockableFrameEvent(4009);
                        frameContainer.setPreviousSelectedFrame(frame);
                    }
                }
            }
        };
    }

    private SidePaneListener createSidePaneListener() {
        return new SidePaneListener(){

            @Override
            public void sidePaneTabSelected(SidePaneEvent e) {
                this.fireDockableFrameSidePaneEvent(e);
            }

            @Override
            public void sidePaneTabDeselected(SidePaneEvent e) {
                this.fireDockableFrameSidePaneEvent(e);
            }

            public void fireDockableFrameSidePaneEvent(SidePaneEvent e) {
                SidePaneItem item = e.getSidePaneItem();
                if (item == null) {
                    return;
                }
                Component comp = item.getComponent();
                if (comp == null || !(comp instanceof DockableFrame)) {
                    return;
                }
                DockableFrame frame = (DockableFrame)comp;
                int id = e.getID();
                if (id < 4099 || id > 4100) {
                    return;
                }
                switch (id) {
                    case 4099: {
                        frame.fireDockableFrameEvent(4009);
                        break;
                    }
                    case 4100: {
                        frame.fireDockableFrameEvent(4010);
                        break;
                    }
                }
            }
        };
    }

    @Override
    public Component getEscapeKeyTargetComponent() {
        if (this._escapeKeyTargetComponent == null && this._workspace.isVisible()) {
            return this._workspace;
        }
        return this._escapeKeyTargetComponent;
    }

    @Override
    public void setEscapeKeyTargetComponent(Component escapeKeyTargetComponent) {
        this._escapeKeyTargetComponent = escapeKeyTargetComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void dispose() {
        void object;
        this._dockableFramePropertyChangeListener = null;
        if (this._slidingAnimator != null) {
            this._slidingAnimator.hideImmediately();
        }
        this._slidingAnimator = null;
        if (this._rootPaneContainer instanceof Window) {
            ((Window)((Object)this._rootPaneContainer)).removeWindowListener(this.getFloatingContainerWindowListener());
        }
        this.disposeAllFloatingFrames();
        List<String> list = this._allFrameKeys;
        DockableFrame[] frames = new DockableFrame[list.size()];
        boolean bl = false;
        while (object < list.size()) {
            String key = list.get((int)object);
            frames[object] = this.getFrame(key);
            if (frames[object] != null && frames[object].getParent() instanceof FrameContainer && this._changeListener != null) {
                ((FrameContainer)frames[object].getParent()).removeChangeListener(this._changeListener);
            }
            ++object;
        }
        this.removeAllFrames();
        for (DockableFrame frame : frames) {
            if (frame == null) continue;
            if (frame.getParent() != null) {
                frame.getParent().remove(frame);
            }
            frame.dispose();
        }
        this.removeFocusOwnerChangeListener();
        MenuSelectionManager.defaultManager().removeChangeListener(_listenerMenuChangeStateListener);
        _listenerMenuChangeStateListener = null;
        this.removeGlobalEventHandler();
        DelegateAction.restoreAction(this.getMainContainer(), 1, KeyStroke.getKeyStroke(27, 0));
        this._escAction = null;
        if (this.getWorkspace() != null) {
            this.getWorkspace().removeAll();
        }
        this._keyEventDispatcher = null;
        if (this._allContexts != null) {
            this._allContexts.clear();
        }
        if (this.getRootPaneContainerAsComponent() != null) {
            this.getRootPaneContainerAsComponent().removeComponentListener(this._componentListener);
        }
        if (this._rootPaneContainer instanceof Window) {
            ((Window)((Object)this._rootPaneContainer)).removeWindowListener(this._windowListener);
            ((Window)((Object)this._rootPaneContainer)).removeWindowStateListener(this._windowStateListener);
        }
        this._rootPaneContainer = null;
        this._windowListener = null;
        this._windowStateListener = null;
        this._componentListener = null;
        if (this._eastContainer != null) {
            this._eastContainer.removeAll();
            this._eastContainer = null;
        }
        if (this._westContainer != null) {
            this._westContainer.removeAll();
            this._westContainer = null;
        }
        if (this._northContainer != null) {
            this._northContainer.removeAll();
            this._northContainer = null;
        }
        if (this._southContainer != null) {
            this._southContainer.removeAll();
            this._southContainer = null;
        }
        if (this._floatingFrames != null) {
            this._floatingFrames.clear();
            this._floatingFrames = null;
        }
        if (this._orderedFloatingFrames != null) {
            this._orderedFloatingFrames.clear();
            this._orderedFloatingFrames = null;
        }
        if (this._hiddenFrames != null) {
            this._hiddenFrames.clear();
            this._hiddenFrames = null;
        }
        this._dragContour = null;
        if (this._zorderFrameHandles != null) {
            this._zorderFrameHandles.clear();
            this._zorderFrameHandles = null;
        }
        this._activeFrame = null;
        this._maximizedFrame = null;
        this._maximizedOtherFloatingFrames = null;
        this._maximizeFramePreviousState = -1;
        this._workspace = null;
        if (this._contentContainer != null) {
            this._contentContainer.removeAll();
            this._contentContainer = null;
        }
        this._escapeKeyTargetComponent = null;
        if (this._tempCs != null) {
            this._tempCs.clear();
            this._tempCs = null;
        }
        if (this._tempCCs != null) {
            this._tempCCs.clear();
            this._tempCCs = null;
        }
        this._tabbedPaneCustomizer = null;
        this._popupMenuCustomizer = null;
        this._changeListener = null;
        this._sidePaneListener = null;
        if (this._dockedFrameContainer != null) {
            this._dockedFrameContainer.removeAll();
            this._dockedFrameContainer = null;
        }
        if (this._dockedHiddenSlidingContainer != null) {
            this._dockedHiddenSlidingContainer.removeAll();
            this._dockedHiddenSlidingContainer = null;
        }
        if (this._panelMain != null) {
            this._panelMain.removeAll();
            this._panelMain = null;
        }
        this._internalRoutingFrameListener = null;
        DockID.getInstance(this).releaseAll();
        DockID.removeInstance(this);
        _zorderDockingManagers.remove(this);
        List<DockingManager> list2 = _dockingManagers;
        synchronized (list2) {
            _dockingManagers.remove(this);
        }
        if (_dockingManagers.size() == 0) {
            DefaultDockingManager.removeMouseEventHandler();
            _listenerMenuChangeStateListener = null;
        }
    }

    private void disposeAllFloatingFrames() {
        if (this._floatingFrames != null) {
            for (int i = this._floatingFrames.size() - 1; i >= 0; --i) {
                FloatingContainer floatingContainer = (FloatingContainer)this._floatingFrames.get(i);
                floatingContainer.setVisible(false);
                floatingContainer.removeAll();
                if (floatingContainer instanceof Component && ((Component)((Object)floatingContainer)).getParent() != null) {
                    ((Component)((Object)floatingContainer)).getParent().remove((Component)((Object)floatingContainer));
                }
                floatingContainer.removeWindowListener(this.getFloatingContainerWindowListener());
                this.disposeFloatingContainer(floatingContainer);
            }
            this._floatingFrames.clear();
            if (this._rootPaneContainer instanceof Window) {
                ((Window)((Object)this._rootPaneContainer)).removeWindowListener(this._floatingContainerWindowListener);
            }
            this._floatingContainerWindowListener = null;
        }
        if (this._orderedFloatingFrames != null) {
            this._orderedFloatingFrames.clear();
            if (this.getRootPaneContainerAsComponent() != null) {
                this._orderedFloatingFrames.add(this.getRootPaneContainerAsComponent());
            }
        }
    }

    private void updateAllFloatingFramesTitle() {
        if (this._floatingFrames != null) {
            for (FloatingContainer floatingContainer : this._floatingFrames) {
                floatingContainer.updateTitle();
            }
        }
    }

    private void dockToContainerContainerDuringDragging(FrameContainer componentToBeDocked, ContainerContainer containerContainer, int side, Container parent) {
        boolean ltr = parent.getComponentOrientation().isLeftToRight();
        int adjustSide = side == 8 && !ltr ? 4 : (side == 4 && !ltr ? 8 : side);
        int frameContainerCount = DockingUtils.getFrameContainerCount(this, containerContainer);
        switch (adjustSide) {
            case 8: {
                List<DockableFrame> dockableFrames;
                if (containerContainer.getOrientation() == 1) {
                    containerContainer.insertPane(componentToBeDocked, 0);
                    containerContainer.validate();
                    break;
                }
                if (frameContainerCount == 0) {
                    containerContainer.setOrientation(1);
                    containerContainer.insertPane(componentToBeDocked, 0);
                    containerContainer.validate();
                    break;
                }
                if (frameContainerCount == 1 && (dockableFrames = DockingUtils.getAllDockableFrameOf(containerContainer)).size() > 0) {
                    DockableFrame frame = dockableFrames.get(0);
                    boolean inserted = false;
                    for (Container frameParent = frame.getParent(); frameParent != containerContainer; frameParent = frameParent.getParent()) {
                        if (!(frameParent instanceof ContainerContainer) || ((ContainerContainer)frameParent).getOrientation() != 1) continue;
                        ((ContainerContainer)frameParent).insertPane(componentToBeDocked, 0);
                        frameParent.validate();
                        inserted = true;
                        break;
                    }
                    if (inserted) break;
                }
                ContainerContainer newContainer = this.createContainerContainer();
                newContainer.setOrientation(1);
                newContainer.add(componentToBeDocked);
                newContainer.add(containerContainer);
                parent.add((Component)newContainer, "Center");
                parent.validate();
                break;
            }
            case 4: {
                List<DockableFrame> dockableFrames;
                if (containerContainer.getOrientation() == 1) {
                    containerContainer.add(componentToBeDocked);
                    containerContainer.validate();
                    break;
                }
                if (frameContainerCount == 0) {
                    containerContainer.setOrientation(1);
                    containerContainer.addPane(componentToBeDocked);
                    containerContainer.validate();
                    break;
                }
                if (frameContainerCount == 1 && (dockableFrames = DockingUtils.getAllDockableFrameOf(containerContainer)).size() > 0) {
                    DockableFrame frame = dockableFrames.get(0);
                    boolean inserted = false;
                    for (Container frameParent = frame.getParent(); frameParent != containerContainer; frameParent = frameParent.getParent()) {
                        if (!(frameParent instanceof ContainerContainer) || ((ContainerContainer)frameParent).getOrientation() != 1) continue;
                        ((ContainerContainer)frameParent).addPane(componentToBeDocked);
                        frameParent.validate();
                        inserted = true;
                        break;
                    }
                    if (inserted) break;
                }
                ContainerContainer newContainer = this.createContainerContainer();
                newContainer.setOrientation(1);
                newContainer.add(containerContainer);
                newContainer.add(componentToBeDocked);
                parent.add((Component)newContainer, "Center");
                parent.validate();
                break;
            }
            case 1: {
                List<DockableFrame> dockableFrames;
                if (containerContainer.getOrientation() == 0) {
                    containerContainer.insertPane(componentToBeDocked, 0);
                    containerContainer.validate();
                    break;
                }
                if (frameContainerCount == 0) {
                    containerContainer.setOrientation(0);
                    containerContainer.insertPane(componentToBeDocked, 0);
                    containerContainer.validate();
                    break;
                }
                if (frameContainerCount == 1 && (dockableFrames = DockingUtils.getAllDockableFrameOf(containerContainer)).size() > 0) {
                    DockableFrame frame = dockableFrames.get(0);
                    boolean inserted = false;
                    for (Container frameParent = frame.getParent(); frameParent != containerContainer; frameParent = frameParent.getParent()) {
                        if (!(frameParent instanceof ContainerContainer) || ((ContainerContainer)frameParent).getOrientation() != 0) continue;
                        ((ContainerContainer)frameParent).insertPane(componentToBeDocked, 0);
                        frameParent.validate();
                        inserted = true;
                        break;
                    }
                    if (inserted) break;
                }
                ContainerContainer newContainer = this.createContainerContainer();
                newContainer.setOrientation(0);
                newContainer.add(componentToBeDocked);
                newContainer.add(containerContainer);
                parent.add((Component)newContainer, "Center");
                parent.validate();
                break;
            }
            case 2: {
                List<DockableFrame> dockableFrames;
                if (containerContainer.getOrientation() == 0) {
                    containerContainer.add(componentToBeDocked);
                    containerContainer.validate();
                    break;
                }
                if (frameContainerCount == 0) {
                    containerContainer.setOrientation(0);
                    containerContainer.addPane(componentToBeDocked);
                    containerContainer.validate();
                    break;
                }
                if (frameContainerCount == 1 && (dockableFrames = DockingUtils.getAllDockableFrameOf(containerContainer)).size() > 0) {
                    DockableFrame frame = dockableFrames.get(0);
                    boolean inserted = false;
                    for (Container frameParent = frame.getParent(); frameParent != containerContainer; frameParent = frameParent.getParent()) {
                        if (!(frameParent instanceof ContainerContainer) || ((ContainerContainer)frameParent).getOrientation() != 0) continue;
                        ((ContainerContainer)frameParent).addPane(componentToBeDocked);
                        frameParent.validate();
                        inserted = true;
                        break;
                    }
                    if (inserted) break;
                }
                ContainerContainer newContainer = this.createContainerContainer();
                newContainer.setOrientation(0);
                newContainer.add(containerContainer);
                newContainer.add(componentToBeDocked);
                parent.add((Component)newContainer, "Center");
                parent.validate();
            }
        }
    }

    private void dockToContainerContainer(FrameContainer componentToBeDocked, ContainerContainer containerContainer, int side, Container parent) {
        switch (side) {
            case 8: {
                Container container;
                if (containerContainer.getOrientation() == 1) {
                    containerContainer.insertPane(componentToBeDocked, 0);
                    containerContainer.validate();
                    break;
                }
                if (this.getInitSplitPriority() == 0) {
                    ContainerContainer newContainer = this.createContainerContainer();
                    newContainer.setOrientation(1);
                    newContainer.add(componentToBeDocked);
                    newContainer.add(containerContainer);
                    parent.add((Component)newContainer, "Center");
                    parent.validate();
                    break;
                }
                Component ws = PreviousState.findComponentByDockID(this, containerContainer, 3);
                if (ws == null || !((container = ws.getParent()) instanceof ContainerContainer)) break;
                ContainerContainer cc = (ContainerContainer)container;
                if (cc.getOrientation() == 1) {
                    cc.add((Component)componentToBeDocked, 0);
                    break;
                }
                int index = cc.indexOf(ws);
                ContainerContainer newContainer = this.createContainerContainer();
                newContainer.setOrientation(1);
                newContainer.add(componentToBeDocked);
                newContainer.add(ws);
                if (index > cc.getComponentCount()) {
                    index = cc.getComponentCount();
                } else if (index < 0) {
                    index = 0;
                }
                cc.add((Component)newContainer, index);
                cc.validate();
                break;
            }
            case 4: {
                Container container;
                if (containerContainer.getOrientation() == 1) {
                    containerContainer.add(componentToBeDocked);
                    containerContainer.validate();
                    break;
                }
                if (this.getInitSplitPriority() == 0) {
                    ContainerContainer newContainer = this.createContainerContainer();
                    newContainer.setOrientation(1);
                    newContainer.add(containerContainer);
                    newContainer.add(componentToBeDocked);
                    parent.add((Component)newContainer, "Center");
                    parent.validate();
                    break;
                }
                Component ws = PreviousState.findComponentByDockID(this, containerContainer, 3);
                if (ws == null || !((container = ws.getParent()) instanceof ContainerContainer)) break;
                ContainerContainer cc = (ContainerContainer)container;
                if (cc.getOrientation() == 1) {
                    cc.add(componentToBeDocked);
                    break;
                }
                int index = cc.indexOf(ws);
                ContainerContainer newContainer = this.createContainerContainer();
                newContainer.setOrientation(1);
                newContainer.add(ws);
                newContainer.add(componentToBeDocked);
                if (index > cc.getComponentCount()) {
                    index = cc.getComponentCount();
                } else if (index < 0) {
                    index = 0;
                }
                cc.add((Component)newContainer, index);
                cc.validate();
                break;
            }
            case 1: {
                Container container;
                if (containerContainer.getOrientation() == 0) {
                    containerContainer.insertPane(componentToBeDocked, 0);
                    containerContainer.validate();
                    break;
                }
                if (this.getInitSplitPriority() == 1) {
                    ContainerContainer newContainer = this.createContainerContainer();
                    newContainer.setOrientation(0);
                    newContainer.add(componentToBeDocked);
                    newContainer.add(containerContainer);
                    parent.add((Component)newContainer, "Center");
                    parent.validate();
                    break;
                }
                Component ws = PreviousState.findComponentByDockID(this, containerContainer, 3);
                if (ws == null || !((container = ws.getParent()) instanceof ContainerContainer)) break;
                ContainerContainer cc = (ContainerContainer)container;
                if (cc.getOrientation() == 0) {
                    cc.add((Component)componentToBeDocked, 0);
                    break;
                }
                int index = cc.indexOf(ws);
                ContainerContainer newContainer = this.createContainerContainer();
                newContainer.setOrientation(0);
                newContainer.add(componentToBeDocked);
                newContainer.add(ws);
                if (index > cc.getComponentCount()) {
                    index = cc.getComponentCount();
                } else if (index < 0) {
                    index = 0;
                }
                cc.add((Component)newContainer, index);
                cc.validate();
                break;
            }
            case 2: {
                Container container;
                if (containerContainer.getOrientation() == 0) {
                    containerContainer.add(componentToBeDocked);
                    containerContainer.validate();
                    break;
                }
                if (this.getInitSplitPriority() == 1) {
                    ContainerContainer newContainer = this.createContainerContainer();
                    newContainer.setOrientation(0);
                    newContainer.add(containerContainer);
                    newContainer.add(componentToBeDocked);
                    parent.add((Component)newContainer, "Center");
                    parent.validate();
                    break;
                }
                Component ws = PreviousState.findComponentByDockID(this, containerContainer, 3);
                if (ws == null || !((container = ws.getParent()) instanceof ContainerContainer)) break;
                ContainerContainer cc = (ContainerContainer)container;
                if (cc.getOrientation() == 0) {
                    cc.add(componentToBeDocked);
                    break;
                }
                int index = cc.indexOf(ws);
                ContainerContainer newContainer = this.createContainerContainer();
                newContainer.setOrientation(0);
                newContainer.add(ws);
                newContainer.add(componentToBeDocked);
                if (index > cc.getComponentCount()) {
                    index = cc.getComponentCount();
                } else if (index < 0) {
                    index = 0;
                }
                cc.add((Component)newContainer, index);
                cc.validate();
            }
        }
    }

    @Override
    public int getInitDelay() {
        return this._initDelay;
    }

    @Override
    public void setInitDelay(int initDelay) {
        int old = this._initDelay;
        if (this._initDelay != initDelay) {
            this._initDelay = initDelay;
            this.firePropertyChange("initDelay", old, this._initDelay);
        }
    }

    @Override
    public int getStepDelay() {
        return this._stepDelay;
    }

    @Override
    public void setStepDelay(int stepDelay) {
        int old = this._stepDelay;
        if (this._stepDelay != stepDelay) {
            this._stepDelay = stepDelay;
            this.firePropertyChange("stepDelay", old, this._stepDelay);
        }
    }

    @Override
    public int getSteps() {
        return this._steps;
    }

    @Override
    public void setSteps(int steps) {
        if (steps <= 0) {
            throw new IllegalArgumentException("steps must be greater than 0.");
        }
        int old = this._steps;
        if (this._steps != steps) {
            this._steps = steps;
            this.firePropertyChange("steps", old, this._steps);
        }
    }

    @Override
    public boolean isEasyTabDock() {
        return this._easyTabDock;
    }

    @Override
    public void setEasyTabDock(boolean easyTabDock) {
        if (this._easyTabDock != easyTabDock) {
            boolean old = this._easyTabDock;
            this._easyTabDock = easyTabDock;
            this.firePropertyChange("easyTabDock", old, this._easyTabDock);
        }
    }

    @Override
    public boolean isTabDockAllowed() {
        return this._tabDockAllowed;
    }

    @Override
    public void setTabDockAllowed(boolean tabDockAllowed) {
        if (this._tabDockAllowed != tabDockAllowed) {
            boolean old = this._tabDockAllowed;
            this._tabDockAllowed = tabDockAllowed;
            this.firePropertyChange("tabDockAllowed", old, this._tabDockAllowed);
        }
    }

    @Override
    public boolean isTabReorderAllowed() {
        return this._tabReorderAllowed;
    }

    @Override
    public void setTabReorderAllowed(boolean tabReorderAllowed) {
        if (this._tabReorderAllowed != tabReorderAllowed) {
            boolean old = this._tabReorderAllowed;
            this._tabReorderAllowed = tabReorderAllowed;
            this.firePropertyChange("tabReorderAllowed", old, this._tabReorderAllowed);
        }
    }

    @Override
    public boolean isNestedFloatingAllowed() {
        return this._nestedFloatingAllowed;
    }

    @Override
    public void setNestedFloatingAllowed(boolean nestedFloatingAllowed) {
        boolean old = this._nestedFloatingAllowed;
        if (this._nestedFloatingAllowed != nestedFloatingAllowed) {
            this._nestedFloatingAllowed = nestedFloatingAllowed;
            this.firePropertyChange("nestedFloatingAllowed", old, this._nestedFloatingAllowed);
        }
    }

    @Override
    public boolean isDragAllTabs() {
        return this._dragAllTabs;
    }

    @Override
    public void setDragAllTabs(boolean dragAllTabs) {
        boolean old = this._dragAllTabs;
        if (this._dragAllTabs != dragAllTabs) {
            this._dragAllTabs = dragAllTabs;
            this.firePropertyChange("dragAllTabs", old, this._dragAllTabs);
        }
    }

    @Override
    public boolean isShowGripper() {
        return this._showGripper;
    }

    @Override
    public void setShowGripper(boolean showGripper) {
        boolean old = this._showGripper;
        if (this._showGripper != showGripper) {
            this._showGripper = showGripper;
            if (SwingUtilities.isEventDispatchThread()) {
                this.internalSetShowGripper();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            DefaultDockingManager.this.internalSetShowGripper();
                        }
                    });
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    JideSwingUtilities.throwInvocationTargetException(e);
                }
            }
            this.firePropertyChange("showGripper", old, this._showGripper);
        }
    }

    @Override
    public boolean isShowDividerGripper() {
        return this._showDividerGripper;
    }

    @Override
    public void setShowDividerGripper(boolean showDividerGripper) {
        boolean old = this._showDividerGripper;
        if (this._showDividerGripper != showDividerGripper) {
            this._showDividerGripper = showDividerGripper;
            if (SwingUtilities.isEventDispatchThread()) {
                this.internalSetShowDividerGripper(this._showDividerGripper);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            DefaultDockingManager.this.internalSetShowDividerGripper(DefaultDockingManager.this._showDividerGripper);
                        }
                    });
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    JideSwingUtilities.throwInvocationTargetException(e);
                }
            }
            this.firePropertyChange("showDividerGripper", old, this._showDividerGripper);
        }
    }

    @Override
    public boolean isDragGripperOnly() {
        return this._dragGripperOnly;
    }

    @Override
    public void setDragGripperOnly(boolean dragGripperOnly) {
        boolean old = this._dragGripperOnly;
        if (this._dragGripperOnly != dragGripperOnly) {
            this._dragGripperOnly = dragGripperOnly;
            this.firePropertyChange("dragGripperOnly", old, this._dragGripperOnly);
        }
    }

    @Override
    public boolean isShowTitleBar() {
        return this._showTitleBar;
    }

    @Override
    public void setShowTitleBar(boolean showTitleBar) {
        boolean old = this._showTitleBar;
        if (this._showTitleBar != showTitleBar) {
            this._showTitleBar = showTitleBar;
            if (SwingUtilities.isEventDispatchThread()) {
                this.internalSetShowTitleBar();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            DefaultDockingManager.this.internalSetShowTitleBar();
                        }
                    });
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    JideSwingUtilities.throwInvocationTargetException(e);
                }
            }
            this.firePropertyChange("showTitleBar", old, this._showTitleBar);
        }
    }

    @Override
    public void setAutohideShowingContentHidden(boolean hide) {
        boolean old = this._autohideShowingContentHidden;
        if (this._autohideShowingContentHidden != hide) {
            this._autohideShowingContentHidden = hide;
            this.firePropertyChange("autohideShowingContentHidden", old, this._autohideShowingContentHidden);
        }
    }

    @Override
    public boolean isAutohideShowingContentHidden() {
        return this._autohideShowingContentHidden;
    }

    @Override
    public boolean isSidebarRollover() {
        return this._sidebarRollover;
    }

    @Override
    public void setSidebarRollover(boolean sidebarRollover) {
        boolean old = this._sidebarRollover;
        if (this._sidebarRollover != sidebarRollover) {
            this._sidebarRollover = sidebarRollover;
            if (this._westContainer != null) {
                this._westContainer.setRollover(sidebarRollover);
            }
            if (this._eastContainer != null) {
                this._eastContainer.setRollover(sidebarRollover);
            }
            if (this._southContainer != null) {
                this._southContainer.setRollover(sidebarRollover);
            }
            if (this._northContainer != null) {
                this._northContainer.setRollover(sidebarRollover);
            }
            this.firePropertyChange("sidebarRollover", old, this._sidebarRollover);
        }
    }

    private void internalSetFrameAvailable(DockableFrame f) {
        if (f.getContext() == null || f.isAvailable()) {
            return;
        }
        if (!this._allFrames.containsKey(f.getKey())) {
            this.addFrame(f);
        }
        if (!f.isHidden() && !f.isVisible()) {
            f.setVisible(true);
        }
        f.setAvailable(true);
        if (!this.loadAvailablePreviousState(f)) {
            if (!f.isAutohideShowing()) {
                if (f.isAutohide()) {
                    this.internalStartShowingAutohideFrame(f, f.getContext().getCurrentDockSide(), 0);
                } else if (!f.isFloated() && !f.isDocked()) {
                    if (f.isDockable()) {
                        this.internalDockFrame(f, this.getDockedFrameContainer(), true);
                    } else {
                        this.internalFloatOutFrame(f);
                    }
                }
            }
        } else if (f.isAutohideShowing()) {
            this.internalStartShowingAutohideFrame(f, f.getContext().getCurrentDockSide(), 0);
        }
    }

    @Override
    public void setFrameAvailable(String key) {
        final DockableFrame frame = this.getFrame(key);
        if (frame == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalSetFrameAvailable(frame);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockingManager.this.internalSetFrameAvailable(frame);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    @Override
    public void setFrameUnavailable(String key) {
        final DockableFrame frame = this.getFrame(key);
        if (frame == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalSetFrameUnavailable(frame);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockingManager.this.internalSetFrameUnavailable(frame);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    private void internalSetFrameUnavailable(DockableFrame f) {
        if (f.getContext() == null || !f.isAvailable()) {
            return;
        }
        if (!this._allFrames.containsKey(f.getKey())) {
            this.addFrame(f);
        }
        if (f.isMaximized()) {
            this.restoreFrame();
        }
        DockingUtils.saveAvailablePreviousState(f);
        if (!f.isAutohideShowing() && !f.isAutohide()) {
            this.saveState(f);
            if (f.getParent() != null) {
                f.getParent().remove(f);
            }
            this.loadState();
        } else {
            AutoHideContainer container;
            if (f.isAutohideShowing()) {
                this.stopShowingAutohideFrameImmediately();
            }
            if ((container = this.getAutoHideContainer(f.getContext().getCurrentDockSide())) != null) {
                container.removeFrame(f);
                container.repaint();
            }
        }
        f.setAvailable(false);
        this.resetLayout();
    }

    @Override
    public void setUndoLimit(int undoLimit) {
        int old = this.getUndoManager().getLimit();
        if (old != undoLimit) {
            this.getUndoManager().setLimit(undoLimit);
            this.firePropertyChange("undoLimit", old, undoLimit);
        }
    }

    public int getUndoLimit() {
        return this.getUndoManager().getLimit();
    }

    @Override
    public void discardAllUndoEdits() {
        this.getUndoManager().discardAllEdits();
    }

    private boolean containsFrame(byte[] layoutData, String frameKey) {
        if (layoutData == null) {
            return false;
        }
        if (PersistenceUtils.isXmlFormat(layoutData)) {
            return DockingPersistenceUtils.containsFrameKey(this, layoutData, frameKey);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(layoutData);
        DataInputStream stream = new DataInputStream(inputStream);
        try {
            SaveUtils.readVersion(stream);
            SaveUtils.readRectangle(stream);
            SaveUtils.readInt(stream);
            HashMap<String, DockContext> allContexts = new HashMap<String, DockContext>();
            SaveUtils.readContext(this, stream, allContexts);
            return allContexts.containsKey(frameKey);
        }
        catch (IOException e) {
            return false;
        }
    }

    void discardAllUndoEdits(String frameKey) {
        if (this.getUndoManager() instanceof DockingManagerUndoManager) {
            UndoableEdit[] allEdits;
            for (UndoableEdit edit : allEdits = ((DockingManagerUndoManager)this.getUndoManager()).getAllEdits()) {
                if (!(edit instanceof DockingManagerUndoableEdit) || !this.containsFrame(((DockingManagerUndoableEdit)edit).getUndoLayout(), frameKey) && !this.containsFrame(((DockingManagerUndoableEdit)edit).getRedoLayout(), frameKey)) continue;
                ((DockingManagerUndoManager)this.getUndoManager()).removeEdit(edit);
                this.getUndoableEditSupport().postEdit(edit);
            }
        }
    }

    @Override
    public void undo() {
        try {
            if (this.getUndoManager().canUndo()) {
                this.getUndoManager().undo();
            }
        }
        catch (CannotUndoException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void redo() {
        try {
            if (this.getUndoManager().canRedo()) {
                this.getUndoManager().redo();
            }
        }
        catch (CannotRedoException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public UndoManager getUndoManager() {
        if (this._undoManager == null) {
            this._undoManager = this.createUndoManager();
        }
        return this._undoManager;
    }

    protected UndoManager createUndoManager() {
        return new DockingManagerUndoManager();
    }

    @Override
    public void beginCompoundEdit(boolean isUndoRedo) {
    }

    @Override
    public void endCompoundEdit() {
    }

    @Override
    public boolean isPreserveAvailableProperty() {
        return this._preserveAvailableProperty;
    }

    @Override
    public void setPreserveAvailableProperty(boolean preserveAvailableProperty) {
        this._preserveAvailableProperty = preserveAvailableProperty;
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener listener) {
        this.getUndoableEditSupport().addUndoableEditListener(listener);
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.getUndoableEditSupport().removeUndoableEditListener(listener);
    }

    @Override
    public void addUndo(String name) {
        if (this.getUndoManager().getLimit() > 0) {
            DockingManagerUndoableEdit edit = new DockingManagerUndoableEdit(name, this);
            this.getUndoManager().addEdit(edit);
            this.getUndoableEditSupport().postEdit(edit);
        }
    }

    @Override
    public UndoableEditSupport getUndoableEditSupport() {
        if (this._undoableEditSupport == null) {
            this._undoableEditSupport = new UndoableEditSupport();
        }
        return this._undoableEditSupport;
    }

    @Override
    public void maximizeFrame(String key) {
        final DockableFrame frame = this.getFrame(key);
        if (frame == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalMaximizeFrame(frame, true);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockingManager.this.internalMaximizeFrame(frame, true);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    void internalMaximizeFrame(DockableFrame f, boolean activate) {
        if (f.getContext() == null || !f.isAvailable()) {
            return;
        }
        if (!this._allFrames.containsKey(f.getKey())) {
            this.addFrame(f);
        }
        if (f.isMaximized() || !f.isMaximizable()) {
            return;
        }
        if (f.isHidden()) {
            this.internalShowFrame(f);
        }
        if (activate) {
            this.activateFrame(f.getKey());
        }
        this._maximizeFramePreviousState = 4;
        if (!f.isDocked()) {
            if (f.isAutohide() || f.isAutohideShowing()) {
                this._maximizeFramePreviousState = 2;
                this.internalToggleAutohideState(f, false);
            } else if (f.isFloated()) {
                FrameContainer frameContainer;
                int tabCount;
                this._maximizeFramePreviousState = 1;
                if (this.isMaximizeAllTabs() && f.getParent() instanceof FrameContainer && (tabCount = (frameContainer = (FrameContainer)f.getParent()).getTabCount()) > 1) {
                    this._maximizedOtherFloatingFrames = new DockableFrame[tabCount - 1];
                    int index = 0;
                    for (int i = 0; i < tabCount; ++i) {
                        if (frameContainer.getFrame(i) == f) continue;
                        this._maximizedOtherFloatingFrames[index] = frameContainer.getFrame(i);
                        ++index;
                    }
                }
                this.internalToggleState(f, !this.isMaximizeAllTabs());
            }
        }
        if (!f.isDocked()) {
            this._maximizeFramePreviousState = -1;
            this._maximizedOtherFloatingFrames = null;
            return;
        }
        if (this.isMaximizeAllTabs()) {
            Container parent = f.getParent();
            if (parent instanceof FrameContainer) {
                int i;
                FrameContainer frameContainer = (FrameContainer)parent;
                for (i = 0; i < frameContainer.getTabCount(); ++i) {
                    DockingUtils.saveMaximizedPreviousState(frameContainer.getFrame(i));
                }
                JideSwingUtilities.removeFromParentWithFocusTransfer(parent);
                this.getDockedFrameContainer().getMaximizeContainer().add((Component)parent, "Center");
                this.getDockedFrameContainer().showMaximizeContainer();
                for (i = 0; i < frameContainer.getTabCount(); ++i) {
                    try {
                        DockableFrame frame = frameContainer.getFrame(i);
                        frame.setMaximized(true);
                        if (frame != f) continue;
                        this._maximizedFrame = f;
                        continue;
                    }
                    catch (PropertyVetoException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        } else {
            DockingUtils.saveMaximizedPreviousState(f);
            FrameContainer fc = this.createFrameContainer();
            fc.addTab(f, true);
            this.getDockedFrameContainer().getMaximizeContainer().add((Component)fc, "Center");
            this.getDockedFrameContainer().showMaximizeContainer();
            try {
                f.setMaximized(true);
                this._maximizedFrame = f;
            }
            catch (PropertyVetoException e) {
                throw new RuntimeException(e);
            }
        }
        this.resetLayout();
        if (activate) {
            this.activateFront(true);
        }
    }

    private DockableFrame getInternalMaximizedFrame() {
        return this._maximizedFrame;
    }

    @Override
    public String getMaximizedFrameKey() {
        DockableFrame f = this.getInternalMaximizedFrame();
        if (f == null) {
            return null;
        }
        return f.getKey();
    }

    @Override
    public void restoreFrame() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalRestoreFrame(true);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockingManager.this.internalRestoreFrame(true);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    void internalRestoreFrame(boolean activate) {
        DockableFrame f = this.getInternalMaximizedFrame();
        if (f == null) {
            return;
        }
        if (f.getContext() == null || !f.isAvailable()) {
            return;
        }
        if (!f.isMaximized()) {
            return;
        }
        if (!f.isHidden() && !f.isVisible()) {
            f.setVisible(true);
        }
        if (this.isMaximizeAllTabs()) {
            JideSwingUtilities.removeFromParentWithFocusTransfer(f.getParent());
            this.getDockedFrameContainer().getMaximizeContainer().remove(f.getParent());
            this.getDockedFrameContainer().showNormalContainer();
            Container parent = f.getParent();
            if (parent instanceof FrameContainer) {
                FrameContainer frameContainer = (FrameContainer)parent;
                int selectedIndex = frameContainer.getSelectedIndex();
                for (int i = frameContainer.getTabCount() - 1; i >= 0; --i) {
                    DockableFrame frame = frameContainer.getFrame(i);
                    try {
                        frame.setMaximized(false);
                    }
                    catch (PropertyVetoException e) {
                        e.printStackTrace();
                    }
                    if (frame == f) continue;
                    this.loadMaximizePreviousState(frame);
                }
                this.loadMaximizePreviousState(f);
                ((FrameContainer)f.getParent()).setSelectedIndex(selectedIndex);
                this._maximizedFrame = null;
            }
        } else {
            JideSwingUtilities.removeFromParentWithFocusTransfer(f);
            this.getDockedFrameContainer().getMaximizeContainer().remove(f);
            this.getDockedFrameContainer().showNormalContainer();
            this.loadMaximizePreviousState(f);
            try {
                f.setMaximized(false);
                this._maximizedFrame = null;
            }
            catch (PropertyVetoException e) {
                throw new RuntimeException(e);
            }
        }
        if (this._maximizeFramePreviousState != -1) {
            if (this._maximizeFramePreviousState == 2) {
                this.internalToggleAutohideState(f, false);
            } else if (this._maximizeFramePreviousState == 1) {
                ArrayList<DockableFrame> framesToFloat = null;
                if (f.getParent() instanceof FrameContainer && this._maximizedOtherFloatingFrames != null) {
                    framesToFloat = new ArrayList<DockableFrame>();
                    block5: for (int i = 0; i < ((FrameContainer)f.getParent()).getTabCount(); ++i) {
                        DockableFrame dockableFrame = ((FrameContainer)f.getParent()).getFrame(i);
                        if (dockableFrame == f) {
                            framesToFloat.add(f);
                            continue;
                        }
                        for (DockableFrame frame : this._maximizedOtherFloatingFrames) {
                            if (dockableFrame != frame) continue;
                            framesToFloat.add(frame);
                            continue block5;
                        }
                    }
                }
                if (framesToFloat == null) {
                    this.internalToggleState(f, true);
                } else {
                    DockableFrame frame = (DockableFrame)framesToFloat.get(0);
                    this.internalToggleState(frame, true);
                    for (int i = 1; i < framesToFloat.size(); ++i) {
                        this.moveFrame(((DockableFrame)framesToFloat.get(i)).getKey(), frame.getKey());
                    }
                    this.internalActivateFrame(f);
                }
                if (this._maximizedOtherFloatingFrames != null && this._maximizedOtherFloatingFrames.length > 0) {
                    for (DockableFrame frame : this._maximizedOtherFloatingFrames) {
                        if (framesToFloat == null || framesToFloat.contains(frame)) continue;
                        this.moveFrame(frame.getKey(), f.getKey());
                    }
                }
            }
            this._maximizeFramePreviousState = -1;
            this._maximizedOtherFloatingFrames = null;
        }
        if (activate) {
            this.activateFront(true);
        }
    }

    private void loadMaximizePreviousState(DockableFrame f) {
        if (!this.loadMaximizedPreviousState(f)) {
            if (!f.isAutohideShowing()) {
                if (f.isAutohide()) {
                    this.internalStartShowingAutohideFrame(f, f.getContext().getCurrentDockSide(), 0);
                } else if (!f.isFloated() && !f.isDocked()) {
                    if (f.isDockable()) {
                        this.internalDockFrame(f, this.getDockedFrameContainer(), true);
                    } else {
                        this.internalFloatOutFrame(f);
                    }
                }
            }
        } else if (f.isAutohideShowing()) {
            this.internalStartShowingAutohideFrame(f, f.getContext().getCurrentDockSide(), 0);
        }
    }

    @Override
    public int getDoubleClickAction() {
        return this._doubleClickAction;
    }

    @Override
    public void setDoubleClickAction(int doubleClickAction) {
        int old = this._doubleClickAction;
        if (this._doubleClickAction != doubleClickAction) {
            this._doubleClickAction = doubleClickAction;
            this.firePropertyChange("doubleClickAction", old, this._doubleClickAction);
        }
    }

    @Override
    public boolean isAutoDocking() {
        return this._autoDocking;
    }

    @Override
    public void setAutoDocking(boolean autoDocking) {
        boolean old = this._autoDocking;
        if (old != autoDocking) {
            this._autoDocking = autoDocking;
            this.firePropertyChange("autoDocking", old, this._autoDocking);
        }
    }

    @Override
    public boolean isAutoDockingAsDefault() {
        return this._autoDockingAsDefault;
    }

    @Override
    public void setAutoDockingAsDefault(boolean autoDockingAsDefault) {
        boolean old = this._autoDockingAsDefault;
        if (old != autoDockingAsDefault) {
            this._autoDockingAsDefault = autoDockingAsDefault;
            this.firePropertyChange("autoDockingAsDefault", old, this._autoDockingAsDefault);
        }
    }

    @Override
    public boolean isPreserveStateOnDragging() {
        return this._preserveStateOnDragging;
    }

    @Override
    public void setPreserveStateOnDragging(boolean preserveStateOnDragging) {
        boolean old = this._preserveStateOnDragging;
        if (old != preserveStateOnDragging) {
            this._preserveStateOnDragging = preserveStateOnDragging;
            this.firePropertyChange("preserveStateOnDragging", old, this._preserveStateOnDragging);
        }
    }

    @Override
    public void removeExtraContexts() {
        if (this._allContexts != null) {
            String[] col;
            for (String key : col = this._allContexts.keySet().toArray(new String[this._allContexts.size()])) {
                DockableFrame dockableFrame = this.getFrame(key);
                if (dockableFrame != null) continue;
                this.removeContext(key);
            }
        }
        if (this._hiddenFrames != null) {
            for (int i = this._hiddenFrames.size() - 1; i >= 0; --i) {
                String key = (String)this._hiddenFrames.get(i);
                DockableFrame dockableFrame = this.getFrame(key);
                if (dockableFrame != null) continue;
                this._hiddenFrames.remove(key);
            }
        }
    }

    @Override
    public Map<String, DockContext> getAllContexts() {
        return this._allContexts;
    }

    @Override
    public boolean isHideFloatingFramesWhenDeactivate() {
        return this._hideFloatingFramesWhenDeactivate;
    }

    @Override
    public void setHideFloatingFramesWhenDeactivate(boolean hideFloatingFramesWhenDeactivate) {
        boolean old = this._hideFloatingFramesWhenDeactivate;
        if (old != hideFloatingFramesWhenDeactivate) {
            this._hideFloatingFramesWhenDeactivate = hideFloatingFramesWhenDeactivate;
            this.firePropertyChange("hideFloatingFramesWhenDeactivate", old, this._hideFloatingFramesWhenDeactivate);
        }
    }

    @Override
    public boolean isHideFloatingFramesOnSwitchOutOfApplication() {
        return this._hideFloatingFramesOnSwitchOutOfApplication;
    }

    @Override
    public void setHideFloatingFramesOnSwitchOutOfApplication(boolean newValue) {
        boolean old = this._hideFloatingFramesOnSwitchOutOfApplication;
        if (old != newValue) {
            this._hideFloatingFramesOnSwitchOutOfApplication = newValue;
            this.firePropertyChange("hideFloatingFramesOnSwitchOutOfApplication", old, this._hideFloatingFramesOnSwitchOutOfApplication);
        }
    }

    private void updateKey(String oldKey, String newKey) {
        Serializable obj;
        if (this._allContexts != null && this._allContexts.containsKey(oldKey)) {
            obj = this._allContexts.get(oldKey);
            this._allContexts.remove(oldKey);
            this._allContexts.put(newKey, (DockContext)obj);
        }
        if (this._allFrames != null && this._allFrames.containsKey(oldKey)) {
            obj = this._allFrames.get(oldKey);
            this._allFrames.remove(oldKey);
            this._allFrames.put(newKey, (DockableFrame)obj);
        }
        List<String> oldFrameKeys = this.getAllFrameNames();
        if (this._allFrameKeys != null && this._allFrameKeys.contains(oldKey)) {
            this._allFrameKeys.set(this._allFrameKeys.indexOf(oldKey), newKey);
        }
        this.firePropertyChange("managedFrames", oldFrameKeys, this.getAllFrameNames());
        if (this._hiddenFrames != null && this._hiddenFrames.contains(oldKey)) {
            this._hiddenFrames.set(this._hiddenFrames.indexOf(oldKey), newKey);
        }
    }

    @Override
    public int getAllowedDockSides() {
        return this._allowedDockSides;
    }

    @Override
    public void setAllowedDockSides(int allowedDockSides) {
        int old = this._allowedDockSides;
        if (this._allowedDockSides != allowedDockSides) {
            this._allowedDockSides = allowedDockSides;
            this.firePropertyChange("allowedDockSides", old, this._allowedDockSides);
        }
    }

    @Override
    public boolean shouldVetoRemovingAllFrames() {
        List<String> list = this.getAllFrameNames();
        for (String str : list) {
            if (!this.getFrame(str).shouldVetoHiding()) continue;
            return true;
        }
        return false;
    }

    public static boolean isExclusive() {
        return _exclusive;
    }

    public static void setExclusive(boolean exclusive) {
        _exclusive = exclusive;
    }

    @Override
    public boolean isShowContextMenu() {
        return this._showContextMenu;
    }

    @Override
    public void setShowContextMenu(boolean showContextMenu) {
        this._showContextMenu = showContextMenu;
    }

    @Override
    public boolean isAutohideShowingInProgress() {
        return this._slidingAnimator != null && this._slidingAnimator.isSliding();
    }

    @Override
    public String getAutohideShowingFrame() {
        String f = null;
        if (this._slidingAnimator != null && this._slidingAnimator.getSlidingFrame() != null) {
            f = this._slidingAnimator.getSlidingFrame().getKey();
        }
        return f;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateAutohideWidthHeight(DockableFrame f) {
        try {
            f.setSettingSize(true);
            int side = f.getContext().getCurrentDockSide();
            switch (side) {
                case 4: 
                case 8: {
                    f.setAutohideWidth(f.getWidth());
                    return;
                }
                case 1: 
                case 2: {
                    f.setAutohideHeight(f.getHeight());
                    return;
                }
            }
            return;
        }
        finally {
            f.setSettingSize(false);
        }
    }

    @Override
    public DockableFrameFactory getDockableFrameFactory() {
        return this._dockableFrameFactory;
    }

    @Override
    public void setDockableFrameFactory(DockableFrameFactory dockableFrameFactory) {
        this._dockableFrameFactory = dockableFrameFactory;
    }

    @Override
    public void loadInitialLayout(final Document layoutDocument) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalLoadInitialLayout(layoutDocument);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DefaultDockingManager.this.internalLoadInitialLayout(layoutDocument);
                }
            });
        }
    }

    private void internalLoadInitialLayout(Document layoutDocument) {
        NodeList managers = layoutDocument.getElementsByTagName(NODE_MANAGERS).item(0).getChildNodes();
        for (int index = 0; index < managers.getLength(); ++index) {
            Node node = managers.item(index);
            if (!NODE_DOCKING_MANAGER.equals(node.getNodeName())) continue;
            Element dockingManagerElement = (Element)node;
            XmlUtils.readElement(this, dockingManagerElement);
            Element barsElement = (Element)dockingManagerElement.getElementsByTagName(NODE_DOCKABLE_FRAMES).item(0);
            NodeList nodeList = barsElement.getElementsByTagName(NODE_DOCKABLE_FRAME);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element frameElement = (Element)nodeList.item(i);
                this.readFrameElement(frameElement);
            }
            break;
        }
    }

    private void readFrameElement(Element element) {
        DockableFrameFactory factory;
        String key = element.getAttribute(ATTRIBUTE_KEY);
        DockableFrame dockableFrame = this.getFrame(key);
        if (dockableFrame == null && (factory = this.getDockableFrameFactory()) != null) {
            dockableFrame = factory.create(key);
        }
        if (dockableFrame == null) {
            return;
        }
        if (this.getFrame(key) == null) {
            this.addFrame(dockableFrame);
        }
        XmlUtils.readElement(dockableFrame, element);
        dockableFrame.setShowTitleBarConfigured(false);
    }

    @Override
    public boolean isUseDecoratedFloatingContainer() {
        return this._useDecoratedFloatingContainer && !"window".equalsIgnoreCase(SecurityUtils.getProperty("docking.floatingContainerType", "dialog"));
    }

    @Override
    public void setUseDecoratedFloatingContainer(boolean useDecoratedFloatingContainer) {
        boolean old = this._useDecoratedFloatingContainer;
        if (old != useDecoratedFloatingContainer) {
            this._useDecoratedFloatingContainer = useDecoratedFloatingContainer;
            this.firePropertyChange("useDecoratedFloatingContainer", old, this._useDecoratedFloatingContainer);
        }
    }

    @Override
    public boolean isProportionalSplits() {
        return this._proportionalSplits;
    }

    @Override
    public void setProportionalSplits(boolean b) {
        boolean old = this._proportionalSplits;
        if (this._proportionalSplits != b) {
            this._proportionalSplits = b;
            this.firePropertyChange("rearrangable", old, this._proportionalSplits);
        }
    }

    protected void preDispatchDockableFrameEvent() {
        this.updateAllFloatingFramesTitle();
    }

    private DockableFrameListener getInternalRoutingFrameListener() {
        if (this._internalRoutingFrameListener == null) {
            this._internalRoutingFrameListener = new InternalDockableFrameRouter();
        }
        return this._internalRoutingFrameListener;
    }

    WindowListener getFloatingContainerWindowListener() {
        if (this._floatingContainerWindowListener == null) {
            this._floatingContainerWindowListener = new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    if (!DefaultDockingManager.this._floatingFramesVisible) {
                        return;
                    }
                    Window o = e.getWindow();
                    if ((o instanceof FloatingContainer || o == DefaultDockingManager.this.getRootPaneContainerAsComponent()) && DefaultDockingManager.this._orderedFloatingFrames != null && DefaultDockingManager.this._orderedFloatingFrames.indexOf(o) != 0) {
                        DefaultDockingManager.this._orderedFloatingFrames.remove(o);
                        DefaultDockingManager.this._orderedFloatingFrames.add(0, o);
                    }
                }
            };
        }
        return this._floatingContainerWindowListener;
    }

    @Override
    public boolean isHeavyweightComponentEnabled() {
        return this._heavyweightComponentEnabled;
    }

    @Override
    public void setHeavyweightComponentEnabled(boolean heavyweightComponentEnabled) {
        boolean old = this._heavyweightComponentEnabled;
        if (this._heavyweightComponentEnabled != heavyweightComponentEnabled) {
            this._heavyweightComponentEnabled = heavyweightComponentEnabled;
            this.firePropertyChange("heavyweightComponentEnabled", old, this._heavyweightComponentEnabled);
        }
        if (this.isHeavyweightComponentEnabled()) {
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        }
    }

    @Override
    public boolean isUseGlassPaneEnabled() {
        return this._useGlassPaneEnabled;
    }

    @Override
    public void setUseGlassPaneEnabled(boolean useGlassPaneEnabled) {
        this._useGlassPaneEnabled = useGlassPaneEnabled;
    }

    @Override
    public boolean isSideDockAllowed() {
        return this._sideDockAllowed;
    }

    @Override
    public void setSideDockAllowed(boolean sideDockAllowed) {
        if (this._sideDockAllowed != sideDockAllowed) {
            boolean old = this._sideDockAllowed;
            this._sideDockAllowed = sideDockAllowed;
            this.firePropertyChange("sideDockAllowed", old, this._sideDockAllowed);
        }
    }

    @Override
    public boolean isWithinFrameBoundsOnDragging() {
        return this._withinFrameBoundsOnDragging;
    }

    @Override
    public void setWithinFrameBoundsOnDragging(boolean withinFrameBoundsOnDragging) {
        if (this._withinFrameBoundsOnDragging != withinFrameBoundsOnDragging) {
            boolean old = this._withinFrameBoundsOnDragging;
            this._withinFrameBoundsOnDragging = withinFrameBoundsOnDragging;
            this.firePropertyChange("withinFrameBoundsOnDragging", old, this._withinFrameBoundsOnDragging);
        }
    }

    @Override
    public boolean isWithinScreenBoundsOnDragging() {
        return this._withinScreenBoundsOnDragging;
    }

    @Override
    public void setWithinScreenBoundsOnDragging(boolean withinScreenBoundsOnDragging) {
        if (this._withinScreenBoundsOnDragging != withinScreenBoundsOnDragging) {
            boolean old = this._withinScreenBoundsOnDragging;
            this._withinScreenBoundsOnDragging = withinScreenBoundsOnDragging;
            this.firePropertyChange("withinScreenBoundsOnDragging", old, this._withinScreenBoundsOnDragging);
        }
    }

    @Override
    public boolean isCrossDraggingAllowed() {
        return this._crossDraggingAllowed;
    }

    @Override
    public void setCrossDraggingAllowed(boolean crossDraggingAllowed) {
        if (this._crossDraggingAllowed != crossDraggingAllowed) {
            boolean old = this._crossDraggingAllowed;
            this._crossDraggingAllowed = crossDraggingAllowed;
            this.firePropertyChange("crossDraggingAllowed", old, this._crossDraggingAllowed);
        }
    }

    @Override
    public boolean isCrossDroppingAllowed() {
        return this._crossDroppingAllowed;
    }

    @Override
    public void setCrossDroppingAllowed(boolean crossDroppingAllowed) {
        if (this._crossDroppingAllowed != crossDroppingAllowed) {
            boolean old = this._crossDroppingAllowed;
            this._crossDroppingAllowed = crossDroppingAllowed;
            this.firePropertyChange("crossDroppingAllowed", old, this._crossDroppingAllowed);
        }
    }

    public static List<DockingManager> getAllDockingManagers() {
        return Collections.unmodifiableList(_dockingManagers);
    }

    @Override
    public void addDockableFrameDropListener(DockableFrameDropListener l) {
        this.listenerList.add(DockableFrameDropListener.class, l);
    }

    @Override
    public void removeDockableFrameDropListener(DockableFrameDropListener l) {
        this.listenerList.remove(DockableFrameDropListener.class, l);
    }

    @Override
    public DockableFrameDropListener[] getDockableFrameDropListeners() {
        return (DockableFrameDropListener[])this.listenerList.getListeners(DockableFrameDropListener.class);
    }

    @Override
    public boolean isDropAllowed(DockableFrame source, Component target, int side) {
        if (LOGGER_DROP_LISTENER.isLoggable(Level.FINE)) {
            if (target instanceof DockableFrame) {
                LOGGER_DROP_LISTENER.fine("DockableFrame \"" + source.getKey() + "\" is about to be dropped on " + ((DockableFrame)target).getKey() + " + on side " + DockContext.getDockSideName(side));
            } else if (target instanceof Workspace) {
                LOGGER_DROP_LISTENER.fine("DockableFrame \"" + source.getKey() + "\" is about to be dropped on workspace on side " + DockContext.getDockSideName(side));
            } else if (target instanceof DockedFrameContainer) {
                LOGGER_DROP_LISTENER.fine("DockableFrame \"" + source.getKey() + "\" is about to be dropped on DockedFrameContainer on side " + DockContext.getDockSideName(side));
            } else if (target instanceof ContainerContainerDivider) {
                LOGGER_DROP_LISTENER.fine("DockableFrame \"" + source.getKey() + "\" is about to be dropped on ContainerContainerDivider");
            }
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            boolean result;
            if (listeners[i] != DockableFrameDropListener.class || (result = ((DockableFrameDropListener)listeners[i + 1]).isDockingAllowed(source, target, side))) continue;
            return result;
        }
        return true;
    }

    @Override
    public void addDockableFrameListener(DockableFrameListener l) {
        DockableFrameListener[] listeners;
        for (DockableFrameListener listener : listeners = (DockableFrameListener[])this.listenerList.getListeners(DockableFrameListener.class)) {
            if (listener != l) continue;
            return;
        }
        this.listenerList.add(DockableFrameListener.class, l);
    }

    @Override
    public void removeDockableFrameListener(DockableFrameListener l) {
        this.listenerList.remove(DockableFrameListener.class, l);
    }

    @Override
    public DockableFrameListener[] getDockableFrameListeners() {
        return (DockableFrameListener[])this.listenerList.getListeners(DockableFrameListener.class);
    }

    @Override
    public boolean isHideNewlyAddedFrames() {
        return this._hideNewlyAddedFrames;
    }

    @Override
    public void setHideNewlyAddedFrames(boolean hideNewlyAddedFrames) {
        this._hideNewlyAddedFrames = hideNewlyAddedFrames;
    }

    @Override
    public Color getNotificationBackground() {
        return this._notificationBackground;
    }

    @Override
    public void setNotificationBackground(Color notificationBackground) {
        this._notificationBackground = notificationBackground;
    }

    @Override
    public Color getNotificationForeground() {
        return this._notificationForeground;
    }

    @Override
    public void setNotificationForeground(Color notificationForeground) {
        this._notificationForeground = notificationForeground;
    }

    @Override
    public int getNotificationDelay() {
        return this._notificationDelay;
    }

    @Override
    public void setNotificationDelay(int notificationDelay) {
        this._notificationDelay = notificationDelay;
    }

    @Override
    public int getNotificationSteps() {
        return this._notificationSteps;
    }

    @Override
    public void setNotificationSteps(int notificationSteps) {
        this._notificationSteps = notificationSteps;
    }

    @Override
    public boolean isShowTitleOnOutline() {
        return this._showTitleOnOutline;
    }

    @Override
    public void setShowTitleOnOutline(boolean showTitleOnOutline) {
        boolean old = this._showTitleOnOutline;
        if (old != showTitleOnOutline) {
            this._showTitleOnOutline = showTitleOnOutline;
            this.firePropertyChange("showTitleOnOutline", old, showTitleOnOutline);
        }
    }

    private MouseInputListener internalCreateAutoHideMouseInputListener(DockableFrame frame, int side) {
        return new AutoHideMouseListener(this, frame, side);
    }

    @Override
    @Deprecated
    public void dockFrame(DockableFrame f, int side, int index) {
        this.dockFrame(f.getKey(), side, index);
    }

    @Override
    @Deprecated
    public DockableFrame getFirstFrame() {
        return this.getFrame(this.getLastFrameKey());
    }

    @Override
    @Deprecated
    public DockableFrame getLastFrame() {
        return this.getFrame(this.getLastFrameKey());
    }

    @Override
    @Deprecated
    public DockableFrame getNextFrame(DockableFrame f) {
        if (f == null) {
            return null;
        }
        String nextKey = this.getNextFrame(f.getKey());
        return this.getFrame(nextKey);
    }

    @Override
    @Deprecated
    public DockableFrame getPreviousFrame(DockableFrame f) {
        if (f == null) {
            return null;
        }
        String prevKey = this.getPreviousFrame(f.getKey());
        return this.getFrame(prevKey);
    }

    @Override
    @Deprecated
    public void toggleMaximizeState(DockableFrame f) {
        if (f == null) {
            return;
        }
        this.toggleMaximizeState(f.getKey());
    }

    @Override
    @Deprecated
    public void setAutohideShowingFrame(DockableFrame f) {
    }

    @Override
    @Deprecated
    public void hideActiveAutohideFrame() {
        this.stopShowingAutohideFrameImmediately();
    }

    @Override
    @Deprecated
    public void startShowingAutohideFrame(DockableFrame f, int side, int delay, boolean forceFocus) {
        if (f == null) {
            return;
        }
        this.startShowingAutohideFrame(f.getKey(), side, delay);
    }

    @Override
    @Deprecated
    public void startShowingAutohideFrame(DockableFrame f, int side, int delay) {
        if (f == null) {
            return;
        }
        this.startShowingAutohideFrame(f.getKey(), side, delay);
    }

    @Override
    @Deprecated
    public JFrame getMainFrame() {
        if (this.getRootPaneContainer() instanceof JFrame) {
            return (JFrame)this.getRootPaneContainer();
        }
        return null;
    }

    @Override
    @Deprecated
    public AutoHideContainer getAutoHideContaner(int side) {
        return this.getAutoHideContainer(side);
    }

    @Override
    @Deprecated
    public void floatFrame(DockableFrame f, Rectangle bounds, boolean isSingle) {
        if (f == null) {
            return;
        }
        this.floatFrame(f.getKey(), bounds, isSingle);
    }

    @Override
    @Deprecated
    public void autohideFrame(DockableFrame f, int side, int index) {
        this.autohideFrame(f.getKey(), side, index);
    }

    @Override
    @Deprecated
    public DockableFrame getActiveFrame() {
        return this.getFrame(this.getActiveFrameKey());
    }

    @Override
    @Deprecated
    public DockableFrame getMaximizedFrame() {
        return this.getFrame(this.getMaximizedFrameKey());
    }

    @Override
    @Deprecated
    public void toggleAutohideState(DockableFrame frame) {
        if (frame == null) {
            return;
        }
        this.toggleAutohideState(frame.getKey());
    }

    @Override
    @Deprecated
    public void toggleDockable(DockableFrame frame) {
        if (frame == null) {
            return;
        }
        this.toggleDockable(frame.getKey());
    }

    @Override
    @Deprecated
    public void toggleState(DockableFrame frame, boolean single) {
        if (frame == null) {
            return;
        }
        this.toggleState(frame.getKey(), single);
    }

    @Override
    @Deprecated
    public void doLayout() {
    }

    @Override
    @Deprecated
    public void handleEscapeKey(AWTEvent event) {
        this.internalHandleEscapeKey(event);
    }

    @Override
    @Deprecated
    public void floatingFrameDeactivated(WindowEvent windowEvent) {
        Thread.dumpStack();
    }

    @Override
    @Deprecated
    public void floatingFrameActivated(WindowEvent windowEvent) {
        Thread.dumpStack();
    }

    @Override
    @Deprecated
    public MouseListener createAutoHideMouseListener(DockableFrame frame, int side) {
        return new AutoHideMouseListener(this, frame, side);
    }

    @Override
    @Deprecated
    public boolean isFocusDuringLoadLayout() {
        return false;
    }

    @Override
    @Deprecated
    public void setFocusDuringLayout(boolean doFocus) {
    }

    @Override
    @Deprecated
    public boolean isAllowRequestFocus() {
        return false;
    }

    @Override
    @Deprecated
    public Component getDefaultFocusComponent() {
        return null;
    }

    @Override
    @Deprecated
    public void setDefaultFocusComponent(Component defaultFocusComponent) {
    }

    protected void checkFrameKey(String key, String methodName) {
        if (key == null || key.trim().length() == 0) {
            throw new IllegalArgumentException("The frame key passed to " + methodName + " is empty. Please use DockableFrame#getKey() method to get the unique key when using APIs on DockingManager.");
        }
    }

    @Override
    public boolean isActive() {
        return this.getGroup() == null || this._active;
    }

    @Override
    public void setActive(boolean active) {
        DockingManagerGroup group = this.getGroup();
        if (group != null) {
            group.setSelected(this, active);
            active = group.isSelected(this);
        }
        if (this._active != active) {
            boolean old = this._active;
            this._active = active;
            if (active) {
                if (this._unsentMouseEvents.size() == 0) {
                    this.activateFront(false);
                }
            } else {
                this._hasFocus = false;
                this.internalActivateFrame(null);
            }
            this.firePropertyChange("active", old, this._active);
        }
    }

    @Override
    public DockingManagerGroup getGroup() {
        return this._group;
    }

    @Override
    public void setGroup(DockingManagerGroup group) {
        if (this._group != group) {
            DockingManagerGroup old = this._group;
            this._group = group;
            this.firePropertyChange("dockingManagerGroup", old, (Object)this._active);
        }
    }

    @Override
    public int getFloatingContainerType() {
        String property = SecurityUtils.getProperty("docking.floatingContainerType", null);
        if (property != null) {
            if ("dialog".equals(property)) {
                return 0;
            }
            if ("frame".equals(property)) {
                return 1;
            }
            if ("window".equals(property)) {
                return 2;
            }
        }
        return this._floatingContainerType;
    }

    @Override
    public void setFloatingContainerType(int floatingContainerType) {
        int old = this._floatingContainerType;
        if (old != floatingContainerType) {
            this._floatingContainerType = floatingContainerType;
            this.firePropertyChange("floatingContainerType", old, this._floatingContainerType);
        }
    }

    @Override
    public DockingManager.FloatingContainerCustomizer getFloatingContainerCustomizer() {
        return this._floatingContainerCustomizer;
    }

    @Override
    public void setFloatingContainerCustomizer(DockingManager.FloatingContainerCustomizer customizer) {
        this._floatingContainerCustomizer = customizer;
    }

    @Override
    public List<FloatingContainer> getFloatingFrames() {
        return this._floatingFrames;
    }

    HiddenFrames getHiddenFrames() {
        return this._hiddenFrames;
    }

    void setHiddenFrames(HiddenFrames hiddenFrames) {
        this._hiddenFrames = hiddenFrames;
    }

    boolean isUseFrameBounds() {
        return this._useFrameBounds;
    }

    @Override
    public void setActiveMouseInputListener(MouseInputListener listener) {
        this._mouseInputListener = listener;
    }

    @Override
    public MouseInputListener getActiveMouseInputListener() {
        return this._mouseInputListener;
    }

    @Override
    public void setFloatingContainerCloseBehavior(int closeBehavior) {
        this._floatingContainerCloseBehavior = closeBehavior;
    }

    @Override
    public int getFloatingContainerCloseBehavior() {
        return this._floatingContainerCloseBehavior;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29) {
                System.err.println("The Lm class is invalid, exiting ...");
                System.exit(-1);
            }
        }
        catch (Exception e) {
            System.exit(-1);
        }
        if (!Q.zz(1)) {
            Lm.showInvalidProductMessage(DefaultDockingManager.class.getName(), 1);
        }
        LOGGER = Logger.getLogger(DefaultDockingManager.class.getName());
        LOGGER_FOCUS = Logger.getLogger(DefaultDockingManager.class.getName() + ".focus");
        LOGGER_MOUSE_EVENTS = Logger.getLogger(DefaultDockingManager.class.getName() + ".mouseevents");
        LOGGER_DROP_LISTENER = Logger.getLogger(DockableFrameDropListener.class.getName());
        _processingFocusEvent = false;
        _dockingManagers = new Vector<DockingManager>();
        _exclusive = false;
        _zorderDockingManagers = new ArrayList<DockingManager>();
    }

    protected class InternalEventManager
    implements AutoHideContainer.MouseInputCreator,
    FloatingContainer.FloatingContainerManager {
        protected InternalEventManager() {
        }

        @Override
        public MouseInputListener createAutoHideMouseInputListener(DockableFrame frame, int side) {
            return DefaultDockingManager.this.internalCreateAutoHideMouseInputListener(frame, side);
        }

        @Override
        public void floatingFrameDeactivated(WindowEvent windowEvent) {
            DefaultDockingManager.this.internalFloatingFrameDeactivated(windowEvent);
        }

        @Override
        public void floatingFrameActivated(WindowEvent windowEvent) {
            DefaultDockingManager.this.internalFloatingFrameActivated(windowEvent);
        }
    }

    protected class MenuChangeStateListener
    implements ChangeListener {
        protected MenuChangeStateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            if ((MenuSelectionManager.defaultManager().getSelectedPath() == null || MenuSelectionManager.defaultManager().getSelectedPath().length == 0) && KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner() instanceof JRootPane) {
                List list = _dockingManagers;
                synchronized (list) {
                    DockingManager[] dockMgrs;
                    Collections.sort(_dockingManagers, new Comparator<DockingManager>(){

                        @Override
                        public int compare(DockingManager o1, DockingManager o2) {
                            if (DockingUtils.isDockingManagerAncestor(o1.getMainContainer(), o2)) {
                                return 1;
                            }
                            if (DockingUtils.isDockingManagerAncestor(o2.getMainContainer(), o1)) {
                                return -1;
                            }
                            return 0;
                        }
                    });
                    for (DockingManager dockingManager : dockMgrs = _dockingManagers.toArray(new DockingManager[_dockingManagers.size()])) {
                        ((DefaultDockingManager)dockingManager).reFocusActiveFrame(false);
                    }
                }
            }
        }
    }

    protected class InternalDockableFrameRouter
    implements DockableFrameListener {
        protected InternalDockableFrameRouter() {
        }

        protected void dispatchEvent(String eventType, DockableFrameEvent e) {
            DefaultDockingManager.this.preDispatchDockableFrameEvent();
            Object[] listeners = DefaultDockingManager.this.listenerList.getListenerList();
            try {
                Method listenerMethod = DockableFrameListener.class.getMethod(eventType, DockableFrameEvent.class);
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (!DockableFrameListener.class.isAssignableFrom((Class)listeners[i])) continue;
                    listenerMethod.invoke(listeners[i + 1], e);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void dockableFrameActivated(DockableFrameEvent e) {
            this.dispatchEvent("dockableFrameActivated", e);
        }

        @Override
        public void dockableFrameAdded(DockableFrameEvent e) {
            this.dispatchEvent("dockableFrameAdded", e);
        }

        @Override
        public void dockableFrameAutohidden(DockableFrameEvent e) {
            this.dispatchEvent("dockableFrameAutohidden", e);
        }

        @Override
        public void dockableFrameAutohideShowing(DockableFrameEvent e) {
            this.dispatchEvent("dockableFrameAutohideShowing", e);
        }

        @Override
        public void dockableFrameDeactivated(DockableFrameEvent e) {
            this.dispatchEvent("dockableFrameDeactivated", e);
        }

        @Override
        public void dockableFrameDocked(DockableFrameEvent e) {
            this.dispatchEvent("dockableFrameDocked", e);
        }

        @Override
        public void dockableFrameFloating(DockableFrameEvent e) {
            this.dispatchEvent("dockableFrameFloating", e);
        }

        @Override
        public void dockableFrameHidden(DockableFrameEvent e) {
            this.dispatchEvent("dockableFrameHidden", e);
        }

        @Override
        public void dockableFrameMaximized(DockableFrameEvent e) {
            this.dispatchEvent("dockableFrameMaximized", e);
        }

        @Override
        public void dockableFrameRemoved(DockableFrameEvent e) {
            this.dispatchEvent("dockableFrameRemoved", e);
        }

        @Override
        public void dockableFrameRestored(DockableFrameEvent e) {
            this.dispatchEvent("dockableFrameRestored", e);
        }

        @Override
        public void dockableFrameShown(DockableFrameEvent e) {
            this.dispatchEvent("dockableFrameShown", e);
        }

        @Override
        public void dockableFrameTabHidden(DockableFrameEvent e) {
            this.dispatchEvent("dockableFrameTabHidden", e);
        }

        @Override
        public void dockableFrameTabShown(DockableFrameEvent e) {
            this.dispatchEvent("dockableFrameTabShown", e);
        }

        @Override
        public void dockableFrameTransferred(DockableFrameEvent e) {
            this.dispatchEvent("dockableFrameTransferred", e);
        }

        @Override
        public void dockableFrameMoved(DockableFrameEvent e) {
            this.dispatchEvent("dockableFrameMoved", e);
        }
    }

    private class DockingManagerUndoManager
    extends UndoManager {
        private int _limit = 100;
        private int _indexOfNextAdd = 0;

        public DockingManagerUndoManager() {
            this.edits.ensureCapacity(this._limit);
        }

        @Override
        public synchronized int getLimit() {
            return this._limit;
        }

        @Override
        public synchronized void discardAllEdits() {
            Enumeration cursor = this.edits.elements();
            while (cursor.hasMoreElements()) {
                UndoableEdit e = (UndoableEdit)cursor.nextElement();
                e.die();
            }
            this.edits = new Vector();
            this._indexOfNextAdd = 0;
        }

        @Override
        protected void trimForLimit() {
            int size;
            if (this._limit >= 0 && (size = this.edits.size()) > this._limit) {
                int halfLimit = this._limit / 2;
                int keepTo = this._indexOfNextAdd - 1 + halfLimit;
                int keepFrom = this._indexOfNextAdd - 1 - halfLimit;
                if (keepTo - keepFrom + 1 > this._limit) {
                    ++keepFrom;
                }
                if (keepFrom < 0) {
                    keepTo -= keepFrom;
                    keepFrom = 0;
                }
                if (keepTo >= size) {
                    int delta = size - keepTo - 1;
                    keepTo += delta;
                    keepFrom += delta;
                }
                this.thisTrimEdits(keepTo + 1, size - 1);
                this.thisTrimEdits(0, keepFrom - 1);
            }
        }

        @Override
        protected void trimEdits(int from, int to) {
        }

        protected void thisTrimEdits(int from, int to) {
            if (from <= to) {
                for (int i = to; from <= i; --i) {
                    UndoableEdit e = (UndoableEdit)this.edits.elementAt(i);
                    e.die();
                    this.edits.removeElementAt(i);
                }
                if (this._indexOfNextAdd > to) {
                    this._indexOfNextAdd -= to - from + 1;
                } else if (this._indexOfNextAdd >= from) {
                    this._indexOfNextAdd = from;
                }
            }
        }

        @Override
        public synchronized void setLimit(int l) {
            if (!this.isInProgress()) {
                throw new RuntimeException("Attempt to call UndoManager.setLimit() after UndoManager.end() has been called");
            }
            this._limit = l;
            this.trimForLimit();
        }

        @Override
        protected UndoableEdit editToBeUndone() {
            int i = this._indexOfNextAdd;
            while (i > 0) {
                UndoableEdit edit;
                if (!(edit = (UndoableEdit)this.edits.elementAt(--i)).isSignificant()) continue;
                return edit;
            }
            return null;
        }

        @Override
        protected UndoableEdit editToBeRedone() {
            int count = this.edits.size();
            int i = this._indexOfNextAdd;
            while (i < count && i >= 0) {
                UndoableEdit edit;
                if (!(edit = (UndoableEdit)this.edits.elementAt(i++)).isSignificant()) continue;
                return edit;
            }
            return null;
        }

        @Override
        protected void undoTo(UndoableEdit edit) throws CannotUndoException {
            boolean done = false;
            while (!done && this._indexOfNextAdd > 0) {
                UndoableEdit next = (UndoableEdit)this.edits.elementAt(--this._indexOfNextAdd);
                next.undo();
                done = next == edit;
            }
        }

        @Override
        protected void redoTo(UndoableEdit edit) throws CannotRedoException {
            boolean done = false;
            while (!done) {
                UndoableEdit next = (UndoableEdit)this.edits.elementAt(this._indexOfNextAdd++);
                next.redo();
                done = next == edit;
            }
        }

        @Override
        public synchronized void undoOrRedo() throws CannotRedoException, CannotUndoException {
            if (this._indexOfNextAdd == this.edits.size()) {
                this.undo();
            } else {
                this.redo();
            }
        }

        @Override
        public synchronized boolean canUndoOrRedo() {
            if (this._indexOfNextAdd == this.edits.size()) {
                return this.canUndo();
            }
            return this.canRedo();
        }

        @Override
        public synchronized boolean addEdit(UndoableEdit anEdit) {
            this.thisTrimEdits(this._indexOfNextAdd, this.edits.size() - 1);
            boolean retVal = super.addEdit(anEdit);
            if (this.isInProgress()) {
                retVal = true;
            }
            this._indexOfNextAdd = this.edits.size();
            this.trimForLimit();
            return retVal;
        }

        @Override
        public synchronized void end() {
            super.end();
            this.thisTrimEdits(this._indexOfNextAdd, this.edits.size() - 1);
        }

        @Override
        public synchronized String getUndoOrRedoPresentationName() {
            if (this._indexOfNextAdd == this.edits.size()) {
                return this.getUndoPresentationName();
            }
            return this.getRedoPresentationName();
        }

        @Override
        public String toString() {
            return super.toString() + " limit: " + this._limit + " indexOfNextAdd: " + this._indexOfNextAdd;
        }

        public UndoableEdit[] getAllEdits() {
            return this.edits == null ? new UndoableEdit[]{} : this.edits.toArray(new UndoableEdit[this.edits.size()]);
        }

        public void removeEdit(UndoableEdit edit) {
            int index;
            if (this.edits != null && (index = this.edits.indexOf(edit)) >= 0) {
                if (this._indexOfNextAdd >= index) {
                    --this._indexOfNextAdd;
                }
                this.edits.remove(index);
            }
        }
    }

    protected class DockedHiddenSlidingContainer
    extends JPanel {
        private FocusTraversalPolicy _emptyFocusPolicy;

        protected DockedHiddenSlidingContainer() {
            this.setFocusCycleRoot(true);
            this.setFocusable(true);
            this._emptyFocusPolicy = new FocusTraversalPolicy(){

                @Override
                public Component getComponentAfter(Container container, Component component) {
                    return DockedHiddenSlidingContainer.this;
                }

                @Override
                public Component getComponentBefore(Container container, Component component) {
                    return DockedHiddenSlidingContainer.this;
                }

                @Override
                public Component getDefaultComponent(Container container) {
                    return DockedHiddenSlidingContainer.this;
                }

                @Override
                public Component getFirstComponent(Container container) {
                    return DockedHiddenSlidingContainer.this;
                }

                @Override
                public Component getLastComponent(Container container) {
                    return DockedHiddenSlidingContainer.this;
                }
            };
            this.setLayout(new LayoutManager(){

                @Override
                public void addLayoutComponent(String name, Component comp) {
                }

                @Override
                public void removeLayoutComponent(Component comp) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Dimension preferredLayoutSize(Container parent) {
                    Object object = parent.getTreeLock();
                    synchronized (object) {
                        if (parent.getComponentCount() < 2) {
                            return null;
                        }
                        return parent.getComponent(1).getPreferredSize();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Dimension minimumLayoutSize(Container parent) {
                    Object object = parent.getTreeLock();
                    synchronized (object) {
                        if (parent.getComponentCount() < 2) {
                            return null;
                        }
                        return parent.getComponent(1).getMinimumSize();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void layoutContainer(Container parent) {
                    Object object = parent.getTreeLock();
                    synchronized (object) {
                        if (parent.getComponentCount() < 2) {
                            return;
                        }
                        parent.getComponent(1).setLocation(0, 0);
                        parent.getComponent(1).setSize(parent.getWidth(), parent.getHeight());
                        parent.getComponent(0).setLocation(0, 0);
                        parent.getComponent(0).setSize(parent.getWidth(), parent.getHeight());
                    }
                }
            });
            this.setOpaque(false);
        }

        @Override
        public boolean isOptimizedDrawingEnabled() {
            return DefaultDockingManager.this._slidingAnimator == null || DefaultDockingManager.this._slidingAnimator.getSlidingComponent() == null;
        }

        @Override
        public FocusTraversalPolicy getFocusTraversalPolicy() {
            return this._emptyFocusPolicy;
        }
    }

    public class MainPanel
    extends JPanel
    implements DockableHolder {
        @Override
        public DockingManager getDockingManager() {
            return DefaultDockingManager.this;
        }

        @Override
        public void doLayout() {
            super.doLayout();
            if (DefaultDockingManager.this._slidingAnimator != null && DefaultDockingManager.this._slidingAnimator.getSlidingFrame() != null) {
                DefaultDockingManager.this._slidingContainer.invalidate();
                DefaultDockingManager.this._slidingContainer.doLayout();
            }
        }
    }

    protected class DockableFrameWorkspaceHandle
    implements DockingManager.FrameHandle {
        protected Object untyped = null;
        protected boolean isVisible = true;
        protected boolean isManaged = true;

        protected DockableFrameWorkspaceHandle(Object componentHandle) {
            if (!(componentHandle instanceof DockableFrame) && !(componentHandle instanceof Workspace)) {
                throw new RuntimeException(componentHandle + "must be of type " + DockableFrame.class + " or " + Workspace.class);
            }
            this.untyped = componentHandle;
        }

        @Override
        public String getKey() {
            if (this.untyped instanceof DockableFrame) {
                return ((DockableFrame)this.untyped).getKey();
            }
            if (this.untyped instanceof Workspace) {
                return DefaultDockingManager.WORKSPACE_KEY;
            }
            return "#Error";
        }

        @Override
        public String getTitle() {
            if (this.untyped instanceof DockableFrame) {
                return ((DockableFrame)this.untyped).getTitle();
            }
            if (this.untyped instanceof Workspace) {
                return "Workspace";
            }
            return "#Error";
        }

        @Override
        public Icon getIcon() {
            if (this.untyped instanceof DockableFrame) {
                return ((DockableFrame)this.untyped).getFrameIcon();
            }
            if (this.untyped instanceof Workspace) {
                return null;
            }
            return null;
        }

        @Override
        public boolean isWorkspace() {
            return this.untyped instanceof Workspace;
        }

        @Override
        public boolean isManaged() {
            return this.isManaged;
        }

        @Override
        public boolean isFront() {
            return this.isManaged() && DefaultDockingManager.this._zorderFrameHandles != null && DefaultDockingManager.this._zorderFrameHandles.indexOf(this) == 0;
        }

        @Override
        public boolean toFront() {
            return this.isManaged && DefaultDockingManager.this.moveToFront(this.untyped);
        }

        public String toString() {
            return "DockableFrameWorkspaceHandle[" + this.getKey() + ", " + this.getTitle() + "]";
        }
    }

    protected class DefaultDockingManagerAnimationHandler
    implements SlidingAnimator.Handler {
        protected DefaultDockingManagerAnimationHandler() {
        }

        @Override
        public void handleBeginShowing(DockableFrame frame) {
        }

        @Override
        public void handleOpened(DockableFrame frame) {
            Component focusOwner;
            if (frame.isActive() && DefaultDockingManager.this._hasFocus && ((focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner()) == null || focusOwner == frame || !SwingUtilities.isDescendingFrom(focusOwner, frame))) {
                frame.requestFocusInInternalWindow();
                if (LOGGER_MOUSE_EVENTS.isLoggable(Level.FINE)) {
                    LOGGER_MOUSE_EVENTS.fine(DefaultDockingManager.this.getProfileKey() + ":handleOpened dequeuing " + DefaultDockingManager.this._unsentMouseEvents.size() + " due to autohide open.");
                }
                DockingUtils.dequeueMouseEvents(DefaultDockingManager.this._unsentMouseEvents, frame);
            }
        }

        @Override
        public void handleShowingCancelled(DockableFrame frame) {
            DefaultDockingManager.this._slidingAnimator = null;
            if (frame.isActive()) {
                if (DefaultDockingManager.this._startingAutohideShow != null) {
                    DefaultDockingManager.this.internalActivateFrame(DefaultDockingManager.this._startingAutohideShow);
                } else if (DefaultDockingManager.this.findNonAutoHideHandle() != null) {
                    DefaultDockingManager.this.findNonAutoHideHandle().toFront();
                } else {
                    DefaultDockingManager.this.internalActivateFrame(null);
                }
            }
        }

        @Override
        public void handleHidden(DockableFrame frame) {
            DefaultDockingManager.this._slidingAnimator = null;
            if (frame.isActive()) {
                if (DefaultDockingManager.this._startingAutohideShow != null) {
                    DefaultDockingManager.this.internalActivateFrame(DefaultDockingManager.this._startingAutohideShow);
                } else if (DefaultDockingManager.this.findNonAutoHideHandle() != null) {
                    DefaultDockingManager.this.findNonAutoHideHandle().toFront();
                } else {
                    DefaultDockingManager.this.internalActivateFrame(null);
                }
            }
        }
    }
}

