/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.DefaultDockingManager;
import com.jidesoft.docking.DockableHolder;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.swing.LayoutPersistence;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DefaultDockableHolder
extends JFrame
implements DockableHolder {
    protected DockingManager _dockingManager;
    protected JPanel _contentContainer;
    protected boolean _autoDispose = true;

    public DefaultDockableHolder() throws HeadlessException {
        this.initFrame(this.getContentPane());
    }

    public DefaultDockableHolder(GraphicsConfiguration gc) {
        super(gc);
        this.initFrame(this.getContentPane());
    }

    public DefaultDockableHolder(String title) throws HeadlessException {
        super(title);
        this.initFrame(this.getContentPane());
    }

    public DefaultDockableHolder(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.initFrame(this.getContentPane());
    }

    protected void initFrame(Container container) {
        this.setRootPaneCheckingEnabled(false);
        try {
            container.setLayout(new BorderLayout());
            this._contentContainer = new JPanel();
            this._contentContainer.setOpaque(false);
            container.add((Component)this._contentContainer, "Center");
            this._dockingManager = this.createDockingManager(this._contentContainer);
        }
        finally {
            this.setRootPaneCheckingEnabled(true);
        }
    }

    protected DockingManager createDockingManager(Container contentContainer) {
        return new DefaultDockingManager(this, contentContainer);
    }

    @Override
    public DockingManager getDockingManager() {
        return this._dockingManager;
    }

    public LayoutPersistence getLayoutPersistence() {
        return this._dockingManager;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.isAutoDispose()) {
            this._contentContainer = null;
            if (this._dockingManager != null) {
                this._dockingManager.dispose();
                this._dockingManager = null;
            }
            if (this.getRootPane() != null && this.getRootPane().getJMenuBar() != null) {
                this.getJMenuBar().removeAll();
                this.setJMenuBar(null);
            }
        }
    }

    public boolean isAutoDispose() {
        return this._autoDispose;
    }

    public void setAutoDispose(boolean autoDispose) {
        this._autoDispose = autoDispose;
    }

    protected boolean isContentPaneCheckingEnabled() {
        return this.isRootPaneCheckingEnabled();
    }

    protected void setContentPaneCheckingEnabled(boolean contentPaneCheckingEnabled) {
        this.setRootPaneCheckingEnabled(contentPaneCheckingEnabled);
    }
}

