/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.CommandBar;
import com.jidesoft.action.DockableBar;
import com.jidesoft.action.DockableBarContainer;
import com.jidesoft.action.DockableBarContext;
import com.jidesoft.action.DockableBarItem;
import com.jidesoft.action.DockableBarList;
import com.jidesoft.action.DockableBarListList;
import com.jidesoft.action.DockableBarManager;
import com.jidesoft.action.FloatingDockableBarContainer;
import com.jidesoft.action.FloatingDockableBars;
import com.jidesoft.action.HiddenDockableBars;
import com.jidesoft.action.PreviousState;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.PortingUtils;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingConstants;

class SaveUtils
implements SwingConstants {
    private static final int DBC = 1130;
    private static final int DB = 1131;
    private static final int FLC = 1132;
    private static final int HIDE_OFFSCREEN_OFFSET = 10000;

    SaveUtils() {
    }

    static short readShort(DataInputStream in) throws IOException {
        return in.readShort();
    }

    static void writeShort(DataOutputStream out, short i) throws IOException {
        out.writeShort(i);
    }

    static int readInt(DataInputStream in) throws IOException {
        return in.readInt();
    }

    static void writeInt(DataOutputStream out, int i) throws IOException {
        out.writeInt(i);
    }

    static String readString(DataInputStream in) throws IOException {
        int length = in.readInt();
        if (length > 0x100000) {
            throw new IOException("The layout is corrupted. Please remove it and try again.");
        }
        char[] b = new char[length];
        for (int i = 0; i < b.length; ++i) {
            b[i] = in.readChar();
        }
        return new String(b);
    }

    static void writeString(DataOutputStream out, String s) throws IOException {
        out.writeInt(s.length());
        for (int i = 0; i < s.length(); ++i) {
            out.writeChar(s.charAt(i));
        }
    }

    static Dimension readSize(DataInputStream in) throws IOException {
        Dimension dim = new Dimension(in.readInt(), in.readInt());
        return dim;
    }

    static void writeSize(DataOutputStream out, Dimension dim) throws IOException {
        if (dim == null) {
            out.writeInt(0);
            out.writeInt(0);
        } else {
            out.writeInt(dim.width);
            out.writeInt(dim.height);
        }
    }

    static Rectangle readRectangle(DataInputStream in) throws IOException {
        Rectangle rect = new Rectangle(in.readInt(), in.readInt(), in.readInt(), in.readInt());
        return rect;
    }

    static void writeRectangle(DataOutputStream out, Rectangle rect) throws IOException {
        if (rect == null) {
            out.writeInt(60);
            out.writeInt(60);
            out.writeInt(200);
            out.writeInt(200);
        } else {
            out.writeInt(rect.x);
            out.writeInt(rect.y);
            out.writeInt(rect.width);
            out.writeInt(rect.height);
        }
    }

    static short readVersion(DataInputStream in) throws IOException {
        return SaveUtils.readShort(in);
    }

    static void writeVersion(DataOutputStream out, short version) throws IOException {
        SaveUtils.writeShort(out, version);
    }

    static void readContext(DataInputStream in, Map contexts) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String key = SaveUtils.readString(in);
            DockableBarContext context = new DockableBarContext();
            context.setDockID(in.readInt());
            context.setInitSide(in.readInt());
            context.setInitIndex(in.readInt());
            context.setInitPosition(in.readInt() != 0);
            context.setInitMode(in.readInt());
            context.setCurrentMode(in.readInt());
            context.setCurrentDockSide(in.readInt());
            context.setDockedWidth(in.readInt());
            context.setDockedHeight(in.readInt());
            Rectangle rect = SaveUtils.readRectangle(in);
            if (!rect.isEmpty()) {
                context.setUndockedBounds(rect);
            }
            context.setHiddenPreviousState(SaveUtils.readPreviousState(in));
            context.setClosePreviousState(SaveUtils.readPreviousState(in));
            context.setDockPreviousState(SaveUtils.readPreviousState(in));
            context.setFloatPreviousState(SaveUtils.readPreviousState(in));
            Object previousContext = contexts.remove(key);
            if (previousContext instanceof DockableBarContext) {
                context.setInitIndex(((DockableBarContext)previousContext).getInitIndex());
                context.setInitMode(((DockableBarContext)previousContext).getInitMode());
                context.setInitSide(((DockableBarContext)previousContext).getInitSide());
                context.setInitSubindex(((DockableBarContext)previousContext).getInitSubindex());
            }
            contexts.put(key, context);
        }
    }

    static void writeContext(DataOutputStream out, Map contexts) throws IOException {
        out.writeInt(contexts.size());
        Set set = contexts.keySet();
        for (String key : set) {
            DockableBarContext context = (DockableBarContext)contexts.get(key);
            SaveUtils.writeString(out, key);
            out.writeInt(context.getDockID());
            out.writeInt(context.getInitSide());
            out.writeInt(context.getInitIndex());
            out.writeInt(context.isInitPosition() ? 1 : 0);
            out.writeInt(context.getInitMode());
            out.writeInt(context.getCurrentMode());
            out.writeInt(context.getCurrentDockSide());
            out.writeInt(context.getDockedWidth());
            out.writeInt(context.getDockedHeight());
            if (context.getUndockedBounds() != null) {
                SaveUtils.writeRectangle(out, context.getUndockedBounds());
            } else {
                SaveUtils.writeRectangle(out, new Rectangle(0, 0, 0, 0));
            }
            SaveUtils.writePreviousState(out, context.getHiddenPreviousState());
            SaveUtils.writePreviousState(out, context.getClosePreviousState());
            SaveUtils.writePreviousState(out, context.getDockPreviousState());
            SaveUtils.writePreviousState(out, context.getFloatPreviousState());
        }
    }

    static void writeComponent(DataOutputStream out, Component component) throws IOException {
        if (component instanceof DockableBarContainer) {
            SaveUtils.writeDockableBarContainer(out, (DockableBarContainer)component);
        } else if (component instanceof DockableBar) {
            SaveUtils.writeDockableBar(out, (DockableBar)component);
        } else if (component instanceof FloatingDockableBarContainer) {
            SaveUtils.writeFloatingContainer(out, (FloatingDockableBarContainer)component);
        } else {
            System.out.println("Error: Unknown type " + component);
        }
    }

    static Component readComponent(DockableBarManager dockableBarManager, DataInputStream in) throws IOException {
        int type = in.readInt();
        switch (type) {
            case 1130: {
                return SaveUtils.readDockableBarContainer(dockableBarManager, in);
            }
            case 1131: {
                return SaveUtils.readDockableBar(dockableBarManager, in);
            }
            case 1132: {
                return SaveUtils.readFloatingContainer(dockableBarManager, in);
            }
        }
        throw new IOException("Unknown type: " + type);
    }

    private static DockableBarContainer readDockableBarContainer(DockableBarManager dockableBarManager, DataInputStream in) throws IOException {
        DockableBarContainer fc = dockableBarManager.createDockableBarContainer();
        fc.setSide(in.readInt());
        int count = in.readInt();
        DockableBarListList listList = new DockableBarListList(fc);
        for (int i = 0; i < count; ++i) {
            int count2 = in.readInt();
            if (count2 == 0) continue;
            DockableBarList list = new DockableBarList(listList);
            listList.add(list);
            for (int j = 0; j < count2; ++j) {
                int start = in.readInt();
                DockableBar db = (DockableBar)SaveUtils.readComponent(dockableBarManager, in);
                if (db == null) continue;
                try {
                    if (fc.getOrientation() == 0) {
                        db.setHoriDocked();
                    } else {
                        db.setVertDocked();
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                DockableBarItem item = new DockableBarItem(db, start);
                list.add(item);
            }
        }
        fc.setDockableBarList(listList);
        return fc;
    }

    private static void writeDockableBarContainer(DataOutputStream out, DockableBarContainer fc) throws IOException {
        out.writeInt(1130);
        out.writeInt(fc.getSide());
        DockableBarListList listList = fc.getDockableBarList();
        SaveUtils.writeInt(out, listList.size());
        for (Object aListList : listList) {
            DockableBarList list = (DockableBarList)aListList;
            SaveUtils.writeInt(out, list.size());
            for (Object o : list) {
                DockableBarItem item = (DockableBarItem)o;
                SaveUtils.writeInt(out, item.getStart());
                SaveUtils.writeDockableBar(out, (DockableBar)item.getComponent());
            }
        }
    }

    private static DockableBar readDockableBar(DockableBarManager dockableBarManager, DataInputStream in) throws IOException {
        String name = SaveUtils.readString(in);
        DockableBar df = dockableBarManager.getDockableBar(name);
        if (df != null) {
            DockableBarContext dockContext = dockableBarManager.getDockableBarContextOf(name);
            if (dockContext != null) {
                df.setContext(dockContext);
                if (dockContext.isVertDocked()) {
                    df.setOrientation(1);
                } else {
                    df.setOrientation(0);
                }
            } else {
                System.err.println("DockableBarContext shouldn't be null");
            }
            if (!df.isHidden()) {
                dockableBarManager.removeFromHiddenDockableBars(name);
            }
            df.setVisible(!df.isHidden());
            if (df instanceof CommandBar) {
                ((CommandBar)df).setPreferredRowCount(SaveUtils.readInt(in));
            }
        } else {
            SaveUtils.readInt(in);
        }
        return df;
    }

    private static void writeDockableBar(DataOutputStream out, DockableBar df) throws IOException {
        out.writeInt(1131);
        SaveUtils.writeString(out, df.getKey());
        if (df instanceof CommandBar) {
            SaveUtils.writeInt(out, ((CommandBar)df).getPreferredRowCount());
        }
    }

    private static FloatingDockableBarContainer createFloatingContainer(DockableBarManager dockableBarManager) {
        FloatingDockableBarContainer floatingContainer = dockableBarManager.getRootPaneContainer() instanceof Dialog ? dockableBarManager.createFloatingDockableBarContainer((Dialog)((Object)dockableBarManager.getRootPaneContainer())) : (dockableBarManager.getRootPaneContainer() instanceof Applet ? dockableBarManager.createFloatingDockableBarContainer(JideSwingUtilities.getFrame((Applet)((Object)dockableBarManager.getRootPaneContainer()))) : dockableBarManager.createFloatingDockableBarContainer((Frame)((Object)dockableBarManager.getRootPaneContainer())));
        return floatingContainer;
    }

    private static FloatingDockableBarContainer readFloatingContainer(DockableBarManager dockableBarManager, DataInputStream in) throws IOException {
        FloatingDockableBarContainer fc = SaveUtils.createFloatingContainer(dockableBarManager);
        fc.setBounds(PortingUtils.overlapWithScreenBounds(fc, SaveUtils.readRectangle(in)));
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            Component comp = SaveUtils.readComponent(dockableBarManager, in);
            if (comp == null) continue;
            fc.getContentPane().add(comp);
            if (!(comp instanceof DockableBar)) continue;
            ((DockableBar)comp).setOrientation(0);
            if (((DockableBar)comp).isHidden()) continue;
            try {
                ((DockableBar)comp).setFloating();
                continue;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (fc.getContentPane().getComponentCount() == 0) {
            fc.dispose();
            return null;
        }
        return fc;
    }

    private static void writeFloatingContainer(DataOutputStream out, FloatingDockableBarContainer fc) throws IOException {
        boolean visible;
        out.writeInt(1132);
        Rectangle bounds = fc.getBounds();
        int contY = bounds.y;
        boolean bl = visible = contY >= -5000;
        if (!visible) {
            bounds.y += 10000;
        }
        SaveUtils.writeRectangle(out, bounds);
        out.writeInt(fc.getContentPane().getComponentCount());
        for (int i = 0; i < fc.getContentPane().getComponentCount(); ++i) {
            SaveUtils.writeComponent(out, fc.getContentPane().getComponent(i));
        }
    }

    static FloatingDockableBars readFloatingDockableBars(DockableBarManager dockableBarManager, DataInputStream in) throws IOException {
        FloatingDockableBars frames = new FloatingDockableBars();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            Component comp = SaveUtils.readComponent(dockableBarManager, in);
            if (comp == null) continue;
            frames.add(comp);
        }
        return frames;
    }

    static void writeFloatingDockableBars(DataOutputStream out, FloatingDockableBars frames) throws IOException {
        int framesSize = frames != null ? frames.size() : 0;
        out.writeInt(framesSize);
        for (int i = 0; i < framesSize; ++i) {
            SaveUtils.writeComponent(out, (FloatingDockableBarContainer)frames.get(i));
        }
    }

    static HiddenDockableBars readHiddenDockableBars(DataInputStream in) throws IOException {
        HiddenDockableBars<String> frames = new HiddenDockableBars<String>();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            String name = SaveUtils.readString(in);
            frames.add(name);
        }
        return frames;
    }

    static void writeHiddenDockableBars(DataOutputStream out, HiddenDockableBars frames) throws IOException {
        out.writeInt(frames.size());
        for (int i = 0; i < frames.size(); ++i) {
            String name = (String)frames.get(i);
            SaveUtils.writeString(out, name);
        }
    }

    private static PreviousState readPreviousState(DataInputStream in) throws IOException {
        int valid = in.readInt();
        if (valid == 1) {
            int i;
            PreviousState state = new PreviousState();
            state.mode = in.readInt();
            state.dockID = in.readInt();
            state.side = in.readInt();
            state.rcBounds = SaveUtils.readRectangle(in);
            state.start = in.readInt();
            state.row = in.readInt();
            state.newRow = in.readBoolean();
            state.fcID = in.readInt();
            int count = in.readInt();
            if (count != 0) {
                state.fcChildren = new ArrayList();
                for (i = 0; i < count; ++i) {
                    state.fcChildren.add(in.readInt());
                }
            }
            if ((count = in.readInt()) != 0) {
                state.parentStates = new ArrayList();
                for (i = 0; i < count; ++i) {
                    PreviousState.ParentState pState = new PreviousState.ParentState();
                    pState.ccID = in.readInt();
                    pState.myID = in.readInt();
                    pState.orientation = in.readInt();
                    int count2 = in.readInt();
                    if (count2 != 0) {
                        pState.ccChildren = new ArrayList();
                        for (int j = 0; j < count2; ++j) {
                            pState.ccChildren.add(in.readInt());
                        }
                    }
                    state.parentStates.add(pState);
                }
            }
            return state;
        }
        return null;
    }

    private static void writePreviousState(DataOutputStream out, PreviousState state) throws IOException {
        if (state != null) {
            int i;
            out.writeInt(1);
            out.writeInt(state.mode);
            out.writeInt(state.dockID);
            out.writeInt(state.side);
            SaveUtils.writeRectangle(out, state.rcBounds);
            out.writeInt(state.start);
            out.writeInt(state.row);
            out.writeBoolean(state.newRow);
            out.writeInt(state.fcID);
            if (state.fcChildren != null) {
                out.writeInt(state.fcChildren.size());
                for (i = 0; i < state.fcChildren.size(); ++i) {
                    out.writeInt((Integer)state.fcChildren.get(i));
                }
            } else {
                out.writeInt(0);
            }
            if (state.parentStates != null) {
                out.writeInt(state.parentStates.size());
                for (i = 0; i < state.parentStates.size(); ++i) {
                    PreviousState.ParentState pState = (PreviousState.ParentState)state.parentStates.get(i);
                    out.writeInt(pState.ccID);
                    out.writeInt(pState.myID);
                    out.writeInt(pState.orientation);
                    if (pState.ccChildren != null) {
                        out.writeInt(pState.ccChildren.size());
                        for (int j = 0; j < pState.ccChildren.size(); ++j) {
                            out.writeInt((Integer)pState.ccChildren.get(j));
                        }
                        continue;
                    }
                    out.writeInt(0);
                }
            } else {
                out.writeInt(0);
            }
        } else {
            out.writeInt(0);
        }
    }
}

