/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.xml.schema;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import ro.sync.basic.io.URLSetDescription;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.xml.schema.ExternalDTDInfo;
import ro.sync.basic.xml.schema.SchemaDeclarationInfo;
import ro.sync.basic.xml.schema.SchemaDeclarationLocatorImpl;
import ro.sync.basic.xml.schema.SchemaTypes;

public class SchemaDescriptor
extends URLSetDescription
implements Cloneable,
SchemaTypes {
    private static final int DT_NOT_SPECIFIED = 0;
    public static final int DT_OPTIONS = 1;
    public static final int DT_USER = 2;
    public static final int DT_INTERNAL = 3;
    public static final int DT_FROM_NAMESPACE = 4;
    public static final int DT_VALIDATION_SCENARIO = 5;
    private int type = 0;
    private int detectionType = 0;
    private boolean hasEmbeddedSubset;
    public String[] schPhases;
    private SchemaDeclarationInfo[] declarationInfos;
    private ExternalDTDInfo externalDTDFromValidatioScenario;
    private String[] extensionJars;

    public SchemaDescriptor(URL[] schemas, int type, int detectionType) {
        this(schemas, null, type, detectionType);
    }

    public SchemaDescriptor(URL[] schemas, String[] schPhases, int type, int detectionType) {
        this(schemas, schPhases, type, detectionType, null);
    }

    public SchemaDescriptor(URL[] schemas, String[] schPhases, int type, int detectionType, SchemaDeclarationInfo[] schemaNodeLoc) {
        super(schemas);
        this.schPhases = schPhases;
        this.type = type;
        this.detectionType = detectionType;
        this.declarationInfos = schemaNodeLoc;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\nSchemas type: ").append(this.type).append(" detection type: ").append(this.detectionType);
        if (this.schPhases != null && this.schPhases.length > 0) {
            sb.append("\nSchematron phases: ").append(Arrays.asList(this.schPhases));
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int i;
        int hashCode = super.hashCode() + this.type + this.detectionType;
        if (this.schPhases != null) {
            for (i = 0; i < this.schPhases.length; ++i) {
                hashCode += this.schPhases[i].hashCode();
            }
        }
        if (this.extensionJars != null) {
            for (i = 0; i < this.extensionJars.length; ++i) {
                hashCode += this.extensionJars[i].hashCode();
            }
        }
        if (this.externalDTDFromValidatioScenario != null) {
            hashCode += this.externalDTDFromValidatioScenario.hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SchemaDescriptor) {
            boolean changesTookPlace = false;
            SchemaDescriptor newDescription = (SchemaDescriptor)obj;
            changesTookPlace = this.type != newDescription.type ? true : (this.detectionType != newDescription.detectionType ? true : (!Equaler.verifyArrayEquals(this.schPhases, newDescription.schPhases) ? true : (!Equaler.verifyArrayEquals(this.extensionJars, newDescription.extensionJars) ? true : (!Equaler.verifyEquals(this.externalDTDFromValidatioScenario, newDescription.externalDTDFromValidatioScenario) ? true : !super.equals(obj)))));
            return !changesTookPlace;
        }
        return false;
    }

    public void setHasEmbeddedSubset(boolean hasEmbeddedSubset) {
        this.hasEmbeddedSubset = hasEmbeddedSubset;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getDetectionType() {
        return this.detectionType;
    }

    public boolean isHasEmbeddedSubset() {
        return this.hasEmbeddedSubset;
    }

    public Object clone() {
        SchemaDescriptor sd = new SchemaDescriptor(this.locations, this.schPhases, this.getType(), this.getDetectionType());
        sd.setHasEmbeddedSubset(this.isHasEmbeddedSubset());
        if (this.declarationInfos != null) {
            sd.declarationInfos = new SchemaDeclarationInfo[this.declarationInfos.length];
            for (int i = 0; i < this.declarationInfos.length; ++i) {
                if (this.declarationInfos[i] == null) continue;
                sd.declarationInfos[i] = new SchemaDeclarationLocatorImpl(this.declarationInfos[i].getDeclarationPIIndex(), this.declarationInfos[i].getOriginalSchemaSystemID());
            }
        }
        return sd;
    }

    public static int getSchemaType(String schemaContentType) {
        int st = 0;
        if ("text/dtd".equals(schemaContentType)) {
            st = 1;
        } else if ("text/nvdl".equals(schemaContentType)) {
            st = 9;
        } else if ("text/rnc".equals(schemaContentType)) {
            st = 3;
        } else if ("text/rng".equals(schemaContentType)) {
            st = 4;
        } else if ("text/sch".equals(schemaContentType)) {
            st = 7;
        } else if ("text/xsd".equals(schemaContentType)) {
            st = 2;
        } else if ("text/json".equals(schemaContentType)) {
            st = 10;
        } else if ("text/json-schema".equals(schemaContentType)) {
            st = 11;
        }
        return st;
    }

    public void setDetectionType(int detectionType) {
        this.detectionType = detectionType;
    }

    public SchemaDeclarationInfo[] getSchemaDeclarationInfo() {
        return this.declarationInfos;
    }

    public static SchemaDescriptor[] splitSchemaDescriptors(SchemaDescriptor ... schemaDescriptors) {
        ArrayList<SchemaDescriptor> res = new ArrayList<SchemaDescriptor>();
        if (schemaDescriptors != null) {
            for (int i = 0; i < schemaDescriptors.length; ++i) {
                for (int j = 0; j < schemaDescriptors[i].locations.length; ++j) {
                    SchemaDeclarationInfo[] schemaDeclarationInfoArray;
                    SchemaDeclarationInfo sdi = null;
                    if (schemaDescriptors[i].getSchemaDeclarationInfo() != null && j < schemaDescriptors[i].getSchemaDeclarationInfo().length) {
                        sdi = schemaDescriptors[i].getSchemaDeclarationInfo()[j];
                    }
                    URL[] uRLArray = new URL[]{schemaDescriptors[i].locations[j]};
                    String[] stringArray = schemaDescriptors[i].schPhases;
                    int n = schemaDescriptors[i].getType();
                    int n2 = schemaDescriptors[i].getDetectionType();
                    if (sdi != null) {
                        SchemaDeclarationInfo[] schemaDeclarationInfoArray2 = new SchemaDeclarationInfo[1];
                        schemaDeclarationInfoArray = schemaDeclarationInfoArray2;
                        schemaDeclarationInfoArray2[0] = sdi;
                    } else {
                        schemaDeclarationInfoArray = null;
                    }
                    res.add(new SchemaDescriptor(uRLArray, stringArray, n, n2, schemaDeclarationInfoArray));
                }
            }
        }
        return res.toArray(new SchemaDescriptor[res.size()]);
    }

    public void setExternalDTDInfo(ExternalDTDInfo externalDTDFromValidatioScenario) {
        this.externalDTDFromValidatioScenario = externalDTDFromValidatioScenario;
    }

    public ExternalDTDInfo getExternalDTDInfo() {
        return this.externalDTDFromValidatioScenario;
    }

    public String[] getExtensionJARs() {
        return this.extensionJars;
    }

    public void setExtensionJARs(String[] extensions) {
        this.extensionJars = extensions;
    }
}

