/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.xml;

import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.TransformerFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class XmlSerializationUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)XmlSerializationUtil.class.getName());
    private static final Class SERIALIZER_CLASS = XmlSerializationUtil.getSerializerClass();

    private static Class getSerializerClass() {
        Class<?> serializerClass;
        try {
            serializerClass = Class.forName("org.apache.xml.serializer.dom3.LSSerializerImpl");
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cannot load LSSerializerImpl:", (Throwable)ex);
            }
            serializerClass = null;
        }
        return serializerClass;
    }

    public static String serialize(Node node, boolean ommitXMLDecl) throws Exception {
        boolean fallbackToTransformer;
        Object result;
        block5: {
            result = null;
            fallbackToTransformer = true;
            try {
                if (SERIALIZER_CLASS != null) {
                    Object serializer = SERIALIZER_CLASS.newInstance();
                    SERIALIZER_CLASS.getMethod("setNewLine", String.class).invoke(serializer, "\n");
                    SERIALIZER_CLASS.getMethod("setParameter", String.class, Object.class).invoke(serializer, "xml-declaration", Boolean.FALSE);
                    result = (String)SERIALIZER_CLASS.getMethod("writeToString", Node.class).invoke(serializer, node);
                    fallbackToTransformer = false;
                }
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug("LSSerializerImpl not available:", (Throwable)ex);
            }
        }
        if (fallbackToTransformer) {
            Transformer tr = new TransformerFactoryImpl().newTransformer();
            tr.setOutputProperty("omit-xml-declaration", "yes");
            tr.setOutputProperty("method", "xml");
            StringWriter sw = new StringWriter();
            StreamResult res = new StreamResult(sw);
            tr.transform(new DOMSource(node), res);
            sw.close();
            result = sw.toString();
        }
        if (!ommitXMLDecl) {
            result = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + result;
        }
        return result;
    }
}

