/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.xml;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import ro.sync.annotations.ModifiedFromTests;

public class EscapingReader
extends FilterReader {
    private static final char[] AMP = new char[]{'&', 'a', 'm', 'p', ';'};
    private static final int NOT_FOUND = -1;
    private static final int POSSIBLE = -2;
    private int count = -1;
    private char[] singleChar = new char[1];
    private int ibAmpIndex = -1;
    @ModifiedFromTests
    static final Integer IB_SIZE = 20480;
    private char[] ib = new char[IB_SIZE.intValue()];
    private int ibPos = 0;
    private int ibLen = 0;

    public EscapingReader(Reader in) {
        super(in);
    }

    @Override
    public final int read() throws IOException {
        if (this.read(this.singleChar, 0, 1) != -1) {
            return this.singleChar[0];
        }
        return -1;
    }

    private final int internalRead() throws IOException {
        int ch;
        if (this.ibPos >= this.ibLen) {
            this.ibLen = super.read(this.ib, 0, this.ib.length);
            this.ibAmpIndex = -1;
            for (int i = 0; i < this.ibLen; ++i) {
                if (this.ib[i] != '&') continue;
                this.ibAmpIndex = i;
                break;
            }
            this.ibPos = 0;
        }
        if (this.ibPos < this.ibLen) {
            ch = this.ib[this.ibPos];
            ++this.ibPos;
        } else {
            ch = -1;
        }
        return ch;
    }

    @Override
    public final int read(char[] cbuf, int off, int len) throws IOException {
        int i;
        int availableIb = this.ibLen - this.ibPos;
        if (availableIb > 0 && (this.ibAmpIndex == -1 || this.ibAmpIndex > this.ibPos)) {
            int lenToAmp;
            if (len > availableIb) {
                len = availableIb;
            }
            if (this.ibAmpIndex > 0 && len > (lenToAmp = this.ibAmpIndex - this.ibPos)) {
                len = lenToAmp;
                this.ibAmpIndex = -2;
            }
            System.arraycopy(this.ib, this.ibPos, cbuf, off, len);
            this.ibPos += len;
            return len;
        }
        int ch = -1;
        for (i = 0; i < len; ++i) {
            if (this.count == -1) {
                ch = this.internalRead();
                if (ch == 38) {
                    this.count = 1;
                }
            } else {
                ch = AMP[this.count];
                ++this.count;
                if (this.count == 5) {
                    this.count = -1;
                }
            }
            if (ch == -1) break;
            cbuf[off + i] = (char)ch;
        }
        if (i == 0 && ch == -1) {
            return -1;
        }
        return i;
    }

    @Override
    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException("Skip not supported.");
    }

    @Override
    public boolean ready() throws IOException {
        return this.in.ready();
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.count = -1;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

