/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.nio.charset.StandardCharsets;
import java.util.Hashtable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLStreamHandlerFactorySetter {
    private static final Logger logger = LoggerFactory.getLogger((String)URLStreamHandlerFactorySetter.class.getName());
    private URLStreamHandlerFactory oldFactory = this.getExistingFactory();

    public void setFactory(URLStreamHandlerFactory factory) throws Exception {
        this.tearDown();
        this.oldFactory = this.getExistingFactory();
        this.clearFactory();
        URL.setURLStreamHandlerFactory(factory);
    }

    public void tearDown() throws Exception {
        this.clearFactory();
        URL.setURLStreamHandlerFactory(this.oldFactory);
        this.oldFactory = null;
    }

    public void setHandler(final String proto, final URLStreamHandler streamHandler) throws Exception {
        this.setFactory(new URLStreamHandlerFactory(){

            @Override
            public URLStreamHandler createURLStreamHandler(String protocol) {
                if (protocol.equals(proto)) {
                    return streamHandler;
                }
                return null;
            }
        });
    }

    private void clearFactory() throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        Field factoryField = URL.class.getDeclaredField("factory");
        factoryField.setAccessible(true);
        factoryField.set(null, null);
        URLStreamHandlerFactorySetter.clearURLStreamHandlerCache();
    }

    private static boolean clearURLStreamHandlerCache() {
        boolean success = false;
        try {
            Field handlersField = URL.class.getDeclaredField("handlers");
            handlersField.setAccessible(true);
            Hashtable handlers = (Hashtable)handlersField.get(null);
            handlers.clear();
            success = true;
        }
        catch (Throwable t) {
            logger.error("URL Stream handlers cache cannot be cleared.", t);
        }
        return success;
    }

    public URLStreamHandlerFactory getExistingFactory() throws NoSuchFieldException, IllegalAccessException {
        Field factoryField = URL.class.getDeclaredField("factory");
        factoryField.setAccessible(true);
        Object existingFactory = factoryField.get(null);
        return (URLStreamHandlerFactory)existingFactory;
    }

    public static URLStreamHandler createHandlerWithContent(final Map<String, String> contentByPath) {
        return new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) throws IOException {
                String content = (String)contentByPath.get(u.getPath());
                if (content != null) {
                    return URLStreamHandlerFactorySetter.createURLConnectionWithContent(u, content);
                }
                return null;
            }
        };
    }

    private static URLConnection createURLConnectionWithContent(URL u, final String mainFile) {
        return new URLConnection(u){

            @Override
            public void connect() throws IOException {
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(mainFile.getBytes(StandardCharsets.UTF_8));
            }
        };
    }
}

