/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util;

import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;

@API(type=APIType.INTERNAL, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class Equaler {
    public static boolean verifyEquals(Object o1, Object o2) {
        boolean equals = false;
        if (o1 == o2) {
            equals = true;
        } else if (o1 == null) {
            equals = false;
        } else if (o2 == null) {
            equals = false;
        } else if (o1 instanceof CharSequence) {
            equals = Equaler.verifyStringObjectEquals(o1, o2);
        } else {
            if (o1 instanceof URL) {
                o1 = ((URL)o1).toExternalForm();
            }
            if (o2 instanceof URL) {
                o2 = ((URL)o2).toExternalForm();
            }
            equals = o1.equals(o2);
        }
        return equals;
    }

    private static boolean verifyStringObjectEquals(Object first, Object second) {
        if (first instanceof CharSequence && second instanceof CharSequence) {
            if (first instanceof String && second instanceof String) {
                return first.equals(second);
            }
            CharSequence firstString = (CharSequence)first;
            CharSequence secondString = (CharSequence)second;
            int n = firstString.length();
            if (n == secondString.length()) {
                for (int i = 0; i < n; ++i) {
                    if (firstString.charAt(i) == secondString.charAt(i)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return first.equals(second);
    }

    protected static void checkObjectsForArrays(Object o1, Object o2) {
        boolean secondIsArray;
        boolean firstIsArray = o1.getClass().isArray();
        if (firstIsArray != (secondIsArray = o2.getClass().isArray())) {
            System.err.println("Comparing an array with a non array object");
            new Exception().printStackTrace();
        }
    }

    public static boolean verifyArrayEquals(Object[] o1, Object[] o2) {
        boolean equals = true;
        if (o1 != null && o2 == null) {
            equals = false;
        } else if (o1 == null && o2 != null) {
            equals = false;
        } else if (o1 != null && o2 != null) {
            if (o1.length != o2.length) {
                equals = false;
            } else {
                for (int i = 0; i < o1.length; ++i) {
                    if (Equaler.verifyEquals(o1[i], o2[i])) continue;
                    equals = false;
                    break;
                }
            }
        }
        return equals;
    }

    public static boolean verifyArrayEquals(byte[] b1, byte[] b2) {
        boolean equals = true;
        if (b1 != null && b2 == null) {
            equals = false;
        } else if (b1 == null && b2 != null) {
            equals = false;
        } else if (b1 != null && b2 != null) {
            if (b1.length != b2.length) {
                equals = false;
            } else {
                for (int i = 0; i < b1.length; ++i) {
                    if (b1[i] == b2[i]) continue;
                    equals = false;
                    break;
                }
            }
        }
        return equals;
    }

    public static boolean verifyArrayEquals(int[] b1, int[] b2) {
        boolean equals = true;
        if (b1 != null && b2 == null) {
            equals = false;
        } else if (b1 == null && b2 != null) {
            equals = false;
        } else if (b1 != null && b2 != null) {
            if (b1.length != b2.length) {
                equals = false;
            } else {
                for (int i = 0; i < b1.length; ++i) {
                    if (b1[i] == b2[i]) continue;
                    equals = false;
                    break;
                }
            }
        }
        return equals;
    }

    public static boolean verifyListEquals(Collection<?> o1, Collection<?> o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.size() != o2.size()) {
            return false;
        }
        Iterator<?> itero1 = o1.iterator();
        Iterator<?> itero2 = o2.iterator();
        while (itero1.hasNext()) {
            Object o1Obj = itero1.next();
            Object o2Obj = itero2.next();
            if (!(o1Obj instanceof Collection && o2Obj instanceof Collection ? !Equaler.verifyListEquals((Collection)o1Obj, (Collection)o2Obj) : !Equaler.verifyEquals(o1Obj, o2Obj))) continue;
            return false;
        }
        return true;
    }

    public static boolean verifyNamespaceEquals(String ns1, String ns2) {
        if (ns1 == null) {
            ns1 = "";
        }
        if (ns2 == null) {
            ns2 = "";
        }
        return Equaler.verifyEquals(ns1, ns2);
    }

    public static boolean verifyMapEquals(Map<?, ?> map1, Map<?, ?> map2) {
        if (map1 == map2) {
            return true;
        }
        if (map1 == null || map2 == null) {
            return false;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        Set<?> keySet1 = map1.keySet();
        Set<?> keySet2 = map2.keySet();
        for (Object key : keySet1) {
            if (keySet2.contains(key)) {
                Object o1 = map1.get(key);
                Object o2 = map2.get(key);
                if (!(o1 instanceof Collection && o2 instanceof Collection ? !Equaler.verifyListEquals((Collection)o1, (Collection)o2) : (o1 instanceof Map && o2 instanceof Map ? !Equaler.verifyMapEquals((Map)o1, (Map)o2) : !Equaler.verifyEquals(o1, o2)))) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

