/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.UUID;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.ModifiedFromTests;
import ro.sync.basic.io.IOUtil;
import ro.sync.basic.statics.StaticComponentsRegistry;
import ro.sync.basic.util.FilePermissionSetter;
import ro.sync.basic.util.PlatformDetector;
import ro.sync.basic.util.URLUtil;
import ro.sync.basic.util.WebappEncryptionKey;
import ro.sync.basic.util.concurrent.LazyImmutable;

public class EncryptionKey {
    private static final String KEY = "rk";
    private static final String REG_KEY = "/com/oxygenxml";
    private static final Logger logger = LoggerFactory.getLogger(EncryptionKey.class);
    private static final String FALLBACK_KEY = "acc1c674-8fd5-4ce9-8153-37d9f4747a05";
    private final String key;
    @ModifiedFromTests
    private static final LazyImmutable<EncryptionKey> instance = new LazyImmutable<EncryptionKey>(){

        @Override
        protected EncryptionKey init() {
            if (EncryptionKey.isWebAuthor() && !"false".equals(System.getProperty("encryption.key.file.no.permissions"))) {
                return new WebappEncryptionKey();
            }
            return new EncryptionKey();
        }
    };
    @ModifiedFromTests
    public static final Boolean TEST_MODE = Boolean.FALSE;
    private final LazyImmutable<String> keyService = new LazyImmutable<String>(){

        @Override
        protected String init() {
            String keyServicePropName = "com.oxygenxml.key.service.url";
            String serviceUrl = System.getProperty(keyServicePropName);
            System.clearProperty(keyServicePropName);
            return serviceUrl;
        }
    };

    public static EncryptionKey getInstance() {
        return instance.get();
    }

    EncryptionKey() {
        String key = null;
        if (!TEST_MODE.booleanValue()) {
            key = this.loadKey();
        }
        if (key == null) {
            boolean saved = false;
            if (this.getServiceUrl() == null) {
                key = UUID.randomUUID().toString();
                saved = this.saveKey(key);
            }
            if (!saved) {
                key = FALLBACK_KEY;
            }
        }
        this.key = key;
    }

    private String loadKey() {
        String key = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String key = EncryptionKey.this.loadKeyFromService();
                if (key != null) {
                    return key;
                }
                if (PlatformDetector.isWin()) {
                    try {
                        Preferences preferences = Preferences.userRoot().node(EncryptionKey.REG_KEY);
                        key = preferences.get(EncryptionKey.KEY, null);
                    }
                    catch (AccessControlException ex) {
                        logger.debug("Cannot access registry (code is sandboxed). Fallback to local file system. " + ex.getMessage());
                    }
                } else {
                    File keyFile = EncryptionKey.getKeyFile();
                    if (keyFile.exists()) {
                        try {
                            key = EncryptionKey.this.readKeyFromFile(keyFile);
                        }
                        catch (IOException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
                return key;
            }
        });
        return key;
    }

    protected String readKeyFromFile(File keyFile) throws IOException {
        new FilePermissionSetter().addOnwerReadPerm(keyFile);
        return IOUtil.readFile(keyFile, null, true, false);
    }

    private String loadKeyFromService() {
        String key = null;
        String keyService = this.getServiceUrl();
        if (keyService != null) {
            try {
                URL keyServiceUrl = URLUtil.convertToURL(keyService);
                File file = URLUtil.getAbsoluteFileFromFileUrl(keyServiceUrl);
                key = file != null ? IOUtil.readFile(file, "UTF-8") : IOUtil.readURL(keyServiceUrl, "UTF-8");
                key = key.trim();
            }
            catch (IOException e) {
                logger.debug("Cannot access the key service URL. {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return key;
    }

    private String getServiceUrl() {
        return this.keyService.get();
    }

    protected boolean saveKey(final String key) {
        Boolean saved = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                boolean success = false;
                if (PlatformDetector.isWin()) {
                    Preferences preferences = Preferences.userRoot().node(EncryptionKey.REG_KEY);
                    preferences.put(EncryptionKey.KEY, key);
                    try {
                        preferences.flush();
                        success = true;
                    }
                    catch (BackingStoreException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                } else {
                    File keyFile = EncryptionKey.getKeyFile();
                    File parent = keyFile.getParentFile();
                    boolean parentExists = true;
                    if (!parent.exists()) {
                        parentExists = keyFile.getParentFile().mkdir();
                    }
                    if (parentExists) {
                        try {
                            EncryptionKey.this.writeKeyToFile(key, keyFile);
                            success = true;
                        }
                        catch (Exception e) {
                            logger.error("Could not write file: " + keyFile.toString() + " - " + e.getMessage());
                        }
                    } else {
                        logger.error("Could not create directory '.java' in user home.");
                    }
                }
                return success;
            }
        });
        return saved;
    }

    protected void writeKeyToFile(String key, File keyFile) throws IOException {
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(keyFile)));){
            out.write(key);
        }
    }

    static File getKeyFile() {
        String userHome = System.getProperty("user.home");
        return new File(userHome + "/.java", ".com.oxygenxml.rk");
    }

    private static boolean isWebAuthor() {
        Boolean isWebAuthor = (Boolean)StaticComponentsRegistry.get("IS_WEBAUTHOR_COMPONENT");
        return isWebAuthor == null ? false : isWebAuthor;
    }

    String getKey() {
        return this.key;
    }
}

