/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util;

import java.net.URL;
import java.util.StringTokenizer;
import org.apache.xerces.util.XMLChar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.EncryptionKey;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.basic.util.URLUtil;
import ro.sync.basic.util.concurrent.ImmutableCharacterSet;

public class Crypto {
    private static Logger logger = LoggerFactory.getLogger((String)Crypto.class.getName());
    private static final int MINIMUM_PASSWORD_LENGTH = 20;
    private static final char PADDING_SEPARATOR = '.';
    private static final ImmutableCharacterSet CRIPT_CHARS = new ImmutableCharacterSet('\u00f6', '%', '\u0178', '\u00a2', '\u00b6', '&', '\u00f8', '\u00f1', '#', '\u00be', '^', 'w', '\u00a3', '\u00a4', '\u00c8', '\u00e6', '\u00e0', '\u00de', '\u00df');
    static final String ENCRYPTION_VERSION_PREFIX = "9.1.";

    private Crypto() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static String getKey() {
        return EncryptionKey.getInstance().getKey();
    }

    static String applyEncryptionAlg(String key, String toCrypt) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < toCrypt.length(); ++i) {
            result.append(toCrypt.charAt(i) + key.charAt(i % key.length()) + 2).append(";");
        }
        return result.toString();
    }

    public static String crypt(String key, String toCrypt) {
        StringBuilder toCryptBuilder = new StringBuilder(toCrypt);
        toCryptBuilder.append('.');
        int i = 0;
        char[] criptChars = CRIPT_CHARS.toCharArray();
        while (toCryptBuilder.length() < 20) {
            char paddingChar = criptChars[i];
            if (paddingChar != '.') {
                toCryptBuilder.append(paddingChar);
            }
            ++i;
        }
        return Crypto.applyEncryptionAlg(key, toCryptBuilder.toString());
    }

    public static String decrypt(String key, String toDecrypt, boolean checkPaddingSeparator) {
        try {
            StringBuilder result = new StringBuilder();
            int i = 0;
            StringTokenizer tokenizer = new StringTokenizer(toDecrypt, ";");
            while (tokenizer.hasMoreTokens()) {
                String element = tokenizer.nextToken();
                int e = NumberParserUtil.parseInt(element);
                result.append((char)(e - 2 - key.charAt(i % key.length())));
                ++i;
            }
            int index = result.lastIndexOf(String.valueOf('.'));
            if (index != -1) {
                if (checkPaddingSeparator) {
                    for (int j = index + 1; j < result.length(); ++j) {
                        char ch = result.charAt(j);
                        if (CRIPT_CHARS.contains(ch)) continue;
                        return null;
                    }
                }
                result.setLength(index);
            } else if (checkPaddingSeparator) {
                return null;
            }
            return result.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static URL crypt(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("The URL to crypt can not be null.");
        }
        try {
            String userInfo = url.getUserInfo();
            if (userInfo == null) {
                return url;
            }
            String user = URLUtil.extractUser(userInfo);
            String password = URLUtil.extractPassword(userInfo);
            String crypted = ENCRYPTION_VERSION_PREFIX + Crypto.crypt(Crypto.getKey(), password);
            return URLUtil.attachUserInfo(URLUtil.clearUserInfo(url), user, crypted.toCharArray(), false, false);
        }
        catch (Exception e) {
            return URLUtil.clearUserInfo(url);
        }
    }

    public static String crypt(String password) {
        String toReturn = null;
        if (password != null) {
            toReturn = ENCRYPTION_VERSION_PREFIX + Crypto.crypt(Crypto.getKey(), password);
        }
        return toReturn;
    }

    public static String decrypt(String password) {
        String toReturn = null;
        if (password != null) {
            String key = null;
            if (password.isEmpty()) {
                toReturn = "";
            } else if (password.startsWith(ENCRYPTION_VERSION_PREFIX)) {
                key = Crypto.getKey();
                password = password.substring(ENCRYPTION_VERSION_PREFIX.length());
                toReturn = Crypto.decrypt(key, password, true);
            }
            if (toReturn != null) {
                for (int i = 0; i < toReturn.length(); ++i) {
                    if (!XMLChar.isInvalid((int)toReturn.charAt(i))) continue;
                    return null;
                }
            }
        }
        return toReturn;
    }

    public static URL decrypt(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("The URL to decrypt can not be null.");
        }
        try {
            String userInfo = url.getUserInfo();
            if (userInfo == null) {
                return url;
            }
            String user = URLUtil.extractUser(userInfo);
            String password = URLUtil.extractPassword(userInfo);
            String decrypted = Crypto.decrypt(password);
            if (decrypted != null && decrypted.length() > 255) {
                decrypted = null;
            }
            return URLUtil.attachUserInfo(URLUtil.clearUserInfo(url), user, decrypted == null ? null : decrypted.toCharArray(), false, false);
        }
        catch (Exception e) {
            logger.warn("Could not decript user info for {}", (Object)url, (Object)e);
            return URLUtil.clearUserInfo(url);
        }
    }
}

