/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util;

public class Base64Decoder {
    private static final int EIGHT_BIT_MASK = 255;

    private Base64Decoder() {
    }

    public static byte[] decodeBuffer(String data) {
        StringWrapper wrapper = new StringWrapper(data);
        int byteArrayLength = wrapper.getUsefulLength() * 3 / 4;
        byte[] result = new byte[byteArrayLength];
        int byteTriplet = 0;
        int byteIndex = 0;
        while (byteIndex + 2 < byteArrayLength) {
            byteTriplet = Base64Decoder.mapCharToInt(wrapper.getNextUsefulChar());
            byteTriplet <<= 6;
            byteTriplet |= Base64Decoder.mapCharToInt(wrapper.getNextUsefulChar());
            byteTriplet <<= 6;
            byteTriplet |= Base64Decoder.mapCharToInt(wrapper.getNextUsefulChar());
            byteTriplet <<= 6;
            result[byteIndex + 2] = (byte)((byteTriplet |= Base64Decoder.mapCharToInt(wrapper.getNextUsefulChar())) & 0xFF);
            result[byteIndex + 1] = (byte)((byteTriplet >>= 8) & 0xFF);
            result[byteIndex] = (byte)((byteTriplet >>= 8) & 0xFF);
            byteIndex += 3;
        }
        if (byteIndex == byteArrayLength - 1) {
            byteTriplet = Base64Decoder.mapCharToInt(wrapper.getNextUsefulChar());
            byteTriplet <<= 6;
            byteTriplet |= Base64Decoder.mapCharToInt(wrapper.getNextUsefulChar());
            result[byteIndex] = (byte)((byteTriplet >>= 4) & 0xFF);
        }
        if (byteIndex == byteArrayLength - 2) {
            byteTriplet = Base64Decoder.mapCharToInt(wrapper.getNextUsefulChar());
            byteTriplet <<= 6;
            byteTriplet |= Base64Decoder.mapCharToInt(wrapper.getNextUsefulChar());
            byteTriplet <<= 6;
            byteTriplet |= Base64Decoder.mapCharToInt(wrapper.getNextUsefulChar());
            result[byteIndex + 1] = (byte)((byteTriplet >>= 2) & 0xFF);
            result[byteIndex] = (byte)((byteTriplet >>= 8) & 0xFF);
        }
        return result;
    }

    private static int mapCharToInt(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        if (c == '+') {
            return 62;
        }
        if (c == '/') {
            return 63;
        }
        throw new IllegalArgumentException(c + " is not a valid Base64 character.");
    }

    private static class StringWrapper {
        private String mString;
        private int mIndex = 0;
        private int mUsefulLength;

        private boolean isUsefulChar(char c) {
            return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '+' || c == '/';
        }

        public StringWrapper(String s) {
            this.mString = s;
            this.mUsefulLength = 0;
            int length = this.mString.length();
            for (int i = 0; i < length; ++i) {
                if (!this.isUsefulChar(this.mString.charAt(i))) continue;
                ++this.mUsefulLength;
            }
        }

        private int getUsefulLength() {
            return this.mUsefulLength;
        }

        private char getNextUsefulChar() {
            char result = '_';
            while (!this.isUsefulChar(result)) {
                result = this.mString.charAt(this.mIndex++);
            }
            return result;
        }
    }
}

