/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class LazyInputStream
extends InputStream {
    private final URL wrapped;
    private InputStream wrappedIS;
    private IOException wrappedIO;

    public LazyInputStream(URL wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public int read() throws IOException {
        this.assureOpened();
        return this.wrappedIS.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.assureOpened();
        return this.wrappedIS.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.assureOpened();
        return this.wrappedIS.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.wrappedIS != null) {
            this.wrappedIS.close();
        }
        super.close();
    }

    @Override
    public long skip(long n) throws IOException {
        this.assureOpened();
        return this.wrappedIS.skip(n);
    }

    @Override
    public int available() throws IOException {
        this.assureOpened();
        return this.wrappedIS.available();
    }

    @Override
    public boolean markSupported() {
        try {
            this.assureOpened();
        }
        catch (IOException e) {
            this.wrappedIO = e;
        }
        if (this.wrappedIS != null) {
            return this.wrappedIS.markSupported();
        }
        return super.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.assureOpened();
        this.wrappedIS.reset();
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.assureOpened();
        }
        catch (IOException e) {
            this.wrappedIO = e;
        }
        if (this.wrappedIS != null) {
            this.wrappedIS.mark(readlimit);
        } else {
            super.mark(readlimit);
        }
    }

    private void assureOpened() throws IOException {
        if (this.wrappedIO != null) {
            throw this.wrappedIO;
        }
        if (this.wrappedIS == null) {
            this.wrappedIS = this.wrapped.openStream();
        }
    }
}

