/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.io;

import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ExceptCVSFilenameFilter
implements FilenameFilter {
    private static final List<String> SUBVERSION_FOLDERS = Stream.of(".git", ".svn", "cvs").collect(Collectors.toList());
    private static final String DS_STORE = ".DS_Store";

    @Override
    public boolean accept(File dir, String name) {
        String lowerCaseName = name.toLowerCase();
        return !SUBVERSION_FOLDERS.contains(lowerCaseName) && !name.equals(DS_STORE) && !name.matches("\\.\\~(.*)");
    }
}

