/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.swing;

import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.swing.FileSystemView;
import de.schlichtherle.io.swing.FileView;
import java.awt.Graphics;
import java.io.File;
import javax.swing.Icon;

public class JFileChooser
extends javax.swing.JFileChooser {
    private volatile transient short paintingDisabled;

    public JFileChooser() {
        super(FileSystemView.getFileSystemView());
        super.setFileView(new FileView(super.getFileView()));
        super.setDoubleBuffered(false);
    }

    public JFileChooser(ArchiveDetector archiveDetector) {
        super(FileSystemView.getFileSystemView(archiveDetector));
        super.setFileView(new FileView(super.getFileView()));
        super.setDoubleBuffered(false);
    }

    public File getSelectedFile() {
        File file = super.getSelectedFile();
        return ((FileSystemView)this.getFileSystemView()).wrap(file);
    }

    public File[] getSelectedFiles() {
        File[] fileArray = super.getSelectedFiles();
        if (fileArray != null) {
            FileSystemView fileSystemView = (FileSystemView)this.getFileSystemView();
            int n = fileArray.length;
            while (--n >= 0) {
                fileArray[n] = fileSystemView.wrap(fileArray[n]);
            }
        }
        return fileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getIcon(File file) {
        this.beginPaintingDisabled();
        try {
            Icon icon = super.getIcon(file);
            return icon;
        }
        finally {
            this.endPaintingDisabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTypeDescription(File file) {
        this.beginPaintingDisabled();
        try {
            String string = super.getTypeDescription(file);
            return string;
        }
        finally {
            this.endPaintingDisabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTraversable(File file) {
        this.beginPaintingDisabled();
        try {
            boolean bl = super.isTraversable(file);
            return bl;
        }
        finally {
            this.endPaintingDisabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        if (this.paintingDisabled <= 0) {
            this.beginPaintingDisabled();
            try {
                super.paintChildren(graphics);
            }
            finally {
                this.endPaintingDisabled();
            }
        }
    }

    private synchronized void beginPaintingDisabled() {
        this.paintingDisabled = (short)(this.paintingDisabled + 1);
    }

    private synchronized void endPaintingDisabled() {
        this.paintingDisabled = (short)(this.paintingDisabled - 1);
        if (this.paintingDisabled <= 0) {
            this.repaint();
        }
    }
}

