/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.zip;

import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.spi.AbstractArchiveDriver;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.InputArchive;
import de.schlichtherle.io.archive.spi.MultiplexedOutputArchive;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.io.archive.zip.Zip32Entry;
import de.schlichtherle.io.archive.zip.Zip32InputArchive;
import de.schlichtherle.io.archive.zip.Zip32OutputArchive;
import de.schlichtherle.io.rof.ReadOnlyFile;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.Icon;

public class Zip32Driver
extends AbstractArchiveDriver {
    private static final long serialVersionUID = -7061546656075796996L;
    static final String TEMP_FILE_PREFIX = "tzp-zip";
    public static final String DEFAULT_CHARSET = "IBM437";
    public static final int DEFAULT_LEVEL = 9;
    private final boolean preambled;
    private final boolean postambled;
    private final int level;

    public Zip32Driver() {
        this(DEFAULT_CHARSET, null, null, false, false, 9);
    }

    public Zip32Driver(String string) {
        this(string, null, null, false, false, 9);
    }

    public Zip32Driver(int n) {
        this(DEFAULT_CHARSET, null, null, false, false, n);
    }

    public Zip32Driver(String string, boolean bl, boolean bl2, Icon icon, Icon icon2) {
        this(string, icon, icon2, bl, bl2, 9);
    }

    public Zip32Driver(String string, Icon icon, Icon icon2, boolean bl, boolean bl2, int n) {
        super(string, icon, icon2);
        if ((n < 1 || n > 9) && n != -1) {
            throw new IllegalArgumentException();
        }
        this.preambled = bl;
        this.postambled = bl2;
        this.level = n;
    }

    public final boolean getPreambled() {
        return this.preambled;
    }

    public final boolean getPostambled() {
        return this.postambled;
    }

    public final int getLevel() {
        return this.level;
    }

    public ArchiveEntry createArchiveEntry(Archive archive, String string, ArchiveEntry archiveEntry) throws CharConversionException {
        Zip32Entry zip32Entry;
        this.ensureEncodable(string);
        if (archiveEntry != null) {
            if (archiveEntry instanceof Zip32Entry) {
                zip32Entry = new Zip32Entry((Zip32Entry)archiveEntry);
                zip32Entry.setName(string);
            } else {
                zip32Entry = new Zip32Entry(string);
                zip32Entry.setTime(archiveEntry.getTime());
                zip32Entry.setSize(archiveEntry.getSize());
            }
        } else {
            zip32Entry = new Zip32Entry(string);
        }
        return zip32Entry;
    }

    public InputArchive createInputArchive(Archive archive, ReadOnlyFile readOnlyFile) throws IOException {
        return this.createZip32InputArchive(archive, readOnlyFile);
    }

    protected Zip32InputArchive createZip32InputArchive(Archive archive, ReadOnlyFile readOnlyFile) throws IOException {
        return new Zip32InputArchive(readOnlyFile, this.getCharset(), this.preambled, this.postambled);
    }

    public OutputArchive createOutputArchive(Archive archive, OutputStream outputStream, InputArchive inputArchive) throws IOException {
        return new MultiplexedOutputArchive(this.createZip32OutputArchive(archive, outputStream, (Zip32InputArchive)inputArchive));
    }

    protected Zip32OutputArchive createZip32OutputArchive(Archive archive, OutputStream outputStream, Zip32InputArchive zip32InputArchive) throws IOException {
        return new Zip32OutputArchive(outputStream, this.getCharset(), this.level, zip32InputArchive);
    }
}

