/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.security;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import ro.sync.security.SandboxCore;
import ro.sync.security.SecurityChecker;
import ro.sync.security.UntrustedThreadException;

public final class ThreadsSandbox {
    private ThreadsSandbox() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    private static boolean shouldAskForThread() {
        return SandboxCore.shouldAsk(SandboxCore.ConfirmInfrastructure.Type.THREAD);
    }

    public static void additionalCheckThread(ThreadGroup group) {
        AccessController.doPrivileged(() -> {
            if (ThreadsSandbox.shouldAskForThread()) {
                try {
                    String groupName = group.getName();
                    SecurityChecker.getInstance().verifyThread(groupName, SandboxCore.getConfirmationMessage(SandboxCore.ConfirmInfrastructure.Type.THREAD, groupName));
                }
                catch (UntrustedThreadException ex) {
                    throw new AccessControlException(ex.getMessage());
                }
            }
            return null;
        });
    }

    public static <T> T runWithThreadConfirmation(String message, PrivilegedExceptionAction<T> action) throws Exception {
        return SandboxCore.runWithConfirmation(SandboxCore.ConfirmInfrastructure.Type.THREAD, message, action);
    }
}

