/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.sql;

import com.saxonica.functions.sql.SQLFunctionSet;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;

public class SQLUpdateFn
extends SystemFunction {
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        Connection connection = SQLFunctionSet.expectConnection(arguments[0], context);
        String tableName = arguments[1].head().getStringValue();
        String predicate = arguments[2].head().getStringValue();
        MapItem columns = (MapItem)arguments[3].head();
        StringBuilder statement = new StringBuilder(120);
        statement.append("UPDATE ").append(tableName).append(" SET ");
        ArrayList<AtomicValue> values = new ArrayList<AtomicValue>();
        int cols = 0;
        for (KeyValuePair kvp : columns.keyValuePairs()) {
            if (cols++ > 0) {
                statement.append(',');
            }
            String colname = kvp.key.getStringValue();
            statement.append(colname);
            statement.append("=?");
            AtomicSequence as = Atomizer.atomize((Sequence)kvp.value);
            if (as.getLength() != 1) {
                throw new XPathException("sql:update - new value must be a singleton - actual length = " + as.getLength());
            }
            values.add(as.head());
        }
        if (!predicate.isEmpty()) {
            statement.append(" WHERE ").append(predicate);
        }
        try (PreparedStatement ps = connection.prepareStatement(statement.toString());){
            ParameterMetaData metaData = ps.getParameterMetaData();
            for (int c = 0; c < values.size(); ++c) {
                Object value;
                String parameterClassName;
                AtomicValue v = (AtomicValue)values.get(c);
                switch (parameterClassName = metaData.getParameterClassName(c + 1)) {
                    case "java.lang.String": {
                        value = v.getStringValue();
                        break;
                    }
                    case "java.sql.Date": {
                        value = Date.valueOf(v.getStringValue());
                        break;
                    }
                    default: {
                        try {
                            Class<?> targetClass = Class.forName(parameterClassName);
                            PJConverter converter = PJConverter.allocate((Configuration)context.getConfiguration(), (ItemType)v.getPrimitiveType(), (int)16384, targetClass);
                            value = converter.convert((Sequence)v, targetClass, context);
                            break;
                        }
                        catch (ClassNotFoundException err) {
                            throw new XPathException("sql:update() - cannot convert value to required class " + parameterClassName);
                        }
                    }
                }
                ps.setObject(c + 1, value);
            }
            ps.executeUpdate();
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException ex) {
            throw new XPathException("sql:update() failed: " + ex.getMessage(), "SXSQ0004", context);
        }
        return EmptySequence.getInstance();
    }
}

