/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.validate.external.json;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.SpecificationVersion;
import org.json.JSONObject;
import ro.sync.exml.validate.external.api.ValidationException;
import ro.sync.exml.validate.external.json.JSONValidationUtil;

public class JSONSchemaWarningsGenerator {
    private final JSONObject schemaJson;
    private final SchemaClient httpClient;
    private final String systemId;
    private static final String IGNORED_KEYWORD = "The keyword \"%s\" is not part of the JSON Schema %s specification. Therefore, it is ignored by the validation engine.";
    private static final String IGNORED_KEYWORD_NO_SPEC = "The keyword \"%s\" is ignored by the validation engine. It is either not part of the JSON Schema %s Specification or is used in conjunction with \"$ref\".";
    private static final String UNSUPPORTED_KEYWORD = "The keyword \"%s\" is not supported by the validation engine.";
    private final Set<String> referredSchemas = new HashSet<String>();
    private final SpecificationVersion schemaVersion;
    private static final Set<String> UNRECOGNIZED_SCHEMA_KEYWORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("$schema", "definitions", "$comment", "default", "examples", "$defs", "$vocabulary", "$dynamicAnchor", "$dynamicRef", "$recursiveAnchor", "$recursiveRef", "contentEncoding", "contentMediaType", "contentSchema")));

    public JSONSchemaWarningsGenerator(JSONObject schemaJson, SchemaClient httpClient, String systemId) {
        this.schemaJson = schemaJson;
        this.httpClient = httpClient;
        this.systemId = systemId;
        String metaSchemaUrl = schemaJson.optString("$schema") != null ? schemaJson.optString("$schema") : "";
        this.schemaVersion = SpecificationVersion.lookupByMetaSchemaUrl(metaSchemaUrl).orElse(SpecificationVersion.DRAFT_4);
    }

    public List<ValidationException> getUnprocessedPropsWarnings(Schema jsonSchema) {
        ArrayList<ValidationException> warningsList = new ArrayList<ValidationException>();
        Map<String, Object> unprocessedProperties = jsonSchema.getUnprocessedProperties();
        if (unprocessedProperties != null && !unprocessedProperties.isEmpty()) {
            for (String up : unprocessedProperties.keySet()) {
                String message = JSONSchemaWarningsGenerator.isUnrecognizedSchemaKeyword(up) ? this.checkSchemaCompatibility(up, this.schemaVersion) : this.getIgnoredKeywordMessage(this.schemaVersion, up);
                if (message == null) continue;
                warningsList.add(JSONValidationUtil.createJsonSchemaException(jsonSchema.getLocation().toString() + "/" + up, message, false, this.systemId, this.httpClient, this.schemaJson));
            }
        }
        if (jsonSchema instanceof ObjectSchema) {
            this.inspectObjectSchema((ObjectSchema)jsonSchema, warningsList);
        } else if (jsonSchema instanceof ArraySchema) {
            this.inspectArraySchema((ArraySchema)jsonSchema, warningsList);
        } else if (jsonSchema instanceof CombinedSchema) {
            this.inspectCombinedSchema((CombinedSchema)jsonSchema, warningsList);
        } else if (jsonSchema instanceof ReferenceSchema) {
            this.inspectReferenceSchema((ReferenceSchema)jsonSchema, warningsList);
        }
        return warningsList;
    }

    private String getIgnoredKeywordMessage(SpecificationVersion version, String up) {
        if (version.isAtLeast(SpecificationVersion.DRAFT_2019_09)) {
            return String.format(IGNORED_KEYWORD, up, version.toString().replace("Draft ", ""));
        }
        return String.format(IGNORED_KEYWORD_NO_SPEC, up, version.toString());
    }

    private String checkSchemaCompatibility(String up, SpecificationVersion version) {
        String warningMessage = null;
        if ("definitions".equals(up) && version.isAtLeast(SpecificationVersion.DRAFT_2019_09)) {
            warningMessage = "This keyword is deprecated. Use \"$defs\" instead.";
        } else if ("$dynamicRef".equals(up) && version.isAtLeast(SpecificationVersion.DRAFT_2020_12)) {
            warningMessage = "The keywords \"$ref\" and \"$dynamicRef\" cannot be used together. Only \"$ref\" will be processed.";
        } else if ("dependencies".equals(up) && version.isAtLeast(SpecificationVersion.DRAFT_2019_09)) {
            warningMessage = "This keyword is deprecated. Use \"dependentRequired\" and \"dependentSchemas\" instead.";
        } else if (version.isAtMost(SpecificationVersion.DRAFT_7) && ("$defs".equals(up) || "$vocabulary".equals(up)) || version == SpecificationVersion.DRAFT_4 && "examples".equals(up) || version.isAtMost(SpecificationVersion.DRAFT_6) && "$comment".equals(up)) {
            warningMessage = String.format(IGNORED_KEYWORD, up, version.toString());
        } else if (version.isAtLeast(SpecificationVersion.DRAFT_2019_09) && ("$recursiveRef".equals(up) || "$recursiveAnchor".equals(up)) || version.isAtLeast(SpecificationVersion.DRAFT_2020_12) && "$dynamicAnchor".equals(up)) {
            warningMessage = String.format(UNSUPPORTED_KEYWORD, up);
        }
        return warningMessage;
    }

    private void inspectObjectSchema(ObjectSchema objectSchema, List<ValidationException> warningsList) {
        if (objectSchema.getPropertyNameSchema() != null) {
            this.addWarnings(warningsList, objectSchema.getPropertyNameSchema());
        }
        if (objectSchema.getPropertySchemas() != null) {
            objectSchema.getPropertySchemas().entrySet().forEach(property -> this.addWarnings(warningsList, (Schema)property.getValue()));
        }
        if (objectSchema.getSchemaOfAdditionalProperties() != null) {
            this.addWarnings(warningsList, objectSchema.getSchemaOfAdditionalProperties());
        }
    }

    private void inspectArraySchema(ArraySchema arraySchema, List<ValidationException> warningsList) {
        if (arraySchema.getAllItemSchema() != null) {
            this.addWarnings(warningsList, arraySchema.getAllItemSchema());
        }
        if (arraySchema.getItemSchemas() != null) {
            arraySchema.getItemSchemas().forEach(itemSchema -> this.addWarnings(warningsList, (Schema)itemSchema));
        }
        if (arraySchema.getSchemaOfAdditionalItems() != null) {
            this.addWarnings(warningsList, arraySchema.getSchemaOfAdditionalItems());
        }
    }

    private void inspectCombinedSchema(CombinedSchema combinedSchema, List<ValidationException> warningsList) {
        if (combinedSchema.getSubschemas() != null) {
            combinedSchema.getSubschemas().forEach(subschema -> this.addWarnings(warningsList, (Schema)subschema));
        }
    }

    private void inspectReferenceSchema(ReferenceSchema referenceSchema, List<ValidationException> warningsList) {
        Schema referredSchema = referenceSchema.getReferredSchema();
        String schemaLocation = referredSchema.getSchemaLocation();
        if (!"#".equals(schemaLocation) && this.referredSchemas.add(schemaLocation)) {
            this.addWarnings(warningsList, referredSchema);
        }
    }

    private void addWarnings(List<ValidationException> warningsList, Schema jsonSchema) {
        warningsList.addAll(this.getUnprocessedPropsWarnings(jsonSchema));
    }

    private static boolean isUnrecognizedSchemaKeyword(String propertyName) {
        return UNRECOGNIZED_SCHEMA_KEYWORDS.contains(propertyName);
    }
}

