/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.everit.json.schema.Schema;
import org.everit.json.schema.Visitor;
import org.everit.json.schema.regexp.Regexp;

public class ConditionalSchema
extends Schema {
    private final Schema ifSchema;
    private final Schema thenSchema;
    private final Schema elseSchema;

    public static Builder builder() {
        return new Builder();
    }

    public ConditionalSchema(Builder builder) {
        super(builder);
        this.ifSchema = builder.ifSchema;
        this.thenSchema = builder.thenSchema;
        this.elseSchema = builder.elseSchema;
    }

    public Optional<Schema> getIfSchema() {
        return Optional.ofNullable(this.ifSchema);
    }

    public Optional<Schema> getThenSchema() {
        return Optional.ofNullable(this.thenSchema);
    }

    public Optional<Schema> getElseSchema() {
        return Optional.ofNullable(this.elseSchema);
    }

    @Override
    void accept(Visitor visitor) {
        visitor.visitConditionalSchema(this);
    }

    @Override
    public boolean definesProperty(String name) {
        boolean ifDefines = this.ifSchema != null && this.ifSchema.definesProperty(name);
        boolean thenDefines = this.thenSchema != null && this.thenSchema.definesProperty(name);
        boolean elseDefines = this.elseSchema != null && this.elseSchema.definesProperty(name);
        return ifDefines || thenDefines || elseDefines;
    }

    @Override
    Set<Regexp> getNestedPatterns() {
        Set ifProperties = this.ifSchema != null ? this.ifSchema.getNestedPatterns() : Collections.emptySet();
        Set thenProperties = this.thenSchema != null ? this.thenSchema.getNestedPatterns() : Collections.emptySet();
        Set elseProperties = this.elseSchema != null ? this.elseSchema.getNestedPatterns() : Collections.emptySet();
        return Stream.of(ifProperties, thenProperties, elseProperties).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    List<Schema> getNestedItemSchemas() {
        List elseItemSchemas;
        List<Schema> ifItemSchemas = this.ifSchema != null ? this.ifSchema.getNestedItemSchemas() : Collections.emptyList();
        List<Schema> thenItemSchemas = this.thenSchema != null ? this.thenSchema.getNestedItemSchemas() : Collections.emptyList();
        List<Object> list = elseItemSchemas = this.elseSchema != null ? this.elseSchema.getNestedItemSchemas() : Collections.emptyList();
        if (ifItemSchemas.size() > thenItemSchemas.size()) {
            return ifItemSchemas.size() > elseItemSchemas.size() ? ifItemSchemas : elseItemSchemas;
        }
        return thenItemSchemas.size() > elseItemSchemas.size() ? thenItemSchemas : elseItemSchemas;
    }

    public static class Builder
    extends Schema.Builder<ConditionalSchema> {
        private Schema ifSchema;
        private Schema thenSchema;
        private Schema elseSchema;

        public Builder ifSchema(Schema ifSchema) {
            this.ifSchema = ifSchema;
            return this;
        }

        public Builder thenSchema(Schema thenSchema) {
            this.thenSchema = thenSchema;
            return this;
        }

        public Builder elseSchema(Schema elseSchema) {
            this.elseSchema = elseSchema;
            return this;
        }

        @Override
        public ConditionalSchema build() {
            return new ConditionalSchema(this);
        }
    }
}

