/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.net.protocol;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.io.ProtocolUtil;
import ro.sync.exml.plugin.Plugin;
import ro.sync.exml.plugin.PluginDescriptor;
import ro.sync.exml.plugin.PluginExtension;
import ro.sync.exml.plugin.PluginManager;
import ro.sync.exml.plugin.urlstreamhandler.URLStreamHandlerPluginExtension;
import ro.sync.net.protocol.c.c;
import ro.sync.net.protocol.convert.k;
import ro.sync.net.protocol.d.b;
import ro.sync.net.protocol.file.Handler;
import ro.sync.net.protocol.sftp.e;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PUBLIC)
public class OxygenURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static final Logger b = LoggerFactory.getLogger((String)OxygenURLStreamHandlerFactory.class.getName());
    private URLStreamHandlerFactory c;

    public OxygenURLStreamHandlerFactory() {
    }

    public OxygenURLStreamHandlerFactory(URLStreamHandlerFactory uRLStreamHandlerFactory) {
        this.c = uRLStreamHandlerFactory;
    }

    public static Set<String> getBuiltinProtocols() {
        return ProtocolUtil.BUILT_IN_PROTOCOLS;
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String string) {
        URLStreamHandler uRLStreamHandler = null;
        switch (string) {
            case "file": {
                uRLStreamHandler = new Handler();
                break;
            }
            case "http": {
                uRLStreamHandler = new ro.sync.net.protocol.http.Handler();
                break;
            }
            case "sftp": {
                uRLStreamHandler = new e();
                break;
            }
            case "ftp": {
                uRLStreamHandler = new ro.sync.net.protocol.ftp.Handler();
                break;
            }
            case "https": {
                uRLStreamHandler = new ro.sync.net.protocol.https.b();
                break;
            }
            case "svn": 
            case "svn+ssh": {
                uRLStreamHandler = new URLStreamHandler(){

                    @Override
                    protected URLConnection openConnection(URL uRL) throws IOException {
                        throw new IOException("Unsupported read/write operations over svn protocols");
                    }
                };
                break;
            }
            case "zip": {
                uRLStreamHandler = new ro.sync.net.protocol.zip.b();
                break;
            }
            case "oxygen": {
                uRLStreamHandler = new ro.sync.net.protocol.e.b();
                break;
            }
            case "data": {
                uRLStreamHandler = new b();
                break;
            }
            case "spo": {
                uRLStreamHandler = new c();
                break;
            }
            case "convert": {
                if (!Boolean.parseBoolean(System.getProperty("com.oxygenxml.enable.convert.url.protocol"))) break;
                uRLStreamHandler = new k();
                break;
            }
            default: {
                if ("jrt".equals(string) || PluginManager.pluginsUpdateInProgress()) break;
                List<Plugin> list = PluginManager.getInstance().getPlugins();
                for (Plugin plugin : list) {
                    PluginDescriptor pluginDescriptor = plugin.getDescriptor();
                    List<PluginDescriptor.PluginExtensionDescription> list2 = pluginDescriptor.getExtensions("URLHandler");
                    if (list2.isEmpty()) {
                        list2 = pluginDescriptor.getExtensions("URLStreamHandler");
                    }
                    for (int i2 = 0; i2 < list2.size(); ++i2) {
                        URLStreamHandlerPluginExtension uRLStreamHandlerPluginExtension;
                        URLStreamHandler uRLStreamHandler2;
                        PluginExtension pluginExtension = list2.get((int)i2).k;
                        if (!(pluginExtension instanceof URLStreamHandlerPluginExtension) || (uRLStreamHandler2 = (uRLStreamHandlerPluginExtension = (URLStreamHandlerPluginExtension)pluginExtension).getURLStreamHandler(string)) == null) continue;
                        return uRLStreamHandler2;
                    }
                }
            }
        }
        b.debug("Returning {} for: {}", (Object)uRLStreamHandler, (Object)string);
        if (uRLStreamHandler == null && this.c != null) {
            uRLStreamHandler = this.c.createURLStreamHandler(string);
        }
        return uRLStreamHandler;
    }
}

