/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.fsv.sharepoint.webservice.lists;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.fsv.sharepoint.browser.b.q;
import ro.sync.fsv.sharepoint.browser.b.r;
import ro.sync.fsv.sharepoint.webservice.lists.ListFieldProperty;

@XmlAccessorType(value=XmlAccessType.FIELD)
@SkipObfuscate(fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE, classes=SkipLevel.PRIVATE)
@XmlRootElement(name="Field", namespace="http://schemas.microsoft.com/sharepoint/soap/")
public class ListField
implements r,
Comparable<ListField> {
    private static final Map<q, String> COLUMN_ID_2_FIELD_ID = new ImmutableMap.Builder().put((Object)q.h, (Object)"LinkFilename").put((Object)q.i, (Object)"DocIcon").put((Object)q.c, (Object)"FileSizeDisplay").put((Object)q.g, (Object)"FolderChildCount").put((Object)q.e, (Object)"ItemChildCount").put((Object)q.f, (Object)"_UIVersionString").put((Object)q.b, (Object)"_CheckinComment").build();
    private static final Logger logger = LoggerFactory.getLogger((String)ListField.class.getName());
    @XmlAttribute(name="Name", namespace="")
    private final String name;
    @XmlAttribute(name="DisplayName", namespace="")
    private final String displayName;
    @XmlAttribute(name="ID", namespace="")
    private final String id;
    @XmlAnyAttribute
    private final Map<QName, String> properties = new HashMap<QName, String>();
    @XmlElementWrapper(name="CHOICES", namespace="http://schemas.microsoft.com/sharepoint/soap/")
    @XmlElement(name="CHOICE", namespace="http://schemas.microsoft.com/sharepoint/soap/")
    private final List<FieldChoice> choices = null;
    @XmlElement(name="Default", namespace="http://schemas.microsoft.com/sharepoint/soap/")
    private final String defaultChoice;

    public ListField() {
        this.name = null;
        this.displayName = null;
        this.id = null;
        this.defaultChoice = null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ListField [internalName=");
        stringBuilder.append(this.name);
        stringBuilder.append(", displayName=");
        stringBuilder.append(this.displayName);
        stringBuilder.append(", id=");
        stringBuilder.append(this.id);
        stringBuilder.append(", properties=");
        stringBuilder.append(this.properties);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(ListField listField) {
        if (this.name == listField.name) {
            return 0;
        }
        if (listField.name == null) {
            return 1;
        }
        return this.name.compareTo(listField.name);
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        n3 = 31 * n3 + (this.name == null ? 0 : this.name.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ListField listField = (ListField)object;
        if (this.id == null ? listField.id != null : !this.id.equals(listField.id)) {
            return false;
        }
        return !(this.name == null ? listField.name != null : !this.name.equals(listField.name));
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public boolean matches(q q3) {
        boolean bl = Optional.ofNullable(q3).map(q2 -> COLUMN_ID_2_FIELD_ID.get(q2)).filter(string -> string.equals(this.getName())).isPresent();
        return bl;
    }

    public String getId() {
        return this.id;
    }

    public Map<QName, String> getProperties() {
        return this.properties;
    }

    public List<FieldChoice> getChoices() {
        return this.choices;
    }

    public String getDefaultChoice() {
        return this.defaultChoice;
    }

    public boolean hasChoices() {
        return this.choices != null && this.choices.size() > 0;
    }

    public String getChoiceValue(String string) {
        String string2 = string;
        if (string != null && this.choices != null) {
            for (FieldChoice fieldChoice : this.choices) {
                if (!string.equals(fieldChoice.id)) continue;
                string2 = fieldChoice.value;
                break;
            }
        }
        return string2;
    }

    public String getProperty(ListFieldProperty listFieldProperty) {
        return this.properties.get(listFieldProperty.qname);
    }

    public void dumpProperties() {
        logger.info(" ---------- Properties of field: " + this.getDisplayName() + " ---------- ");
        if (this.properties == null) {
            logger.info(" NULL");
        } else {
            Set<QName> set = this.properties.keySet();
            for (QName qName : set) {
                logger.info(" ++++++++++ " + qName + " --> '" + this.properties.get(qName) + "'");
            }
        }
        logger.info(" ********** CHOICES: " + this.choices);
        logger.info(" ********** Def. Choice: " + this.defaultChoice);
        logger.info(" ---------- End of properties ----------");
    }

    @Override
    public boolean isFilterable() {
        return !"FALSE".equalsIgnoreCase(this.getProperty(ListFieldProperty.FILTERABLE));
    }

    @Override
    public boolean hasDateType() {
        return "DateTime".equalsIgnoreCase(this.getProperty(ListFieldProperty.TYPE));
    }

    @Override
    public boolean isSortable() {
        return !"FALSE".equalsIgnoreCase(this.getProperty(ListFieldProperty.SORTABLE));
    }

    @SkipObfuscate
    @XmlJavaTypeAdapter(value=ChoiceAdapter.class)
    public static class FieldChoice {
        public String id;
        public String value;

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("FieldChoice [id=");
            stringBuilder.append(this.id);
            stringBuilder.append(", value=");
            stringBuilder.append(this.value);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    @SkipObfuscate
    public static class ChoiceAdapter
    extends XmlAdapter<String, FieldChoice> {
        public FieldChoice unmarshal(String string) throws Exception {
            FieldChoice fieldChoice = null;
            if (string != null) {
                fieldChoice = new FieldChoice();
                int n2 = string.indexOf(";#");
                if (n2 != -1) {
                    fieldChoice.id = string.substring(0, n2);
                    fieldChoice.value = string.substring(n2 + ";#".length());
                } else {
                    fieldChoice.value = string;
                }
            }
            return fieldChoice;
        }

        public String marshal(FieldChoice fieldChoice) throws Exception {
            Object object = null;
            if (fieldChoice != null) {
                object = fieldChoice.id != null ? fieldChoice.id + ";#" + fieldChoice.value : fieldChoice.value;
            }
            return object;
        }
    }
}

