/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.fsv.sharepoint.api.rest;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.fsv.sharepoint.api.entity.b;
import ro.sync.fsv.sharepoint.api.rest.SPItemContentType;
import ro.sync.fsv.sharepoint.api.rest.SpListItemParentRef;

@SkipObfuscate
@JsonIgnoreProperties(ignoreUnknown=true)
public class SpListItem
implements b {
    private static final String CT_NAME = "name";
    private String id;
    @JsonProperty(value="webUrl")
    private String url;
    @JsonIgnore
    private SPItemContentType contentType;
    @JsonProperty(value="parentReference")
    private SpListItemParentRef parentRef;
    private Map<String, Object> fields;

    public SPItemContentType getContentTypeName() {
        return this.contentType;
    }

    @JsonProperty(value="contentType")
    public void setContentType(Map<String, String> map2) {
        this.contentType = Optional.ofNullable(map2).map(map -> (String)map.get(CT_NAME)).map(SPItemContentType::get).orElse(SPItemContentType.DOCUMENT);
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }

    public String toString() {
        return "SpListItem [id=" + this.id + ", webUrl=" + this.url + ", contentType =" + this.contentType + ", fields=\n    " + this.fields.entrySet().stream().map(String::valueOf).collect(Collectors.joining("\n    ")) + "]\n";
    }

    @Override
    public String getProperty(String string) {
        Object object = this.fields.get(string);
        if (object != null) {
            return String.valueOf(object);
        }
        return null;
    }

    @Override
    public String getPath() {
        return null;
    }

    @Override
    public boolean isFolder() {
        return this.contentType == SPItemContentType.FOLDER;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getCheckOutUser() {
        return this.getProperty("CheckoutUserLookupId");
    }

    @Override
    public String getName() {
        return this.getProperty("FileLeafRef");
    }

    public SpListItemParentRef getParentRef() {
        return this.parentRef;
    }
}

