/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.xproc.transform;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.dt.PersistentObjectField;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.editor.xproc.transform.XProcParameterImpl;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;
import ro.sync.xml.transformer.xproc.api.XProcParameter;
import ro.sync.xml.transformer.xproc.api.XProcParametersPort;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class XProcParametersPortImpl
implements XProcParametersPort,
PersistentObject {
    private static final Logger logger = LoggerFactory.getLogger((String)XProcParametersPortImpl.class.getName());
    @PersistentObjectField(hasEditorVariables=false)
    private String portName;
    private XProcParameterImpl[] parameters;

    public XProcParametersPortImpl() {
        this.portName = "";
        this.parameters = new XProcParameterImpl[0];
    }

    public XProcParametersPortImpl(XProcParametersPort xProcParametersPort) {
        this.portName = xProcParametersPort.getPortName();
        this.parameters = new XProcParameterImpl[xProcParametersPort.getParameters().length];
        for (int i2 = 0; i2 < this.parameters.length; ++i2) {
            this.parameters[i2] = new XProcParameterImpl(xProcParametersPort.getParameters()[i2]);
        }
    }

    @Override
    public XProcParameter[] getParameters() {
        return this.parameters;
    }

    public void setParameters(XProcParameter[] xProcParameterArray) {
        this.parameters = new XProcParameterImpl[xProcParameterArray.length];
        for (int i2 = 0; i2 < xProcParameterArray.length; ++i2) {
            this.parameters[i2] = new XProcParameterImpl(xProcParameterArray[i2]);
        }
    }

    @Override
    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String string) {
        this.portName = string;
    }

    @Override
    public Object clone() {
        XProcParametersPortImpl xProcParametersPortImpl = null;
        try {
            xProcParametersPortImpl = (XProcParametersPortImpl)super.clone();
            if (this.parameters != null && this.parameters.length > 0) {
                xProcParametersPortImpl.parameters = new XProcParameterImpl[this.parameters.length];
                for (int i2 = 0; i2 < this.parameters.length; ++i2) {
                    if (this.parameters[i2] == null) continue;
                    xProcParametersPortImpl.parameters[i2] = (XProcParameterImpl)this.parameters[i2].clone();
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
        }
        return xProcParametersPortImpl;
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.portName == null || "".equals(this.portName.trim())) {
            throw new InvalidPersistentObjException("The name of this parameter port is not specified !");
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }
}

