/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.xmleditor.transform.advanced;

import java.net.MalformedURLException;
import java.net.URL;
import ro.sync.annotations.dt.PersistentObjectField;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.Equaler;
import ro.sync.exml.editor.xmleditor.transform.advanced.AdvancedTransformerOptionsBase;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.util.editorvars.EditorVariables;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class SaxonHEAdvancedOptions
extends AdvancedTransformerOptionsBase {
    @PersistentObjectField(hasEditorVariables=false)
    private String stripWS;
    private boolean optimizationEnabled = true;
    private boolean useConfigFile;
    @PersistentObjectField(hasEditorVariables=true)
    private String configSystemID;
    @PersistentObjectField(hasEditorVariables=false)
    private String initializer;
    @PersistentObjectField(hasEditorVariables=true)
    private String profilingOutputFile;
    private boolean isProfilingEnabled;

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.stripWS == null) {
            throw new InvalidPersistentObjException("Strip whitespaces setting for the Saxon transformer cannot be null.");
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof SaxonHEAdvancedOptions) {
            SaxonHEAdvancedOptions saxonHEAdvancedOptions = (SaxonHEAdvancedOptions)object;
            return this.useConfigFile == saxonHEAdvancedOptions.useConfigFile && this.optimizationEnabled == saxonHEAdvancedOptions.isOptimizationEnabled() && Equaler.verifyEquals((Object)this.configSystemID, (Object)saxonHEAdvancedOptions.getConfigSystemID()) && this.stripWS.equals(saxonHEAdvancedOptions.stripWS);
        }
        return false;
    }

    public int hashCode() {
        int n2 = Boolean.valueOf(this.useConfigFile).hashCode() + Boolean.valueOf(this.optimizationEnabled).hashCode();
        if (this.stripWS != null) {
            n2 += this.stripWS.hashCode();
        }
        if (this.configSystemID != null) {
            n2 += this.configSystemID.hashCode();
        }
        return n2;
    }

    public void setStripWS(String string) {
        this.stripWS = string;
    }

    public String getStripWS() {
        return this.stripWS;
    }

    public void setOptimization(boolean bl) {
        this.optimizationEnabled = bl;
    }

    public boolean isOptimizationEnabled() {
        return this.optimizationEnabled;
    }

    public boolean isUseConfigFile() {
        return this.useConfigFile;
    }

    public void setUseConfigFile(boolean bl) {
        this.useConfigFile = bl;
    }

    public String getConfigSystemID() {
        return this.configSystemID;
    }

    public void setConfigSystemID(String string) {
        this.configSystemID = string;
    }

    public void setInitializer(String string) {
        this.initializer = string;
    }

    public String getInitializer() {
        return this.initializer;
    }

    public String getCommandLineOptions(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.useConfigFile) {
            String string2 = EditorVariables.expandEditorVariables(this.configSystemID, string);
            try {
                new URL(string2);
                stringBuilder.append(" -config:").append(string2);
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            String string3 = "none";
            if (this.stripWS.equals("saxon.strip.ws.all")) {
                string3 = "all";
            } else if (this.stripWS.equals("saxon.strip.ws.ignorable")) {
                string3 = "ignorable";
            }
            stringBuilder.append(" -strip:").append(string3);
            stringBuilder.append(" -opt:").append(this.optimizationEnabled ? "10" : "0");
            if (this.isProfilingEnabled && this.profilingOutputFile != null) {
                String string4 = EditorVariables.expandEditorVariablesAsFilePath(this.profilingOutputFile, string);
                stringBuilder.append("-TP:").append(string4);
            }
        }
        if (this.initializer != null) {
            stringBuilder.append(" -init:").append(this.initializer);
        }
        return stringBuilder.toString();
    }

    public boolean isProfilingEnabled() {
        return this.isProfilingEnabled;
    }

    public String getProfilingOutputFile() {
        return this.profilingOutputFile;
    }

    public void setProfilingEnabled(boolean bl) {
        this.isProfilingEnabled = bl;
    }

    public void setProfilingOutputFile(String string) {
        this.profilingOutputFile = string;
    }

    public String getErrorRecoverPolicy() {
        return "saxon.recover.with.warning";
    }
}

