/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.persistance;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.dt.PersistentObjectField;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.util.URLUtil;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class CSSDescriptorPO
implements PersistentObject {
    private static final Logger logger = LoggerFactory.getLogger((String)CSSDescriptorPO.class.getName());
    @PersistentObjectField(hasEditorVariables=true, isIDTypeVariables=true)
    private String href;
    @PersistentObjectField(hasEditorVariables=false)
    private String title;
    private boolean alternate;
    private transient byte origin = 0;

    public CSSDescriptorPO(String string, String string2, boolean bl, byte by) {
        this.href = string;
        this.title = string2;
        this.alternate = bl;
        this.origin = by;
    }

    public CSSDescriptorPO() {
    }

    public String getHref() {
        return this.href;
    }

    public String getTitle() {
        if (this.title == null || this.title.length() == 0) {
            return null;
        }
        return this.title;
    }

    public boolean isAlternate() {
        return this.alternate;
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.href == null || this.href.trim().length() == 0) {
            throw new InvalidPersistentObjException("Null CSS url.");
        }
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
            return null;
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof CSSDescriptorPO) {
            CSSDescriptorPO cSSDescriptorPO = (CSSDescriptorPO)object;
            bl = this.alternate == cSSDescriptorPO.alternate && Equaler.verifyEquals((Object)this.title, (Object)cSSDescriptorPO.title) && Equaler.verifyEquals((Object)this.href, (Object)cSSDescriptorPO.href);
        }
        return bl;
    }

    public int hashCode() {
        int n2 = Boolean.valueOf(this.alternate).hashCode();
        if (this.title != null) {
            n2 += this.title.hashCode();
        }
        if (this.href != null) {
            n2 += this.href.hashCode();
        }
        return n2;
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return new String[]{"origin"};
    }

    public String toString() {
        return "href: " + URLUtil.filterPasswords((String)this.href) + ", title: " + this.title + ", alternate: " + this.alternate;
    }

    public byte getOrigin() {
        return this.origin;
    }

    public void setAlternate(boolean bl) {
        this.alternate = bl;
    }
}

