/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.xsd;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.schematron.SchematronNodeRendererCustomizer;
import ro.sync.exml.workspace.api.node.customizer.BasicRenderingInformation;
import ro.sync.exml.workspace.api.node.customizer.NodeRendererCustomizerContext;
import ro.sync.exml.workspace.api.node.customizer.XMLNodeRendererCustomizer;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class XSDNodeRendererCustomizer
extends XMLNodeRendererCustomizer {
    private static final Logger mpy = LoggerFactory.getLogger((String)XSDNodeRendererCustomizer.class.getName());
    private final SchematronNodeRendererCustomizer npy = new SchematronNodeRendererCustomizer();
    private static final Map<String, String> opy = new HashMap<String, String>();

    private static String zwp(String string) {
        URL uRL = XSDNodeRendererCustomizer.class.getResource(string);
        if (uRL != null) {
            return uRL.toExternalForm();
        }
        mpy.error(XSDNodeRendererCustomizer.class.getName() + " - Image not found: " + string);
        return null;
    }

    @Override
    public BasicRenderingInformation getRenderingInformation(NodeRendererCustomizerContext nodeRendererCustomizerContext) {
        BasicRenderingInformation basicRenderingInformation = new BasicRenderingInformation();
        String string = nodeRendererCustomizerContext.getNodeName();
        if (string != null) {
            String string2 = nodeRendererCustomizerContext.getNodeNamespace();
            String string3 = null;
            if ("http://www.w3.org/2001/XMLSchema".equals(string2)) {
                String string4 = string.indexOf(":") != -1 ? string.substring(string.indexOf(":") + 1) : string;
                string3 = opy.get(string4);
                basicRenderingInformation.setIconPath(string3);
            } else if ("http://www.ascc.net/xml/schematron".equals(string2) || "http://purl.oclc.org/dsdl/schematron".equals(string2)) {
                return this.npy.getRenderingInformation(nodeRendererCustomizerContext);
            }
        }
        return basicRenderingInformation;
    }

    @Override
    public String getDescription() {
        return "XML Schema Node Renderer Customizer";
    }

    static {
        opy.put("assert", XSDNodeRendererCustomizer.zwp("/images/node-customizer/Assert16.png"));
        opy.put("alternative", XSDNodeRendererCustomizer.zwp("/images/node-customizer/Alternative16.png"));
        opy.put("attribute", XSDNodeRendererCustomizer.zwp("/images/node-customizer/AttributeDeclaration16.png"));
        opy.put("attributeGroup", XSDNodeRendererCustomizer.zwp("/images/node-customizer/AttributeGroup16.png"));
        opy.put("element", XSDNodeRendererCustomizer.zwp("/images/node-customizer/ElementDeclaration16.gif"));
        opy.put("group", XSDNodeRendererCustomizer.zwp("/images/node-customizer/ModelGroup16.png"));
        opy.put("notation", XSDNodeRendererCustomizer.zwp("/images/node-customizer/Notation16.png"));
        opy.put("complexType", XSDNodeRendererCustomizer.zwp("/images/node-customizer/ComplexType16.png"));
        opy.put("simpleType", XSDNodeRendererCustomizer.zwp("/images/node-customizer/SimpleType16.png"));
        opy.put("import", XSDNodeRendererCustomizer.zwp("/images/node-customizer/Import16.png"));
        opy.put("include", XSDNodeRendererCustomizer.zwp("/images/node-customizer/Include16.png"));
        opy.put("redefine", XSDNodeRendererCustomizer.zwp("/images/node-customizer/Redefine16.png"));
        opy.put("all", XSDNodeRendererCustomizer.zwp("/images/node-customizer/ElementAll16.png"));
        opy.put("choice", XSDNodeRendererCustomizer.zwp("/images/node-customizer/ElementChoice16.png"));
        opy.put("sequence", XSDNodeRendererCustomizer.zwp("/images/node-customizer/ElementSequence16.png"));
        opy.put("schema", XSDNodeRendererCustomizer.zwp("/images/node-customizer/ElementSchema16.png"));
        opy.put("openContent", XSDNodeRendererCustomizer.zwp("/images/node-customizer/ElementOpenContent16.png"));
        opy.put("defaultOpenContent", XSDNodeRendererCustomizer.zwp("/images/node-customizer/ElementOpenContent16.png"));
        opy.put("override", XSDNodeRendererCustomizer.zwp("/images/node-customizer/ElementOverride16.png"));
    }
}

