/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.ui.EclipseHelpUtils;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class ECTableSplitCustomizerDialog
extends TrayDialog {
    private AuthorResourceBundle authorResourceBundle;
    private Spinner rowsSpinner;
    private Spinner columnsSpinner;
    private int chosenColumns = 0;
    private int chosenRows = 0;
    private int maxColumns;
    private int maxRows;
    private String helpPageID;

    public ECTableSplitCustomizerDialog(Object object, AuthorResourceBundle authorResourceBundle, int n2, int n3, String string) {
        super((Shell)object);
        this.authorResourceBundle = authorResourceBundle;
        this.maxColumns = n2;
        this.maxRows = n3;
        this.helpPageID = string;
        int n4 = 2144;
        n4 |= 0x10;
        this.setShellStyle(n4 |= 0x10000);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        EclipseHelpUtils.installHelp(shell, this.helpPageID);
        shell.setText(this.authorResourceBundle.getMessage("Split_cells"));
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 16384);
        label.setText(this.authorResourceBundle.getMessage("Number_of_columns") + ":");
        this.columnsSpinner = new Spinner(composite2, 2048);
        this.columnsSpinner.setMinimum(1);
        this.columnsSpinner.setMaximum(this.maxColumns);
        this.chosenColumns = this.maxColumns > 1 ? 2 : 1;
        this.columnsSpinner.setSelection(this.chosenColumns);
        this.columnsSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ECTableSplitCustomizerDialog.this.chosenColumns = ECTableSplitCustomizerDialog.this.columnsSpinner.getSelection();
            }
        });
        GridData gridData = new GridData(4, 0, true, false);
        this.columnsSpinner.setLayoutData((Object)gridData);
        Label label2 = new Label(composite2, 16384);
        label2.setText(this.authorResourceBundle.getMessage("Number_of_rows") + ":");
        this.rowsSpinner = new Spinner(composite2, 2048);
        this.rowsSpinner.setMinimum(1);
        this.rowsSpinner.setMaximum(this.maxRows);
        this.chosenRows = 1;
        this.rowsSpinner.setSelection(this.chosenRows);
        this.rowsSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ECTableSplitCustomizerDialog.this.chosenRows = ECTableSplitCustomizerDialog.this.rowsSpinner.getSelection();
            }
        });
        gridData = new GridData(4, 0, true, false);
        this.rowsSpinner.setLayoutData((Object)gridData);
        return composite2;
    }

    public int[] getSplitInformation() {
        int[] nArray = null;
        if (this.open() == 0) {
            nArray = new int[]{this.chosenColumns, this.chosenRows};
        }
        return nArray;
    }
}

