/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.sort;

import java.util.List;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.SelectionInterpretationMode;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.node.AuthorElement;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public final class TableSortUtil {
    private TableSortUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static boolean isEntirelySelected(AuthorAccess authorAccess, AuthorElement authorElement) {
        boolean bl = false;
        AuthorEditorAccess authorEditorAccess = authorAccess.getEditorAccess();
        if (authorEditorAccess.getAuthorSelectionModel().hasSelection()) {
            SelectionInterpretationMode selectionInterpretationMode = authorEditorAccess.getAuthorSelectionModel().getSelectionInterpretationMode();
            if (selectionInterpretationMode == SelectionInterpretationMode.TABLE) {
                bl = true;
            } else if (selectionInterpretationMode == SelectionInterpretationMode.TABLE_COLUMN) {
                bl = TableSortUtil.isIncludedInSelectionInterval(authorAccess, authorElement);
            }
        }
        return bl;
    }

    public static boolean isIncludedInSelectionInterval(AuthorAccess authorAccess, AuthorElement authorElement) {
        List<ContentInterval> list = authorAccess.getEditorAccess().getAuthorSelectionModel().getSelectionIntervals();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ContentInterval contentInterval = list.get(i2);
            if (contentInterval.getStartOffset() > authorElement.getStartOffset() || contentInterval.getEndOffset() < authorElement.getEndOffset()) continue;
            return true;
        }
        return false;
    }

    public static boolean isColumnOrTableSelection(AuthorAccess authorAccess) {
        SelectionInterpretationMode selectionInterpretationMode = authorAccess.getEditorAccess().getAuthorSelectionModel().getSelectionInterpretationMode();
        return selectionInterpretationMode == SelectionInterpretationMode.TABLE_COLUMN || selectionInterpretationMode == SelectionInterpretationMode.TABLE;
    }
}

