/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.common.CommonAccess;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class ToggleCommentOperation
implements AuthorOperation {
    @Override
    public String getDescription() {
        return "Wrap selection in an XML comment or unwrap existing XML comment";
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        block3: {
            int n2 = authorAccess.getEditorAccess().getSelectionStart();
            try {
                AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(n2);
                if (authorNode == null) break block3;
                int n3 = authorAccess.getEditorAccess().getSelectionEnd();
                if (CommonAccess.isToggleCommentPossibleOnSelection(authorAccess, n2, n3)) {
                    CommonAccess.toggleComment(authorAccess, authorNode, n2, n3);
                    break block3;
                }
                throw new AuthorOperationException("Toggle comment is not possible at this location.");
            }
            catch (BadLocationException badLocationException) {
                throw new AuthorOperationException("Cannot identify the current element", badLocationException);
            }
        }
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return new ArgumentDescriptor[0];
    }
}

