/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.component.AuthorSchemaAwareOptions;
import ro.sync.ecss.css.Styles;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorSelectionModel;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.access.EditingSessionContext;
import ro.sync.ecss.extensions.api.content.OffsetInformation;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResult;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;
import ro.sync.exml.options.Options;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=true)
public abstract class InsertListOperation
implements AuthorOperation {
    protected static final ArgumentDescriptor SCHEMA_AWARE_ARGUMENT_DESCRIPTOR = new ArgumentDescriptor("schemaAware", 3, "Controls if the insertion is schema aware or not. When the schema aware is enabled and the fragments insertion is not allowed, a dialog will be shown, proposing solutions, like:\n - insert the fragments inside a new element. The name of the element to wrap the fragments in is computed by analyzing the left or right siblings;\n - split an ancestor of the node at insertion offset and insert the fragments between the resulted elements;\n - insert the fragments somewhere in the proximity of the insertion offset (left or right without skipping content);\nNote: if a selection exists, the surround with fragment operation is not schema aware.\nCan be: true, false. Default value is true.", new String[]{"true", "false"}, "true");
    public static final String CONVERT_ELEMENT_AT_CARET_ARGUMENT = "convertElementAtCaret";
    private static final String ARG_VALUE_AUTO = "auto";
    protected static final ArgumentDescriptor CONVERT_ELEMENT_AT_CARET_ARGUMENT_DESCRIPTOR = new ArgumentDescriptor("convertElementAtCaret", 3, "Controls whether a new list is inserted or the element at caret is converted to list, if there is no selection in the document.\n Can be: true, false or auto.\nDefault value is auto meaning that the element at caret is converted only if the option toshow content completion when pressing Enter is disabled.", new String[]{"true", "false", "auto"}, "auto");
    public static final String LIST_TYPE_ARGUMENT = "listType";
    private static final Logger logger = LoggerFactory.getLogger((String)InsertListOperation.class.getName());
    protected AuthorAccess authorAccess;
    protected String listType;

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        this.authorAccess = authorAccess;
        Object object = argumentsMap.getArgumentValue("schemaAware");
        boolean bl = !"false".equals(object);
        this.listType = (String)argumentsMap.getArgumentValue(LIST_TYPE_ARGUMENT);
        String string = (String)argumentsMap.getArgumentValue(CONVERT_ELEMENT_AT_CARET_ARGUMENT);
        List<ContentInterval> list = this.getIntervalsToConvert(string);
        List<CommonsOperationsUtil.SelectedFragmentInfo> list2 = this.getFragmentsToConvert(authorAccess, list);
        if (list2 != null) {
            Optional<AuthorElement> optional = this.getSelectedList(list);
            Optional<Map> optional2 = optional.map(authorElement -> CommonsOperationsUtil.getAttributes(authorElement, true));
            List<Position> list3 = CommonsOperationsUtil.removeIntervals(authorAccess, list);
            Optional<Map<String, String>> optional3 = this.removeEmptyListElements(authorAccess, list3);
            if (!optional2.isPresent()) {
                optional2 = optional3;
            }
            InsertListOperation.deleteEmptyFragments(list2);
            StringBuilder stringBuilder = this.getListXMLFragment((String)argumentsMap.getArgumentValue(LIST_TYPE_ARGUMENT), optional2.orElse(Collections.emptyMap()), list2.size(), authorAccess);
            SchemaAwareHandlerResult schemaAwareHandlerResult = authorAccess.getDocumentController().insertXMLFragmentSchemaAware(stringBuilder.toString(), authorAccess.getEditorAccess().getCaretOffset(), 7, true);
            Integer n2 = (Integer)schemaAwareHandlerResult.getResult("result.id.handle.insert.fragment.offset");
            this.insertFragmentsInListAtOffset(authorAccess, list2, n2);
            CommonsOperationsUtil.removeEmptyElements(authorAccess, list3);
        } else {
            this.insertAtCaret(authorAccess, argumentsMap, bl);
        }
    }

    private Optional<Map<String, String>> removeEmptyListElements(AuthorAccess authorAccess, List<Position> list) {
        Optional<Map<String, String>> optional = Optional.empty();
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        AuthorElement authorElement = authorDocumentController.getAuthorDocumentNode().getRootElement();
        try {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                AuthorNode authorNode = authorDocumentController.getNodeAtOffset(list.get(i2).getOffset() + 1);
                while (authorNode != null && authorNode != authorElement) {
                    AuthorNode authorNode2 = authorNode.getParent();
                    if (this.isEmptyListElement(authorNode)) {
                        if (!optional.isPresent() && this.isList(authorNode)) {
                            Map<String, String> map = CommonsOperationsUtil.getAttributes(authorNode, true);
                            optional = Optional.of(map != null ? map : Collections.emptyMap());
                        }
                        authorDocumentController.deleteNode(authorNode);
                        list.remove(authorDocumentController.createPositionInContent(authorNode.getStartOffset()));
                    }
                    authorNode = authorNode2;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            logger.debug(badLocationException.getMessage(), (Throwable)badLocationException);
        }
        return optional;
    }

    private Optional<AuthorElement> getSelectedList(List<ContentInterval> list) {
        return list.stream().map(this::getSelectedList).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private Optional<AuthorElement> getSelectedList(ContentInterval contentInterval) {
        try {
            return this.authorAccess.getDocumentController().getNodesToSelect(contentInterval.getStartOffset(), contentInterval.getEndOffset()).stream().filter(this::isList).map(AuthorElement.class::cast).findFirst();
        }
        catch (BadLocationException badLocationException) {
            return Optional.empty();
        }
    }

    private void insertFragmentsInListAtOffset(AuthorAccess authorAccess, List<CommonsOperationsUtil.SelectedFragmentInfo> list, int n2) {
        try {
            AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(n2 + 1);
            this.insertContent(authorAccess, authorNode, list);
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException, (Throwable)badLocationException);
        }
    }

    private static void deleteEmptyFragments(List<CommonsOperationsUtil.SelectedFragmentInfo> list) {
        int n2 = list.size();
        Iterator<CommonsOperationsUtil.SelectedFragmentInfo> iterator = list.iterator();
        while (iterator.hasNext()) {
            CommonsOperationsUtil.SelectedFragmentInfo selectedFragmentInfo = iterator.next();
            if (!selectedFragmentInfo.getSelectedFragment().isEmpty() || n2 <= 1) continue;
            iterator.remove();
            --n2;
        }
    }

    private boolean shoudConvertElementAtCaret(String string, boolean bl) {
        boolean bl2;
        if ("true".equals(string)) {
            bl2 = true;
        } else if (ARG_VALUE_AUTO.equals(string)) {
            if (bl) {
                bl2 = true;
            } else {
                AuthorSchemaAwareOptions authorSchemaAwareOptions = (AuthorSchemaAwareOptions)Options.getInstance().getObjectProperty("author.editing.mode");
                EditingSessionContext editingSessionContext = this.authorAccess.getEditorAccess().getEditingContext();
                bl2 = !authorSchemaAwareOptions.isShowAvailableCCItemsOnEnter() || "false".equals(editingSessionContext.getAttribute("ccOnEnter"));
            }
        } else {
            bl2 = false;
        }
        return bl2;
    }

    private List<CommonsOperationsUtil.SelectedFragmentInfo> getFragmentsToConvert(AuthorAccess authorAccess, List<ContentInterval> list) throws AuthorOperationException {
        List<CommonsOperationsUtil.SelectedFragmentInfo> list2;
        block4: {
            list2 = null;
            if (!list.isEmpty()) {
                try {
                    CommonsOperationsUtil.ConversionElementHelper conversionElementHelper = this.getConversionElementsChecker();
                    list2 = CommonsOperationsUtil.getFragmentsForConversions(authorAccess, conversionElementHelper, list);
                }
                catch (BadLocationException badLocationException) {
                    logger.debug((Object)badLocationException, (Throwable)badLocationException);
                }
                catch (AuthorOperationException authorOperationException) {
                    if (!authorAccess.getEditorAccess().hasSelection()) break block4;
                    throw authorOperationException;
                }
            }
        }
        return list2;
    }

    private List<ContentInterval> getIntervalsToConvert(String string) {
        CommonsOperationsUtil.ConversionElementHelper conversionElementHelper = this.getConversionElementsChecker();
        AuthorEditorAccess authorEditorAccess = this.authorAccess.getEditorAccess();
        AuthorSelectionModel authorSelectionModel = authorEditorAccess.getAuthorSelectionModel();
        List<ContentInterval> list = Collections.emptyList();
        if (authorSelectionModel.hasSelection()) {
            list = authorSelectionModel.getSelectionIntervals().stream().map(contentInterval -> {
                int[] nArray = authorEditorAccess.getBalancedSelection(contentInterval.getStartOffset(), contentInterval.getEndOffset());
                return new ContentInterval(nArray[0], nArray[1]);
            }).collect(Collectors.toList());
        } else {
            boolean bl;
            Optional<AuthorNode> optional = this.getElementAtCaretToConvert(this.authorAccess, conversionElementHelper);
            if (optional.isPresent() && this.shoudConvertElementAtCaret(string, bl = InsertListOperation.containsOnlyStartSentinels(this.authorAccess, optional.get().getStartOffset(), authorEditorAccess.getCaretOffset()))) {
                list = Collections.singletonList(new ContentInterval(optional.get().getStartOffset(), optional.get().getEndOffset() + 1));
            }
        }
        return list;
    }

    private static boolean containsOnlyStartSentinels(AuthorAccess authorAccess, int n2, int n3) {
        boolean bl = true;
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        try {
            for (int i2 = n2; i2 < n3; ++i2) {
                OffsetInformation offsetInformation = authorDocumentController.getContentInformationAtOffset(i2);
                if (offsetInformation.getPositionType() == 1) continue;
                bl = false;
                break;
            }
        }
        catch (BadLocationException badLocationException) {
            logger.debug((Object)badLocationException, (Throwable)badLocationException);
            bl = false;
        }
        return bl;
    }

    public Optional<AuthorNode> getElementAtCaretToConvert(AuthorAccess authorAccess, CommonsOperationsUtil.ConversionElementHelper conversionElementHelper) {
        Optional<AuthorNode> optional = Optional.empty();
        int n2 = authorAccess.getEditorAccess().getCaretOffset();
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        try {
            for (AuthorNode authorNode = authorDocumentController.getNodeAtOffset(n2); authorNode != null; authorNode = authorNode.getParent()) {
                boolean bl;
                Styles styles = authorAccess.getEditorAccess().getStyles(authorNode);
                String string = styles.getDisplay();
                if (!"block".equals(string) && !"list-item".equals(string) || !(bl = InsertListOperation.canBeConverted(authorAccess, conversionElementHelper, authorNode))) continue;
                if ("list-item".equals(string)) {
                    authorNode = authorNode.getParent();
                }
                optional = Optional.of(authorNode);
                break;
            }
        }
        catch (BadLocationException badLocationException) {
            logger.debug((Object)badLocationException, (Throwable)badLocationException);
        }
        return optional;
    }

    private static boolean canBeConverted(AuthorAccess authorAccess, CommonsOperationsUtil.ConversionElementHelper conversionElementHelper, AuthorNode authorNode) {
        boolean bl = false;
        try {
            conversionElementHelper.blockContentMustBeConverted(authorNode, authorAccess);
            bl = true;
        }
        catch (AuthorOperationException authorOperationException) {
            // empty catch block
        }
        return bl;
    }

    private boolean isEmptyListElement(AuthorNode authorNode) {
        return this.isListElement(authorNode) && authorNode.getStartOffset() == authorNode.getEndOffset() - 1;
    }

    protected boolean isListElement(AuthorNode authorNode) {
        return false;
    }

    protected abstract boolean isList(AuthorNode var1);

    private void insertAtCaret(AuthorAccess authorAccess, ArgumentsMap argumentsMap, boolean bl) throws AuthorOperationException {
        Object object;
        String string = (String)argumentsMap.getArgumentValue(LIST_TYPE_ARGUMENT);
        String string2 = null;
        try {
            object = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset());
            string2 = this.getParentListType((AuthorNode)object);
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException, (Throwable)badLocationException);
        }
        object = this.getXMLFragment(authorAccess, string, string2);
        if (string2 != null) {
            int n2 = authorAccess.getEditorAccess().getCaretOffset();
            if (!bl) {
                authorAccess.getDocumentController().insertXMLFragment((String)object, (String)null, "Inside as first child");
            } else {
                Integer n3;
                SchemaAwareHandlerResult schemaAwareHandlerResult = authorAccess.getDocumentController().insertXMLFragmentSchemaAware((String)object, null, "Inside as first child");
                if (schemaAwareHandlerResult != null && (n3 = (Integer)schemaAwareHandlerResult.getResult("result.id.handle.insert.fragment.offset")) != null) {
                    n2 = n3;
                }
            }
            try {
                int n4 = authorAccess.getEditorAccess().getCaretOffset();
                authorAccess.getEditorAccess().goToNextEditablePosition(n2, n4);
            }
            catch (BadLocationException badLocationException) {
                logger.error((Object)badLocationException, (Throwable)badLocationException);
            }
        } else {
            CommonsOperationsUtil.surroundWithFragment(authorAccess, bl, (String)object);
        }
    }

    protected abstract String getParentListType(AuthorNode var1);

    protected abstract CommonsOperationsUtil.ConversionElementHelper getConversionElementsChecker();

    protected abstract void insertContent(AuthorAccess var1, AuthorNode var2, List<CommonsOperationsUtil.SelectedFragmentInfo> var3);

    protected abstract String getNamespace();

    protected abstract String getXMLFragment(AuthorAccess var1, String var2, String var3);

    protected abstract StringBuilder getListXMLFragment(String var1, Map<String, String> var2, int var3, AuthorAccess var4);

    protected abstract String getListTypeDescription(String var1);
}

