/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.common.CommonAccess;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.XPathVersion;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.exml.workspace.api.editor.transformation.TransformationFeedback;
import ro.sync.exml.workspace.api.editor.transformation.TransformationScenarioNotFoundException;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class ExecuteCustomizableTransformationScenarioOperation
implements AuthorOperation {
    private static final String XPATH_EXPRESSION_CURRENT_ELEMENT = ".";
    private static final String MARK_IN_PROGRESS_PSEUDO_CLASS = "-oxy-transformation-in-progress";
    private static final String MARK_OTHERS_IN_PROGRESS_PSEUDO_CLASS = "-oxy-transformation-in-progress-others";
    private static final Splitter SPLITTER_ON_END_LINE = Splitter.on((String)"\n").trimResults();
    private static final Splitter SPLITTER_ON_EQUALS = Splitter.on((String)"=").trimResults();
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[4];
    private static final String SCENARIO_NAME = "scenarioName";
    private static final String SCENARIO_PARAMETERS = "scenarioParameters";
    private static final String MARK_IN_PROGRESS_XPATH_LOCATION = "markInProgressXPathLocation";
    private static final String MARK_OTHERS_IN_PROGRESS_XPATH_LOCATION = "markOthersInProgressXPathLocation";

    public ExecuteCustomizableTransformationScenarioOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(SCENARIO_NAME, 0, "The name of the transformation scenario which will be executed.");
        this.arguments[1] = argumentDescriptor = new ArgumentDescriptor(SCENARIO_PARAMETERS, 0, "Provided parameters for the transformation scenario.\nParameters are inserted as name=value pairs separated by line breaks.\nThe set parameters are taken into account for XSLT, DITA, Chemistry and ANT Transformation scenario types.");
        this.arguments[2] = argumentDescriptor = new ArgumentDescriptor(MARK_IN_PROGRESS_XPATH_LOCATION, 0, "XPath expression that identifies the element(s) on which a specific  '-oxy-transformation-in-progress' pseudo class is set before transformation is started.The pseudo class is reset when the transformation ends.If this XPath expression is not defined, the current node is used.");
        this.arguments[3] = argumentDescriptor = new ArgumentDescriptor(MARK_OTHERS_IN_PROGRESS_XPATH_LOCATION, 0, "XPath expression that indentifies other elements on which a specific '-oxy-transformation-in-progress-others' pseudo class is set before the transformation is started.The pseudo class is reset when the transformation ends.");
    }

    @Override
    public String getDescription() {
        return "Run a named transformation scenario with specific parameters defined in the associated document type.";
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        Object object = argumentsMap.getArgumentValue(SCENARIO_NAME);
        Object object2 = argumentsMap.getArgumentValue(SCENARIO_PARAMETERS);
        if (object == null) {
            throw new AuthorOperationException("The scenario name was not specified as a parameter.");
        }
        Map map = null;
        if (object2 instanceof String && !((String)object2).trim().isEmpty()) {
            try {
                map = SPLITTER_ON_END_LINE.withKeyValueSeparator(SPLITTER_ON_EQUALS).split((CharSequence)String.valueOf(object2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new AuthorOperationException("The arguments should be defined as key=value pairs.");
            }
        }
        String string2 = Optional.ofNullable(argumentsMap.getArgumentValue(MARK_IN_PROGRESS_XPATH_LOCATION)).map(String.class::cast).map(String::trim).filter(string -> !string.isEmpty()).orElse(XPATH_EXPRESSION_CURRENT_ELEMENT);
        String string3 = Optional.ofNullable(argumentsMap.getArgumentValue(MARK_OTHERS_IN_PROGRESS_XPATH_LOCATION)).map(String.class::cast).orElse(null);
        final AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        final List<AuthorElement> list = ExecuteCustomizableTransformationScenarioOperation.findElementsByXPath(authorDocumentController, string2);
        final List<AuthorElement> list2 = ExecuteCustomizableTransformationScenarioOperation.findElementsByXPath(authorDocumentController, string3);
        list2.removeAll(list);
        ExecuteCustomizableTransformationScenarioOperation.setPseudoClassToElements(authorDocumentController, list, MARK_IN_PROGRESS_PSEUDO_CLASS);
        ExecuteCustomizableTransformationScenarioOperation.setPseudoClassToElements(authorDocumentController, list2, MARK_OTHERS_IN_PROGRESS_PSEUDO_CLASS);
        TransformationFeedback transformationFeedback = new TransformationFeedback(){

            @Override
            public void transformationStopped() {
                ExecuteCustomizableTransformationScenarioOperation.removePseudoClassToElements(authorDocumentController, list, ExecuteCustomizableTransformationScenarioOperation.MARK_IN_PROGRESS_PSEUDO_CLASS);
                ExecuteCustomizableTransformationScenarioOperation.removePseudoClassToElements(authorDocumentController, list2, ExecuteCustomizableTransformationScenarioOperation.MARK_OTHERS_IN_PROGRESS_PSEUDO_CLASS);
            }

            @Override
            public void transformationFinished(boolean bl) {
                ExecuteCustomizableTransformationScenarioOperation.removePseudoClassToElements(authorDocumentController, list, ExecuteCustomizableTransformationScenarioOperation.MARK_IN_PROGRESS_PSEUDO_CLASS);
                ExecuteCustomizableTransformationScenarioOperation.removePseudoClassToElements(authorDocumentController, list2, ExecuteCustomizableTransformationScenarioOperation.MARK_OTHERS_IN_PROGRESS_PSEUDO_CLASS);
            }
        };
        try {
            authorAccess.getEditorAccess().runTransformationScenario(String.valueOf(object), map, transformationFeedback);
        }
        catch (TransformationScenarioNotFoundException transformationScenarioNotFoundException) {
            throw new AuthorOperationException(transformationScenarioNotFoundException.getMessage(), transformationScenarioNotFoundException);
        }
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    private static List<AuthorElement> findElementsByXPath(AuthorDocumentController authorDocumentController, String string) throws AuthorOperationException {
        AuthorNode[] authorNodeArray;
        ArrayList<AuthorElement> arrayList = new ArrayList<AuthorElement>();
        if (string == null) {
            return arrayList;
        }
        for (AuthorNode authorNode : authorNodeArray = authorDocumentController.findNodesByXPath(string, null, true, true, true, false, XPathVersion.XPATH_2_0, true)) {
            if (authorNode.getType() != 0) continue;
            arrayList.add((AuthorElement)authorNode);
        }
        return arrayList;
    }

    private static void setPseudoClassToElements(AuthorDocumentController authorDocumentController, List<AuthorElement> list, String string) {
        if (string != null) {
            CommonAccess.invokeLater(() -> list.forEach(authorElement -> authorDocumentController.setPseudoClass(string, (AuthorElement)authorElement)));
        }
    }

    private static void removePseudoClassToElements(AuthorDocumentController authorDocumentController, List<AuthorElement> list, String string) {
        if (string != null) {
            CommonAccess.invokeLater(() -> list.forEach(authorElement -> authorDocumentController.removePseudoClass(string, (AuthorElement)authorElement)));
        }
    }
}

