/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.id;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.commons.id.ECIDElementsCustomizer;
import ro.sync.ecss.extensions.commons.id.GenerateIDElementsInfo;
import ro.sync.ecss.extensions.commons.id.SAIDElementsCustomizer;
import ro.sync.exml.workspace.api.Platform;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class ConfigureAutoIDElementsOperation
implements AuthorOperation {
    private static final String HELP_PAGE_ID = "generate-ids";

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        GenerateIDElementsInfo generateIDElementsInfo = new GenerateIDElementsInfo(authorAccess, this.getDefaultOptions(authorAccess));
        Platform platform = authorAccess.getWorkspaceAccess().getPlatform();
        if (Platform.STANDALONE == platform) {
            generateIDElementsInfo = new SAIDElementsCustomizer().customizeIDElements(authorAccess, generateIDElementsInfo, this.getListMessage(), this.getHelpPageID(), this.isDocBook());
        } else if (Platform.ECLIPSE == platform) {
            generateIDElementsInfo = new ECIDElementsCustomizer().customizeIDElements(authorAccess, generateIDElementsInfo, this.getListMessage(), this.getHelpPageID(), this.isDocBook());
        }
        if (generateIDElementsInfo != null) {
            generateIDElementsInfo.saveToOptions(authorAccess);
        }
    }

    protected GenerateIDElementsInfo getDefaultOptions(AuthorAccess authorAccess) {
        return GenerateIDElementsInfo.loadDefaultsFromConfiguration(authorAccess, this.getDefaultOptionsXMLResourceName());
    }

    protected String getDefaultOptionsXMLResourceName() {
        return null;
    }

    protected abstract String getListMessage();

    protected boolean isDocBook() {
        return false;
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    protected String getHelpPageID() {
        return HELP_PAGE_ID;
    }
}

