/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.webapp.plugin;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.webapp.plugin.ServletPluginExtension;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.ServletException;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletRequest;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletResponse;
import ro.sync.exml.options.Options;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
public abstract class ServletPluginConfigExtension
extends ServletPluginExtension {
    private Map<String, String> defaultOptions = null;
    private WSOptionsStorage optionsStorage;

    @Override
    public abstract String getPath();

    @Override
    public void init() throws ServletException {
        this.optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
    }

    @Override
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.optionsStorage == null) {
            return;
        }
        httpServletResponse.setStatus(200);
        httpServletResponse.setHeader("Content-Type", "text/html; charset=utf-8");
        httpServletResponse.setCharacterEncoding("UTF-8");
        httpServletResponse.getWriter().write(this.getOptionsForm());
        httpServletResponse.getWriter().flush();
    }

    @Override
    public void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.optionsStorage == null) {
            return;
        }
        String string = null;
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = httpServletRequest.getReader();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
        }
        ObjectMapper objectMapper = new ObjectMapper(new JsonFactory());
        TypeReference<Map<String, String>> typeReference = new TypeReference<Map<String, String>>(){};
        Map map = null;
        map = (Map)objectMapper.readValue(stringBuilder.toString(), (TypeReference)typeReference);
        for (Map.Entry entry : map.entrySet()) {
            this.setOption((String)entry.getKey(), (String)entry.getValue());
        }
        this.saveOptions();
        httpServletResponse.setStatus(200);
    }

    @Override
    public void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.optionsStorage == null) {
            return;
        }
        if (this.defaultOptions == null) {
            httpServletResponse.setStatus(204);
            return;
        }
        for (Map.Entry<String, String> entry : this.defaultOptions.entrySet()) {
            this.setOption(entry.getKey(), entry.getValue());
        }
        this.saveOptions();
        httpServletResponse.setStatus(200);
    }

    protected String getOption(String string, String string2) {
        return this.optionsStorage.getOption(string, string2);
    }

    protected void setOption(String string, String string2) {
        this.optionsStorage.setOption(string, string2);
    }

    protected void saveOptions() throws IOException {
        Options.getInstance().dumpConfigurationNow();
    }

    public Map<String, String> getDefaultOptions() {
        return this.defaultOptions;
    }

    public void setDefaultOptions(Map<String, String> map) {
        if (map != null && map.isEmpty()) {
            throw new IllegalArgumentException("Default options should have values, even if they are null.");
        }
        this.defaultOptions = map;
    }

    public abstract String getOptionsForm();

    public abstract String getOptionsJson();

    @Override
    public final boolean requiresAuthorization() {
        return true;
    }

    public String serializeMapToJSON(Map<String, Object> map) {
        String string;
        try {
            string = new ObjectMapper().writeValueAsString(map);
        }
        catch (Exception exception) {
            string = null;
        }
        if (string == null || "null".equals(string)) {
            string = "{}";
        }
        return string;
    }
}

