/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.DefaultAuthorActionEventHandler;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PUBLIC)
public class DocbookAuthorActionEventHandler
extends DefaultAuthorActionEventHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)DocbookAuthorActionEventHandler.class.getName());
    private static final int MAX_LEVEL = 1;

    @Override
    protected void promoteSubListItems(AuthorDocumentController authorDocumentController, AuthorNode authorNode, AuthorNode authorNode2) throws BadLocationException, AuthorOperationException {
        block7: {
            try {
                ArrayList<AuthorNode> arrayList = new ArrayList<AuthorNode>();
                this.getSubListToPromote(authorNode, 0, arrayList);
                if (arrayList.size() == 1) {
                    AuthorNode authorNode3 = (AuthorNode)arrayList.get(0);
                    AuthorNode authorNode4 = authorNode3.getParent();
                    if (authorNode3 instanceof AuthorElement && authorNode3.getEndOffset() + 1 == authorNode4.getEndOffset()) {
                        boolean bl = true;
                        if (this.isParagraph(authorNode4)) {
                            boolean bl2 = bl = authorNode4.getEndOffset() + 1 == authorNode4.getParent().getEndOffset();
                        }
                        if (bl) {
                            AuthorElement authorElement = (AuthorElement)authorNode3;
                            List<AuthorNode> list = authorElement.getContentNodes();
                            if (this.areCompatibleLists(authorNode3, authorNode2)) {
                                this.promote(authorDocumentController, 0, list, false);
                            }
                        }
                    }
                }
            }
            catch (AuthorOperationException authorOperationException) {
                if (!logger.isDebugEnabled()) break block7;
                logger.debug((Object)authorOperationException, (Throwable)authorOperationException);
            }
        }
    }

    private void getSubListToPromote(AuthorNode authorNode, int n2, List<AuthorNode> list) throws AuthorOperationException {
        if (authorNode instanceof AuthorElement) {
            AuthorElement authorElement = (AuthorElement)authorNode;
            List<AuthorNode> list2 = authorElement.getContentNodes();
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                AuthorNode authorNode2 = list2.get(i2);
                if (this.isList(authorNode2)) {
                    list.add(authorNode2);
                    if (list.size() <= 1) continue;
                    throw new AuthorOperationException("Too many sublists. Can't promote.");
                }
                if (!this.isParagraph(authorNode2) || n2 >= 1) continue;
                this.getSubListToPromote(authorNode2, n2 + 1, list);
            }
        }
    }

    private boolean isParagraph(AuthorNode authorNode) {
        boolean bl = false;
        if (authorNode != null) {
            String string = CommonsOperationsUtil.getLocalName(authorNode.getName());
            bl = string.equals("para");
        }
        return bl;
    }

    @Override
    protected boolean isList(AuthorNode authorNode) {
        boolean bl = false;
        if (authorNode != null) {
            String string = CommonsOperationsUtil.getLocalName(authorNode.getName());
            bl = string.equals("itemizedlist") || string.equals("orderedlist");
        }
        return bl;
    }

    @Override
    protected boolean areCompatibleLists(AuthorNode authorNode, AuthorNode authorNode2) {
        boolean bl = false;
        if (authorNode != null && authorNode2 != null) {
            String string = authorNode.getName();
            String string2 = authorNode2.getName();
            String string3 = CommonsOperationsUtil.getLocalName(string);
            String string4 = CommonsOperationsUtil.getLocalName(string2);
            String string5 = authorNode.getNamespace();
            String string6 = authorNode2.getNamespace();
            bl = this.isList(authorNode) && this.isList(authorNode2) && string5.equals(string6) && (string3.equals(string4) || string3.equals("itemizedlist") && string4.equals("orderedlist") || string3.equals("orderedlist") && string4.equals("itemizedlist"));
        }
        return bl;
    }

    @Override
    protected String getParagraphElement(AuthorAccess authorAccess) {
        return "para";
    }

    @Override
    public AuthorElement getListItemAncestorToSplit(AuthorNode authorNode, AuthorAccess authorAccess) {
        AuthorNode authorNode2;
        AuthorNode authorNode3;
        if (this.hasLocalName(authorNode, "para") && (authorNode3 = authorNode.getParent()) != null && this.hasLocalName(authorNode3, "listitem") && (authorNode2 = authorNode3.getParent()) != null && this.hasLocalName(authorNode2, "varlistentry")) {
            return (AuthorElement)authorNode2;
        }
        return super.getListItemAncestorToSplit(authorNode, authorAccess);
    }

    private boolean hasLocalName(AuthorNode authorNode, String string) {
        return authorNode.getType() == 0 && string.equals(((AuthorElement)authorNode).getLocalName());
    }
}

