/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
public class ArgumentDescriptor {
    public static final int TYPE_STRING = 0;
    public static final int TYPE_FRAGMENT = 1;
    public static final int TYPE_XPATH_EXPRESSION = 2;
    public static final int TYPE_CONSTANT_LIST = 3;
    public static final int TYPE_SCRIPT = 4;
    public static final int TYPE_JAVA_OBJECT = 5;
    protected String name = null;
    protected int type = -1;
    protected String description = null;
    protected String[] allowedValues;
    protected String defaultValue;

    public ArgumentDescriptor(String string, int n2, String string2) {
        this(string, n2, string2, null, null);
    }

    public ArgumentDescriptor(String string, int n2, String string2, String string3) {
        this(string, n2, string2, null, string3);
    }

    public ArgumentDescriptor(String string, int n2, String string2, String[] stringArray, String string3) {
        this.name = string;
        this.type = n2;
        this.description = string2;
        this.allowedValues = stringArray;
        this.defaultValue = string3;
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("Argument name unspecified");
        }
        if (n2 == 3 && (stringArray == null || stringArray.length == 0)) {
            throw new IllegalArgumentException("For a TYPE_CONSTANT_LIST argument you must also provide the allowed values.");
        }
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public static String decodeType(int n2) {
        String string = null;
        switch (n2) {
            case 0: {
                string = "String";
                break;
            }
            case 1: {
                string = "Fragment";
                break;
            }
            case 2: {
                string = "XPathExpression";
                break;
            }
            case 3: {
                string = "ConstantList";
                break;
            }
            case 4: {
                string = "Script";
            }
        }
        return string;
    }

    public String[] getAllowedValues() {
        return this.allowedValues;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return this.getName() + "|" + this.getType() + "|" + this.getDescription();
    }
}

