/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.component.editor;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.UndoManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.azcheck.ui.t;
import ro.sync.basic.util.PlatformDetector;
import ro.sync.contentcompletion.editor.bb;
import ro.sync.document.hc;
import ro.sync.document.q;
import ro.sync.ecss.component.editor.d;
import ro.sync.ecss.component.editor.db;
import ro.sync.ecss.component.editor.gb;
import ro.sync.ecss.extensions.api.CursorType;
import ro.sync.ecss.extensions.api.editor.AbstractInplaceEditor;
import ro.sync.ecss.extensions.api.editor.AuthorInplaceContext;
import ro.sync.ecss.extensions.api.editor.EditingEvent;
import ro.sync.ecss.extensions.api.editor.InplaceRenderer;
import ro.sync.ecss.extensions.api.editor.RendererLayoutInfo;
import ro.sync.ecss.extensions.commons.editor.InplaceEditorUtil;
import ro.sync.exml.view.graphics.Font;
import ro.sync.exml.view.graphics.Point;
import ro.sync.exml.workspace.api.Platform;
import ro.sync.ui.UndoableTextField;
import ro.sync.ui.theme.l;
import ro.sync.ui.theme.o;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class TextFieldEditor
extends AbstractInplaceEditor
implements InplaceRenderer,
gb {
    private static final Logger chy = LoggerFactory.getLogger((String)TextFieldEditor.class.getName());
    private UndoableTextField zgy;
    private Color fhy;
    private d ehy = new d(){

        @Override
        public boolean tph(char c2) {
            Boolean bl;
            boolean bl2 = false;
            AuthorInplaceContext authorInplaceContext = this.cxh();
            if (authorInplaceContext != null && ((bl = (Boolean)authorInplaceContext.getArguments().get("hasMultipleValues")) == null || bl.booleanValue())) {
                bl2 = super.tph(c2);
            }
            return bl2;
        }

        @Override
        public boolean rph(char c2) {
            Boolean bl;
            boolean bl2 = false;
            AuthorInplaceContext authorInplaceContext = this.cxh();
            if (authorInplaceContext != null && ((bl = (Boolean)authorInplaceContext.getArguments().get("hasMultipleValues")) == null || bl.booleanValue())) {
                bl2 = super.rph(c2);
            }
            return bl2;
        }
    };
    private FocusAdapter bhy = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (chy.isDebugEnabled()) {
                chy.debug("Focus lost " + focusEvent.getOppositeComponent());
            }
            TextFieldEditor.this.fireCommitValue(new EditingEvent((String)TextFieldEditor.this.getValue()));
        }
    };
    private KeyAdapter ahy = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27 && !((bb)TextFieldEditor.this.zgy).eak().ndk().isVisible()) {
                keyEvent.consume();
                TextFieldEditor.this.cancelEditing();
            } else if (keyEvent.getKeyCode() == 10 && !((bb)TextFieldEditor.this.zgy).eak().ndk().isVisible()) {
                keyEvent.consume();
                TextFieldEditor.this.urp(false, true);
            }
        }
    };
    private Insets ygy;
    private java.awt.Font dhy;

    private void yrp(AuthorInplaceContext authorInplaceContext, boolean bl) {
        Object object;
        if (this.zgy == null) {
            if (bl) {
                object = hc.f();
                this.zgy = new bb((KeyStroke)object){
                    final /* synthetic */ KeyStroke mmp;
                    {
                        this.mmp = keyStroke;
                    }

                    @Override
                    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n2, boolean bl) {
                        boolean bl2 = true;
                        if (this.mmp.equals(keyStroke)) {
                            q q2 = hc.e(this.getDocument());
                            bl2 = ((UndoManager)q2).canUndo();
                        }
                        return bl2 ? super.processKeyBinding(keyStroke, keyEvent, n2, bl) : false;
                    }
                };
            } else {
                this.zgy = new UndoableTextField(null, null, 0, false);
            }
            t.ob(authorInplaceContext, this.zgy, bl);
            this.dhy = this.zgy.getFont();
            this.fhy = this.zgy.getForeground();
            object = this.zgy.getMargin();
            this.ygy = null;
            this.ygy = object != null ? (Insets)((Insets)object).clone() : new Insets(1, 1, 1, 1);
            if (PlatformDetector.isWin()) {
                this.ygy.top -= 2;
                this.ygy.bottom += 3;
            }
        }
        if (bl) {
            this.zgy.removeKeyListener(this.ahy);
            this.zgy.removeFocusListener(this.bhy);
        }
        if ((object = (Font)authorInplaceContext.getArguments().get("font")) != null) {
            this.zgy.setFont(new java.awt.Font(((Font)object).getName(), ((Font)object).getStyle(), ((Font)object).getSize()));
        } else {
            this.zgy.setFont(this.dhy);
        }
        this.wrp(authorInplaceContext, bl, false);
        if (bl) {
            this.zgy.addKeyListener(this.ahy);
            this.zgy.addFocusListener(this.bhy);
            this.zgy.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    TextFieldEditor.this.fireEditingOccured();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    TextFieldEditor.this.fireEditingOccured();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    TextFieldEditor.this.fireEditingOccured();
                }
            });
        }
        if (!bl && authorInplaceContext.getAuthorAccess() != null && authorInplaceContext.getAuthorAccess().getWorkspaceAccess() != null && Platform.ECLIPSE == authorInplaceContext.getAuthorAccess().getWorkspaceAccess().getPlatform()) {
            this.zgy.setMargin(this.ygy);
        }
        String string = (String)authorInplaceContext.getArguments().get("tooltip");
        this.zgy.setToolTipText(string);
        InplaceEditorUtil.relayout(this.zgy, authorInplaceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wrp(AuthorInplaceContext authorInplaceContext, boolean bl, boolean bl2) {
        ro.sync.exml.view.graphics.Color color = (ro.sync.exml.view.graphics.Color)authorInplaceContext.getArguments().get("color");
        if (color != null) {
            this.zgy.setForeground(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()));
        } else {
            this.zgy.setForeground(this.fhy);
        }
        if (bl) {
            this.ehy.bxh(authorInplaceContext);
            if (this.zgy instanceof bb) {
                ((bb)this.zgy).setCCManager(this.ehy);
            }
        }
        String string = (String)authorInplaceContext.getArguments().get("initial_value");
        if (!bl && string == null) {
            string = (String)authorInplaceContext.getArguments().get("default_value");
            this.zgy.setForeground(l.e(o.getInstance().getTextBackgroundColor()));
        }
        if (string == null) {
            string = "";
        }
        if (bl2) {
            try {
                bb bb2 = (bb)this.zgy;
                bb2.beginCompoundUndoableEdit();
                try {
                    this.zgy.getDocument().remove(0, this.zgy.getDocument().getLength());
                    this.zgy.getDocument().insertString(0, string, null);
                }
                finally {
                    bb2.endCompoundUndoableEdit();
                }
            }
            catch (BadLocationException badLocationException) {
                chy.error((Object)badLocationException, (Throwable)badLocationException);
            }
        } else {
            this.zgy.setText(string);
        }
    }

    @Override
    public Object getRendererComponent(AuthorInplaceContext authorInplaceContext) {
        this.yrp(authorInplaceContext, false);
        return this.zgy;
    }

    @Override
    public RendererLayoutInfo getRenderingInfo(AuthorInplaceContext authorInplaceContext) {
        this.yrp(authorInplaceContext, false);
        Dimension dimension = db.c(this.zgy, (Container)authorInplaceContext.getParentHost());
        return new RendererLayoutInfo(db.b(this.zgy, dimension.width, dimension.height), InplaceEditorUtil.getPreferredSize(this.zgy, authorInplaceContext));
    }

    @Override
    public Object getEditorComponent(AuthorInplaceContext authorInplaceContext, ro.sync.exml.view.graphics.Rectangle rectangle, Point point) {
        this.yrp(authorInplaceContext, true);
        return this.zgy;
    }

    @Override
    public void requestFocus() {
        this.zgy.requestFocus();
    }

    @Override
    public Object getValue() {
        return this.zgy.getText();
    }

    @Override
    public void stopEditing() {
        this.urp(true, false);
    }

    private void urp(boolean bl, boolean bl2) {
        this.zgy.removeKeyListener(this.ahy);
        this.zgy.removeFocusListener(this.bhy);
        ((bb)this.zgy).cancelCC();
        if (bl2) {
            this.fireNextEditLocationRequested();
        } else {
            this.fireEditingStopped(new EditingEvent((String)this.getValue(), bl));
        }
    }

    @Override
    public void cancelEditing() {
        this.zgy.removeKeyListener(this.ahy);
        this.zgy.removeFocusListener(this.bhy);
        ((bb)this.zgy).cancelCC();
        this.fireEditingCanceled();
    }

    @Override
    public String getDescription() {
        return "A text field renderer and editor";
    }

    @Override
    public ro.sync.exml.view.graphics.Rectangle getScrollRectangle() {
        ro.sync.exml.view.graphics.Rectangle rectangle = null;
        try {
            Rectangle rectangle2 = this.zgy.modelToView(this.zgy.getCaretPosition());
            rectangle = new ro.sync.exml.view.graphics.Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
        catch (BadLocationException badLocationException) {
            chy.error((Object)badLocationException, (Throwable)badLocationException);
        }
        return rectangle;
    }

    @Override
    public String getTooltipText(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        this.yrp(authorInplaceContext, false);
        String string = this.zgy.getToolTipText();
        if (string == null) {
            string = this.zgy.getText();
        }
        return string;
    }

    @Override
    public CursorType getCursorType(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        return CursorType.CURSOR_NORMAL;
    }

    @Override
    public void dump(AuthorInplaceContext authorInplaceContext, StringBuilder stringBuilder) {
        this.yrp(authorInplaceContext, false);
        stringBuilder.append("value:'").append(this.zgy.getText()).append("'");
        if (this.zgy.getToolTipText() != null) {
            stringBuilder.append(", tooltip:'").append(this.zgy.getToolTipText()).append("'");
        }
    }

    @Override
    public CursorType getCursorType(int n2, int n3) {
        return null;
    }

    @Override
    public void refresh(AuthorInplaceContext authorInplaceContext) {
        this.wrp(authorInplaceContext, true, true);
    }

    @Override
    public boolean insertContent(String string) {
        boolean bl = false;
        try {
            this.zgy.getDocument().insertString(this.zgy.getCaretPosition(), string, null);
            bl = true;
        }
        catch (BadLocationException badLocationException) {
            chy.error("Unable to insert to offset. ", (Throwable)badLocationException);
        }
        return bl;
    }

    @Override
    public void commitValue() {
        this.fireCommitValue(new EditingEvent(this.zgy.getText()));
    }
}

